/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRestoreTestingSelectionsResponse extends BackupResponse implements
        ToCopyableBuilder<ListRestoreTestingSelectionsResponse.Builder, ListRestoreTestingSelectionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRestoreTestingSelectionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<RestoreTestingSelectionForList>> RESTORE_TESTING_SELECTIONS_FIELD = SdkField
            .<List<RestoreTestingSelectionForList>> builder(MarshallingType.LIST)
            .memberName("RestoreTestingSelections")
            .getter(getter(ListRestoreTestingSelectionsResponse::restoreTestingSelections))
            .setter(setter(Builder::restoreTestingSelections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingSelections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RestoreTestingSelectionForList> builder(MarshallingType.SDK_POJO)
                                            .constructor(RestoreTestingSelectionForList::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            RESTORE_TESTING_SELECTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<RestoreTestingSelectionForList> restoreTestingSelections;

    private ListRestoreTestingSelectionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.restoreTestingSelections = builder.restoreTestingSelections;
    }

    /**
     * <p>
     * The next item following a partial list of returned items. For example, if a request is made to return
     * <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
     * starting at the location pointed to by the nexttoken.
     * </p>
     * 
     * @return The next item following a partial list of returned items. For example, if a request is made to return
     *         <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your
     *         list starting at the location pointed to by the nexttoken.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the RestoreTestingSelections property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRestoreTestingSelections() {
        return restoreTestingSelections != null && !(restoreTestingSelections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The returned restore testing selections associated with the restore testing plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRestoreTestingSelections} method.
     * </p>
     * 
     * @return The returned restore testing selections associated with the restore testing plan.
     */
    public final List<RestoreTestingSelectionForList> restoreTestingSelections() {
        return restoreTestingSelections;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasRestoreTestingSelections() ? restoreTestingSelections() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRestoreTestingSelectionsResponse)) {
            return false;
        }
        ListRestoreTestingSelectionsResponse other = (ListRestoreTestingSelectionsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasRestoreTestingSelections() == other.hasRestoreTestingSelections()
                && Objects.equals(restoreTestingSelections(), other.restoreTestingSelections());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRestoreTestingSelectionsResponse").add("NextToken", nextToken())
                .add("RestoreTestingSelections", hasRestoreTestingSelections() ? restoreTestingSelections() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "RestoreTestingSelections":
            return Optional.ofNullable(clazz.cast(restoreTestingSelections()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("RestoreTestingSelections", RESTORE_TESTING_SELECTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRestoreTestingSelectionsResponse, T> g) {
        return obj -> g.apply((ListRestoreTestingSelectionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRestoreTestingSelectionsResponse> {
        /**
         * <p>
         * The next item following a partial list of returned items. For example, if a request is made to return
         * <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
         * starting at the location pointed to by the nexttoken.
         * </p>
         * 
         * @param nextToken
         *        The next item following a partial list of returned items. For example, if a request is made to return
         *        <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in
         *        your list starting at the location pointed to by the nexttoken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The returned restore testing selections associated with the restore testing plan.
         * </p>
         * 
         * @param restoreTestingSelections
         *        The returned restore testing selections associated with the restore testing plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingSelections(Collection<RestoreTestingSelectionForList> restoreTestingSelections);

        /**
         * <p>
         * The returned restore testing selections associated with the restore testing plan.
         * </p>
         * 
         * @param restoreTestingSelections
         *        The returned restore testing selections associated with the restore testing plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingSelections(RestoreTestingSelectionForList... restoreTestingSelections);

        /**
         * <p>
         * The returned restore testing selections associated with the restore testing plan.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backup.model.RestoreTestingSelectionForList.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.backup.model.RestoreTestingSelectionForList#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backup.model.RestoreTestingSelectionForList.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #restoreTestingSelections(List<RestoreTestingSelectionForList>)}.
         * 
         * @param restoreTestingSelections
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backup.model.RestoreTestingSelectionForList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restoreTestingSelections(java.util.Collection<RestoreTestingSelectionForList>)
         */
        Builder restoreTestingSelections(Consumer<RestoreTestingSelectionForList.Builder>... restoreTestingSelections);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<RestoreTestingSelectionForList> restoreTestingSelections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRestoreTestingSelectionsResponse model) {
            super(model);
            nextToken(model.nextToken);
            restoreTestingSelections(model.restoreTestingSelections);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RestoreTestingSelectionForList.Builder> getRestoreTestingSelections() {
            List<RestoreTestingSelectionForList.Builder> result = RestoreTestingSelectionsCopier
                    .copyToBuilder(this.restoreTestingSelections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRestoreTestingSelections(
                Collection<RestoreTestingSelectionForList.BuilderImpl> restoreTestingSelections) {
            this.restoreTestingSelections = RestoreTestingSelectionsCopier.copyFromBuilder(restoreTestingSelections);
        }

        @Override
        public final Builder restoreTestingSelections(Collection<RestoreTestingSelectionForList> restoreTestingSelections) {
            this.restoreTestingSelections = RestoreTestingSelectionsCopier.copy(restoreTestingSelections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restoreTestingSelections(RestoreTestingSelectionForList... restoreTestingSelections) {
            restoreTestingSelections(Arrays.asList(restoreTestingSelections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restoreTestingSelections(
                Consumer<RestoreTestingSelectionForList.Builder>... restoreTestingSelections) {
            restoreTestingSelections(Stream.of(restoreTestingSelections)
                    .map(c -> RestoreTestingSelectionForList.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRestoreTestingSelectionsResponse build() {
            return new ListRestoreTestingSelectionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
