/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRestoreValidationResultRequest extends BackupRequest implements
        ToCopyableBuilder<PutRestoreValidationResultRequest.Builder, PutRestoreValidationResultRequest> {
    private static final SdkField<String> RESTORE_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RestoreJobId").getter(getter(PutRestoreValidationResultRequest::restoreJobId))
            .setter(setter(Builder::restoreJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("restoreJobId").build()).build();

    private static final SdkField<String> VALIDATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValidationStatus").getter(getter(PutRestoreValidationResultRequest::validationStatusAsString))
            .setter(setter(Builder::validationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStatus").build()).build();

    private static final SdkField<String> VALIDATION_STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValidationStatusMessage").getter(getter(PutRestoreValidationResultRequest::validationStatusMessage))
            .setter(setter(Builder::validationStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStatusMessage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESTORE_JOB_ID_FIELD,
            VALIDATION_STATUS_FIELD, VALIDATION_STATUS_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String restoreJobId;

    private final String validationStatus;

    private final String validationStatusMessage;

    private PutRestoreValidationResultRequest(BuilderImpl builder) {
        super(builder);
        this.restoreJobId = builder.restoreJobId;
        this.validationStatus = builder.validationStatus;
        this.validationStatusMessage = builder.validationStatusMessage;
    }

    /**
     * <p>
     * This is a unique identifier of a restore job within Backup.
     * </p>
     * 
     * @return This is a unique identifier of a restore job within Backup.
     */
    public final String restoreJobId() {
        return restoreJobId;
    }

    /**
     * <p>
     * The status of your restore validation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #validationStatus}
     * will return {@link RestoreValidationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #validationStatusAsString}.
     * </p>
     * 
     * @return The status of your restore validation.
     * @see RestoreValidationStatus
     */
    public final RestoreValidationStatus validationStatus() {
        return RestoreValidationStatus.fromValue(validationStatus);
    }

    /**
     * <p>
     * The status of your restore validation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #validationStatus}
     * will return {@link RestoreValidationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #validationStatusAsString}.
     * </p>
     * 
     * @return The status of your restore validation.
     * @see RestoreValidationStatus
     */
    public final String validationStatusAsString() {
        return validationStatus;
    }

    /**
     * <p>
     * This is an optional message string you can input to describe the validation status for the restore test
     * validation.
     * </p>
     * 
     * @return This is an optional message string you can input to describe the validation status for the restore test
     *         validation.
     */
    public final String validationStatusMessage() {
        return validationStatusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(restoreJobId());
        hashCode = 31 * hashCode + Objects.hashCode(validationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(validationStatusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRestoreValidationResultRequest)) {
            return false;
        }
        PutRestoreValidationResultRequest other = (PutRestoreValidationResultRequest) obj;
        return Objects.equals(restoreJobId(), other.restoreJobId())
                && Objects.equals(validationStatusAsString(), other.validationStatusAsString())
                && Objects.equals(validationStatusMessage(), other.validationStatusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutRestoreValidationResultRequest").add("RestoreJobId", restoreJobId())
                .add("ValidationStatus", validationStatusAsString()).add("ValidationStatusMessage", validationStatusMessage())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RestoreJobId":
            return Optional.ofNullable(clazz.cast(restoreJobId()));
        case "ValidationStatus":
            return Optional.ofNullable(clazz.cast(validationStatusAsString()));
        case "ValidationStatusMessage":
            return Optional.ofNullable(clazz.cast(validationStatusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("restoreJobId", RESTORE_JOB_ID_FIELD);
        map.put("ValidationStatus", VALIDATION_STATUS_FIELD);
        map.put("ValidationStatusMessage", VALIDATION_STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutRestoreValidationResultRequest, T> g) {
        return obj -> g.apply((PutRestoreValidationResultRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutRestoreValidationResultRequest> {
        /**
         * <p>
         * This is a unique identifier of a restore job within Backup.
         * </p>
         * 
         * @param restoreJobId
         *        This is a unique identifier of a restore job within Backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreJobId(String restoreJobId);

        /**
         * <p>
         * The status of your restore validation.
         * </p>
         * 
         * @param validationStatus
         *        The status of your restore validation.
         * @see RestoreValidationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RestoreValidationStatus
         */
        Builder validationStatus(String validationStatus);

        /**
         * <p>
         * The status of your restore validation.
         * </p>
         * 
         * @param validationStatus
         *        The status of your restore validation.
         * @see RestoreValidationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RestoreValidationStatus
         */
        Builder validationStatus(RestoreValidationStatus validationStatus);

        /**
         * <p>
         * This is an optional message string you can input to describe the validation status for the restore test
         * validation.
         * </p>
         * 
         * @param validationStatusMessage
         *        This is an optional message string you can input to describe the validation status for the restore
         *        test validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationStatusMessage(String validationStatusMessage);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String restoreJobId;

        private String validationStatus;

        private String validationStatusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRestoreValidationResultRequest model) {
            super(model);
            restoreJobId(model.restoreJobId);
            validationStatus(model.validationStatus);
            validationStatusMessage(model.validationStatusMessage);
        }

        public final String getRestoreJobId() {
            return restoreJobId;
        }

        public final void setRestoreJobId(String restoreJobId) {
            this.restoreJobId = restoreJobId;
        }

        @Override
        public final Builder restoreJobId(String restoreJobId) {
            this.restoreJobId = restoreJobId;
            return this;
        }

        public final String getValidationStatus() {
            return validationStatus;
        }

        public final void setValidationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
        }

        @Override
        public final Builder validationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
            return this;
        }

        @Override
        public final Builder validationStatus(RestoreValidationStatus validationStatus) {
            this.validationStatus(validationStatus == null ? null : validationStatus.toString());
            return this;
        }

        public final String getValidationStatusMessage() {
            return validationStatusMessage;
        }

        public final void setValidationStatusMessage(String validationStatusMessage) {
            this.validationStatusMessage = validationStatusMessage;
        }

        @Override
        public final Builder validationStatusMessage(String validationStatusMessage) {
            this.validationStatusMessage = validationStatusMessage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRestoreValidationResultRequest build() {
            return new PutRestoreValidationResultRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
