/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This specifies criteria to assign a set of resources, such as resource types or backup vaults.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecoveryPointSelection implements SdkPojo, Serializable,
        ToCopyableBuilder<RecoveryPointSelection.Builder, RecoveryPointSelection> {
    private static final SdkField<List<String>> VAULT_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VaultNames")
            .getter(getter(RecoveryPointSelection::vaultNames))
            .setter(setter(Builder::vaultNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VaultNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RESOURCE_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceIdentifiers")
            .getter(getter(RecoveryPointSelection::resourceIdentifiers))
            .setter(setter(Builder::resourceIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DateRange> DATE_RANGE_FIELD = SdkField.<DateRange> builder(MarshallingType.SDK_POJO)
            .memberName("DateRange").getter(getter(RecoveryPointSelection::dateRange)).setter(setter(Builder::dateRange))
            .constructor(DateRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VAULT_NAMES_FIELD,
            RESOURCE_IDENTIFIERS_FIELD, DATE_RANGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> vaultNames;

    private final List<String> resourceIdentifiers;

    private final DateRange dateRange;

    private RecoveryPointSelection(BuilderImpl builder) {
        this.vaultNames = builder.vaultNames;
        this.resourceIdentifiers = builder.resourceIdentifiers;
        this.dateRange = builder.dateRange;
    }

    /**
     * For responses, this returns true if the service returned a value for the VaultNames property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVaultNames() {
        return vaultNames != null && !(vaultNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * These are the names of the vaults in which the selected recovery points are contained.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVaultNames} method.
     * </p>
     * 
     * @return These are the names of the vaults in which the selected recovery points are contained.
     */
    public final List<String> vaultNames() {
        return vaultNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceIdentifiers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceIdentifiers() {
        return resourceIdentifiers != null && !(resourceIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * These are the resources included in the resource selection (including type of resources and vaults).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceIdentifiers} method.
     * </p>
     * 
     * @return These are the resources included in the resource selection (including type of resources and vaults).
     */
    public final List<String> resourceIdentifiers() {
        return resourceIdentifiers;
    }

    /**
     * Returns the value of the DateRange property for this object.
     * 
     * @return The value of the DateRange property for this object.
     */
    public final DateRange dateRange() {
        return dateRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasVaultNames() ? vaultNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceIdentifiers() ? resourceIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dateRange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecoveryPointSelection)) {
            return false;
        }
        RecoveryPointSelection other = (RecoveryPointSelection) obj;
        return hasVaultNames() == other.hasVaultNames() && Objects.equals(vaultNames(), other.vaultNames())
                && hasResourceIdentifiers() == other.hasResourceIdentifiers()
                && Objects.equals(resourceIdentifiers(), other.resourceIdentifiers())
                && Objects.equals(dateRange(), other.dateRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecoveryPointSelection").add("VaultNames", hasVaultNames() ? vaultNames() : null)
                .add("ResourceIdentifiers", hasResourceIdentifiers() ? resourceIdentifiers() : null)
                .add("DateRange", dateRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VaultNames":
            return Optional.ofNullable(clazz.cast(vaultNames()));
        case "ResourceIdentifiers":
            return Optional.ofNullable(clazz.cast(resourceIdentifiers()));
        case "DateRange":
            return Optional.ofNullable(clazz.cast(dateRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VaultNames", VAULT_NAMES_FIELD);
        map.put("ResourceIdentifiers", RESOURCE_IDENTIFIERS_FIELD);
        map.put("DateRange", DATE_RANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecoveryPointSelection, T> g) {
        return obj -> g.apply((RecoveryPointSelection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecoveryPointSelection> {
        /**
         * <p>
         * These are the names of the vaults in which the selected recovery points are contained.
         * </p>
         * 
         * @param vaultNames
         *        These are the names of the vaults in which the selected recovery points are contained.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vaultNames(Collection<String> vaultNames);

        /**
         * <p>
         * These are the names of the vaults in which the selected recovery points are contained.
         * </p>
         * 
         * @param vaultNames
         *        These are the names of the vaults in which the selected recovery points are contained.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vaultNames(String... vaultNames);

        /**
         * <p>
         * These are the resources included in the resource selection (including type of resources and vaults).
         * </p>
         * 
         * @param resourceIdentifiers
         *        These are the resources included in the resource selection (including type of resources and vaults).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifiers(Collection<String> resourceIdentifiers);

        /**
         * <p>
         * These are the resources included in the resource selection (including type of resources and vaults).
         * </p>
         * 
         * @param resourceIdentifiers
         *        These are the resources included in the resource selection (including type of resources and vaults).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifiers(String... resourceIdentifiers);

        /**
         * Sets the value of the DateRange property for this object.
         *
         * @param dateRange
         *        The new value for the DateRange property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateRange(DateRange dateRange);

        /**
         * Sets the value of the DateRange property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DateRange.Builder} avoiding the need to
         * create one manually via {@link DateRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateRange.Builder#build()} is called immediately and its result
         * is passed to {@link #dateRange(DateRange)}.
         * 
         * @param dateRange
         *        a consumer that will call methods on {@link DateRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dateRange(DateRange)
         */
        default Builder dateRange(Consumer<DateRange.Builder> dateRange) {
            return dateRange(DateRange.builder().applyMutation(dateRange).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> vaultNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> resourceIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private DateRange dateRange;

        private BuilderImpl() {
        }

        private BuilderImpl(RecoveryPointSelection model) {
            vaultNames(model.vaultNames);
            resourceIdentifiers(model.resourceIdentifiers);
            dateRange(model.dateRange);
        }

        public final Collection<String> getVaultNames() {
            if (vaultNames instanceof SdkAutoConstructList) {
                return null;
            }
            return vaultNames;
        }

        public final void setVaultNames(Collection<String> vaultNames) {
            this.vaultNames = VaultNamesCopier.copy(vaultNames);
        }

        @Override
        public final Builder vaultNames(Collection<String> vaultNames) {
            this.vaultNames = VaultNamesCopier.copy(vaultNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vaultNames(String... vaultNames) {
            vaultNames(Arrays.asList(vaultNames));
            return this;
        }

        public final Collection<String> getResourceIdentifiers() {
            if (resourceIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceIdentifiers;
        }

        public final void setResourceIdentifiers(Collection<String> resourceIdentifiers) {
            this.resourceIdentifiers = ResourceIdentifiersCopier.copy(resourceIdentifiers);
        }

        @Override
        public final Builder resourceIdentifiers(Collection<String> resourceIdentifiers) {
            this.resourceIdentifiers = ResourceIdentifiersCopier.copy(resourceIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIdentifiers(String... resourceIdentifiers) {
            resourceIdentifiers(Arrays.asList(resourceIdentifiers));
            return this;
        }

        public final DateRange.Builder getDateRange() {
            return dateRange != null ? dateRange.toBuilder() : null;
        }

        public final void setDateRange(DateRange.BuilderImpl dateRange) {
            this.dateRange = dateRange != null ? dateRange.build() : null;
        }

        @Override
        public final Builder dateRange(DateRange dateRange) {
            this.dateRange = dateRange;
            return this;
        }

        @Override
        public RecoveryPointSelection build() {
            return new RecoveryPointSelection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
