/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This contains metadata about a restore testing plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreTestingPlanForCreate implements SdkPojo, Serializable,
        ToCopyableBuilder<RestoreTestingPlanForCreate.Builder, RestoreTestingPlanForCreate> {
    private static final SdkField<RestoreTestingRecoveryPointSelection> RECOVERY_POINT_SELECTION_FIELD = SdkField
            .<RestoreTestingRecoveryPointSelection> builder(MarshallingType.SDK_POJO).memberName("RecoveryPointSelection")
            .getter(getter(RestoreTestingPlanForCreate::recoveryPointSelection)).setter(setter(Builder::recoveryPointSelection))
            .constructor(RestoreTestingRecoveryPointSelection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointSelection").build())
            .build();

    private static final SdkField<String> RESTORE_TESTING_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RestoreTestingPlanName").getter(getter(RestoreTestingPlanForCreate::restoreTestingPlanName))
            .setter(setter(Builder::restoreTestingPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingPlanName").build())
            .build();

    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduleExpression").getter(getter(RestoreTestingPlanForCreate::scheduleExpression))
            .setter(setter(Builder::scheduleExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpression").build())
            .build();

    private static final SdkField<String> SCHEDULE_EXPRESSION_TIMEZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ScheduleExpressionTimezone")
            .getter(getter(RestoreTestingPlanForCreate::scheduleExpressionTimezone))
            .setter(setter(Builder::scheduleExpressionTimezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpressionTimezone").build())
            .build();

    private static final SdkField<Integer> START_WINDOW_HOURS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StartWindowHours").getter(getter(RestoreTestingPlanForCreate::startWindowHours))
            .setter(setter(Builder::startWindowHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartWindowHours").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RECOVERY_POINT_SELECTION_FIELD, RESTORE_TESTING_PLAN_NAME_FIELD, SCHEDULE_EXPRESSION_FIELD,
            SCHEDULE_EXPRESSION_TIMEZONE_FIELD, START_WINDOW_HOURS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RestoreTestingRecoveryPointSelection recoveryPointSelection;

    private final String restoreTestingPlanName;

    private final String scheduleExpression;

    private final String scheduleExpressionTimezone;

    private final Integer startWindowHours;

    private RestoreTestingPlanForCreate(BuilderImpl builder) {
        this.recoveryPointSelection = builder.recoveryPointSelection;
        this.restoreTestingPlanName = builder.restoreTestingPlanName;
        this.scheduleExpression = builder.scheduleExpression;
        this.scheduleExpressionTimezone = builder.scheduleExpressionTimezone;
        this.startWindowHours = builder.startWindowHours;
    }

    /**
     * <p>
     * <code>RecoveryPointSelection</code> has five parameters (three required and two optional). The values you specify
     * determine which recovery point is included in the restore test. You must indicate with <code>Algorithm</code> if
     * you want the latest recovery point within your <code>SelectionWindowDays</code> or if you want a random recovery
     * point, and you must indicate through <code>IncludeVaults</code> from which vaults the recovery points can be
     * chosen.
     * </p>
     * <p>
     * <code>Algorithm</code> (<i>required</i>) Valid values: "<code>LATEST_WITHIN_WINDOW</code>" or "
     * <code>RANDOM_WITHIN_WINDOW</code>".
     * </p>
     * <p>
     * <code>Recovery point types</code> (<i>required</i>) Valid values: "<code>SNAPSHOT</code>" and/or "
     * <code>CONTINUOUS</code>". Include <code>SNAPSHOT</code> to restore only snapshot recovery points; include
     * <code>CONTINUOUS</code> to restore continuous recovery points (point in time restore / PITR); use both to restore
     * either a snapshot or a continuous recovery point. The recovery point will be determined by the value for
     * <code>Algorithm</code>.
     * </p>
     * <p>
     * <code>IncludeVaults</code> (<i>required</i>). You must include one or more backup vaults. Use the wildcard ["*"]
     * or specific ARNs.
     * </p>
     * <p>
     * <code>SelectionWindowDays</code> (<i>optional</i>) Value must be an integer (in days) from 1 to 365. If not
     * included, the value defaults to <code>30</code>.
     * </p>
     * <p>
     * <code>ExcludeVaults</code> (<i>optional</i>). You can choose to input one or more specific backup vault ARNs to
     * exclude those vaults' contents from restore eligibility. Or, you can include a list of selectors. If this
     * parameter and its value are not included, it defaults to empty list.
     * </p>
     * 
     * @return <code>RecoveryPointSelection</code> has five parameters (three required and two optional). The values you
     *         specify determine which recovery point is included in the restore test. You must indicate with
     *         <code>Algorithm</code> if you want the latest recovery point within your <code>SelectionWindowDays</code>
     *         or if you want a random recovery point, and you must indicate through <code>IncludeVaults</code> from
     *         which vaults the recovery points can be chosen.</p>
     *         <p>
     *         <code>Algorithm</code> (<i>required</i>) Valid values: "<code>LATEST_WITHIN_WINDOW</code>" or "
     *         <code>RANDOM_WITHIN_WINDOW</code>".
     *         </p>
     *         <p>
     *         <code>Recovery point types</code> (<i>required</i>) Valid values: "<code>SNAPSHOT</code>" and/or "
     *         <code>CONTINUOUS</code>". Include <code>SNAPSHOT</code> to restore only snapshot recovery points; include
     *         <code>CONTINUOUS</code> to restore continuous recovery points (point in time restore / PITR); use both to
     *         restore either a snapshot or a continuous recovery point. The recovery point will be determined by the
     *         value for <code>Algorithm</code>.
     *         </p>
     *         <p>
     *         <code>IncludeVaults</code> (<i>required</i>). You must include one or more backup vaults. Use the
     *         wildcard ["*"] or specific ARNs.
     *         </p>
     *         <p>
     *         <code>SelectionWindowDays</code> (<i>optional</i>) Value must be an integer (in days) from 1 to 365. If
     *         not included, the value defaults to <code>30</code>.
     *         </p>
     *         <p>
     *         <code>ExcludeVaults</code> (<i>optional</i>). You can choose to input one or more specific backup vault
     *         ARNs to exclude those vaults' contents from restore eligibility. Or, you can include a list of selectors.
     *         If this parameter and its value are not included, it defaults to empty list.
     */
    public final RestoreTestingRecoveryPointSelection recoveryPointSelection() {
        return recoveryPointSelection;
    }

    /**
     * <p>
     * The RestoreTestingPlanName is a unique string that is the name of the restore testing plan. This cannot be
     * changed after creation, and it must consist of only alphanumeric characters and underscores.
     * </p>
     * 
     * @return The RestoreTestingPlanName is a unique string that is the name of the restore testing plan. This cannot
     *         be changed after creation, and it must consist of only alphanumeric characters and underscores.
     */
    public final String restoreTestingPlanName() {
        return restoreTestingPlanName;
    }

    /**
     * <p>
     * A CRON expression in specified timezone when a restore testing plan is executed.
     * </p>
     * 
     * @return A CRON expression in specified timezone when a restore testing plan is executed.
     */
    public final String scheduleExpression() {
        return scheduleExpression;
    }

    /**
     * <p>
     * Optional. This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are in
     * UTC. You can modify this to a specified timezone.
     * </p>
     * 
     * @return Optional. This is the timezone in which the schedule expression is set. By default, ScheduleExpressions
     *         are in UTC. You can modify this to a specified timezone.
     */
    public final String scheduleExpressionTimezone() {
        return scheduleExpressionTimezone;
    }

    /**
     * <p>
     * Defaults to 24 hours.
     * </p>
     * <p>
     * A value in hours after a restore test is scheduled before a job will be canceled if it doesn't start
     * successfully. This value is optional. If this value is included, this parameter has a maximum value of 168 hours
     * (one week).
     * </p>
     * 
     * @return Defaults to 24 hours.</p>
     *         <p>
     *         A value in hours after a restore test is scheduled before a job will be canceled if it doesn't start
     *         successfully. This value is optional. If this value is included, this parameter has a maximum value of
     *         168 hours (one week).
     */
    public final Integer startWindowHours() {
        return startWindowHours;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recoveryPointSelection());
        hashCode = 31 * hashCode + Objects.hashCode(restoreTestingPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleExpressionTimezone());
        hashCode = 31 * hashCode + Objects.hashCode(startWindowHours());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreTestingPlanForCreate)) {
            return false;
        }
        RestoreTestingPlanForCreate other = (RestoreTestingPlanForCreate) obj;
        return Objects.equals(recoveryPointSelection(), other.recoveryPointSelection())
                && Objects.equals(restoreTestingPlanName(), other.restoreTestingPlanName())
                && Objects.equals(scheduleExpression(), other.scheduleExpression())
                && Objects.equals(scheduleExpressionTimezone(), other.scheduleExpressionTimezone())
                && Objects.equals(startWindowHours(), other.startWindowHours());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreTestingPlanForCreate").add("RecoveryPointSelection", recoveryPointSelection())
                .add("RestoreTestingPlanName", restoreTestingPlanName()).add("ScheduleExpression", scheduleExpression())
                .add("ScheduleExpressionTimezone", scheduleExpressionTimezone()).add("StartWindowHours", startWindowHours())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecoveryPointSelection":
            return Optional.ofNullable(clazz.cast(recoveryPointSelection()));
        case "RestoreTestingPlanName":
            return Optional.ofNullable(clazz.cast(restoreTestingPlanName()));
        case "ScheduleExpression":
            return Optional.ofNullable(clazz.cast(scheduleExpression()));
        case "ScheduleExpressionTimezone":
            return Optional.ofNullable(clazz.cast(scheduleExpressionTimezone()));
        case "StartWindowHours":
            return Optional.ofNullable(clazz.cast(startWindowHours()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RecoveryPointSelection", RECOVERY_POINT_SELECTION_FIELD);
        map.put("RestoreTestingPlanName", RESTORE_TESTING_PLAN_NAME_FIELD);
        map.put("ScheduleExpression", SCHEDULE_EXPRESSION_FIELD);
        map.put("ScheduleExpressionTimezone", SCHEDULE_EXPRESSION_TIMEZONE_FIELD);
        map.put("StartWindowHours", START_WINDOW_HOURS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestoreTestingPlanForCreate, T> g) {
        return obj -> g.apply((RestoreTestingPlanForCreate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RestoreTestingPlanForCreate> {
        /**
         * <p>
         * <code>RecoveryPointSelection</code> has five parameters (three required and two optional). The values you
         * specify determine which recovery point is included in the restore test. You must indicate with
         * <code>Algorithm</code> if you want the latest recovery point within your <code>SelectionWindowDays</code> or
         * if you want a random recovery point, and you must indicate through <code>IncludeVaults</code> from which
         * vaults the recovery points can be chosen.
         * </p>
         * <p>
         * <code>Algorithm</code> (<i>required</i>) Valid values: "<code>LATEST_WITHIN_WINDOW</code>" or "
         * <code>RANDOM_WITHIN_WINDOW</code>".
         * </p>
         * <p>
         * <code>Recovery point types</code> (<i>required</i>) Valid values: "<code>SNAPSHOT</code>" and/or "
         * <code>CONTINUOUS</code>". Include <code>SNAPSHOT</code> to restore only snapshot recovery points; include
         * <code>CONTINUOUS</code> to restore continuous recovery points (point in time restore / PITR); use both to
         * restore either a snapshot or a continuous recovery point. The recovery point will be determined by the value
         * for <code>Algorithm</code>.
         * </p>
         * <p>
         * <code>IncludeVaults</code> (<i>required</i>). You must include one or more backup vaults. Use the wildcard
         * ["*"] or specific ARNs.
         * </p>
         * <p>
         * <code>SelectionWindowDays</code> (<i>optional</i>) Value must be an integer (in days) from 1 to 365. If not
         * included, the value defaults to <code>30</code>.
         * </p>
         * <p>
         * <code>ExcludeVaults</code> (<i>optional</i>). You can choose to input one or more specific backup vault ARNs
         * to exclude those vaults' contents from restore eligibility. Or, you can include a list of selectors. If this
         * parameter and its value are not included, it defaults to empty list.
         * </p>
         * 
         * @param recoveryPointSelection
         *        <code>RecoveryPointSelection</code> has five parameters (three required and two optional). The values
         *        you specify determine which recovery point is included in the restore test. You must indicate with
         *        <code>Algorithm</code> if you want the latest recovery point within your
         *        <code>SelectionWindowDays</code> or if you want a random recovery point, and you must indicate through
         *        <code>IncludeVaults</code> from which vaults the recovery points can be chosen.</p>
         *        <p>
         *        <code>Algorithm</code> (<i>required</i>) Valid values: "<code>LATEST_WITHIN_WINDOW</code>" or "
         *        <code>RANDOM_WITHIN_WINDOW</code>".
         *        </p>
         *        <p>
         *        <code>Recovery point types</code> (<i>required</i>) Valid values: "<code>SNAPSHOT</code>" and/or "
         *        <code>CONTINUOUS</code>". Include <code>SNAPSHOT</code> to restore only snapshot recovery points;
         *        include <code>CONTINUOUS</code> to restore continuous recovery points (point in time restore / PITR);
         *        use both to restore either a snapshot or a continuous recovery point. The recovery point will be
         *        determined by the value for <code>Algorithm</code>.
         *        </p>
         *        <p>
         *        <code>IncludeVaults</code> (<i>required</i>). You must include one or more backup vaults. Use the
         *        wildcard ["*"] or specific ARNs.
         *        </p>
         *        <p>
         *        <code>SelectionWindowDays</code> (<i>optional</i>) Value must be an integer (in days) from 1 to 365.
         *        If not included, the value defaults to <code>30</code>.
         *        </p>
         *        <p>
         *        <code>ExcludeVaults</code> (<i>optional</i>). You can choose to input one or more specific backup
         *        vault ARNs to exclude those vaults' contents from restore eligibility. Or, you can include a list of
         *        selectors. If this parameter and its value are not included, it defaults to empty list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPointSelection(RestoreTestingRecoveryPointSelection recoveryPointSelection);

        /**
         * <p>
         * <code>RecoveryPointSelection</code> has five parameters (three required and two optional). The values you
         * specify determine which recovery point is included in the restore test. You must indicate with
         * <code>Algorithm</code> if you want the latest recovery point within your <code>SelectionWindowDays</code> or
         * if you want a random recovery point, and you must indicate through <code>IncludeVaults</code> from which
         * vaults the recovery points can be chosen.
         * </p>
         * <p>
         * <code>Algorithm</code> (<i>required</i>) Valid values: "<code>LATEST_WITHIN_WINDOW</code>" or "
         * <code>RANDOM_WITHIN_WINDOW</code>".
         * </p>
         * <p>
         * <code>Recovery point types</code> (<i>required</i>) Valid values: "<code>SNAPSHOT</code>" and/or "
         * <code>CONTINUOUS</code>". Include <code>SNAPSHOT</code> to restore only snapshot recovery points; include
         * <code>CONTINUOUS</code> to restore continuous recovery points (point in time restore / PITR); use both to
         * restore either a snapshot or a continuous recovery point. The recovery point will be determined by the value
         * for <code>Algorithm</code>.
         * </p>
         * <p>
         * <code>IncludeVaults</code> (<i>required</i>). You must include one or more backup vaults. Use the wildcard
         * ["*"] or specific ARNs.
         * </p>
         * <p>
         * <code>SelectionWindowDays</code> (<i>optional</i>) Value must be an integer (in days) from 1 to 365. If not
         * included, the value defaults to <code>30</code>.
         * </p>
         * <p>
         * <code>ExcludeVaults</code> (<i>optional</i>). You can choose to input one or more specific backup vault ARNs
         * to exclude those vaults' contents from restore eligibility. Or, you can include a list of selectors. If this
         * parameter and its value are not included, it defaults to empty list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RestoreTestingRecoveryPointSelection.Builder} avoiding the need to create one manually via
         * {@link RestoreTestingRecoveryPointSelection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RestoreTestingRecoveryPointSelection.Builder#build()} is called
         * immediately and its result is passed to {@link #recoveryPointSelection(RestoreTestingRecoveryPointSelection)}.
         * 
         * @param recoveryPointSelection
         *        a consumer that will call methods on {@link RestoreTestingRecoveryPointSelection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recoveryPointSelection(RestoreTestingRecoveryPointSelection)
         */
        default Builder recoveryPointSelection(Consumer<RestoreTestingRecoveryPointSelection.Builder> recoveryPointSelection) {
            return recoveryPointSelection(RestoreTestingRecoveryPointSelection.builder().applyMutation(recoveryPointSelection)
                    .build());
        }

        /**
         * <p>
         * The RestoreTestingPlanName is a unique string that is the name of the restore testing plan. This cannot be
         * changed after creation, and it must consist of only alphanumeric characters and underscores.
         * </p>
         * 
         * @param restoreTestingPlanName
         *        The RestoreTestingPlanName is a unique string that is the name of the restore testing plan. This
         *        cannot be changed after creation, and it must consist of only alphanumeric characters and underscores.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingPlanName(String restoreTestingPlanName);

        /**
         * <p>
         * A CRON expression in specified timezone when a restore testing plan is executed.
         * </p>
         * 
         * @param scheduleExpression
         *        A CRON expression in specified timezone when a restore testing plan is executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleExpression(String scheduleExpression);

        /**
         * <p>
         * Optional. This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are
         * in UTC. You can modify this to a specified timezone.
         * </p>
         * 
         * @param scheduleExpressionTimezone
         *        Optional. This is the timezone in which the schedule expression is set. By default,
         *        ScheduleExpressions are in UTC. You can modify this to a specified timezone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleExpressionTimezone(String scheduleExpressionTimezone);

        /**
         * <p>
         * Defaults to 24 hours.
         * </p>
         * <p>
         * A value in hours after a restore test is scheduled before a job will be canceled if it doesn't start
         * successfully. This value is optional. If this value is included, this parameter has a maximum value of 168
         * hours (one week).
         * </p>
         * 
         * @param startWindowHours
         *        Defaults to 24 hours.</p>
         *        <p>
         *        A value in hours after a restore test is scheduled before a job will be canceled if it doesn't start
         *        successfully. This value is optional. If this value is included, this parameter has a maximum value of
         *        168 hours (one week).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startWindowHours(Integer startWindowHours);
    }

    static final class BuilderImpl implements Builder {
        private RestoreTestingRecoveryPointSelection recoveryPointSelection;

        private String restoreTestingPlanName;

        private String scheduleExpression;

        private String scheduleExpressionTimezone;

        private Integer startWindowHours;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreTestingPlanForCreate model) {
            recoveryPointSelection(model.recoveryPointSelection);
            restoreTestingPlanName(model.restoreTestingPlanName);
            scheduleExpression(model.scheduleExpression);
            scheduleExpressionTimezone(model.scheduleExpressionTimezone);
            startWindowHours(model.startWindowHours);
        }

        public final RestoreTestingRecoveryPointSelection.Builder getRecoveryPointSelection() {
            return recoveryPointSelection != null ? recoveryPointSelection.toBuilder() : null;
        }

        public final void setRecoveryPointSelection(RestoreTestingRecoveryPointSelection.BuilderImpl recoveryPointSelection) {
            this.recoveryPointSelection = recoveryPointSelection != null ? recoveryPointSelection.build() : null;
        }

        @Override
        public final Builder recoveryPointSelection(RestoreTestingRecoveryPointSelection recoveryPointSelection) {
            this.recoveryPointSelection = recoveryPointSelection;
            return this;
        }

        public final String getRestoreTestingPlanName() {
            return restoreTestingPlanName;
        }

        public final void setRestoreTestingPlanName(String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
        }

        @Override
        public final Builder restoreTestingPlanName(String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
            return this;
        }

        public final String getScheduleExpression() {
            return scheduleExpression;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final String getScheduleExpressionTimezone() {
            return scheduleExpressionTimezone;
        }

        public final void setScheduleExpressionTimezone(String scheduleExpressionTimezone) {
            this.scheduleExpressionTimezone = scheduleExpressionTimezone;
        }

        @Override
        public final Builder scheduleExpressionTimezone(String scheduleExpressionTimezone) {
            this.scheduleExpressionTimezone = scheduleExpressionTimezone;
            return this;
        }

        public final Integer getStartWindowHours() {
            return startWindowHours;
        }

        public final void setStartWindowHours(Integer startWindowHours) {
            this.startWindowHours = startWindowHours;
        }

        @Override
        public final Builder startWindowHours(Integer startWindowHours) {
            this.startWindowHours = startWindowHours;
            return this;
        }

        @Override
        public RestoreTestingPlanForCreate build() {
            return new RestoreTestingPlanForCreate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
