/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This contains metadata about a restore testing plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreTestingPlanForGet implements SdkPojo, Serializable,
        ToCopyableBuilder<RestoreTestingPlanForGet.Builder, RestoreTestingPlanForGet> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(RestoreTestingPlanForGet::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatorRequestId").getter(getter(RestoreTestingPlanForGet::creatorRequestId))
            .setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()).build();

    private static final SdkField<Instant> LAST_EXECUTION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastExecutionTime").getter(getter(RestoreTestingPlanForGet::lastExecutionTime))
            .setter(setter(Builder::lastExecutionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastExecutionTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdateTime").getter(getter(RestoreTestingPlanForGet::lastUpdateTime))
            .setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()).build();

    private static final SdkField<RestoreTestingRecoveryPointSelection> RECOVERY_POINT_SELECTION_FIELD = SdkField
            .<RestoreTestingRecoveryPointSelection> builder(MarshallingType.SDK_POJO).memberName("RecoveryPointSelection")
            .getter(getter(RestoreTestingPlanForGet::recoveryPointSelection)).setter(setter(Builder::recoveryPointSelection))
            .constructor(RestoreTestingRecoveryPointSelection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointSelection").build())
            .build();

    private static final SdkField<String> RESTORE_TESTING_PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RestoreTestingPlanArn").getter(getter(RestoreTestingPlanForGet::restoreTestingPlanArn))
            .setter(setter(Builder::restoreTestingPlanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingPlanArn").build())
            .build();

    private static final SdkField<String> RESTORE_TESTING_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RestoreTestingPlanName").getter(getter(RestoreTestingPlanForGet::restoreTestingPlanName))
            .setter(setter(Builder::restoreTestingPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingPlanName").build())
            .build();

    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduleExpression").getter(getter(RestoreTestingPlanForGet::scheduleExpression))
            .setter(setter(Builder::scheduleExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpression").build())
            .build();

    private static final SdkField<String> SCHEDULE_EXPRESSION_TIMEZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ScheduleExpressionTimezone")
            .getter(getter(RestoreTestingPlanForGet::scheduleExpressionTimezone))
            .setter(setter(Builder::scheduleExpressionTimezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpressionTimezone").build())
            .build();

    private static final SdkField<Integer> START_WINDOW_HOURS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StartWindowHours").getter(getter(RestoreTestingPlanForGet::startWindowHours))
            .setter(setter(Builder::startWindowHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartWindowHours").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD,
            CREATOR_REQUEST_ID_FIELD, LAST_EXECUTION_TIME_FIELD, LAST_UPDATE_TIME_FIELD, RECOVERY_POINT_SELECTION_FIELD,
            RESTORE_TESTING_PLAN_ARN_FIELD, RESTORE_TESTING_PLAN_NAME_FIELD, SCHEDULE_EXPRESSION_FIELD,
            SCHEDULE_EXPRESSION_TIMEZONE_FIELD, START_WINDOW_HOURS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant creationTime;

    private final String creatorRequestId;

    private final Instant lastExecutionTime;

    private final Instant lastUpdateTime;

    private final RestoreTestingRecoveryPointSelection recoveryPointSelection;

    private final String restoreTestingPlanArn;

    private final String restoreTestingPlanName;

    private final String scheduleExpression;

    private final String scheduleExpressionTimezone;

    private final Integer startWindowHours;

    private RestoreTestingPlanForGet(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.creatorRequestId = builder.creatorRequestId;
        this.lastExecutionTime = builder.lastExecutionTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.recoveryPointSelection = builder.recoveryPointSelection;
        this.restoreTestingPlanArn = builder.restoreTestingPlanArn;
        this.restoreTestingPlanName = builder.restoreTestingPlanName;
        this.scheduleExpression = builder.scheduleExpression;
        this.scheduleExpressionTimezone = builder.scheduleExpressionTimezone;
        this.startWindowHours = builder.startWindowHours;
    }

    /**
     * <p>
     * The date and time that a restore testing plan was created, in Unix format and Coordinated Universal Time (UTC).
     * The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087
     * represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that a restore testing plan was created, in Unix format and Coordinated Universal Time
     *         (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value
     *         1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * This identifies the request and allows failed requests to be retried without the risk of running the operation
     * twice. If the request includes a <code>CreatorRequestId</code> that matches an existing backup plan, that plan is
     * returned. This parameter is optional.
     * </p>
     * <p>
     * If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
     * </p>
     * 
     * @return This identifies the request and allows failed requests to be retried without the risk of running the
     *         operation twice. If the request includes a <code>CreatorRequestId</code> that matches an existing backup
     *         plan, that plan is returned. This parameter is optional.</p>
     *         <p>
     *         If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
     */
    public final String creatorRequestId() {
        return creatorRequestId;
    }

    /**
     * <p>
     * The last time a restore test was run with the specified restore testing plan. A date and time, in Unix format and
     * Coordinated Universal Time (UTC). The value of <code>LastExecutionDate</code> is accurate to milliseconds. For
     * example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The last time a restore test was run with the specified restore testing plan. A date and time, in Unix
     *         format and Coordinated Universal Time (UTC). The value of <code>LastExecutionDate</code> is accurate to
     *         milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant lastExecutionTime() {
        return lastExecutionTime;
    }

    /**
     * <p>
     * The date and time that the restore testing plan was updated. This update is in Unix format and Coordinated
     * Universal Time (UTC). The value of <code>LastUpdateTime</code> is accurate to milliseconds. For example, the
     * value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that the restore testing plan was updated. This update is in Unix format and
     *         Coordinated Universal Time (UTC). The value of <code>LastUpdateTime</code> is accurate to milliseconds.
     *         For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    /**
     * <p>
     * The specified criteria to assign a set of resources, such as recovery point types or backup vaults.
     * </p>
     * 
     * @return The specified criteria to assign a set of resources, such as recovery point types or backup vaults.
     */
    public final RestoreTestingRecoveryPointSelection recoveryPointSelection() {
        return recoveryPointSelection;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies a restore testing plan.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies a restore testing plan.
     */
    public final String restoreTestingPlanArn() {
        return restoreTestingPlanArn;
    }

    /**
     * <p>
     * The restore testing plan name.
     * </p>
     * 
     * @return The restore testing plan name.
     */
    public final String restoreTestingPlanName() {
        return restoreTestingPlanName;
    }

    /**
     * <p>
     * A CRON expression in specified timezone when a restore testing plan is executed.
     * </p>
     * 
     * @return A CRON expression in specified timezone when a restore testing plan is executed.
     */
    public final String scheduleExpression() {
        return scheduleExpression;
    }

    /**
     * <p>
     * Optional. This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are in
     * UTC. You can modify this to a specified timezone.
     * </p>
     * 
     * @return Optional. This is the timezone in which the schedule expression is set. By default, ScheduleExpressions
     *         are in UTC. You can modify this to a specified timezone.
     */
    public final String scheduleExpressionTimezone() {
        return scheduleExpressionTimezone;
    }

    /**
     * <p>
     * Defaults to 24 hours.
     * </p>
     * <p>
     * A value in hours after a restore test is scheduled before a job will be canceled if it doesn't start
     * successfully. This value is optional. If this value is included, this parameter has a maximum value of 168 hours
     * (one week).
     * </p>
     * 
     * @return Defaults to 24 hours.</p>
     *         <p>
     *         A value in hours after a restore test is scheduled before a job will be canceled if it doesn't start
     *         successfully. This value is optional. If this value is included, this parameter has a maximum value of
     *         168 hours (one week).
     */
    public final Integer startWindowHours() {
        return startWindowHours;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(lastExecutionTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryPointSelection());
        hashCode = 31 * hashCode + Objects.hashCode(restoreTestingPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(restoreTestingPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleExpressionTimezone());
        hashCode = 31 * hashCode + Objects.hashCode(startWindowHours());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreTestingPlanForGet)) {
            return false;
        }
        RestoreTestingPlanForGet other = (RestoreTestingPlanForGet) obj;
        return Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(creatorRequestId(), other.creatorRequestId())
                && Objects.equals(lastExecutionTime(), other.lastExecutionTime())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime())
                && Objects.equals(recoveryPointSelection(), other.recoveryPointSelection())
                && Objects.equals(restoreTestingPlanArn(), other.restoreTestingPlanArn())
                && Objects.equals(restoreTestingPlanName(), other.restoreTestingPlanName())
                && Objects.equals(scheduleExpression(), other.scheduleExpression())
                && Objects.equals(scheduleExpressionTimezone(), other.scheduleExpressionTimezone())
                && Objects.equals(startWindowHours(), other.startWindowHours());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreTestingPlanForGet").add("CreationTime", creationTime())
                .add("CreatorRequestId", creatorRequestId()).add("LastExecutionTime", lastExecutionTime())
                .add("LastUpdateTime", lastUpdateTime()).add("RecoveryPointSelection", recoveryPointSelection())
                .add("RestoreTestingPlanArn", restoreTestingPlanArn()).add("RestoreTestingPlanName", restoreTestingPlanName())
                .add("ScheduleExpression", scheduleExpression()).add("ScheduleExpressionTimezone", scheduleExpressionTimezone())
                .add("StartWindowHours", startWindowHours()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        case "LastExecutionTime":
            return Optional.ofNullable(clazz.cast(lastExecutionTime()));
        case "LastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        case "RecoveryPointSelection":
            return Optional.ofNullable(clazz.cast(recoveryPointSelection()));
        case "RestoreTestingPlanArn":
            return Optional.ofNullable(clazz.cast(restoreTestingPlanArn()));
        case "RestoreTestingPlanName":
            return Optional.ofNullable(clazz.cast(restoreTestingPlanName()));
        case "ScheduleExpression":
            return Optional.ofNullable(clazz.cast(scheduleExpression()));
        case "ScheduleExpressionTimezone":
            return Optional.ofNullable(clazz.cast(scheduleExpressionTimezone()));
        case "StartWindowHours":
            return Optional.ofNullable(clazz.cast(startWindowHours()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("CreatorRequestId", CREATOR_REQUEST_ID_FIELD);
        map.put("LastExecutionTime", LAST_EXECUTION_TIME_FIELD);
        map.put("LastUpdateTime", LAST_UPDATE_TIME_FIELD);
        map.put("RecoveryPointSelection", RECOVERY_POINT_SELECTION_FIELD);
        map.put("RestoreTestingPlanArn", RESTORE_TESTING_PLAN_ARN_FIELD);
        map.put("RestoreTestingPlanName", RESTORE_TESTING_PLAN_NAME_FIELD);
        map.put("ScheduleExpression", SCHEDULE_EXPRESSION_FIELD);
        map.put("ScheduleExpressionTimezone", SCHEDULE_EXPRESSION_TIMEZONE_FIELD);
        map.put("StartWindowHours", START_WINDOW_HOURS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestoreTestingPlanForGet, T> g) {
        return obj -> g.apply((RestoreTestingPlanForGet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RestoreTestingPlanForGet> {
        /**
         * <p>
         * The date and time that a restore testing plan was created, in Unix format and Coordinated Universal Time
         * (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value
         * 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param creationTime
         *        The date and time that a restore testing plan was created, in Unix format and Coordinated Universal
         *        Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * This identifies the request and allows failed requests to be retried without the risk of running the
         * operation twice. If the request includes a <code>CreatorRequestId</code> that matches an existing backup
         * plan, that plan is returned. This parameter is optional.
         * </p>
         * <p>
         * If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
         * </p>
         * 
         * @param creatorRequestId
         *        This identifies the request and allows failed requests to be retried without the risk of running the
         *        operation twice. If the request includes a <code>CreatorRequestId</code> that matches an existing
         *        backup plan, that plan is returned. This parameter is optional.</p>
         *        <p>
         *        If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        /**
         * <p>
         * The last time a restore test was run with the specified restore testing plan. A date and time, in Unix format
         * and Coordinated Universal Time (UTC). The value of <code>LastExecutionDate</code> is accurate to
         * milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param lastExecutionTime
         *        The last time a restore test was run with the specified restore testing plan. A date and time, in Unix
         *        format and Coordinated Universal Time (UTC). The value of <code>LastExecutionDate</code> is accurate
         *        to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018
         *        12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastExecutionTime(Instant lastExecutionTime);

        /**
         * <p>
         * The date and time that the restore testing plan was updated. This update is in Unix format and Coordinated
         * Universal Time (UTC). The value of <code>LastUpdateTime</code> is accurate to milliseconds. For example, the
         * value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param lastUpdateTime
         *        The date and time that the restore testing plan was updated. This update is in Unix format and
         *        Coordinated Universal Time (UTC). The value of <code>LastUpdateTime</code> is accurate to
         *        milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
         *        AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);

        /**
         * <p>
         * The specified criteria to assign a set of resources, such as recovery point types or backup vaults.
         * </p>
         * 
         * @param recoveryPointSelection
         *        The specified criteria to assign a set of resources, such as recovery point types or backup vaults.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPointSelection(RestoreTestingRecoveryPointSelection recoveryPointSelection);

        /**
         * <p>
         * The specified criteria to assign a set of resources, such as recovery point types or backup vaults.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RestoreTestingRecoveryPointSelection.Builder} avoiding the need to create one manually via
         * {@link RestoreTestingRecoveryPointSelection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RestoreTestingRecoveryPointSelection.Builder#build()} is called
         * immediately and its result is passed to {@link #recoveryPointSelection(RestoreTestingRecoveryPointSelection)}.
         * 
         * @param recoveryPointSelection
         *        a consumer that will call methods on {@link RestoreTestingRecoveryPointSelection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recoveryPointSelection(RestoreTestingRecoveryPointSelection)
         */
        default Builder recoveryPointSelection(Consumer<RestoreTestingRecoveryPointSelection.Builder> recoveryPointSelection) {
            return recoveryPointSelection(RestoreTestingRecoveryPointSelection.builder().applyMutation(recoveryPointSelection)
                    .build());
        }

        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies a restore testing plan.
         * </p>
         * 
         * @param restoreTestingPlanArn
         *        An Amazon Resource Name (ARN) that uniquely identifies a restore testing plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingPlanArn(String restoreTestingPlanArn);

        /**
         * <p>
         * The restore testing plan name.
         * </p>
         * 
         * @param restoreTestingPlanName
         *        The restore testing plan name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingPlanName(String restoreTestingPlanName);

        /**
         * <p>
         * A CRON expression in specified timezone when a restore testing plan is executed.
         * </p>
         * 
         * @param scheduleExpression
         *        A CRON expression in specified timezone when a restore testing plan is executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleExpression(String scheduleExpression);

        /**
         * <p>
         * Optional. This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are
         * in UTC. You can modify this to a specified timezone.
         * </p>
         * 
         * @param scheduleExpressionTimezone
         *        Optional. This is the timezone in which the schedule expression is set. By default,
         *        ScheduleExpressions are in UTC. You can modify this to a specified timezone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleExpressionTimezone(String scheduleExpressionTimezone);

        /**
         * <p>
         * Defaults to 24 hours.
         * </p>
         * <p>
         * A value in hours after a restore test is scheduled before a job will be canceled if it doesn't start
         * successfully. This value is optional. If this value is included, this parameter has a maximum value of 168
         * hours (one week).
         * </p>
         * 
         * @param startWindowHours
         *        Defaults to 24 hours.</p>
         *        <p>
         *        A value in hours after a restore test is scheduled before a job will be canceled if it doesn't start
         *        successfully. This value is optional. If this value is included, this parameter has a maximum value of
         *        168 hours (one week).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startWindowHours(Integer startWindowHours);
    }

    static final class BuilderImpl implements Builder {
        private Instant creationTime;

        private String creatorRequestId;

        private Instant lastExecutionTime;

        private Instant lastUpdateTime;

        private RestoreTestingRecoveryPointSelection recoveryPointSelection;

        private String restoreTestingPlanArn;

        private String restoreTestingPlanName;

        private String scheduleExpression;

        private String scheduleExpressionTimezone;

        private Integer startWindowHours;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreTestingPlanForGet model) {
            creationTime(model.creationTime);
            creatorRequestId(model.creatorRequestId);
            lastExecutionTime(model.lastExecutionTime);
            lastUpdateTime(model.lastUpdateTime);
            recoveryPointSelection(model.recoveryPointSelection);
            restoreTestingPlanArn(model.restoreTestingPlanArn);
            restoreTestingPlanName(model.restoreTestingPlanName);
            scheduleExpression(model.scheduleExpression);
            scheduleExpressionTimezone(model.scheduleExpressionTimezone);
            startWindowHours(model.startWindowHours);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final Instant getLastExecutionTime() {
            return lastExecutionTime;
        }

        public final void setLastExecutionTime(Instant lastExecutionTime) {
            this.lastExecutionTime = lastExecutionTime;
        }

        @Override
        public final Builder lastExecutionTime(Instant lastExecutionTime) {
            this.lastExecutionTime = lastExecutionTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final RestoreTestingRecoveryPointSelection.Builder getRecoveryPointSelection() {
            return recoveryPointSelection != null ? recoveryPointSelection.toBuilder() : null;
        }

        public final void setRecoveryPointSelection(RestoreTestingRecoveryPointSelection.BuilderImpl recoveryPointSelection) {
            this.recoveryPointSelection = recoveryPointSelection != null ? recoveryPointSelection.build() : null;
        }

        @Override
        public final Builder recoveryPointSelection(RestoreTestingRecoveryPointSelection recoveryPointSelection) {
            this.recoveryPointSelection = recoveryPointSelection;
            return this;
        }

        public final String getRestoreTestingPlanArn() {
            return restoreTestingPlanArn;
        }

        public final void setRestoreTestingPlanArn(String restoreTestingPlanArn) {
            this.restoreTestingPlanArn = restoreTestingPlanArn;
        }

        @Override
        public final Builder restoreTestingPlanArn(String restoreTestingPlanArn) {
            this.restoreTestingPlanArn = restoreTestingPlanArn;
            return this;
        }

        public final String getRestoreTestingPlanName() {
            return restoreTestingPlanName;
        }

        public final void setRestoreTestingPlanName(String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
        }

        @Override
        public final Builder restoreTestingPlanName(String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
            return this;
        }

        public final String getScheduleExpression() {
            return scheduleExpression;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final String getScheduleExpressionTimezone() {
            return scheduleExpressionTimezone;
        }

        public final void setScheduleExpressionTimezone(String scheduleExpressionTimezone) {
            this.scheduleExpressionTimezone = scheduleExpressionTimezone;
        }

        @Override
        public final Builder scheduleExpressionTimezone(String scheduleExpressionTimezone) {
            this.scheduleExpressionTimezone = scheduleExpressionTimezone;
            return this;
        }

        public final Integer getStartWindowHours() {
            return startWindowHours;
        }

        public final void setStartWindowHours(Integer startWindowHours) {
            this.startWindowHours = startWindowHours;
        }

        @Override
        public final Builder startWindowHours(Integer startWindowHours) {
            this.startWindowHours = startWindowHours;
            return this;
        }

        @Override
        public RestoreTestingPlanForGet build() {
            return new RestoreTestingPlanForGet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
