/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRecoveryPointIndexSettingsResponse extends BackupResponse implements
        ToCopyableBuilder<UpdateRecoveryPointIndexSettingsResponse.Builder, UpdateRecoveryPointIndexSettingsResponse> {
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultName").getter(getter(UpdateRecoveryPointIndexSettingsResponse::backupVaultName))
            .setter(setter(Builder::backupVaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()).build();

    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecoveryPointArn").getter(getter(UpdateRecoveryPointIndexSettingsResponse::recoveryPointArn))
            .setter(setter(Builder::recoveryPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()).build();

    private static final SdkField<String> INDEX_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexStatus").getter(getter(UpdateRecoveryPointIndexSettingsResponse::indexStatusAsString))
            .setter(setter(Builder::indexStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexStatus").build()).build();

    private static final SdkField<String> INDEX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Index")
            .getter(getter(UpdateRecoveryPointIndexSettingsResponse::indexAsString)).setter(setter(Builder::index))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Index").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_NAME_FIELD,
            RECOVERY_POINT_ARN_FIELD, INDEX_STATUS_FIELD, INDEX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String backupVaultName;

    private final String recoveryPointArn;

    private final String indexStatus;

    private final String index;

    private UpdateRecoveryPointIndexSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.backupVaultName = builder.backupVaultName;
        this.recoveryPointArn = builder.recoveryPointArn;
        this.indexStatus = builder.indexStatus;
        this.index = builder.index;
    }

    /**
     * <p>
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique
     * to the account used to create them and the Region where they are created.
     * </p>
     * 
     * @return The name of a logical container where backups are stored. Backup vaults are identified by names that are
     *         unique to the account used to create them and the Region where they are created.
     */
    public final String backupVaultName() {
        return backupVaultName;
    }

    /**
     * <p>
     * An ARN that uniquely identifies a recovery point; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     * </p>
     * 
     * @return An ARN that uniquely identifies a recovery point; for example,
     *         <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     */
    public final String recoveryPointArn() {
        return recoveryPointArn;
    }

    /**
     * <p>
     * This is the current status for the backup index associated with the specified recovery point.
     * </p>
     * <p>
     * Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
     * </p>
     * <p>
     * A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #indexStatus} will
     * return {@link IndexStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #indexStatusAsString}.
     * </p>
     * 
     * @return This is the current status for the backup index associated with the specified recovery point.</p>
     *         <p>
     *         Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
     *         </p>
     *         <p>
     *         A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
     * @see IndexStatus
     */
    public final IndexStatus indexStatus() {
        return IndexStatus.fromValue(indexStatus);
    }

    /**
     * <p>
     * This is the current status for the backup index associated with the specified recovery point.
     * </p>
     * <p>
     * Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
     * </p>
     * <p>
     * A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #indexStatus} will
     * return {@link IndexStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #indexStatusAsString}.
     * </p>
     * 
     * @return This is the current status for the backup index associated with the specified recovery point.</p>
     *         <p>
     *         Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
     *         </p>
     *         <p>
     *         A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
     * @see IndexStatus
     */
    public final String indexStatusAsString() {
        return indexStatus;
    }

    /**
     * <p>
     * Index can have 1 of 2 possible values, either <code>ENABLED</code> or <code>DISABLED</code>.
     * </p>
     * <p>
     * A value of <code>ENABLED</code> means a backup index for an eligible <code>ACTIVE</code> recovery point has been
     * created.
     * </p>
     * <p>
     * A value of <code>DISABLED</code> means a backup index was deleted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #index} will return
     * {@link Index#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #indexAsString}.
     * </p>
     * 
     * @return Index can have 1 of 2 possible values, either <code>ENABLED</code> or <code>DISABLED</code>.</p>
     *         <p>
     *         A value of <code>ENABLED</code> means a backup index for an eligible <code>ACTIVE</code> recovery point
     *         has been created.
     *         </p>
     *         <p>
     *         A value of <code>DISABLED</code> means a backup index was deleted.
     * @see Index
     */
    public final Index index() {
        return Index.fromValue(index);
    }

    /**
     * <p>
     * Index can have 1 of 2 possible values, either <code>ENABLED</code> or <code>DISABLED</code>.
     * </p>
     * <p>
     * A value of <code>ENABLED</code> means a backup index for an eligible <code>ACTIVE</code> recovery point has been
     * created.
     * </p>
     * <p>
     * A value of <code>DISABLED</code> means a backup index was deleted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #index} will return
     * {@link Index#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #indexAsString}.
     * </p>
     * 
     * @return Index can have 1 of 2 possible values, either <code>ENABLED</code> or <code>DISABLED</code>.</p>
     *         <p>
     *         A value of <code>ENABLED</code> means a backup index for an eligible <code>ACTIVE</code> recovery point
     *         has been created.
     *         </p>
     *         <p>
     *         A value of <code>DISABLED</code> means a backup index was deleted.
     * @see Index
     */
    public final String indexAsString() {
        return index;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(indexStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(indexAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRecoveryPointIndexSettingsResponse)) {
            return false;
        }
        UpdateRecoveryPointIndexSettingsResponse other = (UpdateRecoveryPointIndexSettingsResponse) obj;
        return Objects.equals(backupVaultName(), other.backupVaultName())
                && Objects.equals(recoveryPointArn(), other.recoveryPointArn())
                && Objects.equals(indexStatusAsString(), other.indexStatusAsString())
                && Objects.equals(indexAsString(), other.indexAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRecoveryPointIndexSettingsResponse").add("BackupVaultName", backupVaultName())
                .add("RecoveryPointArn", recoveryPointArn()).add("IndexStatus", indexStatusAsString())
                .add("Index", indexAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupVaultName":
            return Optional.ofNullable(clazz.cast(backupVaultName()));
        case "RecoveryPointArn":
            return Optional.ofNullable(clazz.cast(recoveryPointArn()));
        case "IndexStatus":
            return Optional.ofNullable(clazz.cast(indexStatusAsString()));
        case "Index":
            return Optional.ofNullable(clazz.cast(indexAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BackupVaultName", BACKUP_VAULT_NAME_FIELD);
        map.put("RecoveryPointArn", RECOVERY_POINT_ARN_FIELD);
        map.put("IndexStatus", INDEX_STATUS_FIELD);
        map.put("Index", INDEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRecoveryPointIndexSettingsResponse, T> g) {
        return obj -> g.apply((UpdateRecoveryPointIndexSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateRecoveryPointIndexSettingsResponse> {
        /**
         * <p>
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are
         * unique to the account used to create them and the Region where they are created.
         * </p>
         * 
         * @param backupVaultName
         *        The name of a logical container where backups are stored. Backup vaults are identified by names that
         *        are unique to the account used to create them and the Region where they are created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultName(String backupVaultName);

        /**
         * <p>
         * An ARN that uniquely identifies a recovery point; for example,
         * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
         * </p>
         * 
         * @param recoveryPointArn
         *        An ARN that uniquely identifies a recovery point; for example,
         *        <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPointArn(String recoveryPointArn);

        /**
         * <p>
         * This is the current status for the backup index associated with the specified recovery point.
         * </p>
         * <p>
         * Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
         * </p>
         * <p>
         * A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
         * </p>
         * 
         * @param indexStatus
         *        This is the current status for the backup index associated with the specified recovery point.</p>
         *        <p>
         *        Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
         *        </p>
         *        <p>
         *        A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
         * @see IndexStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexStatus
         */
        Builder indexStatus(String indexStatus);

        /**
         * <p>
         * This is the current status for the backup index associated with the specified recovery point.
         * </p>
         * <p>
         * Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
         * </p>
         * <p>
         * A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
         * </p>
         * 
         * @param indexStatus
         *        This is the current status for the backup index associated with the specified recovery point.</p>
         *        <p>
         *        Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
         *        </p>
         *        <p>
         *        A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
         * @see IndexStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexStatus
         */
        Builder indexStatus(IndexStatus indexStatus);

        /**
         * <p>
         * Index can have 1 of 2 possible values, either <code>ENABLED</code> or <code>DISABLED</code>.
         * </p>
         * <p>
         * A value of <code>ENABLED</code> means a backup index for an eligible <code>ACTIVE</code> recovery point has
         * been created.
         * </p>
         * <p>
         * A value of <code>DISABLED</code> means a backup index was deleted.
         * </p>
         * 
         * @param index
         *        Index can have 1 of 2 possible values, either <code>ENABLED</code> or <code>DISABLED</code>.</p>
         *        <p>
         *        A value of <code>ENABLED</code> means a backup index for an eligible <code>ACTIVE</code> recovery
         *        point has been created.
         *        </p>
         *        <p>
         *        A value of <code>DISABLED</code> means a backup index was deleted.
         * @see Index
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Index
         */
        Builder index(String index);

        /**
         * <p>
         * Index can have 1 of 2 possible values, either <code>ENABLED</code> or <code>DISABLED</code>.
         * </p>
         * <p>
         * A value of <code>ENABLED</code> means a backup index for an eligible <code>ACTIVE</code> recovery point has
         * been created.
         * </p>
         * <p>
         * A value of <code>DISABLED</code> means a backup index was deleted.
         * </p>
         * 
         * @param index
         *        Index can have 1 of 2 possible values, either <code>ENABLED</code> or <code>DISABLED</code>.</p>
         *        <p>
         *        A value of <code>ENABLED</code> means a backup index for an eligible <code>ACTIVE</code> recovery
         *        point has been created.
         *        </p>
         *        <p>
         *        A value of <code>DISABLED</code> means a backup index was deleted.
         * @see Index
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Index
         */
        Builder index(Index index);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private String backupVaultName;

        private String recoveryPointArn;

        private String indexStatus;

        private String index;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRecoveryPointIndexSettingsResponse model) {
            super(model);
            backupVaultName(model.backupVaultName);
            recoveryPointArn(model.recoveryPointArn);
            indexStatus(model.indexStatus);
            index(model.index);
        }

        public final String getBackupVaultName() {
            return backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final String getRecoveryPointArn() {
            return recoveryPointArn;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final String getIndexStatus() {
            return indexStatus;
        }

        public final void setIndexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
        }

        @Override
        public final Builder indexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
            return this;
        }

        @Override
        public final Builder indexStatus(IndexStatus indexStatus) {
            this.indexStatus(indexStatus == null ? null : indexStatus.toString());
            return this;
        }

        public final String getIndex() {
            return index;
        }

        public final void setIndex(String index) {
            this.index = index;
        }

        @Override
        public final Builder index(String index) {
            this.index = index;
            return this;
        }

        @Override
        public final Builder index(Index index) {
            this.index(index == null ? null : index.toString());
            return this;
        }

        @Override
        public UpdateRecoveryPointIndexSettingsResponse build() {
            return new UpdateRecoveryPointIndexSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
