/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model._stringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReportDestination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReportDestination> {
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketName").getter(ReportDestination.getter(ReportDestination::s3BucketName)).setter(ReportDestination.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()}).build();
    private static final SdkField<List<String>> S3_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("S3Keys").getter(ReportDestination.getter(ReportDestination::s3Keys)).setter(ReportDestination.setter(Builder::s3Keys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Keys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_NAME_FIELD, S3_KEYS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReportDestination.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String s3BucketName;
    private final List<String> s3Keys;

    private ReportDestination(BuilderImpl builder) {
        this.s3BucketName = builder.s3BucketName;
        this.s3Keys = builder.s3Keys;
    }

    public final String s3BucketName() {
        return this.s3BucketName;
    }

    public final boolean hasS3Keys() {
        return this.s3Keys != null && !(this.s3Keys instanceof SdkAutoConstructList);
    }

    public final List<String> s3Keys() {
        return this.s3Keys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasS3Keys() ? this.s3Keys() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportDestination)) {
            return false;
        }
        ReportDestination other = (ReportDestination)obj;
        return Objects.equals(this.s3BucketName(), other.s3BucketName()) && this.hasS3Keys() == other.hasS3Keys() && Objects.equals(this.s3Keys(), other.s3Keys());
    }

    public final String toString() {
        return ToString.builder((String)"ReportDestination").add("S3BucketName", (Object)this.s3BucketName()).add("S3Keys", this.hasS3Keys() ? this.s3Keys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
            case "S3Keys": {
                return Optional.ofNullable(clazz.cast(this.s3Keys()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("S3BucketName", S3_BUCKET_NAME_FIELD);
        map.put("S3Keys", S3_KEYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReportDestination, T> g) {
        return obj -> g.apply((ReportDestination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3BucketName;
        private List<String> s3Keys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReportDestination model) {
            this.s3BucketName(model.s3BucketName);
            this.s3Keys(model.s3Keys);
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final Collection<String> getS3Keys() {
            if (this.s3Keys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.s3Keys;
        }

        public final void setS3Keys(Collection<String> s3Keys) {
            this.s3Keys = _stringListCopier.copy(s3Keys);
        }

        @Override
        public final Builder s3Keys(Collection<String> s3Keys) {
            this.s3Keys = _stringListCopier.copy(s3Keys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Keys(String ... s3Keys) {
            this.s3Keys(Arrays.asList(s3Keys));
            return this;
        }

        public ReportDestination build() {
            return new ReportDestination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReportDestination> {
        public Builder s3BucketName(String var1);

        public Builder s3Keys(Collection<String> var1);

        public Builder s3Keys(String ... var1);
    }
}

