/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.RestoreAccessBackupVaultListCopier;
import software.amazon.awssdk.services.backup.model.RestoreAccessBackupVaultListMember;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRestoreAccessBackupVaultsResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, ListRestoreAccessBackupVaultsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRestoreAccessBackupVaultsResponse.getter(ListRestoreAccessBackupVaultsResponse::nextToken)).setter(ListRestoreAccessBackupVaultsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<RestoreAccessBackupVaultListMember>> RESTORE_ACCESS_BACKUP_VAULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RestoreAccessBackupVaults").getter(ListRestoreAccessBackupVaultsResponse.getter(ListRestoreAccessBackupVaultsResponse::restoreAccessBackupVaults)).setter(ListRestoreAccessBackupVaultsResponse.setter(Builder::restoreAccessBackupVaults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreAccessBackupVaults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RestoreAccessBackupVaultListMember::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RESTORE_ACCESS_BACKUP_VAULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRestoreAccessBackupVaultsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<RestoreAccessBackupVaultListMember> restoreAccessBackupVaults;

    private ListRestoreAccessBackupVaultsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.restoreAccessBackupVaults = builder.restoreAccessBackupVaults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasRestoreAccessBackupVaults() {
        return this.restoreAccessBackupVaults != null && !(this.restoreAccessBackupVaults instanceof SdkAutoConstructList);
    }

    public final List<RestoreAccessBackupVaultListMember> restoreAccessBackupVaults() {
        return this.restoreAccessBackupVaults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRestoreAccessBackupVaults() ? this.restoreAccessBackupVaults() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRestoreAccessBackupVaultsResponse)) {
            return false;
        }
        ListRestoreAccessBackupVaultsResponse other = (ListRestoreAccessBackupVaultsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasRestoreAccessBackupVaults() == other.hasRestoreAccessBackupVaults() && Objects.equals(this.restoreAccessBackupVaults(), other.restoreAccessBackupVaults());
    }

    public final String toString() {
        return ToString.builder((String)"ListRestoreAccessBackupVaultsResponse").add("NextToken", (Object)this.nextToken()).add("RestoreAccessBackupVaults", this.hasRestoreAccessBackupVaults() ? this.restoreAccessBackupVaults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RestoreAccessBackupVaults": {
                return Optional.ofNullable(clazz.cast(this.restoreAccessBackupVaults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("RestoreAccessBackupVaults", RESTORE_ACCESS_BACKUP_VAULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRestoreAccessBackupVaultsResponse, T> g) {
        return obj -> g.apply((ListRestoreAccessBackupVaultsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<RestoreAccessBackupVaultListMember> restoreAccessBackupVaults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRestoreAccessBackupVaultsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.restoreAccessBackupVaults(model.restoreAccessBackupVaults);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RestoreAccessBackupVaultListMember.Builder> getRestoreAccessBackupVaults() {
            List<RestoreAccessBackupVaultListMember.Builder> result = RestoreAccessBackupVaultListCopier.copyToBuilder(this.restoreAccessBackupVaults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRestoreAccessBackupVaults(Collection<RestoreAccessBackupVaultListMember.BuilderImpl> restoreAccessBackupVaults) {
            this.restoreAccessBackupVaults = RestoreAccessBackupVaultListCopier.copyFromBuilder(restoreAccessBackupVaults);
        }

        @Override
        public final Builder restoreAccessBackupVaults(Collection<RestoreAccessBackupVaultListMember> restoreAccessBackupVaults) {
            this.restoreAccessBackupVaults = RestoreAccessBackupVaultListCopier.copy(restoreAccessBackupVaults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restoreAccessBackupVaults(RestoreAccessBackupVaultListMember ... restoreAccessBackupVaults) {
            this.restoreAccessBackupVaults(Arrays.asList(restoreAccessBackupVaults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restoreAccessBackupVaults(Consumer<RestoreAccessBackupVaultListMember.Builder> ... restoreAccessBackupVaults) {
            this.restoreAccessBackupVaults(Stream.of(restoreAccessBackupVaults).map(c -> (RestoreAccessBackupVaultListMember)((RestoreAccessBackupVaultListMember.Builder)RestoreAccessBackupVaultListMember.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRestoreAccessBackupVaultsResponse build() {
            return new ListRestoreAccessBackupVaultsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRestoreAccessBackupVaultsResponse> {
        public Builder nextToken(String var1);

        public Builder restoreAccessBackupVaults(Collection<RestoreAccessBackupVaultListMember> var1);

        public Builder restoreAccessBackupVaults(RestoreAccessBackupVaultListMember ... var1);

        public Builder restoreAccessBackupVaults(Consumer<RestoreAccessBackupVaultListMember.Builder> ... var1);
    }
}

