/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.Index;
import software.amazon.awssdk.services.backup.model.IndexStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRecoveryPointIndexSettingsResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, UpdateRecoveryPointIndexSettingsResponse> {
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupVaultName").getter(UpdateRecoveryPointIndexSettingsResponse.getter(UpdateRecoveryPointIndexSettingsResponse::backupVaultName)).setter(UpdateRecoveryPointIndexSettingsResponse.setter(Builder::backupVaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()}).build();
    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecoveryPointArn").getter(UpdateRecoveryPointIndexSettingsResponse.getter(UpdateRecoveryPointIndexSettingsResponse::recoveryPointArn)).setter(UpdateRecoveryPointIndexSettingsResponse.setter(Builder::recoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()}).build();
    private static final SdkField<String> INDEX_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexStatus").getter(UpdateRecoveryPointIndexSettingsResponse.getter(UpdateRecoveryPointIndexSettingsResponse::indexStatusAsString)).setter(UpdateRecoveryPointIndexSettingsResponse.setter(Builder::indexStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexStatus").build()}).build();
    private static final SdkField<String> INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Index").getter(UpdateRecoveryPointIndexSettingsResponse.getter(UpdateRecoveryPointIndexSettingsResponse::indexAsString)).setter(UpdateRecoveryPointIndexSettingsResponse.setter(Builder::index)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Index").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_NAME_FIELD, RECOVERY_POINT_ARN_FIELD, INDEX_STATUS_FIELD, INDEX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateRecoveryPointIndexSettingsResponse.memberNameToFieldInitializer();
    private final String backupVaultName;
    private final String recoveryPointArn;
    private final String indexStatus;
    private final String index;

    private UpdateRecoveryPointIndexSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.backupVaultName = builder.backupVaultName;
        this.recoveryPointArn = builder.recoveryPointArn;
        this.indexStatus = builder.indexStatus;
        this.index = builder.index;
    }

    public final String backupVaultName() {
        return this.backupVaultName;
    }

    public final String recoveryPointArn() {
        return this.recoveryPointArn;
    }

    public final IndexStatus indexStatus() {
        return IndexStatus.fromValue(this.indexStatus);
    }

    public final String indexStatusAsString() {
        return this.indexStatus;
    }

    public final Index index() {
        return Index.fromValue(this.index);
    }

    public final String indexAsString() {
        return this.index;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRecoveryPointIndexSettingsResponse)) {
            return false;
        }
        UpdateRecoveryPointIndexSettingsResponse other = (UpdateRecoveryPointIndexSettingsResponse)((Object)obj);
        return Objects.equals(this.backupVaultName(), other.backupVaultName()) && Objects.equals(this.recoveryPointArn(), other.recoveryPointArn()) && Objects.equals(this.indexStatusAsString(), other.indexStatusAsString()) && Objects.equals(this.indexAsString(), other.indexAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRecoveryPointIndexSettingsResponse").add("BackupVaultName", (Object)this.backupVaultName()).add("RecoveryPointArn", (Object)this.recoveryPointArn()).add("IndexStatus", (Object)this.indexStatusAsString()).add("Index", (Object)this.indexAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupVaultName": {
                return Optional.ofNullable(clazz.cast(this.backupVaultName()));
            }
            case "RecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.recoveryPointArn()));
            }
            case "IndexStatus": {
                return Optional.ofNullable(clazz.cast(this.indexStatusAsString()));
            }
            case "Index": {
                return Optional.ofNullable(clazz.cast(this.indexAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("BackupVaultName", BACKUP_VAULT_NAME_FIELD);
        map.put("RecoveryPointArn", RECOVERY_POINT_ARN_FIELD);
        map.put("IndexStatus", INDEX_STATUS_FIELD);
        map.put("Index", INDEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRecoveryPointIndexSettingsResponse, T> g) {
        return obj -> g.apply((UpdateRecoveryPointIndexSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String backupVaultName;
        private String recoveryPointArn;
        private String indexStatus;
        private String index;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRecoveryPointIndexSettingsResponse model) {
            super(model);
            this.backupVaultName(model.backupVaultName);
            this.recoveryPointArn(model.recoveryPointArn);
            this.indexStatus(model.indexStatus);
            this.index(model.index);
        }

        public final String getBackupVaultName() {
            return this.backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final String getRecoveryPointArn() {
            return this.recoveryPointArn;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final String getIndexStatus() {
            return this.indexStatus;
        }

        public final void setIndexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
        }

        @Override
        public final Builder indexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
            return this;
        }

        @Override
        public final Builder indexStatus(IndexStatus indexStatus) {
            this.indexStatus(indexStatus == null ? null : indexStatus.toString());
            return this;
        }

        public final String getIndex() {
            return this.index;
        }

        public final void setIndex(String index) {
            this.index = index;
        }

        @Override
        public final Builder index(String index) {
            this.index = index;
            return this;
        }

        @Override
        public final Builder index(Index index) {
            this.index(index == null ? null : index.toString());
            return this;
        }

        @Override
        public UpdateRecoveryPointIndexSettingsResponse build() {
            return new UpdateRecoveryPointIndexSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRecoveryPointIndexSettingsResponse> {
        public Builder backupVaultName(String var1);

        public Builder recoveryPointArn(String var1);

        public Builder indexStatus(String var1);

        public Builder indexStatus(IndexStatus var1);

        public Builder index(String var1);

        public Builder index(Index var1);
    }
}

