/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteBackupPlanResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, DeleteBackupPlanResponse> {
    private static final SdkField<String> BACKUP_PLAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupPlanId").getter(DeleteBackupPlanResponse.getter(DeleteBackupPlanResponse::backupPlanId)).setter(DeleteBackupPlanResponse.setter(Builder::backupPlanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanId").build()}).build();
    private static final SdkField<String> BACKUP_PLAN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupPlanArn").getter(DeleteBackupPlanResponse.getter(DeleteBackupPlanResponse::backupPlanArn)).setter(DeleteBackupPlanResponse.setter(Builder::backupPlanArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanArn").build()}).build();
    private static final SdkField<Instant> DELETION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeletionDate").getter(DeleteBackupPlanResponse.getter(DeleteBackupPlanResponse::deletionDate)).setter(DeleteBackupPlanResponse.setter(Builder::deletionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionDate").build()}).build();
    private static final SdkField<String> VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionId").getter(DeleteBackupPlanResponse.getter(DeleteBackupPlanResponse::versionId)).setter(DeleteBackupPlanResponse.setter(Builder::versionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_PLAN_ID_FIELD, BACKUP_PLAN_ARN_FIELD, DELETION_DATE_FIELD, VERSION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteBackupPlanResponse.memberNameToFieldInitializer();
    private final String backupPlanId;
    private final String backupPlanArn;
    private final Instant deletionDate;
    private final String versionId;

    private DeleteBackupPlanResponse(BuilderImpl builder) {
        super(builder);
        this.backupPlanId = builder.backupPlanId;
        this.backupPlanArn = builder.backupPlanArn;
        this.deletionDate = builder.deletionDate;
        this.versionId = builder.versionId;
    }

    public final String backupPlanId() {
        return this.backupPlanId;
    }

    public final String backupPlanArn() {
        return this.backupPlanArn;
    }

    public final Instant deletionDate() {
        return this.deletionDate;
    }

    public final String versionId() {
        return this.versionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBackupPlanResponse)) {
            return false;
        }
        DeleteBackupPlanResponse other = (DeleteBackupPlanResponse)((Object)obj);
        return Objects.equals(this.backupPlanId(), other.backupPlanId()) && Objects.equals(this.backupPlanArn(), other.backupPlanArn()) && Objects.equals(this.deletionDate(), other.deletionDate()) && Objects.equals(this.versionId(), other.versionId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteBackupPlanResponse").add("BackupPlanId", (Object)this.backupPlanId()).add("BackupPlanArn", (Object)this.backupPlanArn()).add("DeletionDate", (Object)this.deletionDate()).add("VersionId", (Object)this.versionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupPlanId": {
                return Optional.ofNullable(clazz.cast(this.backupPlanId()));
            }
            case "BackupPlanArn": {
                return Optional.ofNullable(clazz.cast(this.backupPlanArn()));
            }
            case "DeletionDate": {
                return Optional.ofNullable(clazz.cast(this.deletionDate()));
            }
            case "VersionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BackupPlanId", BACKUP_PLAN_ID_FIELD);
        map.put("BackupPlanArn", BACKUP_PLAN_ARN_FIELD);
        map.put("DeletionDate", DELETION_DATE_FIELD);
        map.put("VersionId", VERSION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteBackupPlanResponse, T> g) {
        return obj -> g.apply((DeleteBackupPlanResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String backupPlanId;
        private String backupPlanArn;
        private Instant deletionDate;
        private String versionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBackupPlanResponse model) {
            super(model);
            this.backupPlanId(model.backupPlanId);
            this.backupPlanArn(model.backupPlanArn);
            this.deletionDate(model.deletionDate);
            this.versionId(model.versionId);
        }

        public final String getBackupPlanId() {
            return this.backupPlanId;
        }

        public final void setBackupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
        }

        @Override
        public final Builder backupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
            return this;
        }

        public final String getBackupPlanArn() {
            return this.backupPlanArn;
        }

        public final void setBackupPlanArn(String backupPlanArn) {
            this.backupPlanArn = backupPlanArn;
        }

        @Override
        public final Builder backupPlanArn(String backupPlanArn) {
            this.backupPlanArn = backupPlanArn;
            return this;
        }

        public final Instant getDeletionDate() {
            return this.deletionDate;
        }

        public final void setDeletionDate(Instant deletionDate) {
            this.deletionDate = deletionDate;
        }

        @Override
        public final Builder deletionDate(Instant deletionDate) {
            this.deletionDate = deletionDate;
            return this;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        @Override
        public DeleteBackupPlanResponse build() {
            return new DeleteBackupPlanResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteBackupPlanResponse> {
        public Builder backupPlanId(String var1);

        public Builder backupPlanArn(String var1);

        public Builder deletionDate(Instant var1);

        public Builder versionId(String var1);
    }
}

