/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This is a resource filter containing FromDate: DateTime and ToDate: DateTime. Both values are required. Future
 * DateTime values are not permitted.
 * </p>
 * <p>
 * The date and time are in Unix format and Coordinated Universal Time (UTC), and it is accurate to milliseconds
 * ((milliseconds are optional). For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
 * AM.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DateRange implements SdkPojo, Serializable, ToCopyableBuilder<DateRange.Builder, DateRange> {
    private static final SdkField<Instant> FROM_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("FromDate").getter(getter(DateRange::fromDate)).setter(setter(Builder::fromDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromDate").build()).build();

    private static final SdkField<Instant> TO_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ToDate").getter(getter(DateRange::toDate)).setter(setter(Builder::toDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FROM_DATE_FIELD, TO_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant fromDate;

    private final Instant toDate;

    private DateRange(BuilderImpl builder) {
        this.fromDate = builder.fromDate;
        this.toDate = builder.toDate;
    }

    /**
     * <p>
     * This value is the beginning date, inclusive.
     * </p>
     * <p>
     * The date and time are in Unix format and Coordinated Universal Time (UTC), and it is accurate to milliseconds
     * (milliseconds are optional).
     * </p>
     * 
     * @return This value is the beginning date, inclusive.</p>
     *         <p>
     *         The date and time are in Unix format and Coordinated Universal Time (UTC), and it is accurate to
     *         milliseconds (milliseconds are optional).
     */
    public final Instant fromDate() {
        return fromDate;
    }

    /**
     * <p>
     * This value is the end date, inclusive.
     * </p>
     * <p>
     * The date and time are in Unix format and Coordinated Universal Time (UTC), and it is accurate to milliseconds
     * (milliseconds are optional).
     * </p>
     * 
     * @return This value is the end date, inclusive.</p>
     *         <p>
     *         The date and time are in Unix format and Coordinated Universal Time (UTC), and it is accurate to
     *         milliseconds (milliseconds are optional).
     */
    public final Instant toDate() {
        return toDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fromDate());
        hashCode = 31 * hashCode + Objects.hashCode(toDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateRange)) {
            return false;
        }
        DateRange other = (DateRange) obj;
        return Objects.equals(fromDate(), other.fromDate()) && Objects.equals(toDate(), other.toDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DateRange").add("FromDate", fromDate()).add("ToDate", toDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FromDate":
            return Optional.ofNullable(clazz.cast(fromDate()));
        case "ToDate":
            return Optional.ofNullable(clazz.cast(toDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FromDate", FROM_DATE_FIELD);
        map.put("ToDate", TO_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DateRange, T> g) {
        return obj -> g.apply((DateRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DateRange> {
        /**
         * <p>
         * This value is the beginning date, inclusive.
         * </p>
         * <p>
         * The date and time are in Unix format and Coordinated Universal Time (UTC), and it is accurate to milliseconds
         * (milliseconds are optional).
         * </p>
         * 
         * @param fromDate
         *        This value is the beginning date, inclusive.</p>
         *        <p>
         *        The date and time are in Unix format and Coordinated Universal Time (UTC), and it is accurate to
         *        milliseconds (milliseconds are optional).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromDate(Instant fromDate);

        /**
         * <p>
         * This value is the end date, inclusive.
         * </p>
         * <p>
         * The date and time are in Unix format and Coordinated Universal Time (UTC), and it is accurate to milliseconds
         * (milliseconds are optional).
         * </p>
         * 
         * @param toDate
         *        This value is the end date, inclusive.</p>
         *        <p>
         *        The date and time are in Unix format and Coordinated Universal Time (UTC), and it is accurate to
         *        milliseconds (milliseconds are optional).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toDate(Instant toDate);
    }

    static final class BuilderImpl implements Builder {
        private Instant fromDate;

        private Instant toDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DateRange model) {
            fromDate(model.fromDate);
            toDate(model.toDate);
        }

        public final Instant getFromDate() {
            return fromDate;
        }

        public final void setFromDate(Instant fromDate) {
            this.fromDate = fromDate;
        }

        @Override
        public final Builder fromDate(Instant fromDate) {
            this.fromDate = fromDate;
            return this;
        }

        public final Instant getToDate() {
            return toDate;
        }

        public final void setToDate(Instant toDate) {
            this.toDate = toDate;
        }

        @Override
        public final Builder toDate(Instant toDate) {
            this.toDate = toDate;
            return this;
        }

        @Override
        public DateRange build() {
            return new DateRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
