/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteRestoreTestingSelectionRequest extends BackupRequest implements
        ToCopyableBuilder<DeleteRestoreTestingSelectionRequest.Builder, DeleteRestoreTestingSelectionRequest> {
    private static final SdkField<String> RESTORE_TESTING_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RestoreTestingPlanName").getter(getter(DeleteRestoreTestingSelectionRequest::restoreTestingPlanName))
            .setter(setter(Builder::restoreTestingPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("RestoreTestingPlanName").build())
            .build();

    private static final SdkField<String> RESTORE_TESTING_SELECTION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING).memberName("RestoreTestingSelectionName")
            .getter(getter(DeleteRestoreTestingSelectionRequest::restoreTestingSelectionName))
            .setter(setter(Builder::restoreTestingSelectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("RestoreTestingSelectionName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESTORE_TESTING_PLAN_NAME_FIELD, RESTORE_TESTING_SELECTION_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String restoreTestingPlanName;

    private final String restoreTestingSelectionName;

    private DeleteRestoreTestingSelectionRequest(BuilderImpl builder) {
        super(builder);
        this.restoreTestingPlanName = builder.restoreTestingPlanName;
        this.restoreTestingSelectionName = builder.restoreTestingSelectionName;
    }

    /**
     * <p>
     * Required unique name of the restore testing plan that contains the restore testing selection you wish to delete.
     * </p>
     * 
     * @return Required unique name of the restore testing plan that contains the restore testing selection you wish to
     *         delete.
     */
    public final String restoreTestingPlanName() {
        return restoreTestingPlanName;
    }

    /**
     * <p>
     * Required unique name of the restore testing selection you wish to delete.
     * </p>
     * 
     * @return Required unique name of the restore testing selection you wish to delete.
     */
    public final String restoreTestingSelectionName() {
        return restoreTestingSelectionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(restoreTestingPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(restoreTestingSelectionName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRestoreTestingSelectionRequest)) {
            return false;
        }
        DeleteRestoreTestingSelectionRequest other = (DeleteRestoreTestingSelectionRequest) obj;
        return Objects.equals(restoreTestingPlanName(), other.restoreTestingPlanName())
                && Objects.equals(restoreTestingSelectionName(), other.restoreTestingSelectionName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteRestoreTestingSelectionRequest").add("RestoreTestingPlanName", restoreTestingPlanName())
                .add("RestoreTestingSelectionName", restoreTestingSelectionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RestoreTestingPlanName":
            return Optional.ofNullable(clazz.cast(restoreTestingPlanName()));
        case "RestoreTestingSelectionName":
            return Optional.ofNullable(clazz.cast(restoreTestingSelectionName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RestoreTestingPlanName", RESTORE_TESTING_PLAN_NAME_FIELD);
        map.put("RestoreTestingSelectionName", RESTORE_TESTING_SELECTION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteRestoreTestingSelectionRequest, T> g) {
        return obj -> g.apply((DeleteRestoreTestingSelectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BackupRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteRestoreTestingSelectionRequest> {
        /**
         * <p>
         * Required unique name of the restore testing plan that contains the restore testing selection you wish to
         * delete.
         * </p>
         * 
         * @param restoreTestingPlanName
         *        Required unique name of the restore testing plan that contains the restore testing selection you wish
         *        to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingPlanName(String restoreTestingPlanName);

        /**
         * <p>
         * Required unique name of the restore testing selection you wish to delete.
         * </p>
         * 
         * @param restoreTestingSelectionName
         *        Required unique name of the restore testing selection you wish to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingSelectionName(String restoreTestingSelectionName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String restoreTestingPlanName;

        private String restoreTestingSelectionName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRestoreTestingSelectionRequest model) {
            super(model);
            restoreTestingPlanName(model.restoreTestingPlanName);
            restoreTestingSelectionName(model.restoreTestingSelectionName);
        }

        public final String getRestoreTestingPlanName() {
            return restoreTestingPlanName;
        }

        public final void setRestoreTestingPlanName(String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
        }

        @Override
        public final Builder restoreTestingPlanName(String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
            return this;
        }

        public final String getRestoreTestingSelectionName() {
            return restoreTestingSelectionName;
        }

        public final void setRestoreTestingSelectionName(String restoreTestingSelectionName) {
            this.restoreTestingSelectionName = restoreTestingSelectionName;
        }

        @Override
        public final Builder restoreTestingSelectionName(String restoreTestingSelectionName) {
            this.restoreTestingSelectionName = restoreTestingSelectionName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRestoreTestingSelectionRequest build() {
            return new DeleteRestoreTestingSelectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
