/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRecoveryPointIndexDetailsResponse extends BackupResponse implements
        ToCopyableBuilder<GetRecoveryPointIndexDetailsResponse.Builder, GetRecoveryPointIndexDetailsResponse> {
    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecoveryPointArn").getter(getter(GetRecoveryPointIndexDetailsResponse::recoveryPointArn))
            .setter(setter(Builder::recoveryPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()).build();

    private static final SdkField<String> BACKUP_VAULT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultArn").getter(getter(GetRecoveryPointIndexDetailsResponse::backupVaultArn))
            .setter(setter(Builder::backupVaultArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultArn").build()).build();

    private static final SdkField<String> SOURCE_RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceResourceArn").getter(getter(GetRecoveryPointIndexDetailsResponse::sourceResourceArn))
            .setter(setter(Builder::sourceResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceResourceArn").build()).build();

    private static final SdkField<Instant> INDEX_CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("IndexCreationDate").getter(getter(GetRecoveryPointIndexDetailsResponse::indexCreationDate))
            .setter(setter(Builder::indexCreationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexCreationDate").build()).build();

    private static final SdkField<Instant> INDEX_DELETION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("IndexDeletionDate").getter(getter(GetRecoveryPointIndexDetailsResponse::indexDeletionDate))
            .setter(setter(Builder::indexDeletionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexDeletionDate").build()).build();

    private static final SdkField<Instant> INDEX_COMPLETION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("IndexCompletionDate").getter(getter(GetRecoveryPointIndexDetailsResponse::indexCompletionDate))
            .setter(setter(Builder::indexCompletionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexCompletionDate").build())
            .build();

    private static final SdkField<String> INDEX_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexStatus").getter(getter(GetRecoveryPointIndexDetailsResponse::indexStatusAsString))
            .setter(setter(Builder::indexStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexStatus").build()).build();

    private static final SdkField<String> INDEX_STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexStatusMessage").getter(getter(GetRecoveryPointIndexDetailsResponse::indexStatusMessage))
            .setter(setter(Builder::indexStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexStatusMessage").build())
            .build();

    private static final SdkField<Long> TOTAL_ITEMS_INDEXED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TotalItemsIndexed").getter(getter(GetRecoveryPointIndexDetailsResponse::totalItemsIndexed))
            .setter(setter(Builder::totalItemsIndexed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalItemsIndexed").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOVERY_POINT_ARN_FIELD,
            BACKUP_VAULT_ARN_FIELD, SOURCE_RESOURCE_ARN_FIELD, INDEX_CREATION_DATE_FIELD, INDEX_DELETION_DATE_FIELD,
            INDEX_COMPLETION_DATE_FIELD, INDEX_STATUS_FIELD, INDEX_STATUS_MESSAGE_FIELD, TOTAL_ITEMS_INDEXED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String recoveryPointArn;

    private final String backupVaultArn;

    private final String sourceResourceArn;

    private final Instant indexCreationDate;

    private final Instant indexDeletionDate;

    private final Instant indexCompletionDate;

    private final String indexStatus;

    private final String indexStatusMessage;

    private final Long totalItemsIndexed;

    private GetRecoveryPointIndexDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.recoveryPointArn = builder.recoveryPointArn;
        this.backupVaultArn = builder.backupVaultArn;
        this.sourceResourceArn = builder.sourceResourceArn;
        this.indexCreationDate = builder.indexCreationDate;
        this.indexDeletionDate = builder.indexDeletionDate;
        this.indexCompletionDate = builder.indexCompletionDate;
        this.indexStatus = builder.indexStatus;
        this.indexStatusMessage = builder.indexStatusMessage;
        this.totalItemsIndexed = builder.totalItemsIndexed;
    }

    /**
     * <p>
     * An ARN that uniquely identifies a recovery point; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     * </p>
     * 
     * @return An ARN that uniquely identifies a recovery point; for example,
     *         <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     */
    public final String recoveryPointArn() {
        return recoveryPointArn;
    }

    /**
     * <p>
     * An ARN that uniquely identifies the backup vault where the recovery point index is stored.
     * </p>
     * <p>
     * For example, <code>arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault</code>.
     * </p>
     * 
     * @return An ARN that uniquely identifies the backup vault where the recovery point index is stored.</p>
     *         <p>
     *         For example, <code>arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault</code>.
     */
    public final String backupVaultArn() {
        return backupVaultArn;
    }

    /**
     * <p>
     * A string of the Amazon Resource Name (ARN) that uniquely identifies the source resource.
     * </p>
     * 
     * @return A string of the Amazon Resource Name (ARN) that uniquely identifies the source resource.
     */
    public final String sourceResourceArn() {
        return sourceResourceArn;
    }

    /**
     * <p>
     * The date and time that a backup index was created, in Unix format and Coordinated Universal Time (UTC). The value
     * of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
     * Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that a backup index was created, in Unix format and Coordinated Universal Time (UTC).
     *         The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087
     *         represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant indexCreationDate() {
        return indexCreationDate;
    }

    /**
     * <p>
     * The date and time that a backup index was deleted, in Unix format and Coordinated Universal Time (UTC). The value
     * of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
     * Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that a backup index was deleted, in Unix format and Coordinated Universal Time (UTC).
     *         The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087
     *         represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant indexDeletionDate() {
        return indexDeletionDate;
    }

    /**
     * <p>
     * The date and time that a backup index finished creation, in Unix format and Coordinated Universal Time (UTC). The
     * value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
     * Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that a backup index finished creation, in Unix format and Coordinated Universal Time
     *         (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value
     *         1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant indexCompletionDate() {
        return indexCompletionDate;
    }

    /**
     * <p>
     * This is the current status for the backup index associated with the specified recovery point.
     * </p>
     * <p>
     * Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
     * </p>
     * <p>
     * A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #indexStatus} will
     * return {@link IndexStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #indexStatusAsString}.
     * </p>
     * 
     * @return This is the current status for the backup index associated with the specified recovery point.</p>
     *         <p>
     *         Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
     *         </p>
     *         <p>
     *         A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
     * @see IndexStatus
     */
    public final IndexStatus indexStatus() {
        return IndexStatus.fromValue(indexStatus);
    }

    /**
     * <p>
     * This is the current status for the backup index associated with the specified recovery point.
     * </p>
     * <p>
     * Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
     * </p>
     * <p>
     * A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #indexStatus} will
     * return {@link IndexStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #indexStatusAsString}.
     * </p>
     * 
     * @return This is the current status for the backup index associated with the specified recovery point.</p>
     *         <p>
     *         Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
     *         </p>
     *         <p>
     *         A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
     * @see IndexStatus
     */
    public final String indexStatusAsString() {
        return indexStatus;
    }

    /**
     * <p>
     * A detailed message explaining the status of a backup index associated with the recovery point.
     * </p>
     * 
     * @return A detailed message explaining the status of a backup index associated with the recovery point.
     */
    public final String indexStatusMessage() {
        return indexStatusMessage;
    }

    /**
     * <p>
     * Count of items within the backup index associated with the recovery point.
     * </p>
     * 
     * @return Count of items within the backup index associated with the recovery point.
     */
    public final Long totalItemsIndexed() {
        return totalItemsIndexed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(indexCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(indexDeletionDate());
        hashCode = 31 * hashCode + Objects.hashCode(indexCompletionDate());
        hashCode = 31 * hashCode + Objects.hashCode(indexStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(indexStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(totalItemsIndexed());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecoveryPointIndexDetailsResponse)) {
            return false;
        }
        GetRecoveryPointIndexDetailsResponse other = (GetRecoveryPointIndexDetailsResponse) obj;
        return Objects.equals(recoveryPointArn(), other.recoveryPointArn())
                && Objects.equals(backupVaultArn(), other.backupVaultArn())
                && Objects.equals(sourceResourceArn(), other.sourceResourceArn())
                && Objects.equals(indexCreationDate(), other.indexCreationDate())
                && Objects.equals(indexDeletionDate(), other.indexDeletionDate())
                && Objects.equals(indexCompletionDate(), other.indexCompletionDate())
                && Objects.equals(indexStatusAsString(), other.indexStatusAsString())
                && Objects.equals(indexStatusMessage(), other.indexStatusMessage())
                && Objects.equals(totalItemsIndexed(), other.totalItemsIndexed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRecoveryPointIndexDetailsResponse").add("RecoveryPointArn", recoveryPointArn())
                .add("BackupVaultArn", backupVaultArn()).add("SourceResourceArn", sourceResourceArn())
                .add("IndexCreationDate", indexCreationDate()).add("IndexDeletionDate", indexDeletionDate())
                .add("IndexCompletionDate", indexCompletionDate()).add("IndexStatus", indexStatusAsString())
                .add("IndexStatusMessage", indexStatusMessage()).add("TotalItemsIndexed", totalItemsIndexed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecoveryPointArn":
            return Optional.ofNullable(clazz.cast(recoveryPointArn()));
        case "BackupVaultArn":
            return Optional.ofNullable(clazz.cast(backupVaultArn()));
        case "SourceResourceArn":
            return Optional.ofNullable(clazz.cast(sourceResourceArn()));
        case "IndexCreationDate":
            return Optional.ofNullable(clazz.cast(indexCreationDate()));
        case "IndexDeletionDate":
            return Optional.ofNullable(clazz.cast(indexDeletionDate()));
        case "IndexCompletionDate":
            return Optional.ofNullable(clazz.cast(indexCompletionDate()));
        case "IndexStatus":
            return Optional.ofNullable(clazz.cast(indexStatusAsString()));
        case "IndexStatusMessage":
            return Optional.ofNullable(clazz.cast(indexStatusMessage()));
        case "TotalItemsIndexed":
            return Optional.ofNullable(clazz.cast(totalItemsIndexed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RecoveryPointArn", RECOVERY_POINT_ARN_FIELD);
        map.put("BackupVaultArn", BACKUP_VAULT_ARN_FIELD);
        map.put("SourceResourceArn", SOURCE_RESOURCE_ARN_FIELD);
        map.put("IndexCreationDate", INDEX_CREATION_DATE_FIELD);
        map.put("IndexDeletionDate", INDEX_DELETION_DATE_FIELD);
        map.put("IndexCompletionDate", INDEX_COMPLETION_DATE_FIELD);
        map.put("IndexStatus", INDEX_STATUS_FIELD);
        map.put("IndexStatusMessage", INDEX_STATUS_MESSAGE_FIELD);
        map.put("TotalItemsIndexed", TOTAL_ITEMS_INDEXED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRecoveryPointIndexDetailsResponse, T> g) {
        return obj -> g.apply((GetRecoveryPointIndexDetailsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BackupResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRecoveryPointIndexDetailsResponse> {
        /**
         * <p>
         * An ARN that uniquely identifies a recovery point; for example,
         * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
         * </p>
         * 
         * @param recoveryPointArn
         *        An ARN that uniquely identifies a recovery point; for example,
         *        <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPointArn(String recoveryPointArn);

        /**
         * <p>
         * An ARN that uniquely identifies the backup vault where the recovery point index is stored.
         * </p>
         * <p>
         * For example, <code>arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault</code>.
         * </p>
         * 
         * @param backupVaultArn
         *        An ARN that uniquely identifies the backup vault where the recovery point index is stored.</p>
         *        <p>
         *        For example, <code>arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultArn(String backupVaultArn);

        /**
         * <p>
         * A string of the Amazon Resource Name (ARN) that uniquely identifies the source resource.
         * </p>
         * 
         * @param sourceResourceArn
         *        A string of the Amazon Resource Name (ARN) that uniquely identifies the source resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceResourceArn(String sourceResourceArn);

        /**
         * <p>
         * The date and time that a backup index was created, in Unix format and Coordinated Universal Time (UTC). The
         * value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087
         * represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param indexCreationDate
         *        The date and time that a backup index was created, in Unix format and Coordinated Universal Time
         *        (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexCreationDate(Instant indexCreationDate);

        /**
         * <p>
         * The date and time that a backup index was deleted, in Unix format and Coordinated Universal Time (UTC). The
         * value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087
         * represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param indexDeletionDate
         *        The date and time that a backup index was deleted, in Unix format and Coordinated Universal Time
         *        (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexDeletionDate(Instant indexDeletionDate);

        /**
         * <p>
         * The date and time that a backup index finished creation, in Unix format and Coordinated Universal Time (UTC).
         * The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087
         * represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param indexCompletionDate
         *        The date and time that a backup index finished creation, in Unix format and Coordinated Universal Time
         *        (UTC). The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexCompletionDate(Instant indexCompletionDate);

        /**
         * <p>
         * This is the current status for the backup index associated with the specified recovery point.
         * </p>
         * <p>
         * Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
         * </p>
         * <p>
         * A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
         * </p>
         * 
         * @param indexStatus
         *        This is the current status for the backup index associated with the specified recovery point.</p>
         *        <p>
         *        Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
         *        </p>
         *        <p>
         *        A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
         * @see IndexStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexStatus
         */
        Builder indexStatus(String indexStatus);

        /**
         * <p>
         * This is the current status for the backup index associated with the specified recovery point.
         * </p>
         * <p>
         * Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
         * </p>
         * <p>
         * A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
         * </p>
         * 
         * @param indexStatus
         *        This is the current status for the backup index associated with the specified recovery point.</p>
         *        <p>
         *        Statuses are: <code>PENDING</code> | <code>ACTIVE</code> | <code>FAILED</code> | <code>DELETING</code>
         *        </p>
         *        <p>
         *        A recovery point with an index that has the status of <code>ACTIVE</code> can be included in a search.
         * @see IndexStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexStatus
         */
        Builder indexStatus(IndexStatus indexStatus);

        /**
         * <p>
         * A detailed message explaining the status of a backup index associated with the recovery point.
         * </p>
         * 
         * @param indexStatusMessage
         *        A detailed message explaining the status of a backup index associated with the recovery point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexStatusMessage(String indexStatusMessage);

        /**
         * <p>
         * Count of items within the backup index associated with the recovery point.
         * </p>
         * 
         * @param totalItemsIndexed
         *        Count of items within the backup index associated with the recovery point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalItemsIndexed(Long totalItemsIndexed);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private String recoveryPointArn;

        private String backupVaultArn;

        private String sourceResourceArn;

        private Instant indexCreationDate;

        private Instant indexDeletionDate;

        private Instant indexCompletionDate;

        private String indexStatus;

        private String indexStatusMessage;

        private Long totalItemsIndexed;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecoveryPointIndexDetailsResponse model) {
            super(model);
            recoveryPointArn(model.recoveryPointArn);
            backupVaultArn(model.backupVaultArn);
            sourceResourceArn(model.sourceResourceArn);
            indexCreationDate(model.indexCreationDate);
            indexDeletionDate(model.indexDeletionDate);
            indexCompletionDate(model.indexCompletionDate);
            indexStatus(model.indexStatus);
            indexStatusMessage(model.indexStatusMessage);
            totalItemsIndexed(model.totalItemsIndexed);
        }

        public final String getRecoveryPointArn() {
            return recoveryPointArn;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final String getBackupVaultArn() {
            return backupVaultArn;
        }

        public final void setBackupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
        }

        @Override
        public final Builder backupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
            return this;
        }

        public final String getSourceResourceArn() {
            return sourceResourceArn;
        }

        public final void setSourceResourceArn(String sourceResourceArn) {
            this.sourceResourceArn = sourceResourceArn;
        }

        @Override
        public final Builder sourceResourceArn(String sourceResourceArn) {
            this.sourceResourceArn = sourceResourceArn;
            return this;
        }

        public final Instant getIndexCreationDate() {
            return indexCreationDate;
        }

        public final void setIndexCreationDate(Instant indexCreationDate) {
            this.indexCreationDate = indexCreationDate;
        }

        @Override
        public final Builder indexCreationDate(Instant indexCreationDate) {
            this.indexCreationDate = indexCreationDate;
            return this;
        }

        public final Instant getIndexDeletionDate() {
            return indexDeletionDate;
        }

        public final void setIndexDeletionDate(Instant indexDeletionDate) {
            this.indexDeletionDate = indexDeletionDate;
        }

        @Override
        public final Builder indexDeletionDate(Instant indexDeletionDate) {
            this.indexDeletionDate = indexDeletionDate;
            return this;
        }

        public final Instant getIndexCompletionDate() {
            return indexCompletionDate;
        }

        public final void setIndexCompletionDate(Instant indexCompletionDate) {
            this.indexCompletionDate = indexCompletionDate;
        }

        @Override
        public final Builder indexCompletionDate(Instant indexCompletionDate) {
            this.indexCompletionDate = indexCompletionDate;
            return this;
        }

        public final String getIndexStatus() {
            return indexStatus;
        }

        public final void setIndexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
        }

        @Override
        public final Builder indexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
            return this;
        }

        @Override
        public final Builder indexStatus(IndexStatus indexStatus) {
            this.indexStatus(indexStatus == null ? null : indexStatus.toString());
            return this;
        }

        public final String getIndexStatusMessage() {
            return indexStatusMessage;
        }

        public final void setIndexStatusMessage(String indexStatusMessage) {
            this.indexStatusMessage = indexStatusMessage;
        }

        @Override
        public final Builder indexStatusMessage(String indexStatusMessage) {
            this.indexStatusMessage = indexStatusMessage;
            return this;
        }

        public final Long getTotalItemsIndexed() {
            return totalItemsIndexed;
        }

        public final void setTotalItemsIndexed(Long totalItemsIndexed) {
            this.totalItemsIndexed = totalItemsIndexed;
        }

        @Override
        public final Builder totalItemsIndexed(Long totalItemsIndexed) {
            this.totalItemsIndexed = totalItemsIndexed;
            return this;
        }

        @Override
        public GetRecoveryPointIndexDetailsResponse build() {
            return new GetRecoveryPointIndexDetailsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
