/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the latest update to an MPA approval team association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LatestMpaApprovalTeamUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<LatestMpaApprovalTeamUpdate.Builder, LatestMpaApprovalTeamUpdate> {
    private static final SdkField<String> MPA_SESSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MpaSessionArn").getter(getter(LatestMpaApprovalTeamUpdate::mpaSessionArn))
            .setter(setter(Builder::mpaSessionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MpaSessionArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(LatestMpaApprovalTeamUpdate::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(LatestMpaApprovalTeamUpdate::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<Instant> INITIATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("InitiationDate").getter(getter(LatestMpaApprovalTeamUpdate::initiationDate))
            .setter(setter(Builder::initiationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiationDate").build()).build();

    private static final SdkField<Instant> EXPIRY_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpiryDate").getter(getter(LatestMpaApprovalTeamUpdate::expiryDate)).setter(setter(Builder::expiryDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiryDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MPA_SESSION_ARN_FIELD,
            STATUS_FIELD, STATUS_MESSAGE_FIELD, INITIATION_DATE_FIELD, EXPIRY_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String mpaSessionArn;

    private final String status;

    private final String statusMessage;

    private final Instant initiationDate;

    private final Instant expiryDate;

    private LatestMpaApprovalTeamUpdate(BuilderImpl builder) {
        this.mpaSessionArn = builder.mpaSessionArn;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.initiationDate = builder.initiationDate;
        this.expiryDate = builder.expiryDate;
    }

    /**
     * <p>
     * The ARN of the MPA session associated with this update.
     * </p>
     * 
     * @return The ARN of the MPA session associated with this update.
     */
    public final String mpaSessionArn() {
        return mpaSessionArn;
    }

    /**
     * <p>
     * The current status of the MPA approval team update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MpaSessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the MPA approval team update.
     * @see MpaSessionStatus
     */
    public final MpaSessionStatus status() {
        return MpaSessionStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the MPA approval team update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MpaSessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the MPA approval team update.
     * @see MpaSessionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A message describing the current status of the MPA approval team update.
     * </p>
     * 
     * @return A message describing the current status of the MPA approval team update.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The date and time when the MPA approval team update was initiated.
     * </p>
     * 
     * @return The date and time when the MPA approval team update was initiated.
     */
    public final Instant initiationDate() {
        return initiationDate;
    }

    /**
     * <p>
     * The date and time when the MPA approval team update will expire.
     * </p>
     * 
     * @return The date and time when the MPA approval team update will expire.
     */
    public final Instant expiryDate() {
        return expiryDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mpaSessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(initiationDate());
        hashCode = 31 * hashCode + Objects.hashCode(expiryDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LatestMpaApprovalTeamUpdate)) {
            return false;
        }
        LatestMpaApprovalTeamUpdate other = (LatestMpaApprovalTeamUpdate) obj;
        return Objects.equals(mpaSessionArn(), other.mpaSessionArn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(initiationDate(), other.initiationDate()) && Objects.equals(expiryDate(), other.expiryDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LatestMpaApprovalTeamUpdate").add("MpaSessionArn", mpaSessionArn())
                .add("Status", statusAsString()).add("StatusMessage", statusMessage()).add("InitiationDate", initiationDate())
                .add("ExpiryDate", expiryDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MpaSessionArn":
            return Optional.ofNullable(clazz.cast(mpaSessionArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "InitiationDate":
            return Optional.ofNullable(clazz.cast(initiationDate()));
        case "ExpiryDate":
            return Optional.ofNullable(clazz.cast(expiryDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MpaSessionArn", MPA_SESSION_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("InitiationDate", INITIATION_DATE_FIELD);
        map.put("ExpiryDate", EXPIRY_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LatestMpaApprovalTeamUpdate, T> g) {
        return obj -> g.apply((LatestMpaApprovalTeamUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LatestMpaApprovalTeamUpdate> {
        /**
         * <p>
         * The ARN of the MPA session associated with this update.
         * </p>
         * 
         * @param mpaSessionArn
         *        The ARN of the MPA session associated with this update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mpaSessionArn(String mpaSessionArn);

        /**
         * <p>
         * The current status of the MPA approval team update.
         * </p>
         * 
         * @param status
         *        The current status of the MPA approval team update.
         * @see MpaSessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MpaSessionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the MPA approval team update.
         * </p>
         * 
         * @param status
         *        The current status of the MPA approval team update.
         * @see MpaSessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MpaSessionStatus
         */
        Builder status(MpaSessionStatus status);

        /**
         * <p>
         * A message describing the current status of the MPA approval team update.
         * </p>
         * 
         * @param statusMessage
         *        A message describing the current status of the MPA approval team update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The date and time when the MPA approval team update was initiated.
         * </p>
         * 
         * @param initiationDate
         *        The date and time when the MPA approval team update was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiationDate(Instant initiationDate);

        /**
         * <p>
         * The date and time when the MPA approval team update will expire.
         * </p>
         * 
         * @param expiryDate
         *        The date and time when the MPA approval team update will expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiryDate(Instant expiryDate);
    }

    static final class BuilderImpl implements Builder {
        private String mpaSessionArn;

        private String status;

        private String statusMessage;

        private Instant initiationDate;

        private Instant expiryDate;

        private BuilderImpl() {
        }

        private BuilderImpl(LatestMpaApprovalTeamUpdate model) {
            mpaSessionArn(model.mpaSessionArn);
            status(model.status);
            statusMessage(model.statusMessage);
            initiationDate(model.initiationDate);
            expiryDate(model.expiryDate);
        }

        public final String getMpaSessionArn() {
            return mpaSessionArn;
        }

        public final void setMpaSessionArn(String mpaSessionArn) {
            this.mpaSessionArn = mpaSessionArn;
        }

        @Override
        public final Builder mpaSessionArn(String mpaSessionArn) {
            this.mpaSessionArn = mpaSessionArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MpaSessionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getInitiationDate() {
            return initiationDate;
        }

        public final void setInitiationDate(Instant initiationDate) {
            this.initiationDate = initiationDate;
        }

        @Override
        public final Builder initiationDate(Instant initiationDate) {
            this.initiationDate = initiationDate;
            return this;
        }

        public final Instant getExpiryDate() {
            return expiryDate;
        }

        public final void setExpiryDate(Instant expiryDate) {
            this.expiryDate = expiryDate;
        }

        @Override
        public final Builder expiryDate(Instant expiryDate) {
            this.expiryDate = expiryDate;
            return this;
        }

        @Override
        public LatestMpaApprovalTeamUpdate build() {
            return new LatestMpaApprovalTeamUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
