/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateReportPlanRequest extends BackupRequest implements
        ToCopyableBuilder<UpdateReportPlanRequest.Builder, UpdateReportPlanRequest> {
    private static final SdkField<String> REPORT_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReportPlanName").getter(getter(UpdateReportPlanRequest::reportPlanName))
            .setter(setter(Builder::reportPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("reportPlanName").build()).build();

    private static final SdkField<String> REPORT_PLAN_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReportPlanDescription").getter(getter(UpdateReportPlanRequest::reportPlanDescription))
            .setter(setter(Builder::reportPlanDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportPlanDescription").build())
            .build();

    private static final SdkField<ReportDeliveryChannel> REPORT_DELIVERY_CHANNEL_FIELD = SdkField
            .<ReportDeliveryChannel> builder(MarshallingType.SDK_POJO).memberName("ReportDeliveryChannel")
            .getter(getter(UpdateReportPlanRequest::reportDeliveryChannel)).setter(setter(Builder::reportDeliveryChannel))
            .constructor(ReportDeliveryChannel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportDeliveryChannel").build())
            .build();

    private static final SdkField<ReportSetting> REPORT_SETTING_FIELD = SdkField
            .<ReportSetting> builder(MarshallingType.SDK_POJO).memberName("ReportSetting")
            .getter(getter(UpdateReportPlanRequest::reportSetting)).setter(setter(Builder::reportSetting))
            .constructor(ReportSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportSetting").build()).build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IdempotencyToken")
            .getter(getter(UpdateReportPlanRequest::idempotencyToken))
            .setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_PLAN_NAME_FIELD,
            REPORT_PLAN_DESCRIPTION_FIELD, REPORT_DELIVERY_CHANNEL_FIELD, REPORT_SETTING_FIELD, IDEMPOTENCY_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String reportPlanName;

    private final String reportPlanDescription;

    private final ReportDeliveryChannel reportDeliveryChannel;

    private final ReportSetting reportSetting;

    private final String idempotencyToken;

    private UpdateReportPlanRequest(BuilderImpl builder) {
        super(builder);
        this.reportPlanName = builder.reportPlanName;
        this.reportPlanDescription = builder.reportPlanDescription;
        this.reportDeliveryChannel = builder.reportDeliveryChannel;
        this.reportSetting = builder.reportSetting;
        this.idempotencyToken = builder.idempotencyToken;
    }

    /**
     * <p>
     * The unique name of the report plan. This name is between 1 and 256 characters, starting with a letter, and
     * consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
     * </p>
     * 
     * @return The unique name of the report plan. This name is between 1 and 256 characters, starting with a letter,
     *         and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
     */
    public final String reportPlanName() {
        return reportPlanName;
    }

    /**
     * <p>
     * An optional description of the report plan with a maximum 1,024 characters.
     * </p>
     * 
     * @return An optional description of the report plan with a maximum 1,024 characters.
     */
    public final String reportPlanDescription() {
        return reportPlanDescription;
    }

    /**
     * <p>
     * The information about where to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and
     * the formats of your reports.
     * </p>
     * 
     * @return The information about where to deliver your reports, specifically your Amazon S3 bucket name, S3 key
     *         prefix, and the formats of your reports.
     */
    public final ReportDeliveryChannel reportDeliveryChannel() {
        return reportDeliveryChannel;
    }

    /**
     * <p>
     * The report template for the report. Reports are built using a report template. The report templates are:
     * </p>
     * <p>
     * <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
     * </p>
     * <p>
     * If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or <code>CONTROL_COMPLIANCE_REPORT</code>, this
     * API resource also describes the report coverage by Amazon Web Services Regions and frameworks.
     * </p>
     * 
     * @return The report template for the report. Reports are built using a report template. The report templates
     *         are:</p>
     *         <p>
     *         <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
     *         </p>
     *         <p>
     *         If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or
     *         <code>CONTROL_COMPLIANCE_REPORT</code>, this API resource also describes the report coverage by Amazon
     *         Web Services Regions and frameworks.
     */
    public final ReportSetting reportSetting() {
        return reportSetting;
    }

    /**
     * <p>
     * A customer-chosen string that you can use to distinguish between otherwise identical calls to
     * <code>UpdateReportPlanInput</code>. Retrying a successful request with the same idempotency token results in a
     * success message with no action taken.
     * </p>
     * 
     * @return A customer-chosen string that you can use to distinguish between otherwise identical calls to
     *         <code>UpdateReportPlanInput</code>. Retrying a successful request with the same idempotency token results
     *         in a success message with no action taken.
     */
    public final String idempotencyToken() {
        return idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reportPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(reportPlanDescription());
        hashCode = 31 * hashCode + Objects.hashCode(reportDeliveryChannel());
        hashCode = 31 * hashCode + Objects.hashCode(reportSetting());
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateReportPlanRequest)) {
            return false;
        }
        UpdateReportPlanRequest other = (UpdateReportPlanRequest) obj;
        return Objects.equals(reportPlanName(), other.reportPlanName())
                && Objects.equals(reportPlanDescription(), other.reportPlanDescription())
                && Objects.equals(reportDeliveryChannel(), other.reportDeliveryChannel())
                && Objects.equals(reportSetting(), other.reportSetting())
                && Objects.equals(idempotencyToken(), other.idempotencyToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateReportPlanRequest").add("ReportPlanName", reportPlanName())
                .add("ReportPlanDescription", reportPlanDescription()).add("ReportDeliveryChannel", reportDeliveryChannel())
                .add("ReportSetting", reportSetting()).add("IdempotencyToken", idempotencyToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReportPlanName":
            return Optional.ofNullable(clazz.cast(reportPlanName()));
        case "ReportPlanDescription":
            return Optional.ofNullable(clazz.cast(reportPlanDescription()));
        case "ReportDeliveryChannel":
            return Optional.ofNullable(clazz.cast(reportDeliveryChannel()));
        case "ReportSetting":
            return Optional.ofNullable(clazz.cast(reportSetting()));
        case "IdempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("reportPlanName", REPORT_PLAN_NAME_FIELD);
        map.put("ReportPlanDescription", REPORT_PLAN_DESCRIPTION_FIELD);
        map.put("ReportDeliveryChannel", REPORT_DELIVERY_CHANNEL_FIELD);
        map.put("ReportSetting", REPORT_SETTING_FIELD);
        map.put("IdempotencyToken", IDEMPOTENCY_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateReportPlanRequest, T> g) {
        return obj -> g.apply((UpdateReportPlanRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BackupRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateReportPlanRequest> {
        /**
         * <p>
         * The unique name of the report plan. This name is between 1 and 256 characters, starting with a letter, and
         * consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
         * </p>
         * 
         * @param reportPlanName
         *        The unique name of the report plan. This name is between 1 and 256 characters, starting with a letter,
         *        and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportPlanName(String reportPlanName);

        /**
         * <p>
         * An optional description of the report plan with a maximum 1,024 characters.
         * </p>
         * 
         * @param reportPlanDescription
         *        An optional description of the report plan with a maximum 1,024 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportPlanDescription(String reportPlanDescription);

        /**
         * <p>
         * The information about where to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix,
         * and the formats of your reports.
         * </p>
         * 
         * @param reportDeliveryChannel
         *        The information about where to deliver your reports, specifically your Amazon S3 bucket name, S3 key
         *        prefix, and the formats of your reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportDeliveryChannel(ReportDeliveryChannel reportDeliveryChannel);

        /**
         * <p>
         * The information about where to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix,
         * and the formats of your reports.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReportDeliveryChannel.Builder} avoiding
         * the need to create one manually via {@link ReportDeliveryChannel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReportDeliveryChannel.Builder#build()} is called immediately and
         * its result is passed to {@link #reportDeliveryChannel(ReportDeliveryChannel)}.
         * 
         * @param reportDeliveryChannel
         *        a consumer that will call methods on {@link ReportDeliveryChannel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reportDeliveryChannel(ReportDeliveryChannel)
         */
        default Builder reportDeliveryChannel(Consumer<ReportDeliveryChannel.Builder> reportDeliveryChannel) {
            return reportDeliveryChannel(ReportDeliveryChannel.builder().applyMutation(reportDeliveryChannel).build());
        }

        /**
         * <p>
         * The report template for the report. Reports are built using a report template. The report templates are:
         * </p>
         * <p>
         * <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
         * </p>
         * <p>
         * If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or <code>CONTROL_COMPLIANCE_REPORT</code>,
         * this API resource also describes the report coverage by Amazon Web Services Regions and frameworks.
         * </p>
         * 
         * @param reportSetting
         *        The report template for the report. Reports are built using a report template. The report templates
         *        are:</p>
         *        <p>
         *        <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
         *        </p>
         *        <p>
         *        If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or
         *        <code>CONTROL_COMPLIANCE_REPORT</code>, this API resource also describes the report coverage by Amazon
         *        Web Services Regions and frameworks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportSetting(ReportSetting reportSetting);

        /**
         * <p>
         * The report template for the report. Reports are built using a report template. The report templates are:
         * </p>
         * <p>
         * <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
         * </p>
         * <p>
         * If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or <code>CONTROL_COMPLIANCE_REPORT</code>,
         * this API resource also describes the report coverage by Amazon Web Services Regions and frameworks.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReportSetting.Builder} avoiding the need
         * to create one manually via {@link ReportSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReportSetting.Builder#build()} is called immediately and its
         * result is passed to {@link #reportSetting(ReportSetting)}.
         * 
         * @param reportSetting
         *        a consumer that will call methods on {@link ReportSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reportSetting(ReportSetting)
         */
        default Builder reportSetting(Consumer<ReportSetting.Builder> reportSetting) {
            return reportSetting(ReportSetting.builder().applyMutation(reportSetting).build());
        }

        /**
         * <p>
         * A customer-chosen string that you can use to distinguish between otherwise identical calls to
         * <code>UpdateReportPlanInput</code>. Retrying a successful request with the same idempotency token results in
         * a success message with no action taken.
         * </p>
         * 
         * @param idempotencyToken
         *        A customer-chosen string that you can use to distinguish between otherwise identical calls to
         *        <code>UpdateReportPlanInput</code>. Retrying a successful request with the same idempotency token
         *        results in a success message with no action taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String reportPlanName;

        private String reportPlanDescription;

        private ReportDeliveryChannel reportDeliveryChannel;

        private ReportSetting reportSetting;

        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateReportPlanRequest model) {
            super(model);
            reportPlanName(model.reportPlanName);
            reportPlanDescription(model.reportPlanDescription);
            reportDeliveryChannel(model.reportDeliveryChannel);
            reportSetting(model.reportSetting);
            idempotencyToken(model.idempotencyToken);
        }

        public final String getReportPlanName() {
            return reportPlanName;
        }

        public final void setReportPlanName(String reportPlanName) {
            this.reportPlanName = reportPlanName;
        }

        @Override
        public final Builder reportPlanName(String reportPlanName) {
            this.reportPlanName = reportPlanName;
            return this;
        }

        public final String getReportPlanDescription() {
            return reportPlanDescription;
        }

        public final void setReportPlanDescription(String reportPlanDescription) {
            this.reportPlanDescription = reportPlanDescription;
        }

        @Override
        public final Builder reportPlanDescription(String reportPlanDescription) {
            this.reportPlanDescription = reportPlanDescription;
            return this;
        }

        public final ReportDeliveryChannel.Builder getReportDeliveryChannel() {
            return reportDeliveryChannel != null ? reportDeliveryChannel.toBuilder() : null;
        }

        public final void setReportDeliveryChannel(ReportDeliveryChannel.BuilderImpl reportDeliveryChannel) {
            this.reportDeliveryChannel = reportDeliveryChannel != null ? reportDeliveryChannel.build() : null;
        }

        @Override
        public final Builder reportDeliveryChannel(ReportDeliveryChannel reportDeliveryChannel) {
            this.reportDeliveryChannel = reportDeliveryChannel;
            return this;
        }

        public final ReportSetting.Builder getReportSetting() {
            return reportSetting != null ? reportSetting.toBuilder() : null;
        }

        public final void setReportSetting(ReportSetting.BuilderImpl reportSetting) {
            this.reportSetting = reportSetting != null ? reportSetting.build() : null;
        }

        @Override
        public final Builder reportSetting(ReportSetting reportSetting) {
            this.reportSetting = reportSetting;
            return this;
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateReportPlanRequest build() {
            return new UpdateReportPlanRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
