/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupAsyncClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.ListRestoreAccessBackupVaultsRequest;
import software.amazon.awssdk.services.backup.model.ListRestoreAccessBackupVaultsResponse;
import software.amazon.awssdk.services.backup.model.RestoreAccessBackupVaultListMember;

public class ListRestoreAccessBackupVaultsPublisher
implements SdkPublisher<ListRestoreAccessBackupVaultsResponse> {
    private final BackupAsyncClient client;
    private final ListRestoreAccessBackupVaultsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRestoreAccessBackupVaultsPublisher(BackupAsyncClient client, ListRestoreAccessBackupVaultsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRestoreAccessBackupVaultsPublisher(BackupAsyncClient client, ListRestoreAccessBackupVaultsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRestoreAccessBackupVaultsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRestoreAccessBackupVaultsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RestoreAccessBackupVaultListMember> restoreAccessBackupVaults() {
        Function<ListRestoreAccessBackupVaultsResponse, Iterator> getIterator = response -> {
            if (response != null && response.restoreAccessBackupVaults() != null) {
                return response.restoreAccessBackupVaults().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRestoreAccessBackupVaultsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRestoreAccessBackupVaultsResponseFetcher
    implements AsyncPageFetcher<ListRestoreAccessBackupVaultsResponse> {
        private ListRestoreAccessBackupVaultsResponseFetcher() {
        }

        public boolean hasNextPage(ListRestoreAccessBackupVaultsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRestoreAccessBackupVaultsResponse> nextPage(ListRestoreAccessBackupVaultsResponse previousPage) {
            if (previousPage == null) {
                return ListRestoreAccessBackupVaultsPublisher.this.client.listRestoreAccessBackupVaults(ListRestoreAccessBackupVaultsPublisher.this.firstRequest);
            }
            return ListRestoreAccessBackupVaultsPublisher.this.client.listRestoreAccessBackupVaults((ListRestoreAccessBackupVaultsRequest)((Object)ListRestoreAccessBackupVaultsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

