/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBackupJobsRequest extends BackupRequest implements
        ToCopyableBuilder<ListBackupJobsRequest.Builder, ListBackupJobsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListBackupJobsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListBackupJobsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> BY_RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ByResourceArn").getter(getter(ListBackupJobsRequest::byResourceArn))
            .setter(setter(Builder::byResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceArn").build()).build();

    private static final SdkField<String> BY_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ByState").getter(getter(ListBackupJobsRequest::byStateAsString)).setter(setter(Builder::byState))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("state").build()).build();

    private static final SdkField<String> BY_BACKUP_VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ByBackupVaultName").getter(getter(ListBackupJobsRequest::byBackupVaultName))
            .setter(setter(Builder::byBackupVaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("backupVaultName").build())
            .build();

    private static final SdkField<Instant> BY_CREATED_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ByCreatedBefore").getter(getter(ListBackupJobsRequest::byCreatedBefore))
            .setter(setter(Builder::byCreatedBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdBefore").build()).build();

    private static final SdkField<Instant> BY_CREATED_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ByCreatedAfter").getter(getter(ListBackupJobsRequest::byCreatedAfter))
            .setter(setter(Builder::byCreatedAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdAfter").build()).build();

    private static final SdkField<String> BY_RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ByResourceType").getter(getter(ListBackupJobsRequest::byResourceType))
            .setter(setter(Builder::byResourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceType").build()).build();

    private static final SdkField<String> BY_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ByAccountId").getter(getter(ListBackupJobsRequest::byAccountId)).setter(setter(Builder::byAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("accountId").build()).build();

    private static final SdkField<Instant> BY_COMPLETE_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ByCompleteAfter").getter(getter(ListBackupJobsRequest::byCompleteAfter))
            .setter(setter(Builder::byCompleteAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("completeAfter").build()).build();

    private static final SdkField<Instant> BY_COMPLETE_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ByCompleteBefore").getter(getter(ListBackupJobsRequest::byCompleteBefore))
            .setter(setter(Builder::byCompleteBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("completeBefore").build())
            .build();

    private static final SdkField<String> BY_PARENT_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ByParentJobId").getter(getter(ListBackupJobsRequest::byParentJobId))
            .setter(setter(Builder::byParentJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("parentJobId").build()).build();

    private static final SdkField<String> BY_MESSAGE_CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ByMessageCategory").getter(getter(ListBackupJobsRequest::byMessageCategory))
            .setter(setter(Builder::byMessageCategory))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("messageCategory").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, BY_RESOURCE_ARN_FIELD, BY_STATE_FIELD, BY_BACKUP_VAULT_NAME_FIELD, BY_CREATED_BEFORE_FIELD,
            BY_CREATED_AFTER_FIELD, BY_RESOURCE_TYPE_FIELD, BY_ACCOUNT_ID_FIELD, BY_COMPLETE_AFTER_FIELD,
            BY_COMPLETE_BEFORE_FIELD, BY_PARENT_JOB_ID_FIELD, BY_MESSAGE_CATEGORY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final Integer maxResults;

    private final String byResourceArn;

    private final String byState;

    private final String byBackupVaultName;

    private final Instant byCreatedBefore;

    private final Instant byCreatedAfter;

    private final String byResourceType;

    private final String byAccountId;

    private final Instant byCompleteAfter;

    private final Instant byCompleteBefore;

    private final String byParentJobId;

    private final String byMessageCategory;

    private ListBackupJobsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.byResourceArn = builder.byResourceArn;
        this.byState = builder.byState;
        this.byBackupVaultName = builder.byBackupVaultName;
        this.byCreatedBefore = builder.byCreatedBefore;
        this.byCreatedAfter = builder.byCreatedAfter;
        this.byResourceType = builder.byResourceType;
        this.byAccountId = builder.byAccountId;
        this.byCompleteAfter = builder.byCompleteAfter;
        this.byCompleteBefore = builder.byCompleteBefore;
        this.byParentJobId = builder.byParentJobId;
        this.byMessageCategory = builder.byMessageCategory;
    }

    /**
     * <p>
     * The next item following a partial list of returned items. For example, if a request is made to return
     * <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
     * starting at the location pointed to by the next token.
     * </p>
     * 
     * @return The next item following a partial list of returned items. For example, if a request is made to return
     *         <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your
     *         list starting at the location pointed to by the next token.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to be returned.
     * </p>
     * 
     * @return The maximum number of items to be returned.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Returns only backup jobs that match the specified resource Amazon Resource Name (ARN).
     * </p>
     * 
     * @return Returns only backup jobs that match the specified resource Amazon Resource Name (ARN).
     */
    public final String byResourceArn() {
        return byResourceArn;
    }

    /**
     * <p>
     * Returns only backup jobs that are in the specified state.
     * </p>
     * <p>
     * <code>Completed with issues</code> is a status found only in the Backup console. For API, this status refers to
     * jobs with a state of <code>COMPLETED</code> and a <code>MessageCategory</code> with a value other than
     * <code>SUCCESS</code>; that is, the status is completed but comes with a status message.
     * </p>
     * <p>
     * To obtain the job count for <code>Completed with issues</code>, run two GET requests, and subtract the second,
     * smaller number:
     * </p>
     * <p>
     * GET /backup-jobs/?state=COMPLETED
     * </p>
     * <p>
     * GET /backup-jobs/?messageCategory=SUCCESS&amp;state=COMPLETED
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #byState} will
     * return {@link BackupJobState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #byStateAsString}.
     * </p>
     * 
     * @return Returns only backup jobs that are in the specified state.</p>
     *         <p>
     *         <code>Completed with issues</code> is a status found only in the Backup console. For API, this status
     *         refers to jobs with a state of <code>COMPLETED</code> and a <code>MessageCategory</code> with a value
     *         other than <code>SUCCESS</code>; that is, the status is completed but comes with a status message.
     *         </p>
     *         <p>
     *         To obtain the job count for <code>Completed with issues</code>, run two GET requests, and subtract the
     *         second, smaller number:
     *         </p>
     *         <p>
     *         GET /backup-jobs/?state=COMPLETED
     *         </p>
     *         <p>
     *         GET /backup-jobs/?messageCategory=SUCCESS&amp;state=COMPLETED
     * @see BackupJobState
     */
    public final BackupJobState byState() {
        return BackupJobState.fromValue(byState);
    }

    /**
     * <p>
     * Returns only backup jobs that are in the specified state.
     * </p>
     * <p>
     * <code>Completed with issues</code> is a status found only in the Backup console. For API, this status refers to
     * jobs with a state of <code>COMPLETED</code> and a <code>MessageCategory</code> with a value other than
     * <code>SUCCESS</code>; that is, the status is completed but comes with a status message.
     * </p>
     * <p>
     * To obtain the job count for <code>Completed with issues</code>, run two GET requests, and subtract the second,
     * smaller number:
     * </p>
     * <p>
     * GET /backup-jobs/?state=COMPLETED
     * </p>
     * <p>
     * GET /backup-jobs/?messageCategory=SUCCESS&amp;state=COMPLETED
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #byState} will
     * return {@link BackupJobState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #byStateAsString}.
     * </p>
     * 
     * @return Returns only backup jobs that are in the specified state.</p>
     *         <p>
     *         <code>Completed with issues</code> is a status found only in the Backup console. For API, this status
     *         refers to jobs with a state of <code>COMPLETED</code> and a <code>MessageCategory</code> with a value
     *         other than <code>SUCCESS</code>; that is, the status is completed but comes with a status message.
     *         </p>
     *         <p>
     *         To obtain the job count for <code>Completed with issues</code>, run two GET requests, and subtract the
     *         second, smaller number:
     *         </p>
     *         <p>
     *         GET /backup-jobs/?state=COMPLETED
     *         </p>
     *         <p>
     *         GET /backup-jobs/?messageCategory=SUCCESS&amp;state=COMPLETED
     * @see BackupJobState
     */
    public final String byStateAsString() {
        return byState;
    }

    /**
     * <p>
     * Returns only backup jobs that will be stored in the specified backup vault. Backup vaults are identified by names
     * that are unique to the account used to create them and the Amazon Web Services Region where they are created.
     * </p>
     * 
     * @return Returns only backup jobs that will be stored in the specified backup vault. Backup vaults are identified
     *         by names that are unique to the account used to create them and the Amazon Web Services Region where they
     *         are created.
     */
    public final String byBackupVaultName() {
        return byBackupVaultName;
    }

    /**
     * <p>
     * Returns only backup jobs that were created before the specified date.
     * </p>
     * 
     * @return Returns only backup jobs that were created before the specified date.
     */
    public final Instant byCreatedBefore() {
        return byCreatedBefore;
    }

    /**
     * <p>
     * Returns only backup jobs that were created after the specified date.
     * </p>
     * 
     * @return Returns only backup jobs that were created after the specified date.
     */
    public final Instant byCreatedAfter() {
        return byCreatedAfter;
    }

    /**
     * <p>
     * Returns only backup jobs for the specified resources:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Aurora</code> for Amazon Aurora
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CloudFormation</code> for CloudFormation
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DocumentDB</code> for Amazon DocumentDB (with MongoDB compatibility)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DynamoDB</code> for Amazon DynamoDB
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EBS</code> for Amazon Elastic Block Store
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EC2</code> for Amazon Elastic Compute Cloud
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EFS</code> for Amazon Elastic File System
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FSx</code> for Amazon FSx
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Neptune</code> for Amazon Neptune
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RDS</code> for Amazon Relational Database Service
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Redshift</code> for Amazon Redshift
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>S3</code> for Amazon Simple Storage Service (Amazon S3)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SAP HANA on Amazon EC2</code> for SAP HANA databases on Amazon Elastic Compute Cloud instances
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Storage Gateway</code> for Storage Gateway
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Timestream</code> for Amazon Timestream
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VirtualMachine</code> for VMware virtual machines
     * </p>
     * </li>
     * </ul>
     * 
     * @return Returns only backup jobs for the specified resources:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Aurora</code> for Amazon Aurora
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CloudFormation</code> for CloudFormation
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DocumentDB</code> for Amazon DocumentDB (with MongoDB compatibility)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DynamoDB</code> for Amazon DynamoDB
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EBS</code> for Amazon Elastic Block Store
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EC2</code> for Amazon Elastic Compute Cloud
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EFS</code> for Amazon Elastic File System
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FSx</code> for Amazon FSx
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Neptune</code> for Amazon Neptune
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RDS</code> for Amazon Relational Database Service
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Redshift</code> for Amazon Redshift
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>S3</code> for Amazon Simple Storage Service (Amazon S3)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SAP HANA on Amazon EC2</code> for SAP HANA databases on Amazon Elastic Compute Cloud instances
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Storage Gateway</code> for Storage Gateway
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Timestream</code> for Amazon Timestream
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VirtualMachine</code> for VMware virtual machines
     *         </p>
     *         </li>
     */
    public final String byResourceType() {
        return byResourceType;
    }

    /**
     * <p>
     * The account ID to list the jobs from. Returns only backup jobs associated with the specified account ID.
     * </p>
     * <p>
     * If used from an Organizations management account, passing <code>*</code> returns all jobs across the
     * organization.
     * </p>
     * 
     * @return The account ID to list the jobs from. Returns only backup jobs associated with the specified account
     *         ID.</p>
     *         <p>
     *         If used from an Organizations management account, passing <code>*</code> returns all jobs across the
     *         organization.
     */
    public final String byAccountId() {
        return byAccountId;
    }

    /**
     * <p>
     * Returns only backup jobs completed after a date expressed in Unix format and Coordinated Universal Time (UTC).
     * </p>
     * 
     * @return Returns only backup jobs completed after a date expressed in Unix format and Coordinated Universal Time
     *         (UTC).
     */
    public final Instant byCompleteAfter() {
        return byCompleteAfter;
    }

    /**
     * <p>
     * Returns only backup jobs completed before a date expressed in Unix format and Coordinated Universal Time (UTC).
     * </p>
     * 
     * @return Returns only backup jobs completed before a date expressed in Unix format and Coordinated Universal Time
     *         (UTC).
     */
    public final Instant byCompleteBefore() {
        return byCompleteBefore;
    }

    /**
     * <p>
     * This is a filter to list child (nested) jobs based on parent job ID.
     * </p>
     * 
     * @return This is a filter to list child (nested) jobs based on parent job ID.
     */
    public final String byParentJobId() {
        return byParentJobId;
    }

    /**
     * <p>
     * This is an optional parameter that can be used to filter out jobs with a MessageCategory which matches the value
     * you input.
     * </p>
     * <p>
     * Example strings may include <code>AccessDenied</code>, <code>SUCCESS</code>, <code>AGGREGATE_ALL</code>, and
     * <code>InvalidParameters</code>.
     * </p>
     * <p>
     * View <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">Monitoring</a>
     * </p>
     * <p>
     * The wildcard () returns count of all message categories.
     * </p>
     * <p>
     * <code>AGGREGATE_ALL</code> aggregates job counts for all message categories and returns the sum.
     * </p>
     * 
     * @return This is an optional parameter that can be used to filter out jobs with a MessageCategory which matches
     *         the value you input.</p>
     *         <p>
     *         Example strings may include <code>AccessDenied</code>, <code>SUCCESS</code>, <code>AGGREGATE_ALL</code>,
     *         and <code>InvalidParameters</code>.
     *         </p>
     *         <p>
     *         View <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">Monitoring</a>
     *         </p>
     *         <p>
     *         The wildcard () returns count of all message categories.
     *         </p>
     *         <p>
     *         <code>AGGREGATE_ALL</code> aggregates job counts for all message categories and returns the sum.
     */
    public final String byMessageCategory() {
        return byMessageCategory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(byResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(byStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(byBackupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(byCreatedBefore());
        hashCode = 31 * hashCode + Objects.hashCode(byCreatedAfter());
        hashCode = 31 * hashCode + Objects.hashCode(byResourceType());
        hashCode = 31 * hashCode + Objects.hashCode(byAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(byCompleteAfter());
        hashCode = 31 * hashCode + Objects.hashCode(byCompleteBefore());
        hashCode = 31 * hashCode + Objects.hashCode(byParentJobId());
        hashCode = 31 * hashCode + Objects.hashCode(byMessageCategory());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBackupJobsRequest)) {
            return false;
        }
        ListBackupJobsRequest other = (ListBackupJobsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(byResourceArn(), other.byResourceArn())
                && Objects.equals(byStateAsString(), other.byStateAsString())
                && Objects.equals(byBackupVaultName(), other.byBackupVaultName())
                && Objects.equals(byCreatedBefore(), other.byCreatedBefore())
                && Objects.equals(byCreatedAfter(), other.byCreatedAfter())
                && Objects.equals(byResourceType(), other.byResourceType()) && Objects.equals(byAccountId(), other.byAccountId())
                && Objects.equals(byCompleteAfter(), other.byCompleteAfter())
                && Objects.equals(byCompleteBefore(), other.byCompleteBefore())
                && Objects.equals(byParentJobId(), other.byParentJobId())
                && Objects.equals(byMessageCategory(), other.byMessageCategory());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBackupJobsRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("ByResourceArn", byResourceArn()).add("ByState", byStateAsString())
                .add("ByBackupVaultName", byBackupVaultName()).add("ByCreatedBefore", byCreatedBefore())
                .add("ByCreatedAfter", byCreatedAfter()).add("ByResourceType", byResourceType())
                .add("ByAccountId", byAccountId()).add("ByCompleteAfter", byCompleteAfter())
                .add("ByCompleteBefore", byCompleteBefore()).add("ByParentJobId", byParentJobId())
                .add("ByMessageCategory", byMessageCategory()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "ByResourceArn":
            return Optional.ofNullable(clazz.cast(byResourceArn()));
        case "ByState":
            return Optional.ofNullable(clazz.cast(byStateAsString()));
        case "ByBackupVaultName":
            return Optional.ofNullable(clazz.cast(byBackupVaultName()));
        case "ByCreatedBefore":
            return Optional.ofNullable(clazz.cast(byCreatedBefore()));
        case "ByCreatedAfter":
            return Optional.ofNullable(clazz.cast(byCreatedAfter()));
        case "ByResourceType":
            return Optional.ofNullable(clazz.cast(byResourceType()));
        case "ByAccountId":
            return Optional.ofNullable(clazz.cast(byAccountId()));
        case "ByCompleteAfter":
            return Optional.ofNullable(clazz.cast(byCompleteAfter()));
        case "ByCompleteBefore":
            return Optional.ofNullable(clazz.cast(byCompleteBefore()));
        case "ByParentJobId":
            return Optional.ofNullable(clazz.cast(byParentJobId()));
        case "ByMessageCategory":
            return Optional.ofNullable(clazz.cast(byMessageCategory()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("resourceArn", BY_RESOURCE_ARN_FIELD);
        map.put("state", BY_STATE_FIELD);
        map.put("backupVaultName", BY_BACKUP_VAULT_NAME_FIELD);
        map.put("createdBefore", BY_CREATED_BEFORE_FIELD);
        map.put("createdAfter", BY_CREATED_AFTER_FIELD);
        map.put("resourceType", BY_RESOURCE_TYPE_FIELD);
        map.put("accountId", BY_ACCOUNT_ID_FIELD);
        map.put("completeAfter", BY_COMPLETE_AFTER_FIELD);
        map.put("completeBefore", BY_COMPLETE_BEFORE_FIELD);
        map.put("parentJobId", BY_PARENT_JOB_ID_FIELD);
        map.put("messageCategory", BY_MESSAGE_CATEGORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBackupJobsRequest, T> g) {
        return obj -> g.apply((ListBackupJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BackupRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListBackupJobsRequest> {
        /**
         * <p>
         * The next item following a partial list of returned items. For example, if a request is made to return
         * <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
         * starting at the location pointed to by the next token.
         * </p>
         * 
         * @param nextToken
         *        The next item following a partial list of returned items. For example, if a request is made to return
         *        <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in
         *        your list starting at the location pointed to by the next token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to be returned.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Returns only backup jobs that match the specified resource Amazon Resource Name (ARN).
         * </p>
         * 
         * @param byResourceArn
         *        Returns only backup jobs that match the specified resource Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byResourceArn(String byResourceArn);

        /**
         * <p>
         * Returns only backup jobs that are in the specified state.
         * </p>
         * <p>
         * <code>Completed with issues</code> is a status found only in the Backup console. For API, this status refers
         * to jobs with a state of <code>COMPLETED</code> and a <code>MessageCategory</code> with a value other than
         * <code>SUCCESS</code>; that is, the status is completed but comes with a status message.
         * </p>
         * <p>
         * To obtain the job count for <code>Completed with issues</code>, run two GET requests, and subtract the
         * second, smaller number:
         * </p>
         * <p>
         * GET /backup-jobs/?state=COMPLETED
         * </p>
         * <p>
         * GET /backup-jobs/?messageCategory=SUCCESS&amp;state=COMPLETED
         * </p>
         * 
         * @param byState
         *        Returns only backup jobs that are in the specified state.</p>
         *        <p>
         *        <code>Completed with issues</code> is a status found only in the Backup console. For API, this status
         *        refers to jobs with a state of <code>COMPLETED</code> and a <code>MessageCategory</code> with a value
         *        other than <code>SUCCESS</code>; that is, the status is completed but comes with a status message.
         *        </p>
         *        <p>
         *        To obtain the job count for <code>Completed with issues</code>, run two GET requests, and subtract the
         *        second, smaller number:
         *        </p>
         *        <p>
         *        GET /backup-jobs/?state=COMPLETED
         *        </p>
         *        <p>
         *        GET /backup-jobs/?messageCategory=SUCCESS&amp;state=COMPLETED
         * @see BackupJobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BackupJobState
         */
        Builder byState(String byState);

        /**
         * <p>
         * Returns only backup jobs that are in the specified state.
         * </p>
         * <p>
         * <code>Completed with issues</code> is a status found only in the Backup console. For API, this status refers
         * to jobs with a state of <code>COMPLETED</code> and a <code>MessageCategory</code> with a value other than
         * <code>SUCCESS</code>; that is, the status is completed but comes with a status message.
         * </p>
         * <p>
         * To obtain the job count for <code>Completed with issues</code>, run two GET requests, and subtract the
         * second, smaller number:
         * </p>
         * <p>
         * GET /backup-jobs/?state=COMPLETED
         * </p>
         * <p>
         * GET /backup-jobs/?messageCategory=SUCCESS&amp;state=COMPLETED
         * </p>
         * 
         * @param byState
         *        Returns only backup jobs that are in the specified state.</p>
         *        <p>
         *        <code>Completed with issues</code> is a status found only in the Backup console. For API, this status
         *        refers to jobs with a state of <code>COMPLETED</code> and a <code>MessageCategory</code> with a value
         *        other than <code>SUCCESS</code>; that is, the status is completed but comes with a status message.
         *        </p>
         *        <p>
         *        To obtain the job count for <code>Completed with issues</code>, run two GET requests, and subtract the
         *        second, smaller number:
         *        </p>
         *        <p>
         *        GET /backup-jobs/?state=COMPLETED
         *        </p>
         *        <p>
         *        GET /backup-jobs/?messageCategory=SUCCESS&amp;state=COMPLETED
         * @see BackupJobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BackupJobState
         */
        Builder byState(BackupJobState byState);

        /**
         * <p>
         * Returns only backup jobs that will be stored in the specified backup vault. Backup vaults are identified by
         * names that are unique to the account used to create them and the Amazon Web Services Region where they are
         * created.
         * </p>
         * 
         * @param byBackupVaultName
         *        Returns only backup jobs that will be stored in the specified backup vault. Backup vaults are
         *        identified by names that are unique to the account used to create them and the Amazon Web Services
         *        Region where they are created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byBackupVaultName(String byBackupVaultName);

        /**
         * <p>
         * Returns only backup jobs that were created before the specified date.
         * </p>
         * 
         * @param byCreatedBefore
         *        Returns only backup jobs that were created before the specified date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byCreatedBefore(Instant byCreatedBefore);

        /**
         * <p>
         * Returns only backup jobs that were created after the specified date.
         * </p>
         * 
         * @param byCreatedAfter
         *        Returns only backup jobs that were created after the specified date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byCreatedAfter(Instant byCreatedAfter);

        /**
         * <p>
         * Returns only backup jobs for the specified resources:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Aurora</code> for Amazon Aurora
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CloudFormation</code> for CloudFormation
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DocumentDB</code> for Amazon DocumentDB (with MongoDB compatibility)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DynamoDB</code> for Amazon DynamoDB
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EBS</code> for Amazon Elastic Block Store
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EC2</code> for Amazon Elastic Compute Cloud
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EFS</code> for Amazon Elastic File System
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FSx</code> for Amazon FSx
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Neptune</code> for Amazon Neptune
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RDS</code> for Amazon Relational Database Service
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Redshift</code> for Amazon Redshift
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>S3</code> for Amazon Simple Storage Service (Amazon S3)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SAP HANA on Amazon EC2</code> for SAP HANA databases on Amazon Elastic Compute Cloud instances
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Storage Gateway</code> for Storage Gateway
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Timestream</code> for Amazon Timestream
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VirtualMachine</code> for VMware virtual machines
         * </p>
         * </li>
         * </ul>
         * 
         * @param byResourceType
         *        Returns only backup jobs for the specified resources:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Aurora</code> for Amazon Aurora
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CloudFormation</code> for CloudFormation
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DocumentDB</code> for Amazon DocumentDB (with MongoDB compatibility)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DynamoDB</code> for Amazon DynamoDB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EBS</code> for Amazon Elastic Block Store
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EC2</code> for Amazon Elastic Compute Cloud
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EFS</code> for Amazon Elastic File System
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FSx</code> for Amazon FSx
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Neptune</code> for Amazon Neptune
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RDS</code> for Amazon Relational Database Service
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Redshift</code> for Amazon Redshift
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>S3</code> for Amazon Simple Storage Service (Amazon S3)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SAP HANA on Amazon EC2</code> for SAP HANA databases on Amazon Elastic Compute Cloud instances
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Storage Gateway</code> for Storage Gateway
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Timestream</code> for Amazon Timestream
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VirtualMachine</code> for VMware virtual machines
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byResourceType(String byResourceType);

        /**
         * <p>
         * The account ID to list the jobs from. Returns only backup jobs associated with the specified account ID.
         * </p>
         * <p>
         * If used from an Organizations management account, passing <code>*</code> returns all jobs across the
         * organization.
         * </p>
         * 
         * @param byAccountId
         *        The account ID to list the jobs from. Returns only backup jobs associated with the specified account
         *        ID.</p>
         *        <p>
         *        If used from an Organizations management account, passing <code>*</code> returns all jobs across the
         *        organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byAccountId(String byAccountId);

        /**
         * <p>
         * Returns only backup jobs completed after a date expressed in Unix format and Coordinated Universal Time
         * (UTC).
         * </p>
         * 
         * @param byCompleteAfter
         *        Returns only backup jobs completed after a date expressed in Unix format and Coordinated Universal
         *        Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byCompleteAfter(Instant byCompleteAfter);

        /**
         * <p>
         * Returns only backup jobs completed before a date expressed in Unix format and Coordinated Universal Time
         * (UTC).
         * </p>
         * 
         * @param byCompleteBefore
         *        Returns only backup jobs completed before a date expressed in Unix format and Coordinated Universal
         *        Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byCompleteBefore(Instant byCompleteBefore);

        /**
         * <p>
         * This is a filter to list child (nested) jobs based on parent job ID.
         * </p>
         * 
         * @param byParentJobId
         *        This is a filter to list child (nested) jobs based on parent job ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byParentJobId(String byParentJobId);

        /**
         * <p>
         * This is an optional parameter that can be used to filter out jobs with a MessageCategory which matches the
         * value you input.
         * </p>
         * <p>
         * Example strings may include <code>AccessDenied</code>, <code>SUCCESS</code>, <code>AGGREGATE_ALL</code>, and
         * <code>InvalidParameters</code>.
         * </p>
         * <p>
         * View <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">Monitoring</a>
         * </p>
         * <p>
         * The wildcard () returns count of all message categories.
         * </p>
         * <p>
         * <code>AGGREGATE_ALL</code> aggregates job counts for all message categories and returns the sum.
         * </p>
         * 
         * @param byMessageCategory
         *        This is an optional parameter that can be used to filter out jobs with a MessageCategory which matches
         *        the value you input.</p>
         *        <p>
         *        Example strings may include <code>AccessDenied</code>, <code>SUCCESS</code>,
         *        <code>AGGREGATE_ALL</code>, and <code>InvalidParameters</code>.
         *        </p>
         *        <p>
         *        View <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">Monitoring</a>
         *        </p>
         *        <p>
         *        The wildcard () returns count of all message categories.
         *        </p>
         *        <p>
         *        <code>AGGREGATE_ALL</code> aggregates job counts for all message categories and returns the sum.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byMessageCategory(String byMessageCategory);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String byResourceArn;

        private String byState;

        private String byBackupVaultName;

        private Instant byCreatedBefore;

        private Instant byCreatedAfter;

        private String byResourceType;

        private String byAccountId;

        private Instant byCompleteAfter;

        private Instant byCompleteBefore;

        private String byParentJobId;

        private String byMessageCategory;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBackupJobsRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            byResourceArn(model.byResourceArn);
            byState(model.byState);
            byBackupVaultName(model.byBackupVaultName);
            byCreatedBefore(model.byCreatedBefore);
            byCreatedAfter(model.byCreatedAfter);
            byResourceType(model.byResourceType);
            byAccountId(model.byAccountId);
            byCompleteAfter(model.byCompleteAfter);
            byCompleteBefore(model.byCompleteBefore);
            byParentJobId(model.byParentJobId);
            byMessageCategory(model.byMessageCategory);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getByResourceArn() {
            return byResourceArn;
        }

        public final void setByResourceArn(String byResourceArn) {
            this.byResourceArn = byResourceArn;
        }

        @Override
        public final Builder byResourceArn(String byResourceArn) {
            this.byResourceArn = byResourceArn;
            return this;
        }

        public final String getByState() {
            return byState;
        }

        public final void setByState(String byState) {
            this.byState = byState;
        }

        @Override
        public final Builder byState(String byState) {
            this.byState = byState;
            return this;
        }

        @Override
        public final Builder byState(BackupJobState byState) {
            this.byState(byState == null ? null : byState.toString());
            return this;
        }

        public final String getByBackupVaultName() {
            return byBackupVaultName;
        }

        public final void setByBackupVaultName(String byBackupVaultName) {
            this.byBackupVaultName = byBackupVaultName;
        }

        @Override
        public final Builder byBackupVaultName(String byBackupVaultName) {
            this.byBackupVaultName = byBackupVaultName;
            return this;
        }

        public final Instant getByCreatedBefore() {
            return byCreatedBefore;
        }

        public final void setByCreatedBefore(Instant byCreatedBefore) {
            this.byCreatedBefore = byCreatedBefore;
        }

        @Override
        public final Builder byCreatedBefore(Instant byCreatedBefore) {
            this.byCreatedBefore = byCreatedBefore;
            return this;
        }

        public final Instant getByCreatedAfter() {
            return byCreatedAfter;
        }

        public final void setByCreatedAfter(Instant byCreatedAfter) {
            this.byCreatedAfter = byCreatedAfter;
        }

        @Override
        public final Builder byCreatedAfter(Instant byCreatedAfter) {
            this.byCreatedAfter = byCreatedAfter;
            return this;
        }

        public final String getByResourceType() {
            return byResourceType;
        }

        public final void setByResourceType(String byResourceType) {
            this.byResourceType = byResourceType;
        }

        @Override
        public final Builder byResourceType(String byResourceType) {
            this.byResourceType = byResourceType;
            return this;
        }

        public final String getByAccountId() {
            return byAccountId;
        }

        public final void setByAccountId(String byAccountId) {
            this.byAccountId = byAccountId;
        }

        @Override
        public final Builder byAccountId(String byAccountId) {
            this.byAccountId = byAccountId;
            return this;
        }

        public final Instant getByCompleteAfter() {
            return byCompleteAfter;
        }

        public final void setByCompleteAfter(Instant byCompleteAfter) {
            this.byCompleteAfter = byCompleteAfter;
        }

        @Override
        public final Builder byCompleteAfter(Instant byCompleteAfter) {
            this.byCompleteAfter = byCompleteAfter;
            return this;
        }

        public final Instant getByCompleteBefore() {
            return byCompleteBefore;
        }

        public final void setByCompleteBefore(Instant byCompleteBefore) {
            this.byCompleteBefore = byCompleteBefore;
        }

        @Override
        public final Builder byCompleteBefore(Instant byCompleteBefore) {
            this.byCompleteBefore = byCompleteBefore;
            return this;
        }

        public final String getByParentJobId() {
            return byParentJobId;
        }

        public final void setByParentJobId(String byParentJobId) {
            this.byParentJobId = byParentJobId;
        }

        @Override
        public final Builder byParentJobId(String byParentJobId) {
            this.byParentJobId = byParentJobId;
            return this;
        }

        public final String getByMessageCategory() {
            return byMessageCategory;
        }

        public final void setByMessageCategory(String byMessageCategory) {
            this.byMessageCategory = byMessageCategory;
        }

        @Override
        public final Builder byMessageCategory(String byMessageCategory) {
            this.byMessageCategory = byMessageCategory;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBackupJobsRequest build() {
            return new ListBackupJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
