/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.EncryptionKeyType;
import software.amazon.awssdk.services.backup.model.IndexStatus;
import software.amazon.awssdk.services.backup.model.RecoveryPointStatus;
import software.amazon.awssdk.services.backup.model.VaultType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecoveryPointByResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecoveryPointByResource> {
    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecoveryPointArn").getter(RecoveryPointByResource.getter(RecoveryPointByResource::recoveryPointArn)).setter(RecoveryPointByResource.setter(Builder::recoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(RecoveryPointByResource.getter(RecoveryPointByResource::creationDate)).setter(RecoveryPointByResource.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(RecoveryPointByResource.getter(RecoveryPointByResource::statusAsString)).setter(RecoveryPointByResource.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(RecoveryPointByResource.getter(RecoveryPointByResource::statusMessage)).setter(RecoveryPointByResource.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionKeyArn").getter(RecoveryPointByResource.getter(RecoveryPointByResource::encryptionKeyArn)).setter(RecoveryPointByResource.setter(Builder::encryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()}).build();
    private static final SdkField<Long> BACKUP_SIZE_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BackupSizeBytes").getter(RecoveryPointByResource.getter(RecoveryPointByResource::backupSizeBytes)).setter(RecoveryPointByResource.setter(Builder::backupSizeBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupSizeBytes").build()}).build();
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupVaultName").getter(RecoveryPointByResource.getter(RecoveryPointByResource::backupVaultName)).setter(RecoveryPointByResource.setter(Builder::backupVaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()}).build();
    private static final SdkField<Boolean> IS_PARENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsParent").getter(RecoveryPointByResource.getter(RecoveryPointByResource::isParent)).setter(RecoveryPointByResource.setter(Builder::isParent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsParent").build()}).build();
    private static final SdkField<String> PARENT_RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParentRecoveryPointArn").getter(RecoveryPointByResource.getter(RecoveryPointByResource::parentRecoveryPointArn)).setter(RecoveryPointByResource.setter(Builder::parentRecoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentRecoveryPointArn").build()}).build();
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceName").getter(RecoveryPointByResource.getter(RecoveryPointByResource::resourceName)).setter(RecoveryPointByResource.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()}).build();
    private static final SdkField<String> VAULT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VaultType").getter(RecoveryPointByResource.getter(RecoveryPointByResource::vaultTypeAsString)).setter(RecoveryPointByResource.setter(Builder::vaultType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VaultType").build()}).build();
    private static final SdkField<String> INDEX_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexStatus").getter(RecoveryPointByResource.getter(RecoveryPointByResource::indexStatusAsString)).setter(RecoveryPointByResource.setter(Builder::indexStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexStatus").build()}).build();
    private static final SdkField<String> INDEX_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexStatusMessage").getter(RecoveryPointByResource.getter(RecoveryPointByResource::indexStatusMessage)).setter(RecoveryPointByResource.setter(Builder::indexStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexStatusMessage").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionKeyType").getter(RecoveryPointByResource.getter(RecoveryPointByResource::encryptionKeyTypeAsString)).setter(RecoveryPointByResource.setter(Builder::encryptionKeyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOVERY_POINT_ARN_FIELD, CREATION_DATE_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, ENCRYPTION_KEY_ARN_FIELD, BACKUP_SIZE_BYTES_FIELD, BACKUP_VAULT_NAME_FIELD, IS_PARENT_FIELD, PARENT_RECOVERY_POINT_ARN_FIELD, RESOURCE_NAME_FIELD, VAULT_TYPE_FIELD, INDEX_STATUS_FIELD, INDEX_STATUS_MESSAGE_FIELD, ENCRYPTION_KEY_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RecoveryPointByResource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String recoveryPointArn;
    private final Instant creationDate;
    private final String status;
    private final String statusMessage;
    private final String encryptionKeyArn;
    private final Long backupSizeBytes;
    private final String backupVaultName;
    private final Boolean isParent;
    private final String parentRecoveryPointArn;
    private final String resourceName;
    private final String vaultType;
    private final String indexStatus;
    private final String indexStatusMessage;
    private final String encryptionKeyType;

    private RecoveryPointByResource(BuilderImpl builder) {
        this.recoveryPointArn = builder.recoveryPointArn;
        this.creationDate = builder.creationDate;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.backupSizeBytes = builder.backupSizeBytes;
        this.backupVaultName = builder.backupVaultName;
        this.isParent = builder.isParent;
        this.parentRecoveryPointArn = builder.parentRecoveryPointArn;
        this.resourceName = builder.resourceName;
        this.vaultType = builder.vaultType;
        this.indexStatus = builder.indexStatus;
        this.indexStatusMessage = builder.indexStatusMessage;
        this.encryptionKeyType = builder.encryptionKeyType;
    }

    public final String recoveryPointArn() {
        return this.recoveryPointArn;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final RecoveryPointStatus status() {
        return RecoveryPointStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String encryptionKeyArn() {
        return this.encryptionKeyArn;
    }

    public final Long backupSizeBytes() {
        return this.backupSizeBytes;
    }

    public final String backupVaultName() {
        return this.backupVaultName;
    }

    public final Boolean isParent() {
        return this.isParent;
    }

    public final String parentRecoveryPointArn() {
        return this.parentRecoveryPointArn;
    }

    public final String resourceName() {
        return this.resourceName;
    }

    public final VaultType vaultType() {
        return VaultType.fromValue(this.vaultType);
    }

    public final String vaultTypeAsString() {
        return this.vaultType;
    }

    public final IndexStatus indexStatus() {
        return IndexStatus.fromValue(this.indexStatus);
    }

    public final String indexStatusAsString() {
        return this.indexStatus;
    }

    public final String indexStatusMessage() {
        return this.indexStatusMessage;
    }

    public final EncryptionKeyType encryptionKeyType() {
        return EncryptionKeyType.fromValue(this.encryptionKeyType);
    }

    public final String encryptionKeyTypeAsString() {
        return this.encryptionKeyType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.isParent());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentRecoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vaultTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKeyTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecoveryPointByResource)) {
            return false;
        }
        RecoveryPointByResource other = (RecoveryPointByResource)obj;
        return Objects.equals(this.recoveryPointArn(), other.recoveryPointArn()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.encryptionKeyArn(), other.encryptionKeyArn()) && Objects.equals(this.backupSizeBytes(), other.backupSizeBytes()) && Objects.equals(this.backupVaultName(), other.backupVaultName()) && Objects.equals(this.isParent(), other.isParent()) && Objects.equals(this.parentRecoveryPointArn(), other.parentRecoveryPointArn()) && Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.vaultTypeAsString(), other.vaultTypeAsString()) && Objects.equals(this.indexStatusAsString(), other.indexStatusAsString()) && Objects.equals(this.indexStatusMessage(), other.indexStatusMessage()) && Objects.equals(this.encryptionKeyTypeAsString(), other.encryptionKeyTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RecoveryPointByResource").add("RecoveryPointArn", (Object)this.recoveryPointArn()).add("CreationDate", (Object)this.creationDate()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("EncryptionKeyArn", (Object)this.encryptionKeyArn()).add("BackupSizeBytes", (Object)this.backupSizeBytes()).add("BackupVaultName", (Object)this.backupVaultName()).add("IsParent", (Object)this.isParent()).add("ParentRecoveryPointArn", (Object)this.parentRecoveryPointArn()).add("ResourceName", (Object)this.resourceName()).add("VaultType", (Object)this.vaultTypeAsString()).add("IndexStatus", (Object)this.indexStatusAsString()).add("IndexStatusMessage", (Object)this.indexStatusMessage()).add("EncryptionKeyType", (Object)this.encryptionKeyTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.recoveryPointArn()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "EncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.encryptionKeyArn()));
            }
            case "BackupSizeBytes": {
                return Optional.ofNullable(clazz.cast(this.backupSizeBytes()));
            }
            case "BackupVaultName": {
                return Optional.ofNullable(clazz.cast(this.backupVaultName()));
            }
            case "IsParent": {
                return Optional.ofNullable(clazz.cast(this.isParent()));
            }
            case "ParentRecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.parentRecoveryPointArn()));
            }
            case "ResourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
            case "VaultType": {
                return Optional.ofNullable(clazz.cast(this.vaultTypeAsString()));
            }
            case "IndexStatus": {
                return Optional.ofNullable(clazz.cast(this.indexStatusAsString()));
            }
            case "IndexStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.indexStatusMessage()));
            }
            case "EncryptionKeyType": {
                return Optional.ofNullable(clazz.cast(this.encryptionKeyTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RecoveryPointArn", RECOVERY_POINT_ARN_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("EncryptionKeyArn", ENCRYPTION_KEY_ARN_FIELD);
        map.put("BackupSizeBytes", BACKUP_SIZE_BYTES_FIELD);
        map.put("BackupVaultName", BACKUP_VAULT_NAME_FIELD);
        map.put("IsParent", IS_PARENT_FIELD);
        map.put("ParentRecoveryPointArn", PARENT_RECOVERY_POINT_ARN_FIELD);
        map.put("ResourceName", RESOURCE_NAME_FIELD);
        map.put("VaultType", VAULT_TYPE_FIELD);
        map.put("IndexStatus", INDEX_STATUS_FIELD);
        map.put("IndexStatusMessage", INDEX_STATUS_MESSAGE_FIELD);
        map.put("EncryptionKeyType", ENCRYPTION_KEY_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecoveryPointByResource, T> g) {
        return obj -> g.apply((RecoveryPointByResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String recoveryPointArn;
        private Instant creationDate;
        private String status;
        private String statusMessage;
        private String encryptionKeyArn;
        private Long backupSizeBytes;
        private String backupVaultName;
        private Boolean isParent;
        private String parentRecoveryPointArn;
        private String resourceName;
        private String vaultType;
        private String indexStatus;
        private String indexStatusMessage;
        private String encryptionKeyType;

        private BuilderImpl() {
        }

        private BuilderImpl(RecoveryPointByResource model) {
            this.recoveryPointArn(model.recoveryPointArn);
            this.creationDate(model.creationDate);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.encryptionKeyArn(model.encryptionKeyArn);
            this.backupSizeBytes(model.backupSizeBytes);
            this.backupVaultName(model.backupVaultName);
            this.isParent(model.isParent);
            this.parentRecoveryPointArn(model.parentRecoveryPointArn);
            this.resourceName(model.resourceName);
            this.vaultType(model.vaultType);
            this.indexStatus(model.indexStatus);
            this.indexStatusMessage(model.indexStatusMessage);
            this.encryptionKeyType(model.encryptionKeyType);
        }

        public final String getRecoveryPointArn() {
            return this.recoveryPointArn;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RecoveryPointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getEncryptionKeyArn() {
            return this.encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final Long getBackupSizeBytes() {
            return this.backupSizeBytes;
        }

        public final void setBackupSizeBytes(Long backupSizeBytes) {
            this.backupSizeBytes = backupSizeBytes;
        }

        @Override
        public final Builder backupSizeBytes(Long backupSizeBytes) {
            this.backupSizeBytes = backupSizeBytes;
            return this;
        }

        public final String getBackupVaultName() {
            return this.backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final Boolean getIsParent() {
            return this.isParent;
        }

        public final void setIsParent(Boolean isParent) {
            this.isParent = isParent;
        }

        @Override
        public final Builder isParent(Boolean isParent) {
            this.isParent = isParent;
            return this;
        }

        public final String getParentRecoveryPointArn() {
            return this.parentRecoveryPointArn;
        }

        public final void setParentRecoveryPointArn(String parentRecoveryPointArn) {
            this.parentRecoveryPointArn = parentRecoveryPointArn;
        }

        @Override
        public final Builder parentRecoveryPointArn(String parentRecoveryPointArn) {
            this.parentRecoveryPointArn = parentRecoveryPointArn;
            return this;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getVaultType() {
            return this.vaultType;
        }

        public final void setVaultType(String vaultType) {
            this.vaultType = vaultType;
        }

        @Override
        public final Builder vaultType(String vaultType) {
            this.vaultType = vaultType;
            return this;
        }

        @Override
        public final Builder vaultType(VaultType vaultType) {
            this.vaultType(vaultType == null ? null : vaultType.toString());
            return this;
        }

        public final String getIndexStatus() {
            return this.indexStatus;
        }

        public final void setIndexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
        }

        @Override
        public final Builder indexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
            return this;
        }

        @Override
        public final Builder indexStatus(IndexStatus indexStatus) {
            this.indexStatus(indexStatus == null ? null : indexStatus.toString());
            return this;
        }

        public final String getIndexStatusMessage() {
            return this.indexStatusMessage;
        }

        public final void setIndexStatusMessage(String indexStatusMessage) {
            this.indexStatusMessage = indexStatusMessage;
        }

        @Override
        public final Builder indexStatusMessage(String indexStatusMessage) {
            this.indexStatusMessage = indexStatusMessage;
            return this;
        }

        public final String getEncryptionKeyType() {
            return this.encryptionKeyType;
        }

        public final void setEncryptionKeyType(String encryptionKeyType) {
            this.encryptionKeyType = encryptionKeyType;
        }

        @Override
        public final Builder encryptionKeyType(String encryptionKeyType) {
            this.encryptionKeyType = encryptionKeyType;
            return this;
        }

        @Override
        public final Builder encryptionKeyType(EncryptionKeyType encryptionKeyType) {
            this.encryptionKeyType(encryptionKeyType == null ? null : encryptionKeyType.toString());
            return this;
        }

        public RecoveryPointByResource build() {
            return new RecoveryPointByResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecoveryPointByResource> {
        public Builder recoveryPointArn(String var1);

        public Builder creationDate(Instant var1);

        public Builder status(String var1);

        public Builder status(RecoveryPointStatus var1);

        public Builder statusMessage(String var1);

        public Builder encryptionKeyArn(String var1);

        public Builder backupSizeBytes(Long var1);

        public Builder backupVaultName(String var1);

        public Builder isParent(Boolean var1);

        public Builder parentRecoveryPointArn(String var1);

        public Builder resourceName(String var1);

        public Builder vaultType(String var1);

        public Builder vaultType(VaultType var1);

        public Builder indexStatus(String var1);

        public Builder indexStatus(IndexStatus var1);

        public Builder indexStatusMessage(String var1);

        public Builder encryptionKeyType(String var1);

        public Builder encryptionKeyType(EncryptionKeyType var1);
    }
}

