/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTieringConfigurationResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, CreateTieringConfigurationResponse> {
    private static final SdkField<String> TIERING_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TieringConfigurationArn").getter(CreateTieringConfigurationResponse.getter(CreateTieringConfigurationResponse::tieringConfigurationArn)).setter(CreateTieringConfigurationResponse.setter(Builder::tieringConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TieringConfigurationArn").build()}).build();
    private static final SdkField<String> TIERING_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TieringConfigurationName").getter(CreateTieringConfigurationResponse.getter(CreateTieringConfigurationResponse::tieringConfigurationName)).setter(CreateTieringConfigurationResponse.setter(Builder::tieringConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TieringConfigurationName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(CreateTieringConfigurationResponse.getter(CreateTieringConfigurationResponse::creationTime)).setter(CreateTieringConfigurationResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIERING_CONFIGURATION_ARN_FIELD, TIERING_CONFIGURATION_NAME_FIELD, CREATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateTieringConfigurationResponse.memberNameToFieldInitializer();
    private final String tieringConfigurationArn;
    private final String tieringConfigurationName;
    private final Instant creationTime;

    private CreateTieringConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.tieringConfigurationArn = builder.tieringConfigurationArn;
        this.tieringConfigurationName = builder.tieringConfigurationName;
        this.creationTime = builder.creationTime;
    }

    public final String tieringConfigurationArn() {
        return this.tieringConfigurationArn;
    }

    public final String tieringConfigurationName() {
        return this.tieringConfigurationName;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tieringConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tieringConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTieringConfigurationResponse)) {
            return false;
        }
        CreateTieringConfigurationResponse other = (CreateTieringConfigurationResponse)((Object)obj);
        return Objects.equals(this.tieringConfigurationArn(), other.tieringConfigurationArn()) && Objects.equals(this.tieringConfigurationName(), other.tieringConfigurationName()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTieringConfigurationResponse").add("TieringConfigurationArn", (Object)this.tieringConfigurationArn()).add("TieringConfigurationName", (Object)this.tieringConfigurationName()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TieringConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.tieringConfigurationArn()));
            }
            case "TieringConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.tieringConfigurationName()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TieringConfigurationArn", TIERING_CONFIGURATION_ARN_FIELD);
        map.put("TieringConfigurationName", TIERING_CONFIGURATION_NAME_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTieringConfigurationResponse, T> g) {
        return obj -> g.apply((CreateTieringConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String tieringConfigurationArn;
        private String tieringConfigurationName;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTieringConfigurationResponse model) {
            super(model);
            this.tieringConfigurationArn(model.tieringConfigurationArn);
            this.tieringConfigurationName(model.tieringConfigurationName);
            this.creationTime(model.creationTime);
        }

        public final String getTieringConfigurationArn() {
            return this.tieringConfigurationArn;
        }

        public final void setTieringConfigurationArn(String tieringConfigurationArn) {
            this.tieringConfigurationArn = tieringConfigurationArn;
        }

        @Override
        public final Builder tieringConfigurationArn(String tieringConfigurationArn) {
            this.tieringConfigurationArn = tieringConfigurationArn;
            return this;
        }

        public final String getTieringConfigurationName() {
            return this.tieringConfigurationName;
        }

        public final void setTieringConfigurationName(String tieringConfigurationName) {
            this.tieringConfigurationName = tieringConfigurationName;
        }

        @Override
        public final Builder tieringConfigurationName(String tieringConfigurationName) {
            this.tieringConfigurationName = tieringConfigurationName;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public CreateTieringConfigurationResponse build() {
            return new CreateTieringConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTieringConfigurationResponse> {
        public Builder tieringConfigurationArn(String var1);

        public Builder tieringConfigurationName(String var1);

        public Builder creationTime(Instant var1);
    }
}

