/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.MalwareScanner;
import software.amazon.awssdk.services.backup.model.ScanFinding;
import software.amazon.awssdk.services.backup.model.ScanFindingsCopier;
import software.amazon.awssdk.services.backup.model.ScanJobState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScanResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScanResult> {
    private static final SdkField<String> MALWARE_SCANNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MalwareScanner").getter(ScanResult.getter(ScanResult::malwareScannerAsString)).setter(ScanResult.setter(Builder::malwareScanner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MalwareScanner").build()}).build();
    private static final SdkField<String> SCAN_JOB_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanJobState").getter(ScanResult.getter(ScanResult::scanJobStateAsString)).setter(ScanResult.setter(Builder::scanJobState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanJobState").build()}).build();
    private static final SdkField<Instant> LAST_SCAN_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastScanTimestamp").getter(ScanResult.getter(ScanResult::lastScanTimestamp)).setter(ScanResult.setter(Builder::lastScanTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastScanTimestamp").build()}).build();
    private static final SdkField<List<String>> FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Findings").getter(ScanResult.getter(ScanResult::findingsAsStrings)).setter(ScanResult.setter(Builder::findingsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Findings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MALWARE_SCANNER_FIELD, SCAN_JOB_STATE_FIELD, LAST_SCAN_TIMESTAMP_FIELD, FINDINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScanResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String malwareScanner;
    private final String scanJobState;
    private final Instant lastScanTimestamp;
    private final List<String> findings;

    private ScanResult(BuilderImpl builder) {
        this.malwareScanner = builder.malwareScanner;
        this.scanJobState = builder.scanJobState;
        this.lastScanTimestamp = builder.lastScanTimestamp;
        this.findings = builder.findings;
    }

    public final MalwareScanner malwareScanner() {
        return MalwareScanner.fromValue(this.malwareScanner);
    }

    public final String malwareScannerAsString() {
        return this.malwareScanner;
    }

    public final ScanJobState scanJobState() {
        return ScanJobState.fromValue(this.scanJobState);
    }

    public final String scanJobStateAsString() {
        return this.scanJobState;
    }

    public final Instant lastScanTimestamp() {
        return this.lastScanTimestamp;
    }

    public final List<ScanFinding> findings() {
        return ScanFindingsCopier.copyStringToEnum(this.findings);
    }

    public final boolean hasFindings() {
        return this.findings != null && !(this.findings instanceof SdkAutoConstructList);
    }

    public final List<String> findingsAsStrings() {
        return this.findings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.malwareScannerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanJobStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastScanTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFindings() ? this.findingsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanResult)) {
            return false;
        }
        ScanResult other = (ScanResult)obj;
        return Objects.equals(this.malwareScannerAsString(), other.malwareScannerAsString()) && Objects.equals(this.scanJobStateAsString(), other.scanJobStateAsString()) && Objects.equals(this.lastScanTimestamp(), other.lastScanTimestamp()) && this.hasFindings() == other.hasFindings() && Objects.equals(this.findingsAsStrings(), other.findingsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ScanResult").add("MalwareScanner", (Object)this.malwareScannerAsString()).add("ScanJobState", (Object)this.scanJobStateAsString()).add("LastScanTimestamp", (Object)this.lastScanTimestamp()).add("Findings", this.hasFindings() ? this.findingsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MalwareScanner": {
                return Optional.ofNullable(clazz.cast(this.malwareScannerAsString()));
            }
            case "ScanJobState": {
                return Optional.ofNullable(clazz.cast(this.scanJobStateAsString()));
            }
            case "LastScanTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastScanTimestamp()));
            }
            case "Findings": {
                return Optional.ofNullable(clazz.cast(this.findingsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MalwareScanner", MALWARE_SCANNER_FIELD);
        map.put("ScanJobState", SCAN_JOB_STATE_FIELD);
        map.put("LastScanTimestamp", LAST_SCAN_TIMESTAMP_FIELD);
        map.put("Findings", FINDINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScanResult, T> g) {
        return obj -> g.apply((ScanResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String malwareScanner;
        private String scanJobState;
        private Instant lastScanTimestamp;
        private List<String> findings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ScanResult model) {
            this.malwareScanner(model.malwareScanner);
            this.scanJobState(model.scanJobState);
            this.lastScanTimestamp(model.lastScanTimestamp);
            this.findingsWithStrings(model.findings);
        }

        public final String getMalwareScanner() {
            return this.malwareScanner;
        }

        public final void setMalwareScanner(String malwareScanner) {
            this.malwareScanner = malwareScanner;
        }

        @Override
        public final Builder malwareScanner(String malwareScanner) {
            this.malwareScanner = malwareScanner;
            return this;
        }

        @Override
        public final Builder malwareScanner(MalwareScanner malwareScanner) {
            this.malwareScanner(malwareScanner == null ? null : malwareScanner.toString());
            return this;
        }

        public final String getScanJobState() {
            return this.scanJobState;
        }

        public final void setScanJobState(String scanJobState) {
            this.scanJobState = scanJobState;
        }

        @Override
        public final Builder scanJobState(String scanJobState) {
            this.scanJobState = scanJobState;
            return this;
        }

        @Override
        public final Builder scanJobState(ScanJobState scanJobState) {
            this.scanJobState(scanJobState == null ? null : scanJobState.toString());
            return this;
        }

        public final Instant getLastScanTimestamp() {
            return this.lastScanTimestamp;
        }

        public final void setLastScanTimestamp(Instant lastScanTimestamp) {
            this.lastScanTimestamp = lastScanTimestamp;
        }

        @Override
        public final Builder lastScanTimestamp(Instant lastScanTimestamp) {
            this.lastScanTimestamp = lastScanTimestamp;
            return this;
        }

        public final Collection<String> getFindings() {
            if (this.findings instanceof SdkAutoConstructList) {
                return null;
            }
            return this.findings;
        }

        public final void setFindings(Collection<String> findings) {
            this.findings = ScanFindingsCopier.copy(findings);
        }

        @Override
        public final Builder findingsWithStrings(Collection<String> findings) {
            this.findings = ScanFindingsCopier.copy(findings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingsWithStrings(String ... findings) {
            this.findingsWithStrings(Arrays.asList(findings));
            return this;
        }

        @Override
        public final Builder findings(Collection<ScanFinding> findings) {
            this.findings = ScanFindingsCopier.copyEnumToString(findings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(ScanFinding ... findings) {
            this.findings(Arrays.asList(findings));
            return this;
        }

        public ScanResult build() {
            return new ScanResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScanResult> {
        public Builder malwareScanner(String var1);

        public Builder malwareScanner(MalwareScanner var1);

        public Builder scanJobState(String var1);

        public Builder scanJobState(ScanJobState var1);

        public Builder lastScanTimestamp(Instant var1);

        public Builder findingsWithStrings(Collection<String> var1);

        public Builder findingsWithStrings(String ... var1);

        public Builder findings(Collection<ScanFinding> var1);

        public Builder findings(ScanFinding ... var1);
    }
}

