/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupJobState;
import software.amazon.awssdk.services.backup.model.BackupRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBackupJobsRequest
extends BackupRequest
implements ToCopyableBuilder<Builder, ListBackupJobsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListBackupJobsRequest.getter(ListBackupJobsRequest::nextToken)).setter(ListBackupJobsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListBackupJobsRequest.getter(ListBackupJobsRequest::maxResults)).setter(ListBackupJobsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> BY_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListBackupJobsRequest.getter(ListBackupJobsRequest::byResourceArn)).setter(ListBackupJobsRequest.setter(Builder::byResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceArn").build()}).build();
    private static final SdkField<String> BY_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListBackupJobsRequest.getter(ListBackupJobsRequest::byStateAsString)).setter(ListBackupJobsRequest.setter(Builder::byState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("state").build()}).build();
    private static final SdkField<String> BY_BACKUP_VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListBackupJobsRequest.getter(ListBackupJobsRequest::byBackupVaultName)).setter(ListBackupJobsRequest.setter(Builder::byBackupVaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("backupVaultName").build()}).build();
    private static final SdkField<Instant> BY_CREATED_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ListBackupJobsRequest.getter(ListBackupJobsRequest::byCreatedBefore)).setter(ListBackupJobsRequest.setter(Builder::byCreatedBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdBefore").build()}).build();
    private static final SdkField<Instant> BY_CREATED_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ListBackupJobsRequest.getter(ListBackupJobsRequest::byCreatedAfter)).setter(ListBackupJobsRequest.setter(Builder::byCreatedAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdAfter").build()}).build();
    private static final SdkField<String> BY_RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListBackupJobsRequest.getter(ListBackupJobsRequest::byResourceType)).setter(ListBackupJobsRequest.setter(Builder::byResourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, BY_RESOURCE_ARN_FIELD, BY_STATE_FIELD, BY_BACKUP_VAULT_NAME_FIELD, BY_CREATED_BEFORE_FIELD, BY_CREATED_AFTER_FIELD, BY_RESOURCE_TYPE_FIELD));
    private final String nextToken;
    private final Integer maxResults;
    private final String byResourceArn;
    private final String byState;
    private final String byBackupVaultName;
    private final Instant byCreatedBefore;
    private final Instant byCreatedAfter;
    private final String byResourceType;

    private ListBackupJobsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.byResourceArn = builder.byResourceArn;
        this.byState = builder.byState;
        this.byBackupVaultName = builder.byBackupVaultName;
        this.byCreatedBefore = builder.byCreatedBefore;
        this.byCreatedAfter = builder.byCreatedAfter;
        this.byResourceType = builder.byResourceType;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String byResourceArn() {
        return this.byResourceArn;
    }

    public BackupJobState byState() {
        return BackupJobState.fromValue(this.byState);
    }

    public String byStateAsString() {
        return this.byState;
    }

    public String byBackupVaultName() {
        return this.byBackupVaultName;
    }

    public Instant byCreatedBefore() {
        return this.byCreatedBefore;
    }

    public Instant byCreatedAfter() {
        return this.byCreatedAfter;
    }

    public String byResourceType() {
        return this.byResourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.byResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.byStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.byBackupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.byCreatedBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.byCreatedAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.byResourceType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBackupJobsRequest)) {
            return false;
        }
        ListBackupJobsRequest other = (ListBackupJobsRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.byResourceArn(), other.byResourceArn()) && Objects.equals(this.byStateAsString(), other.byStateAsString()) && Objects.equals(this.byBackupVaultName(), other.byBackupVaultName()) && Objects.equals(this.byCreatedBefore(), other.byCreatedBefore()) && Objects.equals(this.byCreatedAfter(), other.byCreatedAfter()) && Objects.equals(this.byResourceType(), other.byResourceType());
    }

    public String toString() {
        return ToString.builder((String)"ListBackupJobsRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ByResourceArn", (Object)this.byResourceArn()).add("ByState", (Object)this.byStateAsString()).add("ByBackupVaultName", (Object)this.byBackupVaultName()).add("ByCreatedBefore", (Object)this.byCreatedBefore()).add("ByCreatedAfter", (Object)this.byCreatedAfter()).add("ByResourceType", (Object)this.byResourceType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "ByResourceArn": {
                return Optional.ofNullable(clazz.cast(this.byResourceArn()));
            }
            case "ByState": {
                return Optional.ofNullable(clazz.cast(this.byStateAsString()));
            }
            case "ByBackupVaultName": {
                return Optional.ofNullable(clazz.cast(this.byBackupVaultName()));
            }
            case "ByCreatedBefore": {
                return Optional.ofNullable(clazz.cast(this.byCreatedBefore()));
            }
            case "ByCreatedAfter": {
                return Optional.ofNullable(clazz.cast(this.byCreatedAfter()));
            }
            case "ByResourceType": {
                return Optional.ofNullable(clazz.cast(this.byResourceType()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBackupJobsRequest, T> g) {
        return obj -> g.apply((ListBackupJobsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private String byResourceArn;
        private String byState;
        private String byBackupVaultName;
        private Instant byCreatedBefore;
        private Instant byCreatedAfter;
        private String byResourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBackupJobsRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.byResourceArn(model.byResourceArn);
            this.byState(model.byState);
            this.byBackupVaultName(model.byBackupVaultName);
            this.byCreatedBefore(model.byCreatedBefore);
            this.byCreatedAfter(model.byCreatedAfter);
            this.byResourceType(model.byResourceType);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getByResourceArn() {
            return this.byResourceArn;
        }

        @Override
        public final Builder byResourceArn(String byResourceArn) {
            this.byResourceArn = byResourceArn;
            return this;
        }

        public final void setByResourceArn(String byResourceArn) {
            this.byResourceArn = byResourceArn;
        }

        public final String getByStateAsString() {
            return this.byState;
        }

        @Override
        public final Builder byState(String byState) {
            this.byState = byState;
            return this;
        }

        @Override
        public final Builder byState(BackupJobState byState) {
            this.byState(byState.toString());
            return this;
        }

        public final void setByState(String byState) {
            this.byState = byState;
        }

        public final String getByBackupVaultName() {
            return this.byBackupVaultName;
        }

        @Override
        public final Builder byBackupVaultName(String byBackupVaultName) {
            this.byBackupVaultName = byBackupVaultName;
            return this;
        }

        public final void setByBackupVaultName(String byBackupVaultName) {
            this.byBackupVaultName = byBackupVaultName;
        }

        public final Instant getByCreatedBefore() {
            return this.byCreatedBefore;
        }

        @Override
        public final Builder byCreatedBefore(Instant byCreatedBefore) {
            this.byCreatedBefore = byCreatedBefore;
            return this;
        }

        public final void setByCreatedBefore(Instant byCreatedBefore) {
            this.byCreatedBefore = byCreatedBefore;
        }

        public final Instant getByCreatedAfter() {
            return this.byCreatedAfter;
        }

        @Override
        public final Builder byCreatedAfter(Instant byCreatedAfter) {
            this.byCreatedAfter = byCreatedAfter;
            return this;
        }

        public final void setByCreatedAfter(Instant byCreatedAfter) {
            this.byCreatedAfter = byCreatedAfter;
        }

        public final String getByResourceType() {
            return this.byResourceType;
        }

        @Override
        public final Builder byResourceType(String byResourceType) {
            this.byResourceType = byResourceType;
            return this;
        }

        public final void setByResourceType(String byResourceType) {
            this.byResourceType = byResourceType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBackupJobsRequest build() {
            return new ListBackupJobsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBackupJobsRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder byResourceArn(String var1);

        public Builder byState(String var1);

        public Builder byState(BackupJobState var1);

        public Builder byBackupVaultName(String var1);

        public Builder byCreatedBefore(Instant var1);

        public Builder byCreatedAfter(Instant var1);

        public Builder byResourceType(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

