/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.backup.model.AlreadyExistsException;
import software.amazon.awssdk.services.backup.model.BackupException;
import software.amazon.awssdk.services.backup.model.CreateBackupPlanRequest;
import software.amazon.awssdk.services.backup.model.CreateBackupPlanResponse;
import software.amazon.awssdk.services.backup.model.CreateBackupSelectionRequest;
import software.amazon.awssdk.services.backup.model.CreateBackupSelectionResponse;
import software.amazon.awssdk.services.backup.model.CreateBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.CreateBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupPlanRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupPlanResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupSelectionRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupSelectionResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultAccessPolicyRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultAccessPolicyResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultNotificationsRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultNotificationsResponse;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.DeleteBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.DeleteRecoveryPointRequest;
import software.amazon.awssdk.services.backup.model.DeleteRecoveryPointResponse;
import software.amazon.awssdk.services.backup.model.DependencyFailureException;
import software.amazon.awssdk.services.backup.model.DescribeBackupJobRequest;
import software.amazon.awssdk.services.backup.model.DescribeBackupJobResponse;
import software.amazon.awssdk.services.backup.model.DescribeBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.DescribeBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.DescribeProtectedResourceRequest;
import software.amazon.awssdk.services.backup.model.DescribeProtectedResourceResponse;
import software.amazon.awssdk.services.backup.model.DescribeRecoveryPointRequest;
import software.amazon.awssdk.services.backup.model.DescribeRecoveryPointResponse;
import software.amazon.awssdk.services.backup.model.DescribeRestoreJobRequest;
import software.amazon.awssdk.services.backup.model.DescribeRestoreJobResponse;
import software.amazon.awssdk.services.backup.model.ExportBackupPlanTemplateRequest;
import software.amazon.awssdk.services.backup.model.ExportBackupPlanTemplateResponse;
import software.amazon.awssdk.services.backup.model.GetBackupPlanFromJsonRequest;
import software.amazon.awssdk.services.backup.model.GetBackupPlanFromJsonResponse;
import software.amazon.awssdk.services.backup.model.GetBackupPlanFromTemplateRequest;
import software.amazon.awssdk.services.backup.model.GetBackupPlanFromTemplateResponse;
import software.amazon.awssdk.services.backup.model.GetBackupPlanRequest;
import software.amazon.awssdk.services.backup.model.GetBackupPlanResponse;
import software.amazon.awssdk.services.backup.model.GetBackupSelectionRequest;
import software.amazon.awssdk.services.backup.model.GetBackupSelectionResponse;
import software.amazon.awssdk.services.backup.model.GetBackupVaultAccessPolicyRequest;
import software.amazon.awssdk.services.backup.model.GetBackupVaultAccessPolicyResponse;
import software.amazon.awssdk.services.backup.model.GetBackupVaultNotificationsRequest;
import software.amazon.awssdk.services.backup.model.GetBackupVaultNotificationsResponse;
import software.amazon.awssdk.services.backup.model.GetRecoveryPointRestoreMetadataRequest;
import software.amazon.awssdk.services.backup.model.GetRecoveryPointRestoreMetadataResponse;
import software.amazon.awssdk.services.backup.model.GetSupportedResourceTypesRequest;
import software.amazon.awssdk.services.backup.model.GetSupportedResourceTypesResponse;
import software.amazon.awssdk.services.backup.model.InvalidParameterValueException;
import software.amazon.awssdk.services.backup.model.InvalidRequestException;
import software.amazon.awssdk.services.backup.model.LimitExceededException;
import software.amazon.awssdk.services.backup.model.ListBackupJobsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupJobsResponse;
import software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest;
import software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesResponse;
import software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsResponse;
import software.amazon.awssdk.services.backup.model.ListBackupPlansRequest;
import software.amazon.awssdk.services.backup.model.ListBackupPlansResponse;
import software.amazon.awssdk.services.backup.model.ListBackupSelectionsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupSelectionsResponse;
import software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest;
import software.amazon.awssdk.services.backup.model.ListBackupVaultsResponse;
import software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest;
import software.amazon.awssdk.services.backup.model.ListProtectedResourcesResponse;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultResponse;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceRequest;
import software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceResponse;
import software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest;
import software.amazon.awssdk.services.backup.model.ListRestoreJobsResponse;
import software.amazon.awssdk.services.backup.model.ListTagsRequest;
import software.amazon.awssdk.services.backup.model.ListTagsResponse;
import software.amazon.awssdk.services.backup.model.MissingParameterValueException;
import software.amazon.awssdk.services.backup.model.PutBackupVaultAccessPolicyRequest;
import software.amazon.awssdk.services.backup.model.PutBackupVaultAccessPolicyResponse;
import software.amazon.awssdk.services.backup.model.PutBackupVaultNotificationsRequest;
import software.amazon.awssdk.services.backup.model.PutBackupVaultNotificationsResponse;
import software.amazon.awssdk.services.backup.model.ResourceNotFoundException;
import software.amazon.awssdk.services.backup.model.ServiceUnavailableException;
import software.amazon.awssdk.services.backup.model.StartBackupJobRequest;
import software.amazon.awssdk.services.backup.model.StartBackupJobResponse;
import software.amazon.awssdk.services.backup.model.StartRestoreJobRequest;
import software.amazon.awssdk.services.backup.model.StartRestoreJobResponse;
import software.amazon.awssdk.services.backup.model.StopBackupJobRequest;
import software.amazon.awssdk.services.backup.model.StopBackupJobResponse;
import software.amazon.awssdk.services.backup.model.TagResourceRequest;
import software.amazon.awssdk.services.backup.model.TagResourceResponse;
import software.amazon.awssdk.services.backup.model.UntagResourceRequest;
import software.amazon.awssdk.services.backup.model.UntagResourceResponse;
import software.amazon.awssdk.services.backup.model.UpdateBackupPlanRequest;
import software.amazon.awssdk.services.backup.model.UpdateBackupPlanResponse;
import software.amazon.awssdk.services.backup.model.UpdateRecoveryPointLifecycleRequest;
import software.amazon.awssdk.services.backup.model.UpdateRecoveryPointLifecycleResponse;
import software.amazon.awssdk.services.backup.paginators.ListBackupJobsIterable;
import software.amazon.awssdk.services.backup.paginators.ListBackupPlanTemplatesIterable;
import software.amazon.awssdk.services.backup.paginators.ListBackupPlanVersionsIterable;
import software.amazon.awssdk.services.backup.paginators.ListBackupPlansIterable;
import software.amazon.awssdk.services.backup.paginators.ListBackupSelectionsIterable;
import software.amazon.awssdk.services.backup.paginators.ListBackupVaultsIterable;
import software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesIterable;
import software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByBackupVaultIterable;
import software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByResourceIterable;
import software.amazon.awssdk.services.backup.paginators.ListRestoreJobsIterable;
import software.amazon.awssdk.services.backup.paginators.ListTagsIterable;

/**
 * Service client for accessing AWS Backup. This can be created using the static {@link #builder()} method.
 *
 * <fullname>AWS Backup</fullname>
 * <p>
 * AWS Backup is a unified backup service designed to protect AWS services and their associated data. AWS Backup
 * simplifies the creation, migration, restoration, and deletion of backups, while also providing reporting and
 * auditing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface BackupClient extends SdkClient {
    String SERVICE_NAME = "backup";

    /**
     * Create a {@link BackupClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BackupClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BackupClient}.
     */
    static BackupClientBuilder builder() {
        return new DefaultBackupClientBuilder();
    }

    /**
     * <p>
     * Backup plans are documents that contain information that AWS Backup uses to schedule tasks that create recovery
     * points of resources.
     * </p>
     * <p>
     * If you call <code>CreateBackupPlan</code> with a plan that already exists, the existing <code>backupPlanId</code>
     * is returned.
     * </p>
     *
     * @param createBackupPlanRequest
     * @return Result of the CreateBackupPlan operation returned by the service.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws AlreadyExistsException
     *         The required resource already exists.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.CreateBackupPlan
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateBackupPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateBackupPlanResponse createBackupPlan(CreateBackupPlanRequest createBackupPlanRequest)
            throws LimitExceededException, AlreadyExistsException, InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Backup plans are documents that contain information that AWS Backup uses to schedule tasks that create recovery
     * points of resources.
     * </p>
     * <p>
     * If you call <code>CreateBackupPlan</code> with a plan that already exists, the existing <code>backupPlanId</code>
     * is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBackupPlanRequest.Builder} avoiding the need
     * to create one manually via {@link CreateBackupPlanRequest#builder()}
     * </p>
     *
     * @param createBackupPlanRequest
     *        A {@link Consumer} that will call methods on {@link CreateBackupPlanInput.Builder} to create a request.
     * @return Result of the CreateBackupPlan operation returned by the service.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws AlreadyExistsException
     *         The required resource already exists.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.CreateBackupPlan
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateBackupPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateBackupPlanResponse createBackupPlan(Consumer<CreateBackupPlanRequest.Builder> createBackupPlanRequest)
            throws LimitExceededException, AlreadyExistsException, InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return createBackupPlan(CreateBackupPlanRequest.builder().applyMutation(createBackupPlanRequest).build());
    }

    /**
     * <p>
     * Creates a JSON document that specifies a set of resources to assign to a backup plan. Resources can be included
     * by specifying patterns for a <code>ListOfTags</code> and selected <code>Resources</code>.
     * </p>
     * <p>
     * For example, consider the following patterns:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Resources: "arn:aws:ec2:region:account-id:volume/volume-id"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ConditionKey:"department"</code>
     * </p>
     * <p>
     * <code>ConditionValue:"finance"</code>
     * </p>
     * <p>
     * <code>ConditionType:"StringEquals"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ConditionKey:"importance"</code>
     * </p>
     * <p>
     * <code>ConditionValue:"critical"</code>
     * </p>
     * <p>
     * <code>ConditionType:"StringEquals"</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Using these patterns would back up all Amazon Elastic Block Store (Amazon EBS) volumes that are tagged as
     * <code>"department=finance"</code>, <code>"importance=critical"</code>, in addition to an EBS volume with the
     * specified volume Id.
     * </p>
     * <p>
     * Resources and conditions are additive in that all resources that match the pattern are selected. This shouldn't
     * be confused with a logical AND, where all conditions must match. The matching patterns are logically 'put
     * together using the OR operator. In other words, all patterns that match are selected for backup.
     * </p>
     *
     * @param createBackupSelectionRequest
     * @return Result of the CreateBackupSelection operation returned by the service.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws AlreadyExistsException
     *         The required resource already exists.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.CreateBackupSelection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateBackupSelection" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateBackupSelectionResponse createBackupSelection(CreateBackupSelectionRequest createBackupSelectionRequest)
            throws LimitExceededException, AlreadyExistsException, InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a JSON document that specifies a set of resources to assign to a backup plan. Resources can be included
     * by specifying patterns for a <code>ListOfTags</code> and selected <code>Resources</code>.
     * </p>
     * <p>
     * For example, consider the following patterns:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Resources: "arn:aws:ec2:region:account-id:volume/volume-id"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ConditionKey:"department"</code>
     * </p>
     * <p>
     * <code>ConditionValue:"finance"</code>
     * </p>
     * <p>
     * <code>ConditionType:"StringEquals"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ConditionKey:"importance"</code>
     * </p>
     * <p>
     * <code>ConditionValue:"critical"</code>
     * </p>
     * <p>
     * <code>ConditionType:"StringEquals"</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Using these patterns would back up all Amazon Elastic Block Store (Amazon EBS) volumes that are tagged as
     * <code>"department=finance"</code>, <code>"importance=critical"</code>, in addition to an EBS volume with the
     * specified volume Id.
     * </p>
     * <p>
     * Resources and conditions are additive in that all resources that match the pattern are selected. This shouldn't
     * be confused with a logical AND, where all conditions must match. The matching patterns are logically 'put
     * together using the OR operator. In other words, all patterns that match are selected for backup.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBackupSelectionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateBackupSelectionRequest#builder()}
     * </p>
     *
     * @param createBackupSelectionRequest
     *        A {@link Consumer} that will call methods on {@link CreateBackupSelectionInput.Builder} to create a
     *        request.
     * @return Result of the CreateBackupSelection operation returned by the service.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws AlreadyExistsException
     *         The required resource already exists.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.CreateBackupSelection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateBackupSelection" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateBackupSelectionResponse createBackupSelection(
            Consumer<CreateBackupSelectionRequest.Builder> createBackupSelectionRequest) throws LimitExceededException,
            AlreadyExistsException, InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, BackupException {
        return createBackupSelection(CreateBackupSelectionRequest.builder().applyMutation(createBackupSelectionRequest).build());
    }

    /**
     * <p>
     * Creates a logical container where backups are stored. A <code>CreateBackupVault</code> request includes a name,
     * optionally one or more resource tags, an encryption key, and a request ID.
     * </p>
     * <note>
     * <p>
     * Sensitive data, such as passport numbers, should not be included the name of a backup vault.
     * </p>
     * </note>
     *
     * @param createBackupVaultRequest
     * @return Result of the CreateBackupVault operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws AlreadyExistsException
     *         The required resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.CreateBackupVault
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateBackupVault" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateBackupVaultResponse createBackupVault(CreateBackupVaultRequest createBackupVaultRequest)
            throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException,
            LimitExceededException, AlreadyExistsException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a logical container where backups are stored. A <code>CreateBackupVault</code> request includes a name,
     * optionally one or more resource tags, an encryption key, and a request ID.
     * </p>
     * <note>
     * <p>
     * Sensitive data, such as passport numbers, should not be included the name of a backup vault.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBackupVaultRequest.Builder} avoiding the need
     * to create one manually via {@link CreateBackupVaultRequest#builder()}
     * </p>
     *
     * @param createBackupVaultRequest
     *        A {@link Consumer} that will call methods on {@link CreateBackupVaultInput.Builder} to create a request.
     * @return Result of the CreateBackupVault operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws AlreadyExistsException
     *         The required resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.CreateBackupVault
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateBackupVault" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateBackupVaultResponse createBackupVault(Consumer<CreateBackupVaultRequest.Builder> createBackupVaultRequest)
            throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException,
            LimitExceededException, AlreadyExistsException, AwsServiceException, SdkClientException, BackupException {
        return createBackupVault(CreateBackupVaultRequest.builder().applyMutation(createBackupVaultRequest).build());
    }

    /**
     * <p>
     * Deletes a backup plan. A backup plan can only be deleted after all associated selections of resources have been
     * deleted. Deleting a backup plan deletes the current version of a backup plan. Previous versions, if any, will
     * still exist.
     * </p>
     *
     * @param deleteBackupPlanRequest
     * @return Result of the DeleteBackupPlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteBackupPlan
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteBackupPlanResponse deleteBackupPlan(DeleteBackupPlanRequest deleteBackupPlanRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a backup plan. A backup plan can only be deleted after all associated selections of resources have been
     * deleted. Deleting a backup plan deletes the current version of a backup plan. Previous versions, if any, will
     * still exist.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBackupPlanRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteBackupPlanRequest#builder()}
     * </p>
     *
     * @param deleteBackupPlanRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBackupPlanInput.Builder} to create a request.
     * @return Result of the DeleteBackupPlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteBackupPlan
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteBackupPlanResponse deleteBackupPlan(Consumer<DeleteBackupPlanRequest.Builder> deleteBackupPlanRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        return deleteBackupPlan(DeleteBackupPlanRequest.builder().applyMutation(deleteBackupPlanRequest).build());
    }

    /**
     * <p>
     * Deletes the resource selection associated with a backup plan that is specified by the <code>SelectionId</code>.
     * </p>
     *
     * @param deleteBackupSelectionRequest
     * @return Result of the DeleteBackupSelection operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteBackupSelection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupSelection" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteBackupSelectionResponse deleteBackupSelection(DeleteBackupSelectionRequest deleteBackupSelectionRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the resource selection associated with a backup plan that is specified by the <code>SelectionId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBackupSelectionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteBackupSelectionRequest#builder()}
     * </p>
     *
     * @param deleteBackupSelectionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBackupSelectionInput.Builder} to create a
     *        request.
     * @return Result of the DeleteBackupSelection operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteBackupSelection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupSelection" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteBackupSelectionResponse deleteBackupSelection(
            Consumer<DeleteBackupSelectionRequest.Builder> deleteBackupSelectionRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        return deleteBackupSelection(DeleteBackupSelectionRequest.builder().applyMutation(deleteBackupSelectionRequest).build());
    }

    /**
     * <p>
     * Deletes the backup vault identified by its name. A vault can be deleted only if it is empty.
     * </p>
     *
     * @param deleteBackupVaultRequest
     * @return Result of the DeleteBackupVault operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteBackupVault
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVault" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteBackupVaultResponse deleteBackupVault(DeleteBackupVaultRequest deleteBackupVaultRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the backup vault identified by its name. A vault can be deleted only if it is empty.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBackupVaultRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteBackupVaultRequest#builder()}
     * </p>
     *
     * @param deleteBackupVaultRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBackupVaultInput.Builder} to create a request.
     * @return Result of the DeleteBackupVault operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteBackupVault
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVault" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteBackupVaultResponse deleteBackupVault(Consumer<DeleteBackupVaultRequest.Builder> deleteBackupVaultRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        return deleteBackupVault(DeleteBackupVaultRequest.builder().applyMutation(deleteBackupVaultRequest).build());
    }

    /**
     * <p>
     * Deletes the policy document that manages permissions on a backup vault.
     * </p>
     *
     * @param deleteBackupVaultAccessPolicyRequest
     * @return Result of the DeleteBackupVaultAccessPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteBackupVaultAccessPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVaultAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBackupVaultAccessPolicyResponse deleteBackupVaultAccessPolicy(
            DeleteBackupVaultAccessPolicyRequest deleteBackupVaultAccessPolicyRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the policy document that manages permissions on a backup vault.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBackupVaultAccessPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteBackupVaultAccessPolicyRequest#builder()}
     * </p>
     *
     * @param deleteBackupVaultAccessPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBackupVaultAccessPolicyInput.Builder} to create
     *        a request.
     * @return Result of the DeleteBackupVaultAccessPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteBackupVaultAccessPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVaultAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBackupVaultAccessPolicyResponse deleteBackupVaultAccessPolicy(
            Consumer<DeleteBackupVaultAccessPolicyRequest.Builder> deleteBackupVaultAccessPolicyRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return deleteBackupVaultAccessPolicy(DeleteBackupVaultAccessPolicyRequest.builder()
                .applyMutation(deleteBackupVaultAccessPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes event notifications for the specified backup vault.
     * </p>
     *
     * @param deleteBackupVaultNotificationsRequest
     * @return Result of the DeleteBackupVaultNotifications operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteBackupVaultNotifications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVaultNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBackupVaultNotificationsResponse deleteBackupVaultNotifications(
            DeleteBackupVaultNotificationsRequest deleteBackupVaultNotificationsRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes event notifications for the specified backup vault.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBackupVaultNotificationsRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteBackupVaultNotificationsRequest#builder()}
     * </p>
     *
     * @param deleteBackupVaultNotificationsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBackupVaultNotificationsInput.Builder} to create
     *        a request.
     * @return Result of the DeleteBackupVaultNotifications operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteBackupVaultNotifications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVaultNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteBackupVaultNotificationsResponse deleteBackupVaultNotifications(
            Consumer<DeleteBackupVaultNotificationsRequest.Builder> deleteBackupVaultNotificationsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return deleteBackupVaultNotifications(DeleteBackupVaultNotificationsRequest.builder()
                .applyMutation(deleteBackupVaultNotificationsRequest).build());
    }

    /**
     * <p>
     * Deletes the recovery point specified by a recovery point ID.
     * </p>
     *
     * @param deleteRecoveryPointRequest
     * @return Result of the DeleteRecoveryPoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteRecoveryPoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteRecoveryPoint" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRecoveryPointResponse deleteRecoveryPoint(DeleteRecoveryPointRequest deleteRecoveryPointRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the recovery point specified by a recovery point ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRecoveryPointRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRecoveryPointRequest#builder()}
     * </p>
     *
     * @param deleteRecoveryPointRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRecoveryPointInput.Builder} to create a request.
     * @return Result of the DeleteRecoveryPoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DeleteRecoveryPoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteRecoveryPoint" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRecoveryPointResponse deleteRecoveryPoint(
            Consumer<DeleteRecoveryPointRequest.Builder> deleteRecoveryPointRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, InvalidRequestException,
            AwsServiceException, SdkClientException, BackupException {
        return deleteRecoveryPoint(DeleteRecoveryPointRequest.builder().applyMutation(deleteRecoveryPointRequest).build());
    }

    /**
     * <p>
     * Returns metadata associated with creating a backup of a resource.
     * </p>
     *
     * @param describeBackupJobRequest
     * @return Result of the DescribeBackupJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws DependencyFailureException
     *         A dependent AWS service or resource returned an error to the AWS Backup service, and the action cannot be
     *         completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeBackupJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeBackupJob" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeBackupJobResponse describeBackupJob(DescribeBackupJobRequest describeBackupJobRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, DependencyFailureException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata associated with creating a backup of a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBackupJobRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeBackupJobRequest#builder()}
     * </p>
     *
     * @param describeBackupJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBackupJobInput.Builder} to create a request.
     * @return Result of the DescribeBackupJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws DependencyFailureException
     *         A dependent AWS service or resource returned an error to the AWS Backup service, and the action cannot be
     *         completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeBackupJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeBackupJob" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeBackupJobResponse describeBackupJob(Consumer<DescribeBackupJobRequest.Builder> describeBackupJobRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, DependencyFailureException, AwsServiceException, SdkClientException, BackupException {
        return describeBackupJob(DescribeBackupJobRequest.builder().applyMutation(describeBackupJobRequest).build());
    }

    /**
     * <p>
     * Returns metadata about a backup vault specified by its name.
     * </p>
     *
     * @param describeBackupVaultRequest
     * @return Result of the DescribeBackupVault operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeBackupVault
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeBackupVault" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeBackupVaultResponse describeBackupVault(DescribeBackupVaultRequest describeBackupVaultRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata about a backup vault specified by its name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBackupVaultRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeBackupVaultRequest#builder()}
     * </p>
     *
     * @param describeBackupVaultRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBackupVaultInput.Builder} to create a request.
     * @return Result of the DescribeBackupVault operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeBackupVault
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeBackupVault" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeBackupVaultResponse describeBackupVault(
            Consumer<DescribeBackupVaultRequest.Builder> describeBackupVaultRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        return describeBackupVault(DescribeBackupVaultRequest.builder().applyMutation(describeBackupVaultRequest).build());
    }

    /**
     * <p>
     * Returns information about a saved resource, including the last time it was backed-up, its Amazon Resource Name
     * (ARN), and the AWS service type of the saved resource.
     * </p>
     *
     * @param describeProtectedResourceRequest
     * @return Result of the DescribeProtectedResource operation returned by the service.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeProtectedResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeProtectedResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProtectedResourceResponse describeProtectedResource(
            DescribeProtectedResourceRequest describeProtectedResourceRequest) throws MissingParameterValueException,
            InvalidParameterValueException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a saved resource, including the last time it was backed-up, its Amazon Resource Name
     * (ARN), and the AWS service type of the saved resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProtectedResourceRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeProtectedResourceRequest#builder()}
     * </p>
     *
     * @param describeProtectedResourceRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProtectedResourceInput.Builder} to create a
     *        request.
     * @return Result of the DescribeProtectedResource operation returned by the service.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeProtectedResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeProtectedResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProtectedResourceResponse describeProtectedResource(
            Consumer<DescribeProtectedResourceRequest.Builder> describeProtectedResourceRequest)
            throws MissingParameterValueException, InvalidParameterValueException, ServiceUnavailableException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BackupException {
        return describeProtectedResource(DescribeProtectedResourceRequest.builder()
                .applyMutation(describeProtectedResourceRequest).build());
    }

    /**
     * <p>
     * Returns metadata associated with a recovery point, including ID, status, encryption, and lifecycle.
     * </p>
     *
     * @param describeRecoveryPointRequest
     * @return Result of the DescribeRecoveryPoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeRecoveryPoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeRecoveryPoint" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRecoveryPointResponse describeRecoveryPoint(DescribeRecoveryPointRequest describeRecoveryPointRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata associated with a recovery point, including ID, status, encryption, and lifecycle.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRecoveryPointRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRecoveryPointRequest#builder()}
     * </p>
     *
     * @param describeRecoveryPointRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRecoveryPointInput.Builder} to create a
     *        request.
     * @return Result of the DescribeRecoveryPoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeRecoveryPoint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeRecoveryPoint" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRecoveryPointResponse describeRecoveryPoint(
            Consumer<DescribeRecoveryPointRequest.Builder> describeRecoveryPointRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        return describeRecoveryPoint(DescribeRecoveryPointRequest.builder().applyMutation(describeRecoveryPointRequest).build());
    }

    /**
     * <p>
     * Returns metadata associated with a restore job that is specified by a job ID.
     * </p>
     *
     * @param describeRestoreJobRequest
     * @return Result of the DescribeRestoreJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws DependencyFailureException
     *         A dependent AWS service or resource returned an error to the AWS Backup service, and the action cannot be
     *         completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeRestoreJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeRestoreJob" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeRestoreJobResponse describeRestoreJob(DescribeRestoreJobRequest describeRestoreJobRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, DependencyFailureException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata associated with a restore job that is specified by a job ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRestoreJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeRestoreJobRequest#builder()}
     * </p>
     *
     * @param describeRestoreJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRestoreJobInput.Builder} to create a request.
     * @return Result of the DescribeRestoreJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws DependencyFailureException
     *         A dependent AWS service or resource returned an error to the AWS Backup service, and the action cannot be
     *         completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.DescribeRestoreJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeRestoreJob" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeRestoreJobResponse describeRestoreJob(Consumer<DescribeRestoreJobRequest.Builder> describeRestoreJobRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, DependencyFailureException, AwsServiceException, SdkClientException, BackupException {
        return describeRestoreJob(DescribeRestoreJobRequest.builder().applyMutation(describeRestoreJobRequest).build());
    }

    /**
     * <p>
     * Returns the backup plan that is specified by the plan ID as a backup template.
     * </p>
     *
     * @param exportBackupPlanTemplateRequest
     * @return Result of the ExportBackupPlanTemplate operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ExportBackupPlanTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ExportBackupPlanTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default ExportBackupPlanTemplateResponse exportBackupPlanTemplate(
            ExportBackupPlanTemplateRequest exportBackupPlanTemplateRequest) throws InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the backup plan that is specified by the plan ID as a backup template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportBackupPlanTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link ExportBackupPlanTemplateRequest#builder()}
     * </p>
     *
     * @param exportBackupPlanTemplateRequest
     *        A {@link Consumer} that will call methods on {@link ExportBackupPlanTemplateInput.Builder} to create a
     *        request.
     * @return Result of the ExportBackupPlanTemplate operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ExportBackupPlanTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ExportBackupPlanTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default ExportBackupPlanTemplateResponse exportBackupPlanTemplate(
            Consumer<ExportBackupPlanTemplateRequest.Builder> exportBackupPlanTemplateRequest)
            throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BackupException {
        return exportBackupPlanTemplate(ExportBackupPlanTemplateRequest.builder().applyMutation(exportBackupPlanTemplateRequest)
                .build());
    }

    /**
     * <p>
     * Returns the body of a backup plan in JSON format, in addition to plan metadata.
     * </p>
     *
     * @param getBackupPlanRequest
     * @return Result of the GetBackupPlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetBackupPlan
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBackupPlanResponse getBackupPlan(GetBackupPlanRequest getBackupPlanRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the body of a backup plan in JSON format, in addition to plan metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBackupPlanRequest.Builder} avoiding the need to
     * create one manually via {@link GetBackupPlanRequest#builder()}
     * </p>
     *
     * @param getBackupPlanRequest
     *        A {@link Consumer} that will call methods on {@link GetBackupPlanInput.Builder} to create a request.
     * @return Result of the GetBackupPlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetBackupPlan
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBackupPlanResponse getBackupPlan(Consumer<GetBackupPlanRequest.Builder> getBackupPlanRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return getBackupPlan(GetBackupPlanRequest.builder().applyMutation(getBackupPlanRequest).build());
    }

    /**
     * <p>
     * Returns a valid JSON document specifying a backup plan or an error.
     * </p>
     *
     * @param getBackupPlanFromJsonRequest
     * @return Result of the GetBackupPlanFromJSON operation returned by the service.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetBackupPlanFromJSON
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupPlanFromJSON" target="_top">AWS
     *      API Documentation</a>
     */
    default GetBackupPlanFromJsonResponse getBackupPlanFromJSON(GetBackupPlanFromJsonRequest getBackupPlanFromJsonRequest)
            throws LimitExceededException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, InvalidRequestException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a valid JSON document specifying a backup plan or an error.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBackupPlanFromJsonRequest.Builder} avoiding the
     * need to create one manually via {@link GetBackupPlanFromJsonRequest#builder()}
     * </p>
     *
     * @param getBackupPlanFromJsonRequest
     *        A {@link Consumer} that will call methods on {@link GetBackupPlanFromJSONInput.Builder} to create a
     *        request.
     * @return Result of the GetBackupPlanFromJSON operation returned by the service.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetBackupPlanFromJSON
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupPlanFromJSON" target="_top">AWS
     *      API Documentation</a>
     */
    default GetBackupPlanFromJsonResponse getBackupPlanFromJSON(
            Consumer<GetBackupPlanFromJsonRequest.Builder> getBackupPlanFromJsonRequest) throws LimitExceededException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, InvalidRequestException,
            AwsServiceException, SdkClientException, BackupException {
        return getBackupPlanFromJSON(GetBackupPlanFromJsonRequest.builder().applyMutation(getBackupPlanFromJsonRequest).build());
    }

    /**
     * <p>
     * Returns the template specified by its <code>templateId</code> as a backup plan.
     * </p>
     *
     * @param getBackupPlanFromTemplateRequest
     * @return Result of the GetBackupPlanFromTemplate operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetBackupPlanFromTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupPlanFromTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBackupPlanFromTemplateResponse getBackupPlanFromTemplate(
            GetBackupPlanFromTemplateRequest getBackupPlanFromTemplateRequest) throws InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the template specified by its <code>templateId</code> as a backup plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBackupPlanFromTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link GetBackupPlanFromTemplateRequest#builder()}
     * </p>
     *
     * @param getBackupPlanFromTemplateRequest
     *        A {@link Consumer} that will call methods on {@link GetBackupPlanFromTemplateInput.Builder} to create a
     *        request.
     * @return Result of the GetBackupPlanFromTemplate operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetBackupPlanFromTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupPlanFromTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBackupPlanFromTemplateResponse getBackupPlanFromTemplate(
            Consumer<GetBackupPlanFromTemplateRequest.Builder> getBackupPlanFromTemplateRequest)
            throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BackupException {
        return getBackupPlanFromTemplate(GetBackupPlanFromTemplateRequest.builder()
                .applyMutation(getBackupPlanFromTemplateRequest).build());
    }

    /**
     * <p>
     * Returns selection metadata and a document in JSON format that specifies a list of resources that are associated
     * with a backup plan.
     * </p>
     *
     * @param getBackupSelectionRequest
     * @return Result of the GetBackupSelection operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetBackupSelection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupSelection" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBackupSelectionResponse getBackupSelection(GetBackupSelectionRequest getBackupSelectionRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns selection metadata and a document in JSON format that specifies a list of resources that are associated
     * with a backup plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBackupSelectionRequest.Builder} avoiding the
     * need to create one manually via {@link GetBackupSelectionRequest#builder()}
     * </p>
     *
     * @param getBackupSelectionRequest
     *        A {@link Consumer} that will call methods on {@link GetBackupSelectionInput.Builder} to create a request.
     * @return Result of the GetBackupSelection operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetBackupSelection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupSelection" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBackupSelectionResponse getBackupSelection(Consumer<GetBackupSelectionRequest.Builder> getBackupSelectionRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return getBackupSelection(GetBackupSelectionRequest.builder().applyMutation(getBackupSelectionRequest).build());
    }

    /**
     * <p>
     * Returns the access policy document that is associated with the named backup vault.
     * </p>
     *
     * @param getBackupVaultAccessPolicyRequest
     * @return Result of the GetBackupVaultAccessPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetBackupVaultAccessPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupVaultAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBackupVaultAccessPolicyResponse getBackupVaultAccessPolicy(
            GetBackupVaultAccessPolicyRequest getBackupVaultAccessPolicyRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the access policy document that is associated with the named backup vault.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBackupVaultAccessPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link GetBackupVaultAccessPolicyRequest#builder()}
     * </p>
     *
     * @param getBackupVaultAccessPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetBackupVaultAccessPolicyInput.Builder} to create a
     *        request.
     * @return Result of the GetBackupVaultAccessPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetBackupVaultAccessPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupVaultAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBackupVaultAccessPolicyResponse getBackupVaultAccessPolicy(
            Consumer<GetBackupVaultAccessPolicyRequest.Builder> getBackupVaultAccessPolicyRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return getBackupVaultAccessPolicy(GetBackupVaultAccessPolicyRequest.builder()
                .applyMutation(getBackupVaultAccessPolicyRequest).build());
    }

    /**
     * <p>
     * Returns event notifications for the specified backup vault.
     * </p>
     *
     * @param getBackupVaultNotificationsRequest
     * @return Result of the GetBackupVaultNotifications operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetBackupVaultNotifications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupVaultNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBackupVaultNotificationsResponse getBackupVaultNotifications(
            GetBackupVaultNotificationsRequest getBackupVaultNotificationsRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns event notifications for the specified backup vault.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBackupVaultNotificationsRequest.Builder}
     * avoiding the need to create one manually via {@link GetBackupVaultNotificationsRequest#builder()}
     * </p>
     *
     * @param getBackupVaultNotificationsRequest
     *        A {@link Consumer} that will call methods on {@link GetBackupVaultNotificationsInput.Builder} to create a
     *        request.
     * @return Result of the GetBackupVaultNotifications operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetBackupVaultNotifications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupVaultNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBackupVaultNotificationsResponse getBackupVaultNotifications(
            Consumer<GetBackupVaultNotificationsRequest.Builder> getBackupVaultNotificationsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return getBackupVaultNotifications(GetBackupVaultNotificationsRequest.builder()
                .applyMutation(getBackupVaultNotificationsRequest).build());
    }

    /**
     * <p>
     * Returns two sets of metadata key-value pairs. The first set lists the metadata that the recovery point was
     * created with. The second set lists the metadata key-value pairs that are required to restore the recovery point.
     * </p>
     * <p>
     * These sets can be the same, or the restore metadata set can contain different values if the target service to be
     * restored has changed since the recovery point was created and now requires additional or different information in
     * order to be restored.
     * </p>
     *
     * @param getRecoveryPointRestoreMetadataRequest
     * @return Result of the GetRecoveryPointRestoreMetadata operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetRecoveryPointRestoreMetadata
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRecoveryPointRestoreMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRecoveryPointRestoreMetadataResponse getRecoveryPointRestoreMetadata(
            GetRecoveryPointRestoreMetadataRequest getRecoveryPointRestoreMetadataRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns two sets of metadata key-value pairs. The first set lists the metadata that the recovery point was
     * created with. The second set lists the metadata key-value pairs that are required to restore the recovery point.
     * </p>
     * <p>
     * These sets can be the same, or the restore metadata set can contain different values if the target service to be
     * restored has changed since the recovery point was created and now requires additional or different information in
     * order to be restored.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRecoveryPointRestoreMetadataRequest.Builder}
     * avoiding the need to create one manually via {@link GetRecoveryPointRestoreMetadataRequest#builder()}
     * </p>
     *
     * @param getRecoveryPointRestoreMetadataRequest
     *        A {@link Consumer} that will call methods on {@link GetRecoveryPointRestoreMetadataInput.Builder} to
     *        create a request.
     * @return Result of the GetRecoveryPointRestoreMetadata operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetRecoveryPointRestoreMetadata
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRecoveryPointRestoreMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRecoveryPointRestoreMetadataResponse getRecoveryPointRestoreMetadata(
            Consumer<GetRecoveryPointRestoreMetadataRequest.Builder> getRecoveryPointRestoreMetadataRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return getRecoveryPointRestoreMetadata(GetRecoveryPointRestoreMetadataRequest.builder()
                .applyMutation(getRecoveryPointRestoreMetadataRequest).build());
    }

    /**
     * <p>
     * Returns the AWS resource types supported by AWS Backup.
     * </p>
     *
     * @param getSupportedResourceTypesRequest
     * @return Result of the GetSupportedResourceTypes operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetSupportedResourceTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetSupportedResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSupportedResourceTypesResponse getSupportedResourceTypes(
            GetSupportedResourceTypesRequest getSupportedResourceTypesRequest) throws ServiceUnavailableException,
            AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the AWS resource types supported by AWS Backup.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSupportedResourceTypesRequest.Builder} avoiding
     * the need to create one manually via {@link GetSupportedResourceTypesRequest#builder()}
     * </p>
     *
     * @param getSupportedResourceTypesRequest
     *        A {@link Consumer} that will call methods on {@link GetSupportedResourceTypesRequest.Builder} to create a
     *        request.
     * @return Result of the GetSupportedResourceTypes operation returned by the service.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.GetSupportedResourceTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetSupportedResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSupportedResourceTypesResponse getSupportedResourceTypes(
            Consumer<GetSupportedResourceTypesRequest.Builder> getSupportedResourceTypesRequest)
            throws ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return getSupportedResourceTypes(GetSupportedResourceTypesRequest.builder()
                .applyMutation(getSupportedResourceTypesRequest).build());
    }

    /**
     * <p>
     * Returns metadata about your backup jobs.
     * </p>
     *
     * @return Result of the ListBackupJobs operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupJobs
     * @see #listBackupJobs(ListBackupJobsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupJobsResponse listBackupJobs() throws InvalidParameterValueException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, BackupException {
        return listBackupJobs(ListBackupJobsRequest.builder().build());
    }

    /**
     * <p>
     * Returns metadata about your backup jobs.
     * </p>
     *
     * @param listBackupJobsRequest
     * @return Result of the ListBackupJobs operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupJobsResponse listBackupJobs(ListBackupJobsRequest listBackupJobsRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata about your backup jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBackupJobsRequest#builder()}
     * </p>
     *
     * @param listBackupJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListBackupJobsInput.Builder} to create a request.
     * @return Result of the ListBackupJobs operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupJobsResponse listBackupJobs(Consumer<ListBackupJobsRequest.Builder> listBackupJobsRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        return listBackupJobs(ListBackupJobsRequest.builder().applyMutation(listBackupJobsRequest).build());
    }

    /**
     * <p>
     * Returns metadata about your backup jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBackupJobs(software.amazon.awssdk.services.backup.model.ListBackupJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupJobsIterable responses = client.listBackupJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupJobsIterable responses = client.listBackupJobsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupJobsIterable responses = client.listBackupJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupJobs(software.amazon.awssdk.services.backup.model.ListBackupJobsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupJobs
     * @see #listBackupJobsPaginator(ListBackupJobsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupJobsIterable listBackupJobsPaginator() throws InvalidParameterValueException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, BackupException {
        return listBackupJobsPaginator(ListBackupJobsRequest.builder().build());
    }

    /**
     * <p>
     * Returns metadata about your backup jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBackupJobs(software.amazon.awssdk.services.backup.model.ListBackupJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupJobsIterable responses = client.listBackupJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupJobsIterable responses = client.listBackupJobsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupJobsIterable responses = client.listBackupJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupJobs(software.amazon.awssdk.services.backup.model.ListBackupJobsRequest)} operation.</b>
     * </p>
     *
     * @param listBackupJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupJobsIterable listBackupJobsPaginator(ListBackupJobsRequest listBackupJobsRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata about your backup jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listBackupJobs(software.amazon.awssdk.services.backup.model.ListBackupJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupJobsIterable responses = client.listBackupJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupJobsIterable responses = client.listBackupJobsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupJobsIterable responses = client.listBackupJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupJobs(software.amazon.awssdk.services.backup.model.ListBackupJobsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBackupJobsRequest#builder()}
     * </p>
     *
     * @param listBackupJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListBackupJobsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupJobsIterable listBackupJobsPaginator(Consumer<ListBackupJobsRequest.Builder> listBackupJobsRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        return listBackupJobsPaginator(ListBackupJobsRequest.builder().applyMutation(listBackupJobsRequest).build());
    }

    /**
     * <p>
     * Returns metadata of your saved backup plan templates, including the template ID, name, and the creation and
     * deletion dates.
     * </p>
     *
     * @return Result of the ListBackupPlanTemplates operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlanTemplates
     * @see #listBackupPlanTemplates(ListBackupPlanTemplatesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBackupPlanTemplatesResponse listBackupPlanTemplates() throws InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BackupException {
        return listBackupPlanTemplates(ListBackupPlanTemplatesRequest.builder().build());
    }

    /**
     * <p>
     * Returns metadata of your saved backup plan templates, including the template ID, name, and the creation and
     * deletion dates.
     * </p>
     *
     * @param listBackupPlanTemplatesRequest
     * @return Result of the ListBackupPlanTemplates operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlanTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBackupPlanTemplatesResponse listBackupPlanTemplates(ListBackupPlanTemplatesRequest listBackupPlanTemplatesRequest)
            throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata of your saved backup plan templates, including the template ID, name, and the creation and
     * deletion dates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupPlanTemplatesRequest.Builder} avoiding
     * the need to create one manually via {@link ListBackupPlanTemplatesRequest#builder()}
     * </p>
     *
     * @param listBackupPlanTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListBackupPlanTemplatesInput.Builder} to create a
     *        request.
     * @return Result of the ListBackupPlanTemplates operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlanTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBackupPlanTemplatesResponse listBackupPlanTemplates(
            Consumer<ListBackupPlanTemplatesRequest.Builder> listBackupPlanTemplatesRequest)
            throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BackupException {
        return listBackupPlanTemplates(ListBackupPlanTemplatesRequest.builder().applyMutation(listBackupPlanTemplatesRequest)
                .build());
    }

    /**
     * <p>
     * Returns metadata of your saved backup plan templates, including the template ID, name, and the creation and
     * deletion dates.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBackupPlanTemplates(software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlanTemplatesIterable responses = client.listBackupPlanTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupPlanTemplatesIterable responses = client
     *             .listBackupPlanTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlanTemplatesIterable responses = client.listBackupPlanTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupPlanTemplates(software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlanTemplates
     * @see #listBackupPlanTemplatesPaginator(ListBackupPlanTemplatesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBackupPlanTemplatesIterable listBackupPlanTemplatesPaginator() throws InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BackupException {
        return listBackupPlanTemplatesPaginator(ListBackupPlanTemplatesRequest.builder().build());
    }

    /**
     * <p>
     * Returns metadata of your saved backup plan templates, including the template ID, name, and the creation and
     * deletion dates.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBackupPlanTemplates(software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlanTemplatesIterable responses = client.listBackupPlanTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupPlanTemplatesIterable responses = client
     *             .listBackupPlanTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlanTemplatesIterable responses = client.listBackupPlanTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupPlanTemplates(software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBackupPlanTemplatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlanTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBackupPlanTemplatesIterable listBackupPlanTemplatesPaginator(
            ListBackupPlanTemplatesRequest listBackupPlanTemplatesRequest) throws InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata of your saved backup plan templates, including the template ID, name, and the creation and
     * deletion dates.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBackupPlanTemplates(software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlanTemplatesIterable responses = client.listBackupPlanTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupPlanTemplatesIterable responses = client
     *             .listBackupPlanTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlanTemplatesIterable responses = client.listBackupPlanTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupPlanTemplates(software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupPlanTemplatesRequest.Builder} avoiding
     * the need to create one manually via {@link ListBackupPlanTemplatesRequest#builder()}
     * </p>
     *
     * @param listBackupPlanTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListBackupPlanTemplatesInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlanTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBackupPlanTemplatesIterable listBackupPlanTemplatesPaginator(
            Consumer<ListBackupPlanTemplatesRequest.Builder> listBackupPlanTemplatesRequest)
            throws InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BackupException {
        return listBackupPlanTemplatesPaginator(ListBackupPlanTemplatesRequest.builder()
                .applyMutation(listBackupPlanTemplatesRequest).build());
    }

    /**
     * <p>
     * Returns version metadata of your backup plans, including Amazon Resource Names (ARNs), backup plan IDs, creation
     * and deletion dates, plan names, and version IDs.
     * </p>
     *
     * @param listBackupPlanVersionsRequest
     * @return Result of the ListBackupPlanVersions operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlanVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBackupPlanVersionsResponse listBackupPlanVersions(ListBackupPlanVersionsRequest listBackupPlanVersionsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns version metadata of your backup plans, including Amazon Resource Names (ARNs), backup plan IDs, creation
     * and deletion dates, plan names, and version IDs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupPlanVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBackupPlanVersionsRequest#builder()}
     * </p>
     *
     * @param listBackupPlanVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListBackupPlanVersionsInput.Builder} to create a
     *        request.
     * @return Result of the ListBackupPlanVersions operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlanVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBackupPlanVersionsResponse listBackupPlanVersions(
            Consumer<ListBackupPlanVersionsRequest.Builder> listBackupPlanVersionsRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        return listBackupPlanVersions(ListBackupPlanVersionsRequest.builder().applyMutation(listBackupPlanVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns version metadata of your backup plans, including Amazon Resource Names (ARNs), backup plan IDs, creation
     * and deletion dates, plan names, and version IDs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBackupPlanVersions(software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlanVersionsIterable responses = client.listBackupPlanVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupPlanVersionsIterable responses = client
     *             .listBackupPlanVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlanVersionsIterable responses = client.listBackupPlanVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupPlanVersions(software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBackupPlanVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlanVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBackupPlanVersionsIterable listBackupPlanVersionsPaginator(
            ListBackupPlanVersionsRequest listBackupPlanVersionsRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns version metadata of your backup plans, including Amazon Resource Names (ARNs), backup plan IDs, creation
     * and deletion dates, plan names, and version IDs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBackupPlanVersions(software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlanVersionsIterable responses = client.listBackupPlanVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupPlanVersionsIterable responses = client
     *             .listBackupPlanVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlanVersionsIterable responses = client.listBackupPlanVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupPlanVersions(software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupPlanVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBackupPlanVersionsRequest#builder()}
     * </p>
     *
     * @param listBackupPlanVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListBackupPlanVersionsInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlanVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBackupPlanVersionsIterable listBackupPlanVersionsPaginator(
            Consumer<ListBackupPlanVersionsRequest.Builder> listBackupPlanVersionsRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        return listBackupPlanVersionsPaginator(ListBackupPlanVersionsRequest.builder()
                .applyMutation(listBackupPlanVersionsRequest).build());
    }

    /**
     * <p>
     * Returns metadata of your saved backup plans, including Amazon Resource Names (ARNs), plan IDs, creation and
     * deletion dates, version IDs, plan names, and creator request IDs.
     * </p>
     *
     * @return Result of the ListBackupPlans operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlans
     * @see #listBackupPlans(ListBackupPlansRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlans" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupPlansResponse listBackupPlans() throws ResourceNotFoundException, InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listBackupPlans(ListBackupPlansRequest.builder().build());
    }

    /**
     * <p>
     * Returns metadata of your saved backup plans, including Amazon Resource Names (ARNs), plan IDs, creation and
     * deletion dates, version IDs, plan names, and creator request IDs.
     * </p>
     *
     * @param listBackupPlansRequest
     * @return Result of the ListBackupPlans operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlans
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlans" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupPlansResponse listBackupPlans(ListBackupPlansRequest listBackupPlansRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata of your saved backup plans, including Amazon Resource Names (ARNs), plan IDs, creation and
     * deletion dates, version IDs, plan names, and creator request IDs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupPlansRequest.Builder} avoiding the need
     * to create one manually via {@link ListBackupPlansRequest#builder()}
     * </p>
     *
     * @param listBackupPlansRequest
     *        A {@link Consumer} that will call methods on {@link ListBackupPlansInput.Builder} to create a request.
     * @return Result of the ListBackupPlans operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlans
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlans" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupPlansResponse listBackupPlans(Consumer<ListBackupPlansRequest.Builder> listBackupPlansRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listBackupPlans(ListBackupPlansRequest.builder().applyMutation(listBackupPlansRequest).build());
    }

    /**
     * <p>
     * Returns metadata of your saved backup plans, including Amazon Resource Names (ARNs), plan IDs, creation and
     * deletion dates, version IDs, plan names, and creator request IDs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBackupPlans(software.amazon.awssdk.services.backup.model.ListBackupPlansRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlansIterable responses = client.listBackupPlansPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupPlansIterable responses = client
     *             .listBackupPlansPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupPlansResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlansIterable responses = client.listBackupPlansPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupPlans(software.amazon.awssdk.services.backup.model.ListBackupPlansRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlans
     * @see #listBackupPlansPaginator(ListBackupPlansRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlans" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupPlansIterable listBackupPlansPaginator() throws ResourceNotFoundException, InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listBackupPlansPaginator(ListBackupPlansRequest.builder().build());
    }

    /**
     * <p>
     * Returns metadata of your saved backup plans, including Amazon Resource Names (ARNs), plan IDs, creation and
     * deletion dates, version IDs, plan names, and creator request IDs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBackupPlans(software.amazon.awssdk.services.backup.model.ListBackupPlansRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlansIterable responses = client.listBackupPlansPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupPlansIterable responses = client
     *             .listBackupPlansPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupPlansResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlansIterable responses = client.listBackupPlansPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupPlans(software.amazon.awssdk.services.backup.model.ListBackupPlansRequest)} operation.</b>
     * </p>
     *
     * @param listBackupPlansRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlans
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlans" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupPlansIterable listBackupPlansPaginator(ListBackupPlansRequest listBackupPlansRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns metadata of your saved backup plans, including Amazon Resource Names (ARNs), plan IDs, creation and
     * deletion dates, version IDs, plan names, and creator request IDs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBackupPlans(software.amazon.awssdk.services.backup.model.ListBackupPlansRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlansIterable responses = client.listBackupPlansPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupPlansIterable responses = client
     *             .listBackupPlansPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupPlansResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupPlansIterable responses = client.listBackupPlansPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupPlans(software.amazon.awssdk.services.backup.model.ListBackupPlansRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupPlansRequest.Builder} avoiding the need
     * to create one manually via {@link ListBackupPlansRequest#builder()}
     * </p>
     *
     * @param listBackupPlansRequest
     *        A {@link Consumer} that will call methods on {@link ListBackupPlansInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupPlans
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlans" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupPlansIterable listBackupPlansPaginator(Consumer<ListBackupPlansRequest.Builder> listBackupPlansRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listBackupPlansPaginator(ListBackupPlansRequest.builder().applyMutation(listBackupPlansRequest).build());
    }

    /**
     * <p>
     * Returns an array containing metadata of the resources associated with the target backup plan.
     * </p>
     *
     * @param listBackupSelectionsRequest
     * @return Result of the ListBackupSelections operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupSelections
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupSelections" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBackupSelectionsResponse listBackupSelections(ListBackupSelectionsRequest listBackupSelectionsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array containing metadata of the resources associated with the target backup plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupSelectionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBackupSelectionsRequest#builder()}
     * </p>
     *
     * @param listBackupSelectionsRequest
     *        A {@link Consumer} that will call methods on {@link ListBackupSelectionsInput.Builder} to create a
     *        request.
     * @return Result of the ListBackupSelections operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupSelections
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupSelections" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBackupSelectionsResponse listBackupSelections(
            Consumer<ListBackupSelectionsRequest.Builder> listBackupSelectionsRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        return listBackupSelections(ListBackupSelectionsRequest.builder().applyMutation(listBackupSelectionsRequest).build());
    }

    /**
     * <p>
     * Returns an array containing metadata of the resources associated with the target backup plan.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBackupSelections(software.amazon.awssdk.services.backup.model.ListBackupSelectionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupSelectionsIterable responses = client.listBackupSelectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupSelectionsIterable responses = client
     *             .listBackupSelectionsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupSelectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupSelectionsIterable responses = client.listBackupSelectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupSelections(software.amazon.awssdk.services.backup.model.ListBackupSelectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBackupSelectionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupSelections
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupSelections" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBackupSelectionsIterable listBackupSelectionsPaginator(ListBackupSelectionsRequest listBackupSelectionsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array containing metadata of the resources associated with the target backup plan.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBackupSelections(software.amazon.awssdk.services.backup.model.ListBackupSelectionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupSelectionsIterable responses = client.listBackupSelectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupSelectionsIterable responses = client
     *             .listBackupSelectionsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupSelectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupSelectionsIterable responses = client.listBackupSelectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupSelections(software.amazon.awssdk.services.backup.model.ListBackupSelectionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupSelectionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBackupSelectionsRequest#builder()}
     * </p>
     *
     * @param listBackupSelectionsRequest
     *        A {@link Consumer} that will call methods on {@link ListBackupSelectionsInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupSelections
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupSelections" target="_top">AWS
     *      API Documentation</a>
     */
    default ListBackupSelectionsIterable listBackupSelectionsPaginator(
            Consumer<ListBackupSelectionsRequest.Builder> listBackupSelectionsRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        return listBackupSelectionsPaginator(ListBackupSelectionsRequest.builder().applyMutation(listBackupSelectionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of recovery point storage containers along with information about them.
     * </p>
     *
     * @return Result of the ListBackupVaults operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupVaults
     * @see #listBackupVaults(ListBackupVaultsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupVaults" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupVaultsResponse listBackupVaults() throws ResourceNotFoundException, InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listBackupVaults(ListBackupVaultsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of recovery point storage containers along with information about them.
     * </p>
     *
     * @param listBackupVaultsRequest
     * @return Result of the ListBackupVaults operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupVaults
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupVaults" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupVaultsResponse listBackupVaults(ListBackupVaultsRequest listBackupVaultsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of recovery point storage containers along with information about them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupVaultsRequest.Builder} avoiding the need
     * to create one manually via {@link ListBackupVaultsRequest#builder()}
     * </p>
     *
     * @param listBackupVaultsRequest
     *        A {@link Consumer} that will call methods on {@link ListBackupVaultsInput.Builder} to create a request.
     * @return Result of the ListBackupVaults operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupVaults
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupVaults" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupVaultsResponse listBackupVaults(Consumer<ListBackupVaultsRequest.Builder> listBackupVaultsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listBackupVaults(ListBackupVaultsRequest.builder().applyMutation(listBackupVaultsRequest).build());
    }

    /**
     * <p>
     * Returns a list of recovery point storage containers along with information about them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBackupVaults(software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupVaultsIterable responses = client.listBackupVaultsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupVaultsIterable responses = client
     *             .listBackupVaultsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupVaultsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupVaultsIterable responses = client.listBackupVaultsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupVaults(software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupVaults
     * @see #listBackupVaultsPaginator(ListBackupVaultsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupVaults" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupVaultsIterable listBackupVaultsPaginator() throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        return listBackupVaultsPaginator(ListBackupVaultsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of recovery point storage containers along with information about them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBackupVaults(software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupVaultsIterable responses = client.listBackupVaultsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupVaultsIterable responses = client
     *             .listBackupVaultsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupVaultsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupVaultsIterable responses = client.listBackupVaultsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupVaults(software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest)} operation.</b>
     * </p>
     *
     * @param listBackupVaultsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupVaults
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupVaults" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupVaultsIterable listBackupVaultsPaginator(ListBackupVaultsRequest listBackupVaultsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of recovery point storage containers along with information about them.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBackupVaults(software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupVaultsIterable responses = client.listBackupVaultsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListBackupVaultsIterable responses = client
     *             .listBackupVaultsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListBackupVaultsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListBackupVaultsIterable responses = client.listBackupVaultsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackupVaults(software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackupVaultsRequest.Builder} avoiding the need
     * to create one manually via {@link ListBackupVaultsRequest#builder()}
     * </p>
     *
     * @param listBackupVaultsRequest
     *        A {@link Consumer} that will call methods on {@link ListBackupVaultsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListBackupVaults
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupVaults" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBackupVaultsIterable listBackupVaultsPaginator(Consumer<ListBackupVaultsRequest.Builder> listBackupVaultsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listBackupVaultsPaginator(ListBackupVaultsRequest.builder().applyMutation(listBackupVaultsRequest).build());
    }

    /**
     * <p>
     * Returns an array of resources successfully backed up by AWS Backup, including the time the resource was saved, an
     * Amazon Resource Name (ARN) of the resource, and a resource type.
     * </p>
     *
     * @return Result of the ListProtectedResources operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListProtectedResources
     * @see #listProtectedResources(ListProtectedResourcesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProtectedResourcesResponse listProtectedResources() throws InvalidParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listProtectedResources(ListProtectedResourcesRequest.builder().build());
    }

    /**
     * <p>
     * Returns an array of resources successfully backed up by AWS Backup, including the time the resource was saved, an
     * Amazon Resource Name (ARN) of the resource, and a resource type.
     * </p>
     *
     * @param listProtectedResourcesRequest
     * @return Result of the ListProtectedResources operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListProtectedResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProtectedResourcesResponse listProtectedResources(ListProtectedResourcesRequest listProtectedResourcesRequest)
            throws InvalidParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of resources successfully backed up by AWS Backup, including the time the resource was saved, an
     * Amazon Resource Name (ARN) of the resource, and a resource type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProtectedResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListProtectedResourcesRequest#builder()}
     * </p>
     *
     * @param listProtectedResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListProtectedResourcesInput.Builder} to create a
     *        request.
     * @return Result of the ListProtectedResources operation returned by the service.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListProtectedResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProtectedResourcesResponse listProtectedResources(
            Consumer<ListProtectedResourcesRequest.Builder> listProtectedResourcesRequest) throws InvalidParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listProtectedResources(ListProtectedResourcesRequest.builder().applyMutation(listProtectedResourcesRequest)
                .build());
    }

    /**
     * <p>
     * Returns an array of resources successfully backed up by AWS Backup, including the time the resource was saved, an
     * Amazon Resource Name (ARN) of the resource, and a resource type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProtectedResources(software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesIterable responses = client.listProtectedResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesIterable responses = client
     *             .listProtectedResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListProtectedResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesIterable responses = client.listProtectedResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProtectedResources(software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListProtectedResources
     * @see #listProtectedResourcesPaginator(ListProtectedResourcesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProtectedResourcesIterable listProtectedResourcesPaginator() throws InvalidParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listProtectedResourcesPaginator(ListProtectedResourcesRequest.builder().build());
    }

    /**
     * <p>
     * Returns an array of resources successfully backed up by AWS Backup, including the time the resource was saved, an
     * Amazon Resource Name (ARN) of the resource, and a resource type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProtectedResources(software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesIterable responses = client.listProtectedResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesIterable responses = client
     *             .listProtectedResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListProtectedResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesIterable responses = client.listProtectedResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProtectedResources(software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProtectedResourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListProtectedResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProtectedResourcesIterable listProtectedResourcesPaginator(
            ListProtectedResourcesRequest listProtectedResourcesRequest) throws InvalidParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of resources successfully backed up by AWS Backup, including the time the resource was saved, an
     * Amazon Resource Name (ARN) of the resource, and a resource type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProtectedResources(software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesIterable responses = client.listProtectedResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesIterable responses = client
     *             .listProtectedResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListProtectedResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListProtectedResourcesIterable responses = client.listProtectedResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProtectedResources(software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProtectedResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListProtectedResourcesRequest#builder()}
     * </p>
     *
     * @param listProtectedResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListProtectedResourcesInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListProtectedResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResources" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProtectedResourcesIterable listProtectedResourcesPaginator(
            Consumer<ListProtectedResourcesRequest.Builder> listProtectedResourcesRequest) throws InvalidParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listProtectedResourcesPaginator(ListProtectedResourcesRequest.builder()
                .applyMutation(listProtectedResourcesRequest).build());
    }

    /**
     * <p>
     * Returns detailed information about the recovery points stored in a backup vault.
     * </p>
     *
     * @param listRecoveryPointsByBackupVaultRequest
     * @return Result of the ListRecoveryPointsByBackupVault operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRecoveryPointsByBackupVault
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByBackupVault"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsByBackupVaultResponse listRecoveryPointsByBackupVault(
            ListRecoveryPointsByBackupVaultRequest listRecoveryPointsByBackupVaultRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed information about the recovery points stored in a backup vault.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecoveryPointsByBackupVaultRequest.Builder}
     * avoiding the need to create one manually via {@link ListRecoveryPointsByBackupVaultRequest#builder()}
     * </p>
     *
     * @param listRecoveryPointsByBackupVaultRequest
     *        A {@link Consumer} that will call methods on {@link ListRecoveryPointsByBackupVaultInput.Builder} to
     *        create a request.
     * @return Result of the ListRecoveryPointsByBackupVault operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRecoveryPointsByBackupVault
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByBackupVault"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsByBackupVaultResponse listRecoveryPointsByBackupVault(
            Consumer<ListRecoveryPointsByBackupVaultRequest.Builder> listRecoveryPointsByBackupVaultRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listRecoveryPointsByBackupVault(ListRecoveryPointsByBackupVaultRequest.builder()
                .applyMutation(listRecoveryPointsByBackupVaultRequest).build());
    }

    /**
     * <p>
     * Returns detailed information about the recovery points stored in a backup vault.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRecoveryPointsByBackupVault(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByBackupVaultIterable responses = client.listRecoveryPointsByBackupVaultPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByBackupVaultIterable responses = client
     *             .listRecoveryPointsByBackupVaultPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByBackupVaultIterable responses = client.listRecoveryPointsByBackupVaultPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecoveryPointsByBackupVault(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRecoveryPointsByBackupVaultRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRecoveryPointsByBackupVault
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByBackupVault"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsByBackupVaultIterable listRecoveryPointsByBackupVaultPaginator(
            ListRecoveryPointsByBackupVaultRequest listRecoveryPointsByBackupVaultRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed information about the recovery points stored in a backup vault.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRecoveryPointsByBackupVault(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByBackupVaultIterable responses = client.listRecoveryPointsByBackupVaultPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByBackupVaultIterable responses = client
     *             .listRecoveryPointsByBackupVaultPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByBackupVaultIterable responses = client.listRecoveryPointsByBackupVaultPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecoveryPointsByBackupVault(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecoveryPointsByBackupVaultRequest.Builder}
     * avoiding the need to create one manually via {@link ListRecoveryPointsByBackupVaultRequest#builder()}
     * </p>
     *
     * @param listRecoveryPointsByBackupVaultRequest
     *        A {@link Consumer} that will call methods on {@link ListRecoveryPointsByBackupVaultInput.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRecoveryPointsByBackupVault
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByBackupVault"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsByBackupVaultIterable listRecoveryPointsByBackupVaultPaginator(
            Consumer<ListRecoveryPointsByBackupVaultRequest.Builder> listRecoveryPointsByBackupVaultRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listRecoveryPointsByBackupVaultPaginator(ListRecoveryPointsByBackupVaultRequest.builder()
                .applyMutation(listRecoveryPointsByBackupVaultRequest).build());
    }

    /**
     * <p>
     * Returns detailed information about recovery points of the type specified by a resource Amazon Resource Name
     * (ARN).
     * </p>
     *
     * @param listRecoveryPointsByResourceRequest
     * @return Result of the ListRecoveryPointsByResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRecoveryPointsByResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsByResourceResponse listRecoveryPointsByResource(
            ListRecoveryPointsByResourceRequest listRecoveryPointsByResourceRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed information about recovery points of the type specified by a resource Amazon Resource Name
     * (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecoveryPointsByResourceRequest.Builder}
     * avoiding the need to create one manually via {@link ListRecoveryPointsByResourceRequest#builder()}
     * </p>
     *
     * @param listRecoveryPointsByResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListRecoveryPointsByResourceInput.Builder} to create a
     *        request.
     * @return Result of the ListRecoveryPointsByResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRecoveryPointsByResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsByResourceResponse listRecoveryPointsByResource(
            Consumer<ListRecoveryPointsByResourceRequest.Builder> listRecoveryPointsByResourceRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listRecoveryPointsByResource(ListRecoveryPointsByResourceRequest.builder()
                .applyMutation(listRecoveryPointsByResourceRequest).build());
    }

    /**
     * <p>
     * Returns detailed information about recovery points of the type specified by a resource Amazon Resource Name
     * (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRecoveryPointsByResource(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByResourceIterable responses = client.listRecoveryPointsByResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByResourceIterable responses = client
     *             .listRecoveryPointsByResourcePaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByResourceIterable responses = client.listRecoveryPointsByResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecoveryPointsByResource(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRecoveryPointsByResourceRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRecoveryPointsByResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsByResourceIterable listRecoveryPointsByResourcePaginator(
            ListRecoveryPointsByResourceRequest listRecoveryPointsByResourceRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed information about recovery points of the type specified by a resource Amazon Resource Name
     * (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRecoveryPointsByResource(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByResourceIterable responses = client.listRecoveryPointsByResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByResourceIterable responses = client
     *             .listRecoveryPointsByResourcePaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRecoveryPointsByResourceIterable responses = client.listRecoveryPointsByResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecoveryPointsByResource(software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecoveryPointsByResourceRequest.Builder}
     * avoiding the need to create one manually via {@link ListRecoveryPointsByResourceRequest#builder()}
     * </p>
     *
     * @param listRecoveryPointsByResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListRecoveryPointsByResourceInput.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRecoveryPointsByResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecoveryPointsByResourceIterable listRecoveryPointsByResourcePaginator(
            Consumer<ListRecoveryPointsByResourceRequest.Builder> listRecoveryPointsByResourceRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listRecoveryPointsByResourcePaginator(ListRecoveryPointsByResourceRequest.builder()
                .applyMutation(listRecoveryPointsByResourceRequest).build());
    }

    /**
     * <p>
     * Returns a list of jobs that AWS Backup initiated to restore a saved resource, including metadata about the
     * recovery process.
     * </p>
     *
     * @return Result of the ListRestoreJobs operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRestoreJobs
     * @see #listRestoreJobs(ListRestoreJobsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRestoreJobsResponse listRestoreJobs() throws ResourceNotFoundException, InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listRestoreJobs(ListRestoreJobsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of jobs that AWS Backup initiated to restore a saved resource, including metadata about the
     * recovery process.
     * </p>
     *
     * @param listRestoreJobsRequest
     * @return Result of the ListRestoreJobs operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRestoreJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRestoreJobsResponse listRestoreJobs(ListRestoreJobsRequest listRestoreJobsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of jobs that AWS Backup initiated to restore a saved resource, including metadata about the
     * recovery process.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRestoreJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListRestoreJobsRequest#builder()}
     * </p>
     *
     * @param listRestoreJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListRestoreJobsInput.Builder} to create a request.
     * @return Result of the ListRestoreJobs operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRestoreJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRestoreJobsResponse listRestoreJobs(Consumer<ListRestoreJobsRequest.Builder> listRestoreJobsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listRestoreJobs(ListRestoreJobsRequest.builder().applyMutation(listRestoreJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of jobs that AWS Backup initiated to restore a saved resource, including metadata about the
     * recovery process.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRestoreJobs(software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreJobsIterable responses = client.listRestoreJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListRestoreJobsIterable responses = client
     *             .listRestoreJobsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListRestoreJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreJobsIterable responses = client.listRestoreJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRestoreJobs(software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRestoreJobs
     * @see #listRestoreJobsPaginator(ListRestoreJobsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRestoreJobsIterable listRestoreJobsPaginator() throws ResourceNotFoundException, InvalidParameterValueException,
            MissingParameterValueException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listRestoreJobsPaginator(ListRestoreJobsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of jobs that AWS Backup initiated to restore a saved resource, including metadata about the
     * recovery process.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRestoreJobs(software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreJobsIterable responses = client.listRestoreJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListRestoreJobsIterable responses = client
     *             .listRestoreJobsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListRestoreJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreJobsIterable responses = client.listRestoreJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRestoreJobs(software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest)} operation.</b>
     * </p>
     *
     * @param listRestoreJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRestoreJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRestoreJobsIterable listRestoreJobsPaginator(ListRestoreJobsRequest listRestoreJobsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of jobs that AWS Backup initiated to restore a saved resource, including metadata about the
     * recovery process.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRestoreJobs(software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreJobsIterable responses = client.listRestoreJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListRestoreJobsIterable responses = client
     *             .listRestoreJobsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListRestoreJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListRestoreJobsIterable responses = client.listRestoreJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRestoreJobs(software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRestoreJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListRestoreJobsRequest#builder()}
     * </p>
     *
     * @param listRestoreJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListRestoreJobsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListRestoreJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRestoreJobsIterable listRestoreJobsPaginator(Consumer<ListRestoreJobsRequest.Builder> listRestoreJobsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listRestoreJobsPaginator(ListRestoreJobsRequest.builder().applyMutation(listRestoreJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of key-value pairs assigned to a target recovery point, backup plan, or backup vault.
     * </p>
     *
     * @param listTagsRequest
     * @return Result of the ListTags operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of key-value pairs assigned to a target recovery point, backup plan, or backup vault.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagsRequest#builder()}
     * </p>
     *
     * @param listTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsInput.Builder} to create a request.
     * @return Result of the ListTags operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsResponse listTags(Consumer<ListTagsRequest.Builder> listTagsRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        return listTags(ListTagsRequest.builder().applyMutation(listTagsRequest).build());
    }

    /**
     * <p>
     * Returns a list of key-value pairs assigned to a target recovery point, backup plan, or backup vault.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTags(software.amazon.awssdk.services.backup.model.ListTagsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListTagsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTags(software.amazon.awssdk.services.backup.model.ListTagsRequest)} operation.</b>
     * </p>
     *
     * @param listTagsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsIterable listTagsPaginator(ListTagsRequest listTagsRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of key-value pairs assigned to a target recovery point, backup plan, or backup vault.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listTags(software.amazon.awssdk.services.backup.model.ListTagsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.backup.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     *     for (software.amazon.awssdk.services.backup.model.ListTagsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backup.paginators.ListTagsIterable responses = client.listTagsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTags(software.amazon.awssdk.services.backup.model.ListTagsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagsRequest#builder()}
     * </p>
     *
     * @param listTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsIterable listTagsPaginator(Consumer<ListTagsRequest.Builder> listTagsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return listTagsPaginator(ListTagsRequest.builder().applyMutation(listTagsRequest).build());
    }

    /**
     * <p>
     * Sets a resource-based policy that is used to manage access permissions on the target backup vault. Requires a
     * backup vault name and an access policy document in JSON format.
     * </p>
     *
     * @param putBackupVaultAccessPolicyRequest
     * @return Result of the PutBackupVaultAccessPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.PutBackupVaultAccessPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutBackupVaultAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutBackupVaultAccessPolicyResponse putBackupVaultAccessPolicy(
            PutBackupVaultAccessPolicyRequest putBackupVaultAccessPolicyRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets a resource-based policy that is used to manage access permissions on the target backup vault. Requires a
     * backup vault name and an access policy document in JSON format.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutBackupVaultAccessPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link PutBackupVaultAccessPolicyRequest#builder()}
     * </p>
     *
     * @param putBackupVaultAccessPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutBackupVaultAccessPolicyInput.Builder} to create a
     *        request.
     * @return Result of the PutBackupVaultAccessPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.PutBackupVaultAccessPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutBackupVaultAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutBackupVaultAccessPolicyResponse putBackupVaultAccessPolicy(
            Consumer<PutBackupVaultAccessPolicyRequest.Builder> putBackupVaultAccessPolicyRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return putBackupVaultAccessPolicy(PutBackupVaultAccessPolicyRequest.builder()
                .applyMutation(putBackupVaultAccessPolicyRequest).build());
    }

    /**
     * <p>
     * Turns on notifications on a backup vault for the specified topic and events.
     * </p>
     *
     * @param putBackupVaultNotificationsRequest
     * @return Result of the PutBackupVaultNotifications operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.PutBackupVaultNotifications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutBackupVaultNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default PutBackupVaultNotificationsResponse putBackupVaultNotifications(
            PutBackupVaultNotificationsRequest putBackupVaultNotificationsRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Turns on notifications on a backup vault for the specified topic and events.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutBackupVaultNotificationsRequest.Builder}
     * avoiding the need to create one manually via {@link PutBackupVaultNotificationsRequest#builder()}
     * </p>
     *
     * @param putBackupVaultNotificationsRequest
     *        A {@link Consumer} that will call methods on {@link PutBackupVaultNotificationsInput.Builder} to create a
     *        request.
     * @return Result of the PutBackupVaultNotifications operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.PutBackupVaultNotifications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutBackupVaultNotifications"
     *      target="_top">AWS API Documentation</a>
     */
    default PutBackupVaultNotificationsResponse putBackupVaultNotifications(
            Consumer<PutBackupVaultNotificationsRequest.Builder> putBackupVaultNotificationsRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return putBackupVaultNotifications(PutBackupVaultNotificationsRequest.builder()
                .applyMutation(putBackupVaultNotificationsRequest).build());
    }

    /**
     * <p>
     * Starts a job to create a one-time backup of the specified resource.
     * </p>
     *
     * @param startBackupJobRequest
     * @return Result of the StartBackupJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.StartBackupJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartBackupJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StartBackupJobResponse startBackupJob(StartBackupJobRequest startBackupJobRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, LimitExceededException,
            AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a job to create a one-time backup of the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartBackupJobRequest.Builder} avoiding the need to
     * create one manually via {@link StartBackupJobRequest#builder()}
     * </p>
     *
     * @param startBackupJobRequest
     *        A {@link Consumer} that will call methods on {@link StartBackupJobInput.Builder} to create a request.
     * @return Result of the StartBackupJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.StartBackupJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartBackupJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StartBackupJobResponse startBackupJob(Consumer<StartBackupJobRequest.Builder> startBackupJobRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, LimitExceededException, AwsServiceException, SdkClientException, BackupException {
        return startBackupJob(StartBackupJobRequest.builder().applyMutation(startBackupJobRequest).build());
    }

    /**
     * <p>
     * Recovers the saved resource identified by an Amazon Resource Name (ARN).
     * </p>
     * <p>
     * If the resource ARN is included in the request, then the last complete backup of that resource is recovered. If
     * the ARN of a recovery point is supplied, then that recovery point is restored.
     * </p>
     *
     * @param startRestoreJobRequest
     * @return Result of the StartRestoreJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.StartRestoreJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartRestoreJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StartRestoreJobResponse startRestoreJob(StartRestoreJobRequest startRestoreJobRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Recovers the saved resource identified by an Amazon Resource Name (ARN).
     * </p>
     * <p>
     * If the resource ARN is included in the request, then the last complete backup of that resource is recovered. If
     * the ARN of a recovery point is supplied, then that recovery point is restored.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartRestoreJobRequest.Builder} avoiding the need
     * to create one manually via {@link StartRestoreJobRequest#builder()}
     * </p>
     *
     * @param startRestoreJobRequest
     *        A {@link Consumer} that will call methods on {@link StartRestoreJobInput.Builder} to create a request.
     * @return Result of the StartRestoreJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.StartRestoreJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartRestoreJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StartRestoreJobResponse startRestoreJob(Consumer<StartRestoreJobRequest.Builder> startRestoreJobRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return startRestoreJob(StartRestoreJobRequest.builder().applyMutation(startRestoreJobRequest).build());
    }

    /**
     * <p>
     * Attempts to cancel a job to create a one-time backup of a resource.
     * </p>
     *
     * @param stopBackupJobRequest
     * @return Result of the StopBackupJob operation returned by the service.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.StopBackupJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StopBackupJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StopBackupJobResponse stopBackupJob(StopBackupJobRequest stopBackupJobRequest) throws MissingParameterValueException,
            ResourceNotFoundException, InvalidParameterValueException, InvalidRequestException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attempts to cancel a job to create a one-time backup of a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopBackupJobRequest.Builder} avoiding the need to
     * create one manually via {@link StopBackupJobRequest#builder()}
     * </p>
     *
     * @param stopBackupJobRequest
     *        A {@link Consumer} that will call methods on {@link StopBackupJobInput.Builder} to create a request.
     * @return Result of the StopBackupJob operation returned by the service.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws InvalidRequestException
     *         Indicates that something is wrong with the input to the request. For example, a parameter is of the wrong
     *         type.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.StopBackupJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StopBackupJob" target="_top">AWS API
     *      Documentation</a>
     */
    default StopBackupJobResponse stopBackupJob(Consumer<StopBackupJobRequest.Builder> stopBackupJobRequest)
            throws MissingParameterValueException, ResourceNotFoundException, InvalidParameterValueException,
            InvalidRequestException, ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return stopBackupJob(StopBackupJobRequest.builder().applyMutation(stopBackupJobRequest).build());
    }

    /**
     * <p>
     * Assigns a set of key-value pairs to a recovery point, backup plan, or backup vault identified by an Amazon
     * Resource Name (ARN).
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, LimitExceededException,
            AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns a set of key-value pairs to a recovery point, backup plan, or backup vault identified by an Amazon
     * Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceInput.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws LimitExceededException
     *         A limit in the request has been exceeded; for example, a maximum number of items allowed in a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, LimitExceededException, AwsServiceException, SdkClientException, BackupException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a set of key-value pairs from a recovery point, backup plan, or backup vault identified by an Amazon
     * Resource Name (ARN)
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a set of key-value pairs from a recovery point, backup plan, or backup vault identified by an Amazon
     * Resource Name (ARN)
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceInput.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Replaces the body of a saved backup plan identified by its <code>backupPlanId</code> with the input document in
     * JSON format. The new version is uniquely identified by a <code>VersionId</code>.
     * </p>
     *
     * @param updateBackupPlanRequest
     * @return Result of the UpdateBackupPlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.UpdateBackupPlan
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateBackupPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateBackupPlanResponse updateBackupPlan(UpdateBackupPlanRequest updateBackupPlanRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Replaces the body of a saved backup plan identified by its <code>backupPlanId</code> with the input document in
     * JSON format. The new version is uniquely identified by a <code>VersionId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBackupPlanRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateBackupPlanRequest#builder()}
     * </p>
     *
     * @param updateBackupPlanRequest
     *        A {@link Consumer} that will call methods on {@link UpdateBackupPlanInput.Builder} to create a request.
     * @return Result of the UpdateBackupPlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.UpdateBackupPlan
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateBackupPlan" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateBackupPlanResponse updateBackupPlan(Consumer<UpdateBackupPlanRequest.Builder> updateBackupPlanRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return updateBackupPlan(UpdateBackupPlanRequest.builder().applyMutation(updateBackupPlanRequest).build());
    }

    /**
     * <p>
     * Sets the transition lifecycle of a recovery point.
     * </p>
     * <p>
     * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. AWS Backup
     * transitions and expires backups automatically according to the lifecycle that you define.
     * </p>
     * <p>
     * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the
     * “expire after days” setting must be 90 days greater than the “transition to cold after days” setting. The
     * “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
     * </p>
     *
     * @param updateRecoveryPointLifecycleRequest
     * @return Result of the UpdateRecoveryPointLifecycle operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.UpdateRecoveryPointLifecycle
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateRecoveryPointLifecycle"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRecoveryPointLifecycleResponse updateRecoveryPointLifecycle(
            UpdateRecoveryPointLifecycleRequest updateRecoveryPointLifecycleRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, MissingParameterValueException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, BackupException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the transition lifecycle of a recovery point.
     * </p>
     * <p>
     * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. AWS Backup
     * transitions and expires backups automatically according to the lifecycle that you define.
     * </p>
     * <p>
     * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the
     * “expire after days” setting must be 90 days greater than the “transition to cold after days” setting. The
     * “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRecoveryPointLifecycleRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateRecoveryPointLifecycleRequest#builder()}
     * </p>
     *
     * @param updateRecoveryPointLifecycleRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRecoveryPointLifecycleInput.Builder} to create a
     *        request.
     * @return Result of the UpdateRecoveryPointLifecycle operation returned by the service.
     * @throws ResourceNotFoundException
     *         A resource that is required for the action doesn't exist.
     * @throws InvalidParameterValueException
     *         Indicates that something is wrong with a parameter's value. For example, the value is out of range.
     * @throws MissingParameterValueException
     *         Indicates that a required parameter is missing.
     * @throws ServiceUnavailableException
     *         The request failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BackupException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BackupClient.UpdateRecoveryPointLifecycle
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateRecoveryPointLifecycle"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRecoveryPointLifecycleResponse updateRecoveryPointLifecycle(
            Consumer<UpdateRecoveryPointLifecycleRequest.Builder> updateRecoveryPointLifecycleRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, MissingParameterValueException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, BackupException {
        return updateRecoveryPointLifecycle(UpdateRecoveryPointLifecycleRequest.builder()
                .applyMutation(updateRecoveryPointLifecycleRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("backup");
    }
}
