/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBackupPlanFromJsonRequest extends BackupRequest implements
        ToCopyableBuilder<GetBackupPlanFromJsonRequest.Builder, GetBackupPlanFromJsonRequest> {
    private static final SdkField<String> BACKUP_PLAN_TEMPLATE_JSON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetBackupPlanFromJsonRequest::backupPlanTemplateJson)).setter(setter(Builder::backupPlanTemplateJson))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanTemplateJson").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(BACKUP_PLAN_TEMPLATE_JSON_FIELD));

    private final String backupPlanTemplateJson;

    private GetBackupPlanFromJsonRequest(BuilderImpl builder) {
        super(builder);
        this.backupPlanTemplateJson = builder.backupPlanTemplateJson;
    }

    /**
     * <p>
     * A customer-supplied backup plan document in JSON format.
     * </p>
     * 
     * @return A customer-supplied backup plan document in JSON format.
     */
    public String backupPlanTemplateJson() {
        return backupPlanTemplateJson;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanTemplateJson());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBackupPlanFromJsonRequest)) {
            return false;
        }
        GetBackupPlanFromJsonRequest other = (GetBackupPlanFromJsonRequest) obj;
        return Objects.equals(backupPlanTemplateJson(), other.backupPlanTemplateJson());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetBackupPlanFromJsonRequest").add("BackupPlanTemplateJson", backupPlanTemplateJson()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupPlanTemplateJson":
            return Optional.ofNullable(clazz.cast(backupPlanTemplateJson()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBackupPlanFromJsonRequest, T> g) {
        return obj -> g.apply((GetBackupPlanFromJsonRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetBackupPlanFromJsonRequest> {
        /**
         * <p>
         * A customer-supplied backup plan document in JSON format.
         * </p>
         * 
         * @param backupPlanTemplateJson
         *        A customer-supplied backup plan document in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanTemplateJson(String backupPlanTemplateJson);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String backupPlanTemplateJson;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBackupPlanFromJsonRequest model) {
            super(model);
            backupPlanTemplateJson(model.backupPlanTemplateJson);
        }

        public final String getBackupPlanTemplateJson() {
            return backupPlanTemplateJson;
        }

        @Override
        public final Builder backupPlanTemplateJson(String backupPlanTemplateJson) {
            this.backupPlanTemplateJson = backupPlanTemplateJson;
            return this;
        }

        public final void setBackupPlanTemplateJson(String backupPlanTemplateJson) {
            this.backupPlanTemplateJson = backupPlanTemplateJson;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBackupPlanFromJsonRequest build() {
            return new GetBackupPlanFromJsonRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
