/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRecoveryPointsByBackupVaultResponse extends BackupResponse implements
        ToCopyableBuilder<ListRecoveryPointsByBackupVaultResponse.Builder, ListRecoveryPointsByBackupVaultResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListRecoveryPointsByBackupVaultResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<RecoveryPointByBackupVault>> RECOVERY_POINTS_FIELD = SdkField
            .<List<RecoveryPointByBackupVault>> builder(MarshallingType.LIST)
            .getter(getter(ListRecoveryPointsByBackupVaultResponse::recoveryPoints))
            .setter(setter(Builder::recoveryPoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecoveryPointByBackupVault> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecoveryPointByBackupVault::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            RECOVERY_POINTS_FIELD));

    private final String nextToken;

    private final List<RecoveryPointByBackupVault> recoveryPoints;

    private ListRecoveryPointsByBackupVaultResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.recoveryPoints = builder.recoveryPoints;
    }

    /**
     * <p>
     * The next item following a partial list of returned items. For example, if a request is made to return
     * <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
     * starting at the location pointed to by the next token.
     * </p>
     * 
     * @return The next item following a partial list of returned items. For example, if a request is made to return
     *         <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your
     *         list starting at the location pointed to by the next token.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * An array of objects that contain detailed information about recovery points saved in a backup vault.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of objects that contain detailed information about recovery points saved in a backup vault.
     */
    public List<RecoveryPointByBackupVault> recoveryPoints() {
        return recoveryPoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryPoints());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecoveryPointsByBackupVaultResponse)) {
            return false;
        }
        ListRecoveryPointsByBackupVaultResponse other = (ListRecoveryPointsByBackupVaultResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(recoveryPoints(), other.recoveryPoints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListRecoveryPointsByBackupVaultResponse").add("NextToken", nextToken())
                .add("RecoveryPoints", recoveryPoints()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "RecoveryPoints":
            return Optional.ofNullable(clazz.cast(recoveryPoints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRecoveryPointsByBackupVaultResponse, T> g) {
        return obj -> g.apply((ListRecoveryPointsByBackupVaultResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRecoveryPointsByBackupVaultResponse> {
        /**
         * <p>
         * The next item following a partial list of returned items. For example, if a request is made to return
         * <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
         * starting at the location pointed to by the next token.
         * </p>
         * 
         * @param nextToken
         *        The next item following a partial list of returned items. For example, if a request is made to return
         *        <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in
         *        your list starting at the location pointed to by the next token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of objects that contain detailed information about recovery points saved in a backup vault.
         * </p>
         * 
         * @param recoveryPoints
         *        An array of objects that contain detailed information about recovery points saved in a backup vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPoints(Collection<RecoveryPointByBackupVault> recoveryPoints);

        /**
         * <p>
         * An array of objects that contain detailed information about recovery points saved in a backup vault.
         * </p>
         * 
         * @param recoveryPoints
         *        An array of objects that contain detailed information about recovery points saved in a backup vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPoints(RecoveryPointByBackupVault... recoveryPoints);

        /**
         * <p>
         * An array of objects that contain detailed information about recovery points saved in a backup vault.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RecoveryPointByBackupVault>.Builder}
         * avoiding the need to create one manually via {@link List<RecoveryPointByBackupVault>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RecoveryPointByBackupVault>.Builder#build()} is called
         * immediately and its result is passed to {@link #recoveryPoints(List<RecoveryPointByBackupVault>)}.
         * 
         * @param recoveryPoints
         *        a consumer that will call methods on {@link List<RecoveryPointByBackupVault>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recoveryPoints(List<RecoveryPointByBackupVault>)
         */
        Builder recoveryPoints(Consumer<RecoveryPointByBackupVault.Builder>... recoveryPoints);
    }

    static final class BuilderImpl extends BackupResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<RecoveryPointByBackupVault> recoveryPoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecoveryPointsByBackupVaultResponse model) {
            super(model);
            nextToken(model.nextToken);
            recoveryPoints(model.recoveryPoints);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<RecoveryPointByBackupVault.Builder> getRecoveryPoints() {
            return recoveryPoints != null ? recoveryPoints.stream().map(RecoveryPointByBackupVault::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recoveryPoints(Collection<RecoveryPointByBackupVault> recoveryPoints) {
            this.recoveryPoints = RecoveryPointByBackupVaultListCopier.copy(recoveryPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recoveryPoints(RecoveryPointByBackupVault... recoveryPoints) {
            recoveryPoints(Arrays.asList(recoveryPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recoveryPoints(Consumer<RecoveryPointByBackupVault.Builder>... recoveryPoints) {
            recoveryPoints(Stream.of(recoveryPoints).map(c -> RecoveryPointByBackupVault.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRecoveryPoints(Collection<RecoveryPointByBackupVault.BuilderImpl> recoveryPoints) {
            this.recoveryPoints = RecoveryPointByBackupVaultListCopier.copyFromBuilder(recoveryPoints);
        }

        @Override
        public ListRecoveryPointsByBackupVaultResponse build() {
            return new ListRecoveryPointsByBackupVaultResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
