/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains metadata about a <code>BackupSelection</code> object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BackupSelectionsListMember implements SdkPojo, Serializable,
        ToCopyableBuilder<BackupSelectionsListMember.Builder, BackupSelectionsListMember> {
    private static final SdkField<String> SELECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BackupSelectionsListMember::selectionId)).setter(setter(Builder::selectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionId").build()).build();

    private static final SdkField<String> SELECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BackupSelectionsListMember::selectionName)).setter(setter(Builder::selectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionName").build()).build();

    private static final SdkField<String> BACKUP_PLAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BackupSelectionsListMember::backupPlanId)).setter(setter(Builder::backupPlanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanId").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(BackupSelectionsListMember::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BackupSelectionsListMember::creatorRequestId)).setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BackupSelectionsListMember::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTION_ID_FIELD,
            SELECTION_NAME_FIELD, BACKUP_PLAN_ID_FIELD, CREATION_DATE_FIELD, CREATOR_REQUEST_ID_FIELD, IAM_ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String selectionId;

    private final String selectionName;

    private final String backupPlanId;

    private final Instant creationDate;

    private final String creatorRequestId;

    private final String iamRoleArn;

    private BackupSelectionsListMember(BuilderImpl builder) {
        this.selectionId = builder.selectionId;
        this.selectionName = builder.selectionName;
        this.backupPlanId = builder.backupPlanId;
        this.creationDate = builder.creationDate;
        this.creatorRequestId = builder.creatorRequestId;
        this.iamRoleArn = builder.iamRoleArn;
    }

    /**
     * <p>
     * Uniquely identifies a request to assign a set of resources to a backup plan.
     * </p>
     * 
     * @return Uniquely identifies a request to assign a set of resources to a backup plan.
     */
    public String selectionId() {
        return selectionId;
    }

    /**
     * <p>
     * The display name of a resource selection document.
     * </p>
     * 
     * @return The display name of a resource selection document.
     */
    public String selectionName() {
        return selectionName;
    }

    /**
     * <p>
     * Uniquely identifies a backup plan.
     * </p>
     * 
     * @return Uniquely identifies a backup plan.
     */
    public String backupPlanId() {
        return backupPlanId;
    }

    /**
     * <p>
     * The date and time a backup plan is created, in Unix format and Coordinated Universal Time (UTC). The value of
     * <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday,
     * January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time a backup plan is created, in Unix format and Coordinated Universal Time (UTC). The
     *         value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087
     *         represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * A unique string that identifies the request and allows failed requests to be retried without the risk of
     * executing the operation twice.
     * </p>
     * 
     * @return A unique string that identifies the request and allows failed requests to be retried without the risk of
     *         executing the operation twice.
     */
    public String creatorRequestId() {
        return creatorRequestId;
    }

    /**
     * <p>
     * Specifies the IAM role Amazon Resource Name (ARN) to create the target recovery point; for example,
     * <code>arn:aws:iam::123456789012:role/S3Access</code>.
     * </p>
     * 
     * @return Specifies the IAM role Amazon Resource Name (ARN) to create the target recovery point; for example,
     *         <code>arn:aws:iam::123456789012:role/S3Access</code>.
     */
    public String iamRoleArn() {
        return iamRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(selectionId());
        hashCode = 31 * hashCode + Objects.hashCode(selectionName());
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupSelectionsListMember)) {
            return false;
        }
        BackupSelectionsListMember other = (BackupSelectionsListMember) obj;
        return Objects.equals(selectionId(), other.selectionId()) && Objects.equals(selectionName(), other.selectionName())
                && Objects.equals(backupPlanId(), other.backupPlanId()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(creatorRequestId(), other.creatorRequestId())
                && Objects.equals(iamRoleArn(), other.iamRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BackupSelectionsListMember").add("SelectionId", selectionId())
                .add("SelectionName", selectionName()).add("BackupPlanId", backupPlanId()).add("CreationDate", creationDate())
                .add("CreatorRequestId", creatorRequestId()).add("IamRoleArn", iamRoleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SelectionId":
            return Optional.ofNullable(clazz.cast(selectionId()));
        case "SelectionName":
            return Optional.ofNullable(clazz.cast(selectionName()));
        case "BackupPlanId":
            return Optional.ofNullable(clazz.cast(backupPlanId()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BackupSelectionsListMember, T> g) {
        return obj -> g.apply((BackupSelectionsListMember) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BackupSelectionsListMember> {
        /**
         * <p>
         * Uniquely identifies a request to assign a set of resources to a backup plan.
         * </p>
         * 
         * @param selectionId
         *        Uniquely identifies a request to assign a set of resources to a backup plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectionId(String selectionId);

        /**
         * <p>
         * The display name of a resource selection document.
         * </p>
         * 
         * @param selectionName
         *        The display name of a resource selection document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectionName(String selectionName);

        /**
         * <p>
         * Uniquely identifies a backup plan.
         * </p>
         * 
         * @param backupPlanId
         *        Uniquely identifies a backup plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanId(String backupPlanId);

        /**
         * <p>
         * The date and time a backup plan is created, in Unix format and Coordinated Universal Time (UTC). The value of
         * <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
         * Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param creationDate
         *        The date and time a backup plan is created, in Unix format and Coordinated Universal Time (UTC). The
         *        value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087
         *        represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * A unique string that identifies the request and allows failed requests to be retried without the risk of
         * executing the operation twice.
         * </p>
         * 
         * @param creatorRequestId
         *        A unique string that identifies the request and allows failed requests to be retried without the risk
         *        of executing the operation twice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        /**
         * <p>
         * Specifies the IAM role Amazon Resource Name (ARN) to create the target recovery point; for example,
         * <code>arn:aws:iam::123456789012:role/S3Access</code>.
         * </p>
         * 
         * @param iamRoleArn
         *        Specifies the IAM role Amazon Resource Name (ARN) to create the target recovery point; for example,
         *        <code>arn:aws:iam::123456789012:role/S3Access</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String selectionId;

        private String selectionName;

        private String backupPlanId;

        private Instant creationDate;

        private String creatorRequestId;

        private String iamRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(BackupSelectionsListMember model) {
            selectionId(model.selectionId);
            selectionName(model.selectionName);
            backupPlanId(model.backupPlanId);
            creationDate(model.creationDate);
            creatorRequestId(model.creatorRequestId);
            iamRoleArn(model.iamRoleArn);
        }

        public final String getSelectionId() {
            return selectionId;
        }

        @Override
        public final Builder selectionId(String selectionId) {
            this.selectionId = selectionId;
            return this;
        }

        public final void setSelectionId(String selectionId) {
            this.selectionId = selectionId;
        }

        public final String getSelectionName() {
            return selectionName;
        }

        @Override
        public final Builder selectionName(String selectionName) {
            this.selectionName = selectionName;
            return this;
        }

        public final void setSelectionName(String selectionName) {
            this.selectionName = selectionName;
        }

        public final String getBackupPlanId() {
            return backupPlanId;
        }

        @Override
        public final Builder backupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
            return this;
        }

        public final void setBackupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public BackupSelectionsListMember build() {
            return new BackupSelectionsListMember(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
