/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRecoveryPointsByBackupVaultRequest extends BackupRequest implements
        ToCopyableBuilder<ListRecoveryPointsByBackupVaultRequest.Builder, ListRecoveryPointsByBackupVaultRequest> {
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListRecoveryPointsByBackupVaultRequest::backupVaultName)).setter(setter(Builder::backupVaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("backupVaultName").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListRecoveryPointsByBackupVaultRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListRecoveryPointsByBackupVaultRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> BY_RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListRecoveryPointsByBackupVaultRequest::byResourceArn)).setter(setter(Builder::byResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceArn").build()).build();

    private static final SdkField<String> BY_RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListRecoveryPointsByBackupVaultRequest::byResourceType)).setter(setter(Builder::byResourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceType").build()).build();

    private static final SdkField<String> BY_BACKUP_PLAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListRecoveryPointsByBackupVaultRequest::byBackupPlanId)).setter(setter(Builder::byBackupPlanId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("backupPlanId").build()).build();

    private static final SdkField<Instant> BY_CREATED_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ListRecoveryPointsByBackupVaultRequest::byCreatedBefore)).setter(setter(Builder::byCreatedBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdBefore").build()).build();

    private static final SdkField<Instant> BY_CREATED_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ListRecoveryPointsByBackupVaultRequest::byCreatedAfter)).setter(setter(Builder::byCreatedAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdAfter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_NAME_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, BY_RESOURCE_ARN_FIELD, BY_RESOURCE_TYPE_FIELD, BY_BACKUP_PLAN_ID_FIELD,
            BY_CREATED_BEFORE_FIELD, BY_CREATED_AFTER_FIELD));

    private final String backupVaultName;

    private final String nextToken;

    private final Integer maxResults;

    private final String byResourceArn;

    private final String byResourceType;

    private final String byBackupPlanId;

    private final Instant byCreatedBefore;

    private final Instant byCreatedAfter;

    private ListRecoveryPointsByBackupVaultRequest(BuilderImpl builder) {
        super(builder);
        this.backupVaultName = builder.backupVaultName;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.byResourceArn = builder.byResourceArn;
        this.byResourceType = builder.byResourceType;
        this.byBackupPlanId = builder.byBackupPlanId;
        this.byCreatedBefore = builder.byCreatedBefore;
        this.byCreatedAfter = builder.byCreatedAfter;
    }

    /**
     * <p>
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique
     * to the account used to create them and the AWS Region where they are created. They consist of lowercase letters,
     * numbers, and hyphens.
     * </p>
     * 
     * @return The name of a logical container where backups are stored. Backup vaults are identified by names that are
     *         unique to the account used to create them and the AWS Region where they are created. They consist of
     *         lowercase letters, numbers, and hyphens.
     */
    public String backupVaultName() {
        return backupVaultName;
    }

    /**
     * <p>
     * The next item following a partial list of returned items. For example, if a request is made to return
     * <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
     * starting at the location pointed to by the next token.
     * </p>
     * 
     * @return The next item following a partial list of returned items. For example, if a request is made to return
     *         <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your
     *         list starting at the location pointed to by the next token.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to be returned.
     * </p>
     * 
     * @return The maximum number of items to be returned.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Returns only recovery points that match the specified resource Amazon Resource Name (ARN).
     * </p>
     * 
     * @return Returns only recovery points that match the specified resource Amazon Resource Name (ARN).
     */
    public String byResourceArn() {
        return byResourceArn;
    }

    /**
     * <p>
     * Returns only recovery points that match the specified resource type.
     * </p>
     * 
     * @return Returns only recovery points that match the specified resource type.
     */
    public String byResourceType() {
        return byResourceType;
    }

    /**
     * <p>
     * Returns only recovery points that match the specified backup plan ID.
     * </p>
     * 
     * @return Returns only recovery points that match the specified backup plan ID.
     */
    public String byBackupPlanId() {
        return byBackupPlanId;
    }

    /**
     * <p>
     * Returns only recovery points that were created before the specified timestamp.
     * </p>
     * 
     * @return Returns only recovery points that were created before the specified timestamp.
     */
    public Instant byCreatedBefore() {
        return byCreatedBefore;
    }

    /**
     * <p>
     * Returns only recovery points that were created after the specified timestamp.
     * </p>
     * 
     * @return Returns only recovery points that were created after the specified timestamp.
     */
    public Instant byCreatedAfter() {
        return byCreatedAfter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(byResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(byResourceType());
        hashCode = 31 * hashCode + Objects.hashCode(byBackupPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(byCreatedBefore());
        hashCode = 31 * hashCode + Objects.hashCode(byCreatedAfter());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecoveryPointsByBackupVaultRequest)) {
            return false;
        }
        ListRecoveryPointsByBackupVaultRequest other = (ListRecoveryPointsByBackupVaultRequest) obj;
        return Objects.equals(backupVaultName(), other.backupVaultName()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(byResourceArn(), other.byResourceArn())
                && Objects.equals(byResourceType(), other.byResourceType())
                && Objects.equals(byBackupPlanId(), other.byBackupPlanId())
                && Objects.equals(byCreatedBefore(), other.byCreatedBefore())
                && Objects.equals(byCreatedAfter(), other.byCreatedAfter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListRecoveryPointsByBackupVaultRequest").add("BackupVaultName", backupVaultName())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).add("ByResourceArn", byResourceArn())
                .add("ByResourceType", byResourceType()).add("ByBackupPlanId", byBackupPlanId())
                .add("ByCreatedBefore", byCreatedBefore()).add("ByCreatedAfter", byCreatedAfter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupVaultName":
            return Optional.ofNullable(clazz.cast(backupVaultName()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "ByResourceArn":
            return Optional.ofNullable(clazz.cast(byResourceArn()));
        case "ByResourceType":
            return Optional.ofNullable(clazz.cast(byResourceType()));
        case "ByBackupPlanId":
            return Optional.ofNullable(clazz.cast(byBackupPlanId()));
        case "ByCreatedBefore":
            return Optional.ofNullable(clazz.cast(byCreatedBefore()));
        case "ByCreatedAfter":
            return Optional.ofNullable(clazz.cast(byCreatedAfter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRecoveryPointsByBackupVaultRequest, T> g) {
        return obj -> g.apply((ListRecoveryPointsByBackupVaultRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRecoveryPointsByBackupVaultRequest> {
        /**
         * <p>
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are
         * unique to the account used to create them and the AWS Region where they are created. They consist of
         * lowercase letters, numbers, and hyphens.
         * </p>
         * 
         * @param backupVaultName
         *        The name of a logical container where backups are stored. Backup vaults are identified by names that
         *        are unique to the account used to create them and the AWS Region where they are created. They consist
         *        of lowercase letters, numbers, and hyphens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultName(String backupVaultName);

        /**
         * <p>
         * The next item following a partial list of returned items. For example, if a request is made to return
         * <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
         * starting at the location pointed to by the next token.
         * </p>
         * 
         * @param nextToken
         *        The next item following a partial list of returned items. For example, if a request is made to return
         *        <code>maxResults</code> number of items, <code>NextToken</code> allows you to return more items in
         *        your list starting at the location pointed to by the next token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to be returned.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Returns only recovery points that match the specified resource Amazon Resource Name (ARN).
         * </p>
         * 
         * @param byResourceArn
         *        Returns only recovery points that match the specified resource Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byResourceArn(String byResourceArn);

        /**
         * <p>
         * Returns only recovery points that match the specified resource type.
         * </p>
         * 
         * @param byResourceType
         *        Returns only recovery points that match the specified resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byResourceType(String byResourceType);

        /**
         * <p>
         * Returns only recovery points that match the specified backup plan ID.
         * </p>
         * 
         * @param byBackupPlanId
         *        Returns only recovery points that match the specified backup plan ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byBackupPlanId(String byBackupPlanId);

        /**
         * <p>
         * Returns only recovery points that were created before the specified timestamp.
         * </p>
         * 
         * @param byCreatedBefore
         *        Returns only recovery points that were created before the specified timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byCreatedBefore(Instant byCreatedBefore);

        /**
         * <p>
         * Returns only recovery points that were created after the specified timestamp.
         * </p>
         * 
         * @param byCreatedAfter
         *        Returns only recovery points that were created after the specified timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byCreatedAfter(Instant byCreatedAfter);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String backupVaultName;

        private String nextToken;

        private Integer maxResults;

        private String byResourceArn;

        private String byResourceType;

        private String byBackupPlanId;

        private Instant byCreatedBefore;

        private Instant byCreatedAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecoveryPointsByBackupVaultRequest model) {
            super(model);
            backupVaultName(model.backupVaultName);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            byResourceArn(model.byResourceArn);
            byResourceType(model.byResourceType);
            byBackupPlanId(model.byBackupPlanId);
            byCreatedBefore(model.byCreatedBefore);
            byCreatedAfter(model.byCreatedAfter);
        }

        public final String getBackupVaultName() {
            return backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getByResourceArn() {
            return byResourceArn;
        }

        @Override
        public final Builder byResourceArn(String byResourceArn) {
            this.byResourceArn = byResourceArn;
            return this;
        }

        public final void setByResourceArn(String byResourceArn) {
            this.byResourceArn = byResourceArn;
        }

        public final String getByResourceType() {
            return byResourceType;
        }

        @Override
        public final Builder byResourceType(String byResourceType) {
            this.byResourceType = byResourceType;
            return this;
        }

        public final void setByResourceType(String byResourceType) {
            this.byResourceType = byResourceType;
        }

        public final String getByBackupPlanId() {
            return byBackupPlanId;
        }

        @Override
        public final Builder byBackupPlanId(String byBackupPlanId) {
            this.byBackupPlanId = byBackupPlanId;
            return this;
        }

        public final void setByBackupPlanId(String byBackupPlanId) {
            this.byBackupPlanId = byBackupPlanId;
        }

        public final Instant getByCreatedBefore() {
            return byCreatedBefore;
        }

        @Override
        public final Builder byCreatedBefore(Instant byCreatedBefore) {
            this.byCreatedBefore = byCreatedBefore;
            return this;
        }

        public final void setByCreatedBefore(Instant byCreatedBefore) {
            this.byCreatedBefore = byCreatedBefore;
        }

        public final Instant getByCreatedAfter() {
            return byCreatedAfter;
        }

        @Override
        public final Builder byCreatedAfter(Instant byCreatedAfter) {
            this.byCreatedAfter = byCreatedAfter;
            return this;
        }

        public final void setByCreatedAfter(Instant byCreatedAfter) {
            this.byCreatedAfter = byCreatedAfter;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRecoveryPointsByBackupVaultRequest build() {
            return new ListRecoveryPointsByBackupVaultRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
