/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains detailed information about the recovery points stored in a backup vault.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecoveryPointByBackupVault implements SdkPojo, Serializable,
        ToCopyableBuilder<RecoveryPointByBackupVault.Builder, RecoveryPointByBackupVault> {
    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RecoveryPointByBackupVault::recoveryPointArn)).setter(setter(Builder::recoveryPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()).build();

    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RecoveryPointByBackupVault::backupVaultName)).setter(setter(Builder::backupVaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()).build();

    private static final SdkField<String> BACKUP_VAULT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RecoveryPointByBackupVault::backupVaultArn)).setter(setter(Builder::backupVaultArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultArn").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RecoveryPointByBackupVault::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RecoveryPointByBackupVault::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<RecoveryPointCreator> CREATED_BY_FIELD = SdkField
            .<RecoveryPointCreator> builder(MarshallingType.SDK_POJO).getter(getter(RecoveryPointByBackupVault::createdBy))
            .setter(setter(Builder::createdBy)).constructor(RecoveryPointCreator::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RecoveryPointByBackupVault::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RecoveryPointByBackupVault::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(RecoveryPointByBackupVault::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<Instant> COMPLETION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(RecoveryPointByBackupVault::completionDate)).setter(setter(Builder::completionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionDate").build()).build();

    private static final SdkField<Long> BACKUP_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(RecoveryPointByBackupVault::backupSizeInBytes)).setter(setter(Builder::backupSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupSizeInBytes").build()).build();

    private static final SdkField<CalculatedLifecycle> CALCULATED_LIFECYCLE_FIELD = SdkField
            .<CalculatedLifecycle> builder(MarshallingType.SDK_POJO)
            .getter(getter(RecoveryPointByBackupVault::calculatedLifecycle)).setter(setter(Builder::calculatedLifecycle))
            .constructor(CalculatedLifecycle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatedLifecycle").build())
            .build();

    private static final SdkField<Lifecycle> LIFECYCLE_FIELD = SdkField.<Lifecycle> builder(MarshallingType.SDK_POJO)
            .getter(getter(RecoveryPointByBackupVault::lifecycle)).setter(setter(Builder::lifecycle))
            .constructor(Lifecycle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RecoveryPointByBackupVault::encryptionKeyArn)).setter(setter(Builder::encryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()).build();

    private static final SdkField<Boolean> IS_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(RecoveryPointByBackupVault::isEncrypted)).setter(setter(Builder::isEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsEncrypted").build()).build();

    private static final SdkField<Instant> LAST_RESTORE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(RecoveryPointByBackupVault::lastRestoreTime)).setter(setter(Builder::lastRestoreTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRestoreTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOVERY_POINT_ARN_FIELD,
            BACKUP_VAULT_NAME_FIELD, BACKUP_VAULT_ARN_FIELD, RESOURCE_ARN_FIELD, RESOURCE_TYPE_FIELD, CREATED_BY_FIELD,
            IAM_ROLE_ARN_FIELD, STATUS_FIELD, CREATION_DATE_FIELD, COMPLETION_DATE_FIELD, BACKUP_SIZE_IN_BYTES_FIELD,
            CALCULATED_LIFECYCLE_FIELD, LIFECYCLE_FIELD, ENCRYPTION_KEY_ARN_FIELD, IS_ENCRYPTED_FIELD, LAST_RESTORE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String recoveryPointArn;

    private final String backupVaultName;

    private final String backupVaultArn;

    private final String resourceArn;

    private final String resourceType;

    private final RecoveryPointCreator createdBy;

    private final String iamRoleArn;

    private final String status;

    private final Instant creationDate;

    private final Instant completionDate;

    private final Long backupSizeInBytes;

    private final CalculatedLifecycle calculatedLifecycle;

    private final Lifecycle lifecycle;

    private final String encryptionKeyArn;

    private final Boolean isEncrypted;

    private final Instant lastRestoreTime;

    private RecoveryPointByBackupVault(BuilderImpl builder) {
        this.recoveryPointArn = builder.recoveryPointArn;
        this.backupVaultName = builder.backupVaultName;
        this.backupVaultArn = builder.backupVaultArn;
        this.resourceArn = builder.resourceArn;
        this.resourceType = builder.resourceType;
        this.createdBy = builder.createdBy;
        this.iamRoleArn = builder.iamRoleArn;
        this.status = builder.status;
        this.creationDate = builder.creationDate;
        this.completionDate = builder.completionDate;
        this.backupSizeInBytes = builder.backupSizeInBytes;
        this.calculatedLifecycle = builder.calculatedLifecycle;
        this.lifecycle = builder.lifecycle;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.isEncrypted = builder.isEncrypted;
        this.lastRestoreTime = builder.lastRestoreTime;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
     *         <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     */
    public String recoveryPointArn() {
        return recoveryPointArn;
    }

    /**
     * <p>
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique
     * to the account used to create them and the AWS Region where they are created. They consist of lowercase letters,
     * numbers, and hyphens.
     * </p>
     * 
     * @return The name of a logical container where backups are stored. Backup vaults are identified by names that are
     *         unique to the account used to create them and the AWS Region where they are created. They consist of
     *         lowercase letters, numbers, and hyphens.
     */
    public String backupVaultName() {
        return backupVaultName;
    }

    /**
     * <p>
     * An ARN that uniquely identifies a backup vault; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
     * </p>
     * 
     * @return An ARN that uniquely identifies a backup vault; for example,
     *         <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
     */
    public String backupVaultArn() {
        return backupVaultArn;
    }

    /**
     * <p>
     * An ARN that uniquely identifies a resource. The format of the ARN depends on the resource type.
     * </p>
     * 
     * @return An ARN that uniquely identifies a resource. The format of the ARN depends on the resource type.
     */
    public String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The type of AWS resource saved as a recovery point; for example, an Amazon Elastic Block Store (Amazon EBS)
     * volume or an Amazon Relational Database Service (Amazon RDS) database.
     * </p>
     * 
     * @return The type of AWS resource saved as a recovery point; for example, an Amazon Elastic Block Store (Amazon
     *         EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * Contains identifying information about the creation of a recovery point, including the <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and <code>BackupRuleId</code> of the backup plan
     * that is used to create it.
     * </p>
     * 
     * @return Contains identifying information about the creation of a recovery point, including the
     *         <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and
     *         <code>BackupRuleId</code> of the backup plan that is used to create it.
     */
    public RecoveryPointCreator createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * Specifies the IAM role ARN used to create the target recovery point; for example,
     * <code>arn:aws:iam::123456789012:role/S3Access</code>.
     * </p>
     * 
     * @return Specifies the IAM role ARN used to create the target recovery point; for example,
     *         <code>arn:aws:iam::123456789012:role/S3Access</code>.
     */
    public String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * <p>
     * A status code specifying the state of the recovery point.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RecoveryPointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return A status code specifying the state of the recovery point.
     * @see RecoveryPointStatus
     */
    public RecoveryPointStatus status() {
        return RecoveryPointStatus.fromValue(status);
    }

    /**
     * <p>
     * A status code specifying the state of the recovery point.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RecoveryPointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return A status code specifying the state of the recovery point.
     * @see RecoveryPointStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time a recovery point is created, in Unix format and Coordinated Universal Time (UTC). The value of
     * <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday,
     * January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time a recovery point is created, in Unix format and Coordinated Universal Time (UTC). The
     *         value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087
     *         represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date and time a job to restore a recovery point is completed, in Unix format and Coordinated Universal Time
     * (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value
     * 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time a job to restore a recovery point is completed, in Unix format and Coordinated
     *         Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example,
     *         the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public Instant completionDate() {
        return completionDate;
    }

    /**
     * <p>
     * The size, in bytes, of a backup.
     * </p>
     * 
     * @return The size, in bytes, of a backup.
     */
    public Long backupSizeInBytes() {
        return backupSizeInBytes;
    }

    /**
     * <p>
     * A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and <code>MoveToColdStorageAt</code>
     * timestamps.
     * </p>
     * 
     * @return A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and
     *         <code>MoveToColdStorageAt</code> timestamps.
     */
    public CalculatedLifecycle calculatedLifecycle() {
        return calculatedLifecycle;
    }

    /**
     * <p>
     * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. AWS Backup
     * transitions and expires backups automatically according to the lifecycle that you define.
     * </p>
     * <p>
     * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the
     * “expire after days” setting must be 90 days greater than the “transition to cold after days” setting. The
     * “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
     * </p>
     * 
     * @return The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. AWS
     *         Backup transitions and expires backups automatically according to the lifecycle that you define. </p>
     *         <p>
     *         Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore,
     *         the “expire after days” setting must be 90 days greater than the “transition to cold after days” setting.
     *         The “transition to cold after days” setting cannot be changed after a backup has been transitioned to
     *         cold.
     */
    public Lifecycle lifecycle() {
        return lifecycle;
    }

    /**
     * <p>
     * The server-side encryption key that is used to protect your backups; for example,
     * <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     * 
     * @return The server-side encryption key that is used to protect your backups; for example,
     *         <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     */
    public String encryptionKeyArn() {
        return encryptionKeyArn;
    }

    /**
     * <p>
     * A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is encrypted, or
     * <code>FALSE</code> if the recovery point is not encrypted.
     * </p>
     * 
     * @return A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is encrypted, or
     *         <code>FALSE</code> if the recovery point is not encrypted.
     */
    public Boolean isEncrypted() {
        return isEncrypted;
    }

    /**
     * <p>
     * The date and time a recovery point was last restored, in Unix format and Coordinated Universal Time (UTC). The
     * value of <code>LastRestoreTime</code> is accurate to milliseconds. For example, the value 1516925490.087
     * represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time a recovery point was last restored, in Unix format and Coordinated Universal Time
     *         (UTC). The value of <code>LastRestoreTime</code> is accurate to milliseconds. For example, the value
     *         1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public Instant lastRestoreTime() {
        return lastRestoreTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(completionDate());
        hashCode = 31 * hashCode + Objects.hashCode(backupSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(calculatedLifecycle());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycle());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(isEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(lastRestoreTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecoveryPointByBackupVault)) {
            return false;
        }
        RecoveryPointByBackupVault other = (RecoveryPointByBackupVault) obj;
        return Objects.equals(recoveryPointArn(), other.recoveryPointArn())
                && Objects.equals(backupVaultName(), other.backupVaultName())
                && Objects.equals(backupVaultArn(), other.backupVaultArn()) && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(resourceType(), other.resourceType()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(iamRoleArn(), other.iamRoleArn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(completionDate(), other.completionDate())
                && Objects.equals(backupSizeInBytes(), other.backupSizeInBytes())
                && Objects.equals(calculatedLifecycle(), other.calculatedLifecycle())
                && Objects.equals(lifecycle(), other.lifecycle()) && Objects.equals(encryptionKeyArn(), other.encryptionKeyArn())
                && Objects.equals(isEncrypted(), other.isEncrypted())
                && Objects.equals(lastRestoreTime(), other.lastRestoreTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RecoveryPointByBackupVault").add("RecoveryPointArn", recoveryPointArn())
                .add("BackupVaultName", backupVaultName()).add("BackupVaultArn", backupVaultArn())
                .add("ResourceArn", resourceArn()).add("ResourceType", resourceType()).add("CreatedBy", createdBy())
                .add("IamRoleArn", iamRoleArn()).add("Status", statusAsString()).add("CreationDate", creationDate())
                .add("CompletionDate", completionDate()).add("BackupSizeInBytes", backupSizeInBytes())
                .add("CalculatedLifecycle", calculatedLifecycle()).add("Lifecycle", lifecycle())
                .add("EncryptionKeyArn", encryptionKeyArn()).add("IsEncrypted", isEncrypted())
                .add("LastRestoreTime", lastRestoreTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecoveryPointArn":
            return Optional.ofNullable(clazz.cast(recoveryPointArn()));
        case "BackupVaultName":
            return Optional.ofNullable(clazz.cast(backupVaultName()));
        case "BackupVaultArn":
            return Optional.ofNullable(clazz.cast(backupVaultArn()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "CompletionDate":
            return Optional.ofNullable(clazz.cast(completionDate()));
        case "BackupSizeInBytes":
            return Optional.ofNullable(clazz.cast(backupSizeInBytes()));
        case "CalculatedLifecycle":
            return Optional.ofNullable(clazz.cast(calculatedLifecycle()));
        case "Lifecycle":
            return Optional.ofNullable(clazz.cast(lifecycle()));
        case "EncryptionKeyArn":
            return Optional.ofNullable(clazz.cast(encryptionKeyArn()));
        case "IsEncrypted":
            return Optional.ofNullable(clazz.cast(isEncrypted()));
        case "LastRestoreTime":
            return Optional.ofNullable(clazz.cast(lastRestoreTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecoveryPointByBackupVault, T> g) {
        return obj -> g.apply((RecoveryPointByBackupVault) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecoveryPointByBackupVault> {
        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
         * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
         * </p>
         * 
         * @param recoveryPointArn
         *        An Amazon Resource Name (ARN) that uniquely identifies a recovery point; for example,
         *        <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPointArn(String recoveryPointArn);

        /**
         * <p>
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are
         * unique to the account used to create them and the AWS Region where they are created. They consist of
         * lowercase letters, numbers, and hyphens.
         * </p>
         * 
         * @param backupVaultName
         *        The name of a logical container where backups are stored. Backup vaults are identified by names that
         *        are unique to the account used to create them and the AWS Region where they are created. They consist
         *        of lowercase letters, numbers, and hyphens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultName(String backupVaultName);

        /**
         * <p>
         * An ARN that uniquely identifies a backup vault; for example,
         * <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
         * </p>
         * 
         * @param backupVaultArn
         *        An ARN that uniquely identifies a backup vault; for example,
         *        <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultArn(String backupVaultArn);

        /**
         * <p>
         * An ARN that uniquely identifies a resource. The format of the ARN depends on the resource type.
         * </p>
         * 
         * @param resourceArn
         *        An ARN that uniquely identifies a resource. The format of the ARN depends on the resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The type of AWS resource saved as a recovery point; for example, an Amazon Elastic Block Store (Amazon EBS)
         * volume or an Amazon Relational Database Service (Amazon RDS) database.
         * </p>
         * 
         * @param resourceType
         *        The type of AWS resource saved as a recovery point; for example, an Amazon Elastic Block Store (Amazon
         *        EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Contains identifying information about the creation of a recovery point, including the
         * <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and
         * <code>BackupRuleId</code> of the backup plan that is used to create it.
         * </p>
         * 
         * @param createdBy
         *        Contains identifying information about the creation of a recovery point, including the
         *        <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and
         *        <code>BackupRuleId</code> of the backup plan that is used to create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(RecoveryPointCreator createdBy);

        /**
         * <p>
         * Contains identifying information about the creation of a recovery point, including the
         * <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and
         * <code>BackupRuleId</code> of the backup plan that is used to create it.
         * </p>
         * This is a convenience that creates an instance of the {@link RecoveryPointCreator.Builder} avoiding the need
         * to create one manually via {@link RecoveryPointCreator#builder()}.
         *
         * When the {@link Consumer} completes, {@link RecoveryPointCreator.Builder#build()} is called immediately and
         * its result is passed to {@link #createdBy(RecoveryPointCreator)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link RecoveryPointCreator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(RecoveryPointCreator)
         */
        default Builder createdBy(Consumer<RecoveryPointCreator.Builder> createdBy) {
            return createdBy(RecoveryPointCreator.builder().applyMutation(createdBy).build());
        }

        /**
         * <p>
         * Specifies the IAM role ARN used to create the target recovery point; for example,
         * <code>arn:aws:iam::123456789012:role/S3Access</code>.
         * </p>
         * 
         * @param iamRoleArn
         *        Specifies the IAM role ARN used to create the target recovery point; for example,
         *        <code>arn:aws:iam::123456789012:role/S3Access</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * A status code specifying the state of the recovery point.
         * </p>
         * 
         * @param status
         *        A status code specifying the state of the recovery point.
         * @see RecoveryPointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecoveryPointStatus
         */
        Builder status(String status);

        /**
         * <p>
         * A status code specifying the state of the recovery point.
         * </p>
         * 
         * @param status
         *        A status code specifying the state of the recovery point.
         * @see RecoveryPointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecoveryPointStatus
         */
        Builder status(RecoveryPointStatus status);

        /**
         * <p>
         * The date and time a recovery point is created, in Unix format and Coordinated Universal Time (UTC). The value
         * of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
         * Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param creationDate
         *        The date and time a recovery point is created, in Unix format and Coordinated Universal Time (UTC).
         *        The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date and time a job to restore a recovery point is completed, in Unix format and Coordinated Universal
         * Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value
         * 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param completionDate
         *        The date and time a job to restore a recovery point is completed, in Unix format and Coordinated
         *        Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For
         *        example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionDate(Instant completionDate);

        /**
         * <p>
         * The size, in bytes, of a backup.
         * </p>
         * 
         * @param backupSizeInBytes
         *        The size, in bytes, of a backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupSizeInBytes(Long backupSizeInBytes);

        /**
         * <p>
         * A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and
         * <code>MoveToColdStorageAt</code> timestamps.
         * </p>
         * 
         * @param calculatedLifecycle
         *        A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and
         *        <code>MoveToColdStorageAt</code> timestamps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculatedLifecycle(CalculatedLifecycle calculatedLifecycle);

        /**
         * <p>
         * A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and
         * <code>MoveToColdStorageAt</code> timestamps.
         * </p>
         * This is a convenience that creates an instance of the {@link CalculatedLifecycle.Builder} avoiding the need
         * to create one manually via {@link CalculatedLifecycle#builder()}.
         *
         * When the {@link Consumer} completes, {@link CalculatedLifecycle.Builder#build()} is called immediately and
         * its result is passed to {@link #calculatedLifecycle(CalculatedLifecycle)}.
         * 
         * @param calculatedLifecycle
         *        a consumer that will call methods on {@link CalculatedLifecycle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #calculatedLifecycle(CalculatedLifecycle)
         */
        default Builder calculatedLifecycle(Consumer<CalculatedLifecycle.Builder> calculatedLifecycle) {
            return calculatedLifecycle(CalculatedLifecycle.builder().applyMutation(calculatedLifecycle).build());
        }

        /**
         * <p>
         * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. AWS
         * Backup transitions and expires backups automatically according to the lifecycle that you define.
         * </p>
         * <p>
         * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the
         * “expire after days” setting must be 90 days greater than the “transition to cold after days” setting. The
         * “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
         * </p>
         * 
         * @param lifecycle
         *        The lifecycle defines when a protected resource is transitioned to cold storage and when it expires.
         *        AWS Backup transitions and expires backups automatically according to the lifecycle that you define.
         *        </p>
         *        <p>
         *        Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days.
         *        Therefore, the “expire after days” setting must be 90 days greater than the “transition to cold after
         *        days” setting. The “transition to cold after days” setting cannot be changed after a backup has been
         *        transitioned to cold.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycle(Lifecycle lifecycle);

        /**
         * <p>
         * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. AWS
         * Backup transitions and expires backups automatically according to the lifecycle that you define.
         * </p>
         * <p>
         * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the
         * “expire after days” setting must be 90 days greater than the “transition to cold after days” setting. The
         * “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
         * </p>
         * This is a convenience that creates an instance of the {@link Lifecycle.Builder} avoiding the need to create
         * one manually via {@link Lifecycle#builder()}.
         *
         * When the {@link Consumer} completes, {@link Lifecycle.Builder#build()} is called immediately and its result
         * is passed to {@link #lifecycle(Lifecycle)}.
         * 
         * @param lifecycle
         *        a consumer that will call methods on {@link Lifecycle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecycle(Lifecycle)
         */
        default Builder lifecycle(Consumer<Lifecycle.Builder> lifecycle) {
            return lifecycle(Lifecycle.builder().applyMutation(lifecycle).build());
        }

        /**
         * <p>
         * The server-side encryption key that is used to protect your backups; for example,
         * <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * </p>
         * 
         * @param encryptionKeyArn
         *        The server-side encryption key that is used to protect your backups; for example,
         *        <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKeyArn(String encryptionKeyArn);

        /**
         * <p>
         * A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is encrypted, or
         * <code>FALSE</code> if the recovery point is not encrypted.
         * </p>
         * 
         * @param isEncrypted
         *        A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is encrypted, or
         *        <code>FALSE</code> if the recovery point is not encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isEncrypted(Boolean isEncrypted);

        /**
         * <p>
         * The date and time a recovery point was last restored, in Unix format and Coordinated Universal Time (UTC).
         * The value of <code>LastRestoreTime</code> is accurate to milliseconds. For example, the value 1516925490.087
         * represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param lastRestoreTime
         *        The date and time a recovery point was last restored, in Unix format and Coordinated Universal Time
         *        (UTC). The value of <code>LastRestoreTime</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRestoreTime(Instant lastRestoreTime);
    }

    static final class BuilderImpl implements Builder {
        private String recoveryPointArn;

        private String backupVaultName;

        private String backupVaultArn;

        private String resourceArn;

        private String resourceType;

        private RecoveryPointCreator createdBy;

        private String iamRoleArn;

        private String status;

        private Instant creationDate;

        private Instant completionDate;

        private Long backupSizeInBytes;

        private CalculatedLifecycle calculatedLifecycle;

        private Lifecycle lifecycle;

        private String encryptionKeyArn;

        private Boolean isEncrypted;

        private Instant lastRestoreTime;

        private BuilderImpl() {
        }

        private BuilderImpl(RecoveryPointByBackupVault model) {
            recoveryPointArn(model.recoveryPointArn);
            backupVaultName(model.backupVaultName);
            backupVaultArn(model.backupVaultArn);
            resourceArn(model.resourceArn);
            resourceType(model.resourceType);
            createdBy(model.createdBy);
            iamRoleArn(model.iamRoleArn);
            status(model.status);
            creationDate(model.creationDate);
            completionDate(model.completionDate);
            backupSizeInBytes(model.backupSizeInBytes);
            calculatedLifecycle(model.calculatedLifecycle);
            lifecycle(model.lifecycle);
            encryptionKeyArn(model.encryptionKeyArn);
            isEncrypted(model.isEncrypted);
            lastRestoreTime(model.lastRestoreTime);
        }

        public final String getRecoveryPointArn() {
            return recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        public final String getBackupVaultName() {
            return backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        public final String getBackupVaultArn() {
            return backupVaultArn;
        }

        @Override
        public final Builder backupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
            return this;
        }

        public final void setBackupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final RecoveryPointCreator.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        @Override
        public final Builder createdBy(RecoveryPointCreator createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(RecoveryPointCreator.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RecoveryPointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getCompletionDate() {
            return completionDate;
        }

        @Override
        public final Builder completionDate(Instant completionDate) {
            this.completionDate = completionDate;
            return this;
        }

        public final void setCompletionDate(Instant completionDate) {
            this.completionDate = completionDate;
        }

        public final Long getBackupSizeInBytes() {
            return backupSizeInBytes;
        }

        @Override
        public final Builder backupSizeInBytes(Long backupSizeInBytes) {
            this.backupSizeInBytes = backupSizeInBytes;
            return this;
        }

        public final void setBackupSizeInBytes(Long backupSizeInBytes) {
            this.backupSizeInBytes = backupSizeInBytes;
        }

        public final CalculatedLifecycle.Builder getCalculatedLifecycle() {
            return calculatedLifecycle != null ? calculatedLifecycle.toBuilder() : null;
        }

        @Override
        public final Builder calculatedLifecycle(CalculatedLifecycle calculatedLifecycle) {
            this.calculatedLifecycle = calculatedLifecycle;
            return this;
        }

        public final void setCalculatedLifecycle(CalculatedLifecycle.BuilderImpl calculatedLifecycle) {
            this.calculatedLifecycle = calculatedLifecycle != null ? calculatedLifecycle.build() : null;
        }

        public final Lifecycle.Builder getLifecycle() {
            return lifecycle != null ? lifecycle.toBuilder() : null;
        }

        @Override
        public final Builder lifecycle(Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        public final void setLifecycle(Lifecycle.BuilderImpl lifecycle) {
            this.lifecycle = lifecycle != null ? lifecycle.build() : null;
        }

        public final String getEncryptionKeyArn() {
            return encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        public final Boolean getIsEncrypted() {
            return isEncrypted;
        }

        @Override
        public final Builder isEncrypted(Boolean isEncrypted) {
            this.isEncrypted = isEncrypted;
            return this;
        }

        public final void setIsEncrypted(Boolean isEncrypted) {
            this.isEncrypted = isEncrypted;
        }

        public final Instant getLastRestoreTime() {
            return lastRestoreTime;
        }

        @Override
        public final Builder lastRestoreTime(Instant lastRestoreTime) {
            this.lastRestoreTime = lastRestoreTime;
            return this;
        }

        public final void setLastRestoreTime(Instant lastRestoreTime) {
            this.lastRestoreTime = lastRestoreTime;
        }

        @Override
        public RecoveryPointByBackupVault build() {
            return new RecoveryPointByBackupVault(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
