/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupgateway.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestHypervisorConfigurationRequest extends BackupGatewayRequest implements
        ToCopyableBuilder<TestHypervisorConfigurationRequest.Builder, TestHypervisorConfigurationRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayArn").getter(getter(TestHypervisorConfigurationRequest::gatewayArn))
            .setter(setter(Builder::gatewayArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayArn").build()).build();

    private static final SdkField<String> HOST_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Host")
            .getter(getter(TestHypervisorConfigurationRequest::host)).setter(setter(Builder::host))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Host").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Password").getter(getter(TestHypervisorConfigurationRequest::password))
            .setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(TestHypervisorConfigurationRequest::username))
            .setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, HOST_FIELD,
            PASSWORD_FIELD, USERNAME_FIELD));

    private final String gatewayArn;

    private final String host;

    private final String password;

    private final String username;

    private TestHypervisorConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayArn = builder.gatewayArn;
        this.host = builder.host;
        this.password = builder.password;
        this.username = builder.username;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the gateway to the hypervisor to test.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the gateway to the hypervisor to test.
     */
    public final String gatewayArn() {
        return gatewayArn;
    }

    /**
     * <p>
     * The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name (FQDN).
     * </p>
     * 
     * @return The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name
     *         (FQDN).
     */
    public final String host() {
        return host;
    }

    /**
     * <p>
     * The password for the hypervisor.
     * </p>
     * 
     * @return The password for the hypervisor.
     */
    public final String password() {
        return password;
    }

    /**
     * <p>
     * The username for the hypervisor.
     * </p>
     * 
     * @return The username for the hypervisor.
     */
    public final String username() {
        return username;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(host());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestHypervisorConfigurationRequest)) {
            return false;
        }
        TestHypervisorConfigurationRequest other = (TestHypervisorConfigurationRequest) obj;
        return Objects.equals(gatewayArn(), other.gatewayArn()) && Objects.equals(host(), other.host())
                && Objects.equals(password(), other.password()) && Objects.equals(username(), other.username());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestHypervisorConfigurationRequest").add("GatewayArn", gatewayArn()).add("Host", host())
                .add("Password", password() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Username", username() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayArn":
            return Optional.ofNullable(clazz.cast(gatewayArn()));
        case "Host":
            return Optional.ofNullable(clazz.cast(host()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestHypervisorConfigurationRequest, T> g) {
        return obj -> g.apply((TestHypervisorConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupGatewayRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, TestHypervisorConfigurationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the gateway to the hypervisor to test.
         * </p>
         * 
         * @param gatewayArn
         *        The Amazon Resource Name (ARN) of the gateway to the hypervisor to test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayArn(String gatewayArn);

        /**
         * <p>
         * The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name (FQDN).
         * </p>
         * 
         * @param host
         *        The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name
         *        (FQDN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder host(String host);

        /**
         * <p>
         * The password for the hypervisor.
         * </p>
         * 
         * @param password
         *        The password for the hypervisor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * The username for the hypervisor.
         * </p>
         * 
         * @param username
         *        The username for the hypervisor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupGatewayRequest.BuilderImpl implements Builder {
        private String gatewayArn;

        private String host;

        private String password;

        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(TestHypervisorConfigurationRequest model) {
            super(model);
            gatewayArn(model.gatewayArn);
            host(model.host);
            password(model.password);
            username(model.username);
        }

        public final String getGatewayArn() {
            return gatewayArn;
        }

        public final void setGatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
        }

        @Override
        @Transient
        public final Builder gatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
            return this;
        }

        public final String getHost() {
            return host;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        @Override
        @Transient
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final String getPassword() {
            return password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        @Transient
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        @Transient
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestHypervisorConfigurationRequest build() {
            return new TestHypervisorConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
