/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupgateway.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A virtual machine that is on a hypervisor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualMachine implements SdkPojo, Serializable, ToCopyableBuilder<VirtualMachine.Builder, VirtualMachine> {
    private static final SdkField<String> HOST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostName").getter(getter(VirtualMachine::hostName)).setter(setter(Builder::hostName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostName").build()).build();

    private static final SdkField<String> HYPERVISOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HypervisorId").getter(getter(VirtualMachine::hypervisorId)).setter(setter(Builder::hypervisorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HypervisorId").build()).build();

    private static final SdkField<Instant> LAST_BACKUP_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastBackupDate").getter(getter(VirtualMachine::lastBackupDate)).setter(setter(Builder::lastBackupDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastBackupDate").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(VirtualMachine::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(VirtualMachine::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(VirtualMachine::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_NAME_FIELD,
            HYPERVISOR_ID_FIELD, LAST_BACKUP_DATE_FIELD, NAME_FIELD, PATH_FIELD, RESOURCE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String hostName;

    private final String hypervisorId;

    private final Instant lastBackupDate;

    private final String name;

    private final String path;

    private final String resourceArn;

    private VirtualMachine(BuilderImpl builder) {
        this.hostName = builder.hostName;
        this.hypervisorId = builder.hypervisorId;
        this.lastBackupDate = builder.lastBackupDate;
        this.name = builder.name;
        this.path = builder.path;
        this.resourceArn = builder.resourceArn;
    }

    /**
     * <p>
     * The host name of the virtual machine.
     * </p>
     * 
     * @return The host name of the virtual machine.
     */
    public final String hostName() {
        return hostName;
    }

    /**
     * <p>
     * The ID of the virtual machine's hypervisor.
     * </p>
     * 
     * @return The ID of the virtual machine's hypervisor.
     */
    public final String hypervisorId() {
        return hypervisorId;
    }

    /**
     * <p>
     * The most recent date a virtual machine was backed up, in Unix format and UTC time.
     * </p>
     * 
     * @return The most recent date a virtual machine was backed up, in Unix format and UTC time.
     */
    public final Instant lastBackupDate() {
        return lastBackupDate;
    }

    /**
     * <p>
     * The name of the virtual machine.
     * </p>
     * 
     * @return The name of the virtual machine.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The path of the virtual machine.
     * </p>
     * 
     * @return The path of the virtual machine.
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the virtual machine.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the virtual machine.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostName());
        hashCode = 31 * hashCode + Objects.hashCode(hypervisorId());
        hashCode = 31 * hashCode + Objects.hashCode(lastBackupDate());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualMachine)) {
            return false;
        }
        VirtualMachine other = (VirtualMachine) obj;
        return Objects.equals(hostName(), other.hostName()) && Objects.equals(hypervisorId(), other.hypervisorId())
                && Objects.equals(lastBackupDate(), other.lastBackupDate()) && Objects.equals(name(), other.name())
                && Objects.equals(path(), other.path()) && Objects.equals(resourceArn(), other.resourceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VirtualMachine").add("HostName", hostName()).add("HypervisorId", hypervisorId())
                .add("LastBackupDate", lastBackupDate()).add("Name", name()).add("Path", path())
                .add("ResourceArn", resourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostName":
            return Optional.ofNullable(clazz.cast(hostName()));
        case "HypervisorId":
            return Optional.ofNullable(clazz.cast(hypervisorId()));
        case "LastBackupDate":
            return Optional.ofNullable(clazz.cast(lastBackupDate()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualMachine, T> g) {
        return obj -> g.apply((VirtualMachine) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualMachine> {
        /**
         * <p>
         * The host name of the virtual machine.
         * </p>
         * 
         * @param hostName
         *        The host name of the virtual machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostName(String hostName);

        /**
         * <p>
         * The ID of the virtual machine's hypervisor.
         * </p>
         * 
         * @param hypervisorId
         *        The ID of the virtual machine's hypervisor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hypervisorId(String hypervisorId);

        /**
         * <p>
         * The most recent date a virtual machine was backed up, in Unix format and UTC time.
         * </p>
         * 
         * @param lastBackupDate
         *        The most recent date a virtual machine was backed up, in Unix format and UTC time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastBackupDate(Instant lastBackupDate);

        /**
         * <p>
         * The name of the virtual machine.
         * </p>
         * 
         * @param name
         *        The name of the virtual machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The path of the virtual machine.
         * </p>
         * 
         * @param path
         *        The path of the virtual machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the virtual machine.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the virtual machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);
    }

    static final class BuilderImpl implements Builder {
        private String hostName;

        private String hypervisorId;

        private Instant lastBackupDate;

        private String name;

        private String path;

        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualMachine model) {
            hostName(model.hostName);
            hypervisorId(model.hypervisorId);
            lastBackupDate(model.lastBackupDate);
            name(model.name);
            path(model.path);
            resourceArn(model.resourceArn);
        }

        public final String getHostName() {
            return hostName;
        }

        public final void setHostName(String hostName) {
            this.hostName = hostName;
        }

        @Override
        @Transient
        public final Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public final String getHypervisorId() {
            return hypervisorId;
        }

        public final void setHypervisorId(String hypervisorId) {
            this.hypervisorId = hypervisorId;
        }

        @Override
        @Transient
        public final Builder hypervisorId(String hypervisorId) {
            this.hypervisorId = hypervisorId;
            return this;
        }

        public final Instant getLastBackupDate() {
            return lastBackupDate;
        }

        public final void setLastBackupDate(Instant lastBackupDate) {
            this.lastBackupDate = lastBackupDate;
        }

        @Override
        @Transient
        public final Builder lastBackupDate(Instant lastBackupDate) {
            this.lastBackupDate = lastBackupDate;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        @Transient
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        @Transient
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        @Override
        public VirtualMachine build() {
            return new VirtualMachine(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
