/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupgateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListHypervisorsResponse extends BackupGatewayResponse implements
        ToCopyableBuilder<ListHypervisorsResponse.Builder, ListHypervisorsResponse> {
    private static final SdkField<List<Hypervisor>> HYPERVISORS_FIELD = SdkField
            .<List<Hypervisor>> builder(MarshallingType.LIST)
            .memberName("Hypervisors")
            .getter(getter(ListHypervisorsResponse::hypervisors))
            .setter(setter(Builder::hypervisors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hypervisors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Hypervisor> builder(MarshallingType.SDK_POJO)
                                            .constructor(Hypervisor::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListHypervisorsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HYPERVISORS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Hypervisor> hypervisors;

    private final String nextToken;

    private ListHypervisorsResponse(BuilderImpl builder) {
        super(builder);
        this.hypervisors = builder.hypervisors;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Hypervisors property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHypervisors() {
        return hypervisors != null && !(hypervisors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of your <code>Hypervisor</code> objects, ordered by their Amazon Resource Names (ARNs).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHypervisors} method.
     * </p>
     * 
     * @return A list of your <code>Hypervisor</code> objects, ordered by their Amazon Resource Names (ARNs).
     */
    public final List<Hypervisor> hypervisors() {
        return hypervisors;
    }

    /**
     * <p>
     * The next item following a partial list of returned resources. For example, if a request is made to return
     * <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list
     * starting at the location pointed to by the next token.
     * </p>
     * 
     * @return The next item following a partial list of returned resources. For example, if a request is made to return
     *         <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more items in
     *         your list starting at the location pointed to by the next token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasHypervisors() ? hypervisors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHypervisorsResponse)) {
            return false;
        }
        ListHypervisorsResponse other = (ListHypervisorsResponse) obj;
        return hasHypervisors() == other.hasHypervisors() && Objects.equals(hypervisors(), other.hypervisors())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListHypervisorsResponse").add("Hypervisors", hasHypervisors() ? hypervisors() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Hypervisors":
            return Optional.ofNullable(clazz.cast(hypervisors()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListHypervisorsResponse, T> g) {
        return obj -> g.apply((ListHypervisorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListHypervisorsResponse> {
        /**
         * <p>
         * A list of your <code>Hypervisor</code> objects, ordered by their Amazon Resource Names (ARNs).
         * </p>
         * 
         * @param hypervisors
         *        A list of your <code>Hypervisor</code> objects, ordered by their Amazon Resource Names (ARNs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hypervisors(Collection<Hypervisor> hypervisors);

        /**
         * <p>
         * A list of your <code>Hypervisor</code> objects, ordered by their Amazon Resource Names (ARNs).
         * </p>
         * 
         * @param hypervisors
         *        A list of your <code>Hypervisor</code> objects, ordered by their Amazon Resource Names (ARNs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hypervisors(Hypervisor... hypervisors);

        /**
         * <p>
         * A list of your <code>Hypervisor</code> objects, ordered by their Amazon Resource Names (ARNs).
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Hypervisor>.Builder} avoiding the
         * need to create one manually via {@link List<Hypervisor>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Hypervisor>.Builder#build()} is called immediately and its
         * result is passed to {@link #hypervisors(List<Hypervisor>)}.
         * 
         * @param hypervisors
         *        a consumer that will call methods on {@link List<Hypervisor>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hypervisors(List<Hypervisor>)
         */
        Builder hypervisors(Consumer<Hypervisor.Builder>... hypervisors);

        /**
         * <p>
         * The next item following a partial list of returned resources. For example, if a request is made to return
         * <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your
         * list starting at the location pointed to by the next token.
         * </p>
         * 
         * @param nextToken
         *        The next item following a partial list of returned resources. For example, if a request is made to
         *        return <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more
         *        items in your list starting at the location pointed to by the next token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BackupGatewayResponse.BuilderImpl implements Builder {
        private List<Hypervisor> hypervisors = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHypervisorsResponse model) {
            super(model);
            hypervisors(model.hypervisors);
            nextToken(model.nextToken);
        }

        public final List<Hypervisor.Builder> getHypervisors() {
            List<Hypervisor.Builder> result = HypervisorsCopier.copyToBuilder(this.hypervisors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHypervisors(Collection<Hypervisor.BuilderImpl> hypervisors) {
            this.hypervisors = HypervisorsCopier.copyFromBuilder(hypervisors);
        }

        @Override
        public final Builder hypervisors(Collection<Hypervisor> hypervisors) {
            this.hypervisors = HypervisorsCopier.copy(hypervisors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hypervisors(Hypervisor... hypervisors) {
            hypervisors(Arrays.asList(hypervisors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hypervisors(Consumer<Hypervisor.Builder>... hypervisors) {
            hypervisors(Stream.of(hypervisors).map(c -> Hypervisor.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListHypervisorsResponse build() {
            return new ListHypervisorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
