/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupgateway;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.backupgateway.BackupGatewayAsyncClient;
import software.amazon.awssdk.services.backupgateway.BackupGatewayAsyncClientBuilder;
import software.amazon.awssdk.services.backupgateway.BackupGatewayServiceClientConfiguration;
import software.amazon.awssdk.services.backupgateway.DefaultBackupGatewayAsyncClient;
import software.amazon.awssdk.services.backupgateway.DefaultBackupGatewayBaseClientBuilder;
import software.amazon.awssdk.services.backupgateway.endpoints.BackupGatewayEndpointProvider;

@SdkInternalApi
final class DefaultBackupGatewayAsyncClientBuilder
extends DefaultBackupGatewayBaseClientBuilder<BackupGatewayAsyncClientBuilder, BackupGatewayAsyncClient>
implements BackupGatewayAsyncClientBuilder {
    DefaultBackupGatewayAsyncClientBuilder() {
    }

    @Override
    public DefaultBackupGatewayAsyncClientBuilder endpointProvider(BackupGatewayEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final BackupGatewayAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultBackupGatewayAsyncClientBuilder.validateClientOptions(clientConfiguration);
        BackupGatewayServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultBackupGatewayAsyncClient client = new DefaultBackupGatewayAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private BackupGatewayServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return BackupGatewayServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

