/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupgateway.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A gateway is an Backup Gateway appliance that runs on the customer's network to provide seamless connectivity to
 * backup storage in the Amazon Web Services Cloud.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Gateway implements SdkPojo, Serializable, ToCopyableBuilder<Gateway.Builder, Gateway> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayArn").getter(getter(Gateway::gatewayArn)).setter(setter(Builder::gatewayArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayArn").build()).build();

    private static final SdkField<String> GATEWAY_DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayDisplayName").getter(getter(Gateway::gatewayDisplayName))
            .setter(setter(Builder::gatewayDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayDisplayName").build())
            .build();

    private static final SdkField<String> GATEWAY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayType").getter(getter(Gateway::gatewayTypeAsString)).setter(setter(Builder::gatewayType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayType").build()).build();

    private static final SdkField<String> HYPERVISOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HypervisorId").getter(getter(Gateway::hypervisorId)).setter(setter(Builder::hypervisorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HypervisorId").build()).build();

    private static final SdkField<Instant> LAST_SEEN_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastSeenTime").getter(getter(Gateway::lastSeenTime)).setter(setter(Builder::lastSeenTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSeenTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            GATEWAY_DISPLAY_NAME_FIELD, GATEWAY_TYPE_FIELD, HYPERVISOR_ID_FIELD, LAST_SEEN_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String gatewayArn;

    private final String gatewayDisplayName;

    private final String gatewayType;

    private final String hypervisorId;

    private final Instant lastSeenTime;

    private Gateway(BuilderImpl builder) {
        this.gatewayArn = builder.gatewayArn;
        this.gatewayDisplayName = builder.gatewayDisplayName;
        this.gatewayType = builder.gatewayType;
        this.hypervisorId = builder.hypervisorId;
        this.lastSeenTime = builder.lastSeenTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list of
     * gateways for your account and Amazon Web Services Region.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a
     *         list of gateways for your account and Amazon Web Services Region.
     */
    public final String gatewayArn() {
        return gatewayArn;
    }

    /**
     * <p>
     * The display name of the gateway.
     * </p>
     * 
     * @return The display name of the gateway.
     */
    public final String gatewayDisplayName() {
        return gatewayDisplayName;
    }

    /**
     * <p>
     * The type of the gateway.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gatewayType} will
     * return {@link GatewayType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #gatewayTypeAsString}.
     * </p>
     * 
     * @return The type of the gateway.
     * @see GatewayType
     */
    public final GatewayType gatewayType() {
        return GatewayType.fromValue(gatewayType);
    }

    /**
     * <p>
     * The type of the gateway.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gatewayType} will
     * return {@link GatewayType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #gatewayTypeAsString}.
     * </p>
     * 
     * @return The type of the gateway.
     * @see GatewayType
     */
    public final String gatewayTypeAsString() {
        return gatewayType;
    }

    /**
     * <p>
     * The hypervisor ID of the gateway.
     * </p>
     * 
     * @return The hypervisor ID of the gateway.
     */
    public final String hypervisorId() {
        return hypervisorId;
    }

    /**
     * <p>
     * The last time Backup gateway communicated with the gateway, in Unix format and UTC time.
     * </p>
     * 
     * @return The last time Backup gateway communicated with the gateway, in Unix format and UTC time.
     */
    public final Instant lastSeenTime() {
        return lastSeenTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hypervisorId());
        hashCode = 31 * hashCode + Objects.hashCode(lastSeenTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Gateway)) {
            return false;
        }
        Gateway other = (Gateway) obj;
        return Objects.equals(gatewayArn(), other.gatewayArn())
                && Objects.equals(gatewayDisplayName(), other.gatewayDisplayName())
                && Objects.equals(gatewayTypeAsString(), other.gatewayTypeAsString())
                && Objects.equals(hypervisorId(), other.hypervisorId()) && Objects.equals(lastSeenTime(), other.lastSeenTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Gateway").add("GatewayArn", gatewayArn()).add("GatewayDisplayName", gatewayDisplayName())
                .add("GatewayType", gatewayTypeAsString()).add("HypervisorId", hypervisorId())
                .add("LastSeenTime", lastSeenTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayArn":
            return Optional.ofNullable(clazz.cast(gatewayArn()));
        case "GatewayDisplayName":
            return Optional.ofNullable(clazz.cast(gatewayDisplayName()));
        case "GatewayType":
            return Optional.ofNullable(clazz.cast(gatewayTypeAsString()));
        case "HypervisorId":
            return Optional.ofNullable(clazz.cast(hypervisorId()));
        case "LastSeenTime":
            return Optional.ofNullable(clazz.cast(lastSeenTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GatewayArn", GATEWAY_ARN_FIELD);
        map.put("GatewayDisplayName", GATEWAY_DISPLAY_NAME_FIELD);
        map.put("GatewayType", GATEWAY_TYPE_FIELD);
        map.put("HypervisorId", HYPERVISOR_ID_FIELD);
        map.put("LastSeenTime", LAST_SEEN_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Gateway, T> g) {
        return obj -> g.apply((Gateway) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Gateway> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a list
         * of gateways for your account and Amazon Web Services Region.
         * </p>
         * 
         * @param gatewayArn
         *        The Amazon Resource Name (ARN) of the gateway. Use the <code>ListGateways</code> operation to return a
         *        list of gateways for your account and Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayArn(String gatewayArn);

        /**
         * <p>
         * The display name of the gateway.
         * </p>
         * 
         * @param gatewayDisplayName
         *        The display name of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayDisplayName(String gatewayDisplayName);

        /**
         * <p>
         * The type of the gateway.
         * </p>
         * 
         * @param gatewayType
         *        The type of the gateway.
         * @see GatewayType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayType
         */
        Builder gatewayType(String gatewayType);

        /**
         * <p>
         * The type of the gateway.
         * </p>
         * 
         * @param gatewayType
         *        The type of the gateway.
         * @see GatewayType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayType
         */
        Builder gatewayType(GatewayType gatewayType);

        /**
         * <p>
         * The hypervisor ID of the gateway.
         * </p>
         * 
         * @param hypervisorId
         *        The hypervisor ID of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hypervisorId(String hypervisorId);

        /**
         * <p>
         * The last time Backup gateway communicated with the gateway, in Unix format and UTC time.
         * </p>
         * 
         * @param lastSeenTime
         *        The last time Backup gateway communicated with the gateway, in Unix format and UTC time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSeenTime(Instant lastSeenTime);
    }

    static final class BuilderImpl implements Builder {
        private String gatewayArn;

        private String gatewayDisplayName;

        private String gatewayType;

        private String hypervisorId;

        private Instant lastSeenTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Gateway model) {
            gatewayArn(model.gatewayArn);
            gatewayDisplayName(model.gatewayDisplayName);
            gatewayType(model.gatewayType);
            hypervisorId(model.hypervisorId);
            lastSeenTime(model.lastSeenTime);
        }

        public final String getGatewayArn() {
            return gatewayArn;
        }

        public final void setGatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
        }

        @Override
        public final Builder gatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
            return this;
        }

        public final String getGatewayDisplayName() {
            return gatewayDisplayName;
        }

        public final void setGatewayDisplayName(String gatewayDisplayName) {
            this.gatewayDisplayName = gatewayDisplayName;
        }

        @Override
        public final Builder gatewayDisplayName(String gatewayDisplayName) {
            this.gatewayDisplayName = gatewayDisplayName;
            return this;
        }

        public final String getGatewayType() {
            return gatewayType;
        }

        public final void setGatewayType(String gatewayType) {
            this.gatewayType = gatewayType;
        }

        @Override
        public final Builder gatewayType(String gatewayType) {
            this.gatewayType = gatewayType;
            return this;
        }

        @Override
        public final Builder gatewayType(GatewayType gatewayType) {
            this.gatewayType(gatewayType == null ? null : gatewayType.toString());
            return this;
        }

        public final String getHypervisorId() {
            return hypervisorId;
        }

        public final void setHypervisorId(String hypervisorId) {
            this.hypervisorId = hypervisorId;
        }

        @Override
        public final Builder hypervisorId(String hypervisorId) {
            this.hypervisorId = hypervisorId;
            return this;
        }

        public final Instant getLastSeenTime() {
            return lastSeenTime;
        }

        public final void setLastSeenTime(Instant lastSeenTime) {
            this.lastSeenTime = lastSeenTime;
        }

        @Override
        public final Builder lastSeenTime(Instant lastSeenTime) {
            this.lastSeenTime = lastSeenTime;
            return this;
        }

        @Override
        public Gateway build() {
            return new Gateway(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
