/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupgateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBandwidthRateLimitScheduleResponse extends BackupGatewayResponse implements
        ToCopyableBuilder<GetBandwidthRateLimitScheduleResponse.Builder, GetBandwidthRateLimitScheduleResponse> {
    private static final SdkField<List<BandwidthRateLimitInterval>> BANDWIDTH_RATE_LIMIT_INTERVALS_FIELD = SdkField
            .<List<BandwidthRateLimitInterval>> builder(MarshallingType.LIST)
            .memberName("BandwidthRateLimitIntervals")
            .getter(getter(GetBandwidthRateLimitScheduleResponse::bandwidthRateLimitIntervals))
            .setter(setter(Builder::bandwidthRateLimitIntervals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BandwidthRateLimitIntervals")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BandwidthRateLimitInterval> builder(MarshallingType.SDK_POJO)
                                            .constructor(BandwidthRateLimitInterval::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayArn").getter(getter(GetBandwidthRateLimitScheduleResponse::gatewayArn))
            .setter(setter(Builder::gatewayArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BANDWIDTH_RATE_LIMIT_INTERVALS_FIELD, GATEWAY_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<BandwidthRateLimitInterval> bandwidthRateLimitIntervals;

    private final String gatewayArn;

    private GetBandwidthRateLimitScheduleResponse(BuilderImpl builder) {
        super(builder);
        this.bandwidthRateLimitIntervals = builder.bandwidthRateLimitIntervals;
        this.gatewayArn = builder.gatewayArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the BandwidthRateLimitIntervals property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasBandwidthRateLimitIntervals() {
        return bandwidthRateLimitIntervals != null && !(bandwidthRateLimitIntervals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array containing bandwidth rate limit schedule intervals for a gateway. When no bandwidth rate limit intervals
     * have been scheduled, the array is empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBandwidthRateLimitIntervals} method.
     * </p>
     * 
     * @return An array containing bandwidth rate limit schedule intervals for a gateway. When no bandwidth rate limit
     *         intervals have been scheduled, the array is empty.
     */
    public final List<BandwidthRateLimitInterval> bandwidthRateLimitIntervals() {
        return bandwidthRateLimitIntervals;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the gateway. Use the <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_ListGateways.html">
     * <code>ListGateways</code> </a> operation to return a list of gateways for your account and Amazon Web Services
     * Region.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the gateway. Use the <a
     *         href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_ListGateways.html">
     *         <code>ListGateways</code> </a> operation to return a list of gateways for your account and Amazon Web
     *         Services Region.
     */
    public final String gatewayArn() {
        return gatewayArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBandwidthRateLimitIntervals() ? bandwidthRateLimitIntervals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(gatewayArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBandwidthRateLimitScheduleResponse)) {
            return false;
        }
        GetBandwidthRateLimitScheduleResponse other = (GetBandwidthRateLimitScheduleResponse) obj;
        return hasBandwidthRateLimitIntervals() == other.hasBandwidthRateLimitIntervals()
                && Objects.equals(bandwidthRateLimitIntervals(), other.bandwidthRateLimitIntervals())
                && Objects.equals(gatewayArn(), other.gatewayArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBandwidthRateLimitScheduleResponse")
                .add("BandwidthRateLimitIntervals", hasBandwidthRateLimitIntervals() ? bandwidthRateLimitIntervals() : null)
                .add("GatewayArn", gatewayArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BandwidthRateLimitIntervals":
            return Optional.ofNullable(clazz.cast(bandwidthRateLimitIntervals()));
        case "GatewayArn":
            return Optional.ofNullable(clazz.cast(gatewayArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BandwidthRateLimitIntervals", BANDWIDTH_RATE_LIMIT_INTERVALS_FIELD);
        map.put("GatewayArn", GATEWAY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBandwidthRateLimitScheduleResponse, T> g) {
        return obj -> g.apply((GetBandwidthRateLimitScheduleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetBandwidthRateLimitScheduleResponse> {
        /**
         * <p>
         * An array containing bandwidth rate limit schedule intervals for a gateway. When no bandwidth rate limit
         * intervals have been scheduled, the array is empty.
         * </p>
         * 
         * @param bandwidthRateLimitIntervals
         *        An array containing bandwidth rate limit schedule intervals for a gateway. When no bandwidth rate
         *        limit intervals have been scheduled, the array is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bandwidthRateLimitIntervals(Collection<BandwidthRateLimitInterval> bandwidthRateLimitIntervals);

        /**
         * <p>
         * An array containing bandwidth rate limit schedule intervals for a gateway. When no bandwidth rate limit
         * intervals have been scheduled, the array is empty.
         * </p>
         * 
         * @param bandwidthRateLimitIntervals
         *        An array containing bandwidth rate limit schedule intervals for a gateway. When no bandwidth rate
         *        limit intervals have been scheduled, the array is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bandwidthRateLimitIntervals(BandwidthRateLimitInterval... bandwidthRateLimitIntervals);

        /**
         * <p>
         * An array containing bandwidth rate limit schedule intervals for a gateway. When no bandwidth rate limit
         * intervals have been scheduled, the array is empty.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backupgateway.model.BandwidthRateLimitInterval.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.backupgateway.model.BandwidthRateLimitInterval#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backupgateway.model.BandwidthRateLimitInterval.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #bandwidthRateLimitIntervals(List<BandwidthRateLimitInterval>)}.
         * 
         * @param bandwidthRateLimitIntervals
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backupgateway.model.BandwidthRateLimitInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bandwidthRateLimitIntervals(java.util.Collection<BandwidthRateLimitInterval>)
         */
        Builder bandwidthRateLimitIntervals(Consumer<BandwidthRateLimitInterval.Builder>... bandwidthRateLimitIntervals);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the gateway. Use the <a
         * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_ListGateways.html">
         * <code>ListGateways</code> </a> operation to return a list of gateways for your account and Amazon Web
         * Services Region.
         * </p>
         * 
         * @param gatewayArn
         *        The Amazon Resource Name (ARN) of the gateway. Use the <a
         *        href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_ListGateways.html">
         *        <code>ListGateways</code> </a> operation to return a list of gateways for your account and Amazon Web
         *        Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayArn(String gatewayArn);
    }

    static final class BuilderImpl extends BackupGatewayResponse.BuilderImpl implements Builder {
        private List<BandwidthRateLimitInterval> bandwidthRateLimitIntervals = DefaultSdkAutoConstructList.getInstance();

        private String gatewayArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBandwidthRateLimitScheduleResponse model) {
            super(model);
            bandwidthRateLimitIntervals(model.bandwidthRateLimitIntervals);
            gatewayArn(model.gatewayArn);
        }

        public final List<BandwidthRateLimitInterval.Builder> getBandwidthRateLimitIntervals() {
            List<BandwidthRateLimitInterval.Builder> result = BandwidthRateLimitIntervalsCopier
                    .copyToBuilder(this.bandwidthRateLimitIntervals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBandwidthRateLimitIntervals(
                Collection<BandwidthRateLimitInterval.BuilderImpl> bandwidthRateLimitIntervals) {
            this.bandwidthRateLimitIntervals = BandwidthRateLimitIntervalsCopier.copyFromBuilder(bandwidthRateLimitIntervals);
        }

        @Override
        public final Builder bandwidthRateLimitIntervals(Collection<BandwidthRateLimitInterval> bandwidthRateLimitIntervals) {
            this.bandwidthRateLimitIntervals = BandwidthRateLimitIntervalsCopier.copy(bandwidthRateLimitIntervals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bandwidthRateLimitIntervals(BandwidthRateLimitInterval... bandwidthRateLimitIntervals) {
            bandwidthRateLimitIntervals(Arrays.asList(bandwidthRateLimitIntervals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bandwidthRateLimitIntervals(
                Consumer<BandwidthRateLimitInterval.Builder>... bandwidthRateLimitIntervals) {
            bandwidthRateLimitIntervals(Stream.of(bandwidthRateLimitIntervals)
                    .map(c -> BandwidthRateLimitInterval.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getGatewayArn() {
            return gatewayArn;
        }

        public final void setGatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
        }

        @Override
        public final Builder gatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
            return this;
        }

        @Override
        public GetBandwidthRateLimitScheduleResponse build() {
            return new GetBandwidthRateLimitScheduleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
