/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupgateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVirtualMachinesResponse extends BackupGatewayResponse implements
        ToCopyableBuilder<ListVirtualMachinesResponse.Builder, ListVirtualMachinesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListVirtualMachinesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<VirtualMachine>> VIRTUAL_MACHINES_FIELD = SdkField
            .<List<VirtualMachine>> builder(MarshallingType.LIST)
            .memberName("VirtualMachines")
            .getter(getter(ListVirtualMachinesResponse::virtualMachines))
            .setter(setter(Builder::virtualMachines))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualMachines").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VirtualMachine> builder(MarshallingType.SDK_POJO)
                                            .constructor(VirtualMachine::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            VIRTUAL_MACHINES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<VirtualMachine> virtualMachines;

    private ListVirtualMachinesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.virtualMachines = builder.virtualMachines;
    }

    /**
     * <p>
     * The next item following a partial list of returned resources. For example, if a request is made to return
     * <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your list
     * starting at the location pointed to by the next token.
     * </p>
     * 
     * @return The next item following a partial list of returned resources. For example, if a request is made to return
     *         <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more items in
     *         your list starting at the location pointed to by the next token.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the VirtualMachines property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVirtualMachines() {
        return virtualMachines != null && !(virtualMachines instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of your <code>VirtualMachine</code> objects, ordered by their Amazon Resource Names (ARNs).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVirtualMachines} method.
     * </p>
     * 
     * @return A list of your <code>VirtualMachine</code> objects, ordered by their Amazon Resource Names (ARNs).
     */
    public final List<VirtualMachine> virtualMachines() {
        return virtualMachines;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasVirtualMachines() ? virtualMachines() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVirtualMachinesResponse)) {
            return false;
        }
        ListVirtualMachinesResponse other = (ListVirtualMachinesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasVirtualMachines() == other.hasVirtualMachines()
                && Objects.equals(virtualMachines(), other.virtualMachines());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListVirtualMachinesResponse").add("NextToken", nextToken())
                .add("VirtualMachines", hasVirtualMachines() ? virtualMachines() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "VirtualMachines":
            return Optional.ofNullable(clazz.cast(virtualMachines()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("VirtualMachines", VIRTUAL_MACHINES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListVirtualMachinesResponse, T> g) {
        return obj -> g.apply((ListVirtualMachinesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListVirtualMachinesResponse> {
        /**
         * <p>
         * The next item following a partial list of returned resources. For example, if a request is made to return
         * <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more items in your
         * list starting at the location pointed to by the next token.
         * </p>
         * 
         * @param nextToken
         *        The next item following a partial list of returned resources. For example, if a request is made to
         *        return <code>maxResults</code> number of resources, <code>NextToken</code> allows you to return more
         *        items in your list starting at the location pointed to by the next token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of your <code>VirtualMachine</code> objects, ordered by their Amazon Resource Names (ARNs).
         * </p>
         * 
         * @param virtualMachines
         *        A list of your <code>VirtualMachine</code> objects, ordered by their Amazon Resource Names (ARNs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualMachines(Collection<VirtualMachine> virtualMachines);

        /**
         * <p>
         * A list of your <code>VirtualMachine</code> objects, ordered by their Amazon Resource Names (ARNs).
         * </p>
         * 
         * @param virtualMachines
         *        A list of your <code>VirtualMachine</code> objects, ordered by their Amazon Resource Names (ARNs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualMachines(VirtualMachine... virtualMachines);

        /**
         * <p>
         * A list of your <code>VirtualMachine</code> objects, ordered by their Amazon Resource Names (ARNs).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backupgateway.model.VirtualMachine.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.backupgateway.model.VirtualMachine#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backupgateway.model.VirtualMachine.Builder#build()} is called
         * immediately and its result is passed to {@link #virtualMachines(List<VirtualMachine>)}.
         * 
         * @param virtualMachines
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backupgateway.model.VirtualMachine.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #virtualMachines(java.util.Collection<VirtualMachine>)
         */
        Builder virtualMachines(Consumer<VirtualMachine.Builder>... virtualMachines);
    }

    static final class BuilderImpl extends BackupGatewayResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<VirtualMachine> virtualMachines = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVirtualMachinesResponse model) {
            super(model);
            nextToken(model.nextToken);
            virtualMachines(model.virtualMachines);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<VirtualMachine.Builder> getVirtualMachines() {
            List<VirtualMachine.Builder> result = VirtualMachinesCopier.copyToBuilder(this.virtualMachines);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVirtualMachines(Collection<VirtualMachine.BuilderImpl> virtualMachines) {
            this.virtualMachines = VirtualMachinesCopier.copyFromBuilder(virtualMachines);
        }

        @Override
        public final Builder virtualMachines(Collection<VirtualMachine> virtualMachines) {
            this.virtualMachines = VirtualMachinesCopier.copy(virtualMachines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualMachines(VirtualMachine... virtualMachines) {
            virtualMachines(Arrays.asList(virtualMachines));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualMachines(Consumer<VirtualMachine.Builder>... virtualMachines) {
            virtualMachines(Stream.of(virtualMachines).map(c -> VirtualMachine.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListVirtualMachinesResponse build() {
            return new ListVirtualMachinesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
