/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupgateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This is your gateway's weekly maintenance start time including the day and time of the week. Note that values are in
 * terms of the gateway's time zone. Can be weekly or monthly.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MaintenanceStartTime implements SdkPojo, Serializable,
        ToCopyableBuilder<MaintenanceStartTime.Builder, MaintenanceStartTime> {
    private static final SdkField<Integer> DAY_OF_MONTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DayOfMonth").getter(getter(MaintenanceStartTime::dayOfMonth)).setter(setter(Builder::dayOfMonth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DayOfMonth").build()).build();

    private static final SdkField<Integer> DAY_OF_WEEK_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DayOfWeek").getter(getter(MaintenanceStartTime::dayOfWeek)).setter(setter(Builder::dayOfWeek))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DayOfWeek").build()).build();

    private static final SdkField<Integer> HOUR_OF_DAY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("HourOfDay").getter(getter(MaintenanceStartTime::hourOfDay)).setter(setter(Builder::hourOfDay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HourOfDay").build()).build();

    private static final SdkField<Integer> MINUTE_OF_HOUR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinuteOfHour").getter(getter(MaintenanceStartTime::minuteOfHour)).setter(setter(Builder::minuteOfHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinuteOfHour").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAY_OF_MONTH_FIELD,
            DAY_OF_WEEK_FIELD, HOUR_OF_DAY_FIELD, MINUTE_OF_HOUR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer dayOfMonth;

    private final Integer dayOfWeek;

    private final Integer hourOfDay;

    private final Integer minuteOfHour;

    private MaintenanceStartTime(BuilderImpl builder) {
        this.dayOfMonth = builder.dayOfMonth;
        this.dayOfWeek = builder.dayOfWeek;
        this.hourOfDay = builder.hourOfDay;
        this.minuteOfHour = builder.minuteOfHour;
    }

    /**
     * <p>
     * The day of the month component of the maintenance start time represented as an ordinal number from 1 to 28, where
     * 1 represents the first day of the month and 28 represents the last day of the month.
     * </p>
     * 
     * @return The day of the month component of the maintenance start time represented as an ordinal number from 1 to
     *         28, where 1 represents the first day of the month and 28 represents the last day of the month.
     */
    public final Integer dayOfMonth() {
        return dayOfMonth;
    }

    /**
     * <p>
     * An ordinal number between 0 and 6 that represents the day of the week, where 0 represents Sunday and 6 represents
     * Saturday. The day of week is in the time zone of the gateway.
     * </p>
     * 
     * @return An ordinal number between 0 and 6 that represents the day of the week, where 0 represents Sunday and 6
     *         represents Saturday. The day of week is in the time zone of the gateway.
     */
    public final Integer dayOfWeek() {
        return dayOfWeek;
    }

    /**
     * <p>
     * The hour component of the maintenance start time represented as <i>hh</i>, where <i>hh</i> is the hour (0 to 23).
     * The hour of the day is in the time zone of the gateway.
     * </p>
     * 
     * @return The hour component of the maintenance start time represented as <i>hh</i>, where <i>hh</i> is the hour (0
     *         to 23). The hour of the day is in the time zone of the gateway.
     */
    public final Integer hourOfDay() {
        return hourOfDay;
    }

    /**
     * <p>
     * The minute component of the maintenance start time represented as <i>mm</i>, where <i>mm</i> is the minute (0 to
     * 59). The minute of the hour is in the time zone of the gateway.
     * </p>
     * 
     * @return The minute component of the maintenance start time represented as <i>mm</i>, where <i>mm</i> is the
     *         minute (0 to 59). The minute of the hour is in the time zone of the gateway.
     */
    public final Integer minuteOfHour() {
        return minuteOfHour;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dayOfMonth());
        hashCode = 31 * hashCode + Objects.hashCode(dayOfWeek());
        hashCode = 31 * hashCode + Objects.hashCode(hourOfDay());
        hashCode = 31 * hashCode + Objects.hashCode(minuteOfHour());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceStartTime)) {
            return false;
        }
        MaintenanceStartTime other = (MaintenanceStartTime) obj;
        return Objects.equals(dayOfMonth(), other.dayOfMonth()) && Objects.equals(dayOfWeek(), other.dayOfWeek())
                && Objects.equals(hourOfDay(), other.hourOfDay()) && Objects.equals(minuteOfHour(), other.minuteOfHour());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MaintenanceStartTime").add("DayOfMonth", dayOfMonth()).add("DayOfWeek", dayOfWeek())
                .add("HourOfDay", hourOfDay()).add("MinuteOfHour", minuteOfHour()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DayOfMonth":
            return Optional.ofNullable(clazz.cast(dayOfMonth()));
        case "DayOfWeek":
            return Optional.ofNullable(clazz.cast(dayOfWeek()));
        case "HourOfDay":
            return Optional.ofNullable(clazz.cast(hourOfDay()));
        case "MinuteOfHour":
            return Optional.ofNullable(clazz.cast(minuteOfHour()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DayOfMonth", DAY_OF_MONTH_FIELD);
        map.put("DayOfWeek", DAY_OF_WEEK_FIELD);
        map.put("HourOfDay", HOUR_OF_DAY_FIELD);
        map.put("MinuteOfHour", MINUTE_OF_HOUR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MaintenanceStartTime, T> g) {
        return obj -> g.apply((MaintenanceStartTime) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MaintenanceStartTime> {
        /**
         * <p>
         * The day of the month component of the maintenance start time represented as an ordinal number from 1 to 28,
         * where 1 represents the first day of the month and 28 represents the last day of the month.
         * </p>
         * 
         * @param dayOfMonth
         *        The day of the month component of the maintenance start time represented as an ordinal number from 1
         *        to 28, where 1 represents the first day of the month and 28 represents the last day of the month.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dayOfMonth(Integer dayOfMonth);

        /**
         * <p>
         * An ordinal number between 0 and 6 that represents the day of the week, where 0 represents Sunday and 6
         * represents Saturday. The day of week is in the time zone of the gateway.
         * </p>
         * 
         * @param dayOfWeek
         *        An ordinal number between 0 and 6 that represents the day of the week, where 0 represents Sunday and 6
         *        represents Saturday. The day of week is in the time zone of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dayOfWeek(Integer dayOfWeek);

        /**
         * <p>
         * The hour component of the maintenance start time represented as <i>hh</i>, where <i>hh</i> is the hour (0 to
         * 23). The hour of the day is in the time zone of the gateway.
         * </p>
         * 
         * @param hourOfDay
         *        The hour component of the maintenance start time represented as <i>hh</i>, where <i>hh</i> is the hour
         *        (0 to 23). The hour of the day is in the time zone of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hourOfDay(Integer hourOfDay);

        /**
         * <p>
         * The minute component of the maintenance start time represented as <i>mm</i>, where <i>mm</i> is the minute (0
         * to 59). The minute of the hour is in the time zone of the gateway.
         * </p>
         * 
         * @param minuteOfHour
         *        The minute component of the maintenance start time represented as <i>mm</i>, where <i>mm</i> is the
         *        minute (0 to 59). The minute of the hour is in the time zone of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minuteOfHour(Integer minuteOfHour);
    }

    static final class BuilderImpl implements Builder {
        private Integer dayOfMonth;

        private Integer dayOfWeek;

        private Integer hourOfDay;

        private Integer minuteOfHour;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceStartTime model) {
            dayOfMonth(model.dayOfMonth);
            dayOfWeek(model.dayOfWeek);
            hourOfDay(model.hourOfDay);
            minuteOfHour(model.minuteOfHour);
        }

        public final Integer getDayOfMonth() {
            return dayOfMonth;
        }

        public final void setDayOfMonth(Integer dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
        }

        @Override
        public final Builder dayOfMonth(Integer dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
            return this;
        }

        public final Integer getDayOfWeek() {
            return dayOfWeek;
        }

        public final void setDayOfWeek(Integer dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
        }

        @Override
        public final Builder dayOfWeek(Integer dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        public final Integer getHourOfDay() {
            return hourOfDay;
        }

        public final void setHourOfDay(Integer hourOfDay) {
            this.hourOfDay = hourOfDay;
        }

        @Override
        public final Builder hourOfDay(Integer hourOfDay) {
            this.hourOfDay = hourOfDay;
            return this;
        }

        public final Integer getMinuteOfHour() {
            return minuteOfHour;
        }

        public final void setMinuteOfHour(Integer minuteOfHour) {
            this.minuteOfHour = minuteOfHour;
        }

        @Override
        public final Builder minuteOfHour(Integer minuteOfHour) {
            this.minuteOfHour = minuteOfHour;
            return this;
        }

        @Override
        public MaintenanceStartTime build() {
            return new MaintenanceStartTime(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
