/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupgateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A VMware tag is a tag attached to a specific virtual machine. A <a
 * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_Tag.html">tag</a> is a key-value pair you can
 * use to manage, filter, and search for your resources.
 * </p>
 * <p>
 * The content of VMware tags can be matched to Amazon Web Services tags.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VmwareTag implements SdkPojo, Serializable, ToCopyableBuilder<VmwareTag.Builder, VmwareTag> {
    private static final SdkField<String> VMWARE_CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VmwareCategory").getter(getter(VmwareTag::vmwareCategory)).setter(setter(Builder::vmwareCategory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VmwareCategory").build()).build();

    private static final SdkField<String> VMWARE_TAG_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VmwareTagDescription").getter(getter(VmwareTag::vmwareTagDescription))
            .setter(setter(Builder::vmwareTagDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VmwareTagDescription").build())
            .build();

    private static final SdkField<String> VMWARE_TAG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VmwareTagName").getter(getter(VmwareTag::vmwareTagName)).setter(setter(Builder::vmwareTagName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VmwareTagName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VMWARE_CATEGORY_FIELD,
            VMWARE_TAG_DESCRIPTION_FIELD, VMWARE_TAG_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String vmwareCategory;

    private final String vmwareTagDescription;

    private final String vmwareTagName;

    private VmwareTag(BuilderImpl builder) {
        this.vmwareCategory = builder.vmwareCategory;
        this.vmwareTagDescription = builder.vmwareTagDescription;
        this.vmwareTagName = builder.vmwareTagName;
    }

    /**
     * <p>
     * The is the category of VMware.
     * </p>
     * 
     * @return The is the category of VMware.
     */
    public final String vmwareCategory() {
        return vmwareCategory;
    }

    /**
     * <p>
     * This is a user-defined description of a VMware tag.
     * </p>
     * 
     * @return This is a user-defined description of a VMware tag.
     */
    public final String vmwareTagDescription() {
        return vmwareTagDescription;
    }

    /**
     * <p>
     * This is the user-defined name of a VMware tag.
     * </p>
     * 
     * @return This is the user-defined name of a VMware tag.
     */
    public final String vmwareTagName() {
        return vmwareTagName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vmwareCategory());
        hashCode = 31 * hashCode + Objects.hashCode(vmwareTagDescription());
        hashCode = 31 * hashCode + Objects.hashCode(vmwareTagName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VmwareTag)) {
            return false;
        }
        VmwareTag other = (VmwareTag) obj;
        return Objects.equals(vmwareCategory(), other.vmwareCategory())
                && Objects.equals(vmwareTagDescription(), other.vmwareTagDescription())
                && Objects.equals(vmwareTagName(), other.vmwareTagName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VmwareTag").add("VmwareCategory", vmwareCategory())
                .add("VmwareTagDescription", vmwareTagDescription()).add("VmwareTagName", vmwareTagName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VmwareCategory":
            return Optional.ofNullable(clazz.cast(vmwareCategory()));
        case "VmwareTagDescription":
            return Optional.ofNullable(clazz.cast(vmwareTagDescription()));
        case "VmwareTagName":
            return Optional.ofNullable(clazz.cast(vmwareTagName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VmwareCategory", VMWARE_CATEGORY_FIELD);
        map.put("VmwareTagDescription", VMWARE_TAG_DESCRIPTION_FIELD);
        map.put("VmwareTagName", VMWARE_TAG_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VmwareTag, T> g) {
        return obj -> g.apply((VmwareTag) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VmwareTag> {
        /**
         * <p>
         * The is the category of VMware.
         * </p>
         * 
         * @param vmwareCategory
         *        The is the category of VMware.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vmwareCategory(String vmwareCategory);

        /**
         * <p>
         * This is a user-defined description of a VMware tag.
         * </p>
         * 
         * @param vmwareTagDescription
         *        This is a user-defined description of a VMware tag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vmwareTagDescription(String vmwareTagDescription);

        /**
         * <p>
         * This is the user-defined name of a VMware tag.
         * </p>
         * 
         * @param vmwareTagName
         *        This is the user-defined name of a VMware tag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vmwareTagName(String vmwareTagName);
    }

    static final class BuilderImpl implements Builder {
        private String vmwareCategory;

        private String vmwareTagDescription;

        private String vmwareTagName;

        private BuilderImpl() {
        }

        private BuilderImpl(VmwareTag model) {
            vmwareCategory(model.vmwareCategory);
            vmwareTagDescription(model.vmwareTagDescription);
            vmwareTagName(model.vmwareTagName);
        }

        public final String getVmwareCategory() {
            return vmwareCategory;
        }

        public final void setVmwareCategory(String vmwareCategory) {
            this.vmwareCategory = vmwareCategory;
        }

        @Override
        public final Builder vmwareCategory(String vmwareCategory) {
            this.vmwareCategory = vmwareCategory;
            return this;
        }

        public final String getVmwareTagDescription() {
            return vmwareTagDescription;
        }

        public final void setVmwareTagDescription(String vmwareTagDescription) {
            this.vmwareTagDescription = vmwareTagDescription;
        }

        @Override
        public final Builder vmwareTagDescription(String vmwareTagDescription) {
            this.vmwareTagDescription = vmwareTagDescription;
            return this;
        }

        public final String getVmwareTagName() {
            return vmwareTagName;
        }

        public final void setVmwareTagName(String vmwareTagName) {
            this.vmwareTagName = vmwareTagName;
        }

        @Override
        public final Builder vmwareTagName(String vmwareTagName) {
            this.vmwareTagName = vmwareTagName;
            return this;
        }

        @Override
        public VmwareTag build() {
            return new VmwareTag(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
