/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupgateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This displays the mapping of on-premises VMware tags to the corresponding Amazon Web Services tags.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VmwareToAwsTagMapping implements SdkPojo, Serializable,
        ToCopyableBuilder<VmwareToAwsTagMapping.Builder, VmwareToAwsTagMapping> {
    private static final SdkField<String> AWS_TAG_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsTagKey").getter(getter(VmwareToAwsTagMapping::awsTagKey)).setter(setter(Builder::awsTagKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsTagKey").build()).build();

    private static final SdkField<String> AWS_TAG_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsTagValue").getter(getter(VmwareToAwsTagMapping::awsTagValue)).setter(setter(Builder::awsTagValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsTagValue").build()).build();

    private static final SdkField<String> VMWARE_CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VmwareCategory").getter(getter(VmwareToAwsTagMapping::vmwareCategory))
            .setter(setter(Builder::vmwareCategory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VmwareCategory").build()).build();

    private static final SdkField<String> VMWARE_TAG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VmwareTagName").getter(getter(VmwareToAwsTagMapping::vmwareTagName))
            .setter(setter(Builder::vmwareTagName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VmwareTagName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_TAG_KEY_FIELD,
            AWS_TAG_VALUE_FIELD, VMWARE_CATEGORY_FIELD, VMWARE_TAG_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String awsTagKey;

    private final String awsTagValue;

    private final String vmwareCategory;

    private final String vmwareTagName;

    private VmwareToAwsTagMapping(BuilderImpl builder) {
        this.awsTagKey = builder.awsTagKey;
        this.awsTagValue = builder.awsTagValue;
        this.vmwareCategory = builder.vmwareCategory;
        this.vmwareTagName = builder.vmwareTagName;
    }

    /**
     * <p>
     * The key part of the Amazon Web Services tag's key-value pair.
     * </p>
     * 
     * @return The key part of the Amazon Web Services tag's key-value pair.
     */
    public final String awsTagKey() {
        return awsTagKey;
    }

    /**
     * <p>
     * The value part of the Amazon Web Services tag's key-value pair.
     * </p>
     * 
     * @return The value part of the Amazon Web Services tag's key-value pair.
     */
    public final String awsTagValue() {
        return awsTagValue;
    }

    /**
     * <p>
     * The is the category of VMware.
     * </p>
     * 
     * @return The is the category of VMware.
     */
    public final String vmwareCategory() {
        return vmwareCategory;
    }

    /**
     * <p>
     * This is the user-defined name of a VMware tag.
     * </p>
     * 
     * @return This is the user-defined name of a VMware tag.
     */
    public final String vmwareTagName() {
        return vmwareTagName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsTagKey());
        hashCode = 31 * hashCode + Objects.hashCode(awsTagValue());
        hashCode = 31 * hashCode + Objects.hashCode(vmwareCategory());
        hashCode = 31 * hashCode + Objects.hashCode(vmwareTagName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VmwareToAwsTagMapping)) {
            return false;
        }
        VmwareToAwsTagMapping other = (VmwareToAwsTagMapping) obj;
        return Objects.equals(awsTagKey(), other.awsTagKey()) && Objects.equals(awsTagValue(), other.awsTagValue())
                && Objects.equals(vmwareCategory(), other.vmwareCategory())
                && Objects.equals(vmwareTagName(), other.vmwareTagName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VmwareToAwsTagMapping").add("AwsTagKey", awsTagKey()).add("AwsTagValue", awsTagValue())
                .add("VmwareCategory", vmwareCategory()).add("VmwareTagName", vmwareTagName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsTagKey":
            return Optional.ofNullable(clazz.cast(awsTagKey()));
        case "AwsTagValue":
            return Optional.ofNullable(clazz.cast(awsTagValue()));
        case "VmwareCategory":
            return Optional.ofNullable(clazz.cast(vmwareCategory()));
        case "VmwareTagName":
            return Optional.ofNullable(clazz.cast(vmwareTagName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsTagKey", AWS_TAG_KEY_FIELD);
        map.put("AwsTagValue", AWS_TAG_VALUE_FIELD);
        map.put("VmwareCategory", VMWARE_CATEGORY_FIELD);
        map.put("VmwareTagName", VMWARE_TAG_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VmwareToAwsTagMapping, T> g) {
        return obj -> g.apply((VmwareToAwsTagMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VmwareToAwsTagMapping> {
        /**
         * <p>
         * The key part of the Amazon Web Services tag's key-value pair.
         * </p>
         * 
         * @param awsTagKey
         *        The key part of the Amazon Web Services tag's key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsTagKey(String awsTagKey);

        /**
         * <p>
         * The value part of the Amazon Web Services tag's key-value pair.
         * </p>
         * 
         * @param awsTagValue
         *        The value part of the Amazon Web Services tag's key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsTagValue(String awsTagValue);

        /**
         * <p>
         * The is the category of VMware.
         * </p>
         * 
         * @param vmwareCategory
         *        The is the category of VMware.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vmwareCategory(String vmwareCategory);

        /**
         * <p>
         * This is the user-defined name of a VMware tag.
         * </p>
         * 
         * @param vmwareTagName
         *        This is the user-defined name of a VMware tag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vmwareTagName(String vmwareTagName);
    }

    static final class BuilderImpl implements Builder {
        private String awsTagKey;

        private String awsTagValue;

        private String vmwareCategory;

        private String vmwareTagName;

        private BuilderImpl() {
        }

        private BuilderImpl(VmwareToAwsTagMapping model) {
            awsTagKey(model.awsTagKey);
            awsTagValue(model.awsTagValue);
            vmwareCategory(model.vmwareCategory);
            vmwareTagName(model.vmwareTagName);
        }

        public final String getAwsTagKey() {
            return awsTagKey;
        }

        public final void setAwsTagKey(String awsTagKey) {
            this.awsTagKey = awsTagKey;
        }

        @Override
        public final Builder awsTagKey(String awsTagKey) {
            this.awsTagKey = awsTagKey;
            return this;
        }

        public final String getAwsTagValue() {
            return awsTagValue;
        }

        public final void setAwsTagValue(String awsTagValue) {
            this.awsTagValue = awsTagValue;
        }

        @Override
        public final Builder awsTagValue(String awsTagValue) {
            this.awsTagValue = awsTagValue;
            return this;
        }

        public final String getVmwareCategory() {
            return vmwareCategory;
        }

        public final void setVmwareCategory(String vmwareCategory) {
            this.vmwareCategory = vmwareCategory;
        }

        @Override
        public final Builder vmwareCategory(String vmwareCategory) {
            this.vmwareCategory = vmwareCategory;
            return this;
        }

        public final String getVmwareTagName() {
            return vmwareTagName;
        }

        public final void setVmwareTagName(String vmwareTagName) {
            this.vmwareTagName = vmwareTagName;
        }

        @Override
        public final Builder vmwareTagName(String vmwareTagName) {
            this.vmwareTagName = vmwareTagName;
            return this;
        }

        @Override
        public VmwareToAwsTagMapping build() {
            return new VmwareToAwsTagMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
