/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupgateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backupgateway.model.BackupGatewayResponse;
import software.amazon.awssdk.services.backupgateway.model.BandwidthRateLimitInterval;
import software.amazon.awssdk.services.backupgateway.model.BandwidthRateLimitIntervalsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBandwidthRateLimitScheduleResponse
extends BackupGatewayResponse
implements ToCopyableBuilder<Builder, GetBandwidthRateLimitScheduleResponse> {
    private static final SdkField<List<BandwidthRateLimitInterval>> BANDWIDTH_RATE_LIMIT_INTERVALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BandwidthRateLimitIntervals").getter(GetBandwidthRateLimitScheduleResponse.getter(GetBandwidthRateLimitScheduleResponse::bandwidthRateLimitIntervals)).setter(GetBandwidthRateLimitScheduleResponse.setter(Builder::bandwidthRateLimitIntervals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BandwidthRateLimitIntervals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BandwidthRateLimitInterval::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayArn").getter(GetBandwidthRateLimitScheduleResponse.getter(GetBandwidthRateLimitScheduleResponse::gatewayArn)).setter(GetBandwidthRateLimitScheduleResponse.setter(Builder::gatewayArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BANDWIDTH_RATE_LIMIT_INTERVALS_FIELD, GATEWAY_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetBandwidthRateLimitScheduleResponse.memberNameToFieldInitializer();
    private final List<BandwidthRateLimitInterval> bandwidthRateLimitIntervals;
    private final String gatewayArn;

    private GetBandwidthRateLimitScheduleResponse(BuilderImpl builder) {
        super(builder);
        this.bandwidthRateLimitIntervals = builder.bandwidthRateLimitIntervals;
        this.gatewayArn = builder.gatewayArn;
    }

    public final boolean hasBandwidthRateLimitIntervals() {
        return this.bandwidthRateLimitIntervals != null && !(this.bandwidthRateLimitIntervals instanceof SdkAutoConstructList);
    }

    public final List<BandwidthRateLimitInterval> bandwidthRateLimitIntervals() {
        return this.bandwidthRateLimitIntervals;
    }

    public final String gatewayArn() {
        return this.gatewayArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBandwidthRateLimitIntervals() ? this.bandwidthRateLimitIntervals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBandwidthRateLimitScheduleResponse)) {
            return false;
        }
        GetBandwidthRateLimitScheduleResponse other = (GetBandwidthRateLimitScheduleResponse)((Object)obj);
        return this.hasBandwidthRateLimitIntervals() == other.hasBandwidthRateLimitIntervals() && Objects.equals(this.bandwidthRateLimitIntervals(), other.bandwidthRateLimitIntervals()) && Objects.equals(this.gatewayArn(), other.gatewayArn());
    }

    public final String toString() {
        return ToString.builder((String)"GetBandwidthRateLimitScheduleResponse").add("BandwidthRateLimitIntervals", this.hasBandwidthRateLimitIntervals() ? this.bandwidthRateLimitIntervals() : null).add("GatewayArn", (Object)this.gatewayArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BandwidthRateLimitIntervals": {
                return Optional.ofNullable(clazz.cast(this.bandwidthRateLimitIntervals()));
            }
            case "GatewayArn": {
                return Optional.ofNullable(clazz.cast(this.gatewayArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BandwidthRateLimitIntervals", BANDWIDTH_RATE_LIMIT_INTERVALS_FIELD);
        map.put("GatewayArn", GATEWAY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBandwidthRateLimitScheduleResponse, T> g) {
        return obj -> g.apply((GetBandwidthRateLimitScheduleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupGatewayResponse.BuilderImpl
    implements Builder {
        private List<BandwidthRateLimitInterval> bandwidthRateLimitIntervals = DefaultSdkAutoConstructList.getInstance();
        private String gatewayArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBandwidthRateLimitScheduleResponse model) {
            super(model);
            this.bandwidthRateLimitIntervals(model.bandwidthRateLimitIntervals);
            this.gatewayArn(model.gatewayArn);
        }

        public final List<BandwidthRateLimitInterval.Builder> getBandwidthRateLimitIntervals() {
            List<BandwidthRateLimitInterval.Builder> result = BandwidthRateLimitIntervalsCopier.copyToBuilder(this.bandwidthRateLimitIntervals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBandwidthRateLimitIntervals(Collection<BandwidthRateLimitInterval.BuilderImpl> bandwidthRateLimitIntervals) {
            this.bandwidthRateLimitIntervals = BandwidthRateLimitIntervalsCopier.copyFromBuilder(bandwidthRateLimitIntervals);
        }

        @Override
        public final Builder bandwidthRateLimitIntervals(Collection<BandwidthRateLimitInterval> bandwidthRateLimitIntervals) {
            this.bandwidthRateLimitIntervals = BandwidthRateLimitIntervalsCopier.copy(bandwidthRateLimitIntervals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bandwidthRateLimitIntervals(BandwidthRateLimitInterval ... bandwidthRateLimitIntervals) {
            this.bandwidthRateLimitIntervals(Arrays.asList(bandwidthRateLimitIntervals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bandwidthRateLimitIntervals(Consumer<BandwidthRateLimitInterval.Builder> ... bandwidthRateLimitIntervals) {
            this.bandwidthRateLimitIntervals(Stream.of(bandwidthRateLimitIntervals).map(c -> (BandwidthRateLimitInterval)((BandwidthRateLimitInterval.Builder)BandwidthRateLimitInterval.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getGatewayArn() {
            return this.gatewayArn;
        }

        public final void setGatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
        }

        @Override
        public final Builder gatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
            return this;
        }

        @Override
        public GetBandwidthRateLimitScheduleResponse build() {
            return new GetBandwidthRateLimitScheduleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BackupGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBandwidthRateLimitScheduleResponse> {
        public Builder bandwidthRateLimitIntervals(Collection<BandwidthRateLimitInterval> var1);

        public Builder bandwidthRateLimitIntervals(BandwidthRateLimitInterval ... var1);

        public Builder bandwidthRateLimitIntervals(Consumer<BandwidthRateLimitInterval.Builder> ... var1);

        public Builder gatewayArn(String var1);
    }
}

