/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupgateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportHypervisorConfigurationRequest extends BackupGatewayRequest implements
        ToCopyableBuilder<ImportHypervisorConfigurationRequest.Builder, ImportHypervisorConfigurationRequest> {
    private static final SdkField<String> HOST_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Host")
            .getter(getter(ImportHypervisorConfigurationRequest::host)).setter(setter(Builder::host))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Host").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn").getter(getter(ImportHypervisorConfigurationRequest::kmsKeyArn))
            .setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ImportHypervisorConfigurationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Password").getter(getter(ImportHypervisorConfigurationRequest::password))
            .setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ImportHypervisorConfigurationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(ImportHypervisorConfigurationRequest::username))
            .setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_FIELD, KMS_KEY_ARN_FIELD,
            NAME_FIELD, PASSWORD_FIELD, TAGS_FIELD, USERNAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String host;

    private final String kmsKeyArn;

    private final String name;

    private final String password;

    private final List<Tag> tags;

    private final String username;

    private ImportHypervisorConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.host = builder.host;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.name = builder.name;
        this.password = builder.password;
        this.tags = builder.tags;
        this.username = builder.username;
    }

    /**
     * <p>
     * The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name (FQDN).
     * </p>
     * 
     * @return The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name
     *         (FQDN).
     */
    public final String host() {
        return host;
    }

    /**
     * <p>
     * The Key Management Service for the hypervisor.
     * </p>
     * 
     * @return The Key Management Service for the hypervisor.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * The name of the hypervisor.
     * </p>
     * 
     * @return The name of the hypervisor.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The password for the hypervisor.
     * </p>
     * 
     * @return The password for the hypervisor.
     */
    public final String password() {
        return password;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags of the hypervisor configuration to import.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags of the hypervisor configuration to import.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The username for the hypervisor.
     * </p>
     * 
     * @return The username for the hypervisor.
     */
    public final String username() {
        return username;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(host());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(username());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportHypervisorConfigurationRequest)) {
            return false;
        }
        ImportHypervisorConfigurationRequest other = (ImportHypervisorConfigurationRequest) obj;
        return Objects.equals(host(), other.host()) && Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && Objects.equals(name(), other.name()) && Objects.equals(password(), other.password())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(username(), other.username());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportHypervisorConfigurationRequest").add("Host", host()).add("KmsKeyArn", kmsKeyArn())
                .add("Name", name()).add("Password", password() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Tags", hasTags() ? tags() : null)
                .add("Username", username() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Host":
            return Optional.ofNullable(clazz.cast(host()));
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Host", HOST_FIELD);
        map.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Password", PASSWORD_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("Username", USERNAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportHypervisorConfigurationRequest, T> g) {
        return obj -> g.apply((ImportHypervisorConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BackupGatewayRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ImportHypervisorConfigurationRequest> {
        /**
         * <p>
         * The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name (FQDN).
         * </p>
         * 
         * @param host
         *        The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name
         *        (FQDN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder host(String host);

        /**
         * <p>
         * The Key Management Service for the hypervisor.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Key Management Service for the hypervisor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The name of the hypervisor.
         * </p>
         * 
         * @param name
         *        The name of the hypervisor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The password for the hypervisor.
         * </p>
         * 
         * @param password
         *        The password for the hypervisor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * The tags of the hypervisor configuration to import.
         * </p>
         * 
         * @param tags
         *        The tags of the hypervisor configuration to import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags of the hypervisor configuration to import.
         * </p>
         * 
         * @param tags
         *        The tags of the hypervisor configuration to import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags of the hypervisor configuration to import.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backupgateway.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.backupgateway.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backupgateway.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backupgateway.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The username for the hypervisor.
         * </p>
         * 
         * @param username
         *        The username for the hypervisor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupGatewayRequest.BuilderImpl implements Builder {
        private String host;

        private String kmsKeyArn;

        private String name;

        private String password;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportHypervisorConfigurationRequest model) {
            super(model);
            host(model.host);
            kmsKeyArn(model.kmsKeyArn);
            name(model.name);
            password(model.password);
            tags(model.tags);
            username(model.username);
        }

        public final String getHost() {
            return host;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        @Override
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPassword() {
            return password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportHypervisorConfigurationRequest build() {
            return new ImportHypervisorConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
