/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupgateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutHypervisorPropertyMappingsRequest extends BackupGatewayRequest implements
        ToCopyableBuilder<PutHypervisorPropertyMappingsRequest.Builder, PutHypervisorPropertyMappingsRequest> {
    private static final SdkField<String> HYPERVISOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HypervisorArn").getter(getter(PutHypervisorPropertyMappingsRequest::hypervisorArn))
            .setter(setter(Builder::hypervisorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HypervisorArn").build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRoleArn").getter(getter(PutHypervisorPropertyMappingsRequest::iamRoleArn))
            .setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<List<VmwareToAwsTagMapping>> VMWARE_TO_AWS_TAG_MAPPINGS_FIELD = SdkField
            .<List<VmwareToAwsTagMapping>> builder(MarshallingType.LIST)
            .memberName("VmwareToAwsTagMappings")
            .getter(getter(PutHypervisorPropertyMappingsRequest::vmwareToAwsTagMappings))
            .setter(setter(Builder::vmwareToAwsTagMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VmwareToAwsTagMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VmwareToAwsTagMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(VmwareToAwsTagMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HYPERVISOR_ARN_FIELD,
            IAM_ROLE_ARN_FIELD, VMWARE_TO_AWS_TAG_MAPPINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String hypervisorArn;

    private final String iamRoleArn;

    private final List<VmwareToAwsTagMapping> vmwareToAwsTagMappings;

    private PutHypervisorPropertyMappingsRequest(BuilderImpl builder) {
        super(builder);
        this.hypervisorArn = builder.hypervisorArn;
        this.iamRoleArn = builder.iamRoleArn;
        this.vmwareToAwsTagMappings = builder.vmwareToAwsTagMappings;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the hypervisor.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the hypervisor.
     */
    public final String hypervisorArn() {
        return hypervisorArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the VmwareToAwsTagMappings property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasVmwareToAwsTagMappings() {
        return vmwareToAwsTagMappings != null && !(vmwareToAwsTagMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This action requests the mappings of on-premises VMware tags to the Amazon Web Services tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVmwareToAwsTagMappings} method.
     * </p>
     * 
     * @return This action requests the mappings of on-premises VMware tags to the Amazon Web Services tags.
     */
    public final List<VmwareToAwsTagMapping> vmwareToAwsTagMappings() {
        return vmwareToAwsTagMappings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hypervisorArn());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasVmwareToAwsTagMappings() ? vmwareToAwsTagMappings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutHypervisorPropertyMappingsRequest)) {
            return false;
        }
        PutHypervisorPropertyMappingsRequest other = (PutHypervisorPropertyMappingsRequest) obj;
        return Objects.equals(hypervisorArn(), other.hypervisorArn()) && Objects.equals(iamRoleArn(), other.iamRoleArn())
                && hasVmwareToAwsTagMappings() == other.hasVmwareToAwsTagMappings()
                && Objects.equals(vmwareToAwsTagMappings(), other.vmwareToAwsTagMappings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutHypervisorPropertyMappingsRequest").add("HypervisorArn", hypervisorArn())
                .add("IamRoleArn", iamRoleArn())
                .add("VmwareToAwsTagMappings", hasVmwareToAwsTagMappings() ? vmwareToAwsTagMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HypervisorArn":
            return Optional.ofNullable(clazz.cast(hypervisorArn()));
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "VmwareToAwsTagMappings":
            return Optional.ofNullable(clazz.cast(vmwareToAwsTagMappings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HypervisorArn", HYPERVISOR_ARN_FIELD);
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("VmwareToAwsTagMappings", VMWARE_TO_AWS_TAG_MAPPINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutHypervisorPropertyMappingsRequest, T> g) {
        return obj -> g.apply((PutHypervisorPropertyMappingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BackupGatewayRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutHypervisorPropertyMappingsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the hypervisor.
         * </p>
         * 
         * @param hypervisorArn
         *        The Amazon Resource Name (ARN) of the hypervisor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hypervisorArn(String hypervisorArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role.
         * </p>
         * 
         * @param iamRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * This action requests the mappings of on-premises VMware tags to the Amazon Web Services tags.
         * </p>
         * 
         * @param vmwareToAwsTagMappings
         *        This action requests the mappings of on-premises VMware tags to the Amazon Web Services tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vmwareToAwsTagMappings(Collection<VmwareToAwsTagMapping> vmwareToAwsTagMappings);

        /**
         * <p>
         * This action requests the mappings of on-premises VMware tags to the Amazon Web Services tags.
         * </p>
         * 
         * @param vmwareToAwsTagMappings
         *        This action requests the mappings of on-premises VMware tags to the Amazon Web Services tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vmwareToAwsTagMappings(VmwareToAwsTagMapping... vmwareToAwsTagMappings);

        /**
         * <p>
         * This action requests the mappings of on-premises VMware tags to the Amazon Web Services tags.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backupgateway.model.VmwareToAwsTagMapping.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.backupgateway.model.VmwareToAwsTagMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backupgateway.model.VmwareToAwsTagMapping.Builder#build()} is called
         * immediately and its result is passed to {@link #vmwareToAwsTagMappings(List<VmwareToAwsTagMapping>)}.
         * 
         * @param vmwareToAwsTagMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backupgateway.model.VmwareToAwsTagMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vmwareToAwsTagMappings(java.util.Collection<VmwareToAwsTagMapping>)
         */
        Builder vmwareToAwsTagMappings(Consumer<VmwareToAwsTagMapping.Builder>... vmwareToAwsTagMappings);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupGatewayRequest.BuilderImpl implements Builder {
        private String hypervisorArn;

        private String iamRoleArn;

        private List<VmwareToAwsTagMapping> vmwareToAwsTagMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutHypervisorPropertyMappingsRequest model) {
            super(model);
            hypervisorArn(model.hypervisorArn);
            iamRoleArn(model.iamRoleArn);
            vmwareToAwsTagMappings(model.vmwareToAwsTagMappings);
        }

        public final String getHypervisorArn() {
            return hypervisorArn;
        }

        public final void setHypervisorArn(String hypervisorArn) {
            this.hypervisorArn = hypervisorArn;
        }

        @Override
        public final Builder hypervisorArn(String hypervisorArn) {
            this.hypervisorArn = hypervisorArn;
            return this;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final List<VmwareToAwsTagMapping.Builder> getVmwareToAwsTagMappings() {
            List<VmwareToAwsTagMapping.Builder> result = VmwareToAwsTagMappingsCopier.copyToBuilder(this.vmwareToAwsTagMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVmwareToAwsTagMappings(Collection<VmwareToAwsTagMapping.BuilderImpl> vmwareToAwsTagMappings) {
            this.vmwareToAwsTagMappings = VmwareToAwsTagMappingsCopier.copyFromBuilder(vmwareToAwsTagMappings);
        }

        @Override
        public final Builder vmwareToAwsTagMappings(Collection<VmwareToAwsTagMapping> vmwareToAwsTagMappings) {
            this.vmwareToAwsTagMappings = VmwareToAwsTagMappingsCopier.copy(vmwareToAwsTagMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vmwareToAwsTagMappings(VmwareToAwsTagMapping... vmwareToAwsTagMappings) {
            vmwareToAwsTagMappings(Arrays.asList(vmwareToAwsTagMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vmwareToAwsTagMappings(Consumer<VmwareToAwsTagMapping.Builder>... vmwareToAwsTagMappings) {
            vmwareToAwsTagMappings(Stream.of(vmwareToAwsTagMappings)
                    .map(c -> VmwareToAwsTagMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutHypervisorPropertyMappingsRequest build() {
            return new PutHypervisorPropertyMappingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
