/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupgateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetVirtualMachineResponse extends BackupGatewayResponse implements
        ToCopyableBuilder<GetVirtualMachineResponse.Builder, GetVirtualMachineResponse> {
    private static final SdkField<VirtualMachineDetails> VIRTUAL_MACHINE_FIELD = SdkField
            .<VirtualMachineDetails> builder(MarshallingType.SDK_POJO).memberName("VirtualMachine")
            .getter(getter(GetVirtualMachineResponse::virtualMachine)).setter(setter(Builder::virtualMachine))
            .constructor(VirtualMachineDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualMachine").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_MACHINE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final VirtualMachineDetails virtualMachine;

    private GetVirtualMachineResponse(BuilderImpl builder) {
        super(builder);
        this.virtualMachine = builder.virtualMachine;
    }

    /**
     * <p>
     * This object contains the basic attributes of <code>VirtualMachine</code> contained by the output of
     * <code>GetVirtualMachine</code>
     * </p>
     * 
     * @return This object contains the basic attributes of <code>VirtualMachine</code> contained by the output of
     *         <code>GetVirtualMachine</code>
     */
    public final VirtualMachineDetails virtualMachine() {
        return virtualMachine;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(virtualMachine());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVirtualMachineResponse)) {
            return false;
        }
        GetVirtualMachineResponse other = (GetVirtualMachineResponse) obj;
        return Objects.equals(virtualMachine(), other.virtualMachine());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetVirtualMachineResponse").add("VirtualMachine", virtualMachine()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VirtualMachine":
            return Optional.ofNullable(clazz.cast(virtualMachine()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VirtualMachine", VIRTUAL_MACHINE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetVirtualMachineResponse, T> g) {
        return obj -> g.apply((GetVirtualMachineResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BackupGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetVirtualMachineResponse> {
        /**
         * <p>
         * This object contains the basic attributes of <code>VirtualMachine</code> contained by the output of
         * <code>GetVirtualMachine</code>
         * </p>
         * 
         * @param virtualMachine
         *        This object contains the basic attributes of <code>VirtualMachine</code> contained by the output of
         *        <code>GetVirtualMachine</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualMachine(VirtualMachineDetails virtualMachine);

        /**
         * <p>
         * This object contains the basic attributes of <code>VirtualMachine</code> contained by the output of
         * <code>GetVirtualMachine</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link VirtualMachineDetails.Builder} avoiding
         * the need to create one manually via {@link VirtualMachineDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VirtualMachineDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #virtualMachine(VirtualMachineDetails)}.
         * 
         * @param virtualMachine
         *        a consumer that will call methods on {@link VirtualMachineDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #virtualMachine(VirtualMachineDetails)
         */
        default Builder virtualMachine(Consumer<VirtualMachineDetails.Builder> virtualMachine) {
            return virtualMachine(VirtualMachineDetails.builder().applyMutation(virtualMachine).build());
        }
    }

    static final class BuilderImpl extends BackupGatewayResponse.BuilderImpl implements Builder {
        private VirtualMachineDetails virtualMachine;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVirtualMachineResponse model) {
            super(model);
            virtualMachine(model.virtualMachine);
        }

        public final VirtualMachineDetails.Builder getVirtualMachine() {
            return virtualMachine != null ? virtualMachine.toBuilder() : null;
        }

        public final void setVirtualMachine(VirtualMachineDetails.BuilderImpl virtualMachine) {
            this.virtualMachine = virtualMachine != null ? virtualMachine.build() : null;
        }

        @Override
        public final Builder virtualMachine(VirtualMachineDetails virtualMachine) {
            this.virtualMachine = virtualMachine;
            return this;
        }

        @Override
        public GetVirtualMachineResponse build() {
            return new GetVirtualMachineResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
