/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupgateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the hypervisor's permissions to which the gateway will connect.
 * </p>
 * <p>
 * A hypervisor is hardware, software, or firmware that creates and manages virtual machines, and allocates resources to
 * them.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Hypervisor implements SdkPojo, Serializable, ToCopyableBuilder<Hypervisor.Builder, Hypervisor> {
    private static final SdkField<String> HOST_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Host")
            .getter(getter(Hypervisor::host)).setter(setter(Builder::host))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Host").build()).build();

    private static final SdkField<String> HYPERVISOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HypervisorArn").getter(getter(Hypervisor::hypervisorArn)).setter(setter(Builder::hypervisorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HypervisorArn").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn").getter(getter(Hypervisor::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Hypervisor::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(Hypervisor::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_FIELD,
            HYPERVISOR_ARN_FIELD, KMS_KEY_ARN_FIELD, NAME_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String host;

    private final String hypervisorArn;

    private final String kmsKeyArn;

    private final String name;

    private final String state;

    private Hypervisor(BuilderImpl builder) {
        this.host = builder.host;
        this.hypervisorArn = builder.hypervisorArn;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.name = builder.name;
        this.state = builder.state;
    }

    /**
     * <p>
     * The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name (FQDN).
     * </p>
     * 
     * @return The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name
     *         (FQDN).
     */
    public final String host() {
        return host;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the hypervisor.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the hypervisor.
     */
    public final String hypervisorArn() {
        return hypervisorArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Key Management Service used to encrypt the hypervisor.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Key Management Service used to encrypt the hypervisor.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * The name of the hypervisor.
     * </p>
     * 
     * @return The name of the hypervisor.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The state of the hypervisor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link HypervisorState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the hypervisor.
     * @see HypervisorState
     */
    public final HypervisorState state() {
        return HypervisorState.fromValue(state);
    }

    /**
     * <p>
     * The state of the hypervisor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link HypervisorState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the hypervisor.
     * @see HypervisorState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(host());
        hashCode = 31 * hashCode + Objects.hashCode(hypervisorArn());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Hypervisor)) {
            return false;
        }
        Hypervisor other = (Hypervisor) obj;
        return Objects.equals(host(), other.host()) && Objects.equals(hypervisorArn(), other.hypervisorArn())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(name(), other.name())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Hypervisor").add("Host", host()).add("HypervisorArn", hypervisorArn())
                .add("KmsKeyArn", kmsKeyArn()).add("Name", name()).add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Host":
            return Optional.ofNullable(clazz.cast(host()));
        case "HypervisorArn":
            return Optional.ofNullable(clazz.cast(hypervisorArn()));
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Host", HOST_FIELD);
        map.put("HypervisorArn", HYPERVISOR_ARN_FIELD);
        map.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Hypervisor, T> g) {
        return obj -> g.apply((Hypervisor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Hypervisor> {
        /**
         * <p>
         * The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name (FQDN).
         * </p>
         * 
         * @param host
         *        The server host of the hypervisor. This can be either an IP address or a fully-qualified domain name
         *        (FQDN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder host(String host);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the hypervisor.
         * </p>
         * 
         * @param hypervisorArn
         *        The Amazon Resource Name (ARN) of the hypervisor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hypervisorArn(String hypervisorArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Key Management Service used to encrypt the hypervisor.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of the Key Management Service used to encrypt the hypervisor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The name of the hypervisor.
         * </p>
         * 
         * @param name
         *        The name of the hypervisor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The state of the hypervisor.
         * </p>
         * 
         * @param state
         *        The state of the hypervisor.
         * @see HypervisorState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HypervisorState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the hypervisor.
         * </p>
         * 
         * @param state
         *        The state of the hypervisor.
         * @see HypervisorState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HypervisorState
         */
        Builder state(HypervisorState state);
    }

    static final class BuilderImpl implements Builder {
        private String host;

        private String hypervisorArn;

        private String kmsKeyArn;

        private String name;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(Hypervisor model) {
            host(model.host);
            hypervisorArn(model.hypervisorArn);
            kmsKeyArn(model.kmsKeyArn);
            name(model.name);
            state(model.state);
        }

        public final String getHost() {
            return host;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        @Override
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final String getHypervisorArn() {
            return hypervisorArn;
        }

        public final void setHypervisorArn(String hypervisorArn) {
            this.hypervisorArn = hypervisorArn;
        }

        @Override
        public final Builder hypervisorArn(String hypervisorArn) {
            this.hypervisorArn = hypervisorArn;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(HypervisorState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public Hypervisor build() {
            return new Hypervisor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
