/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupgateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutMaintenanceStartTimeRequest extends BackupGatewayRequest implements
        ToCopyableBuilder<PutMaintenanceStartTimeRequest.Builder, PutMaintenanceStartTimeRequest> {
    private static final SdkField<Integer> DAY_OF_MONTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DayOfMonth").getter(getter(PutMaintenanceStartTimeRequest::dayOfMonth))
            .setter(setter(Builder::dayOfMonth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DayOfMonth").build()).build();

    private static final SdkField<Integer> DAY_OF_WEEK_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DayOfWeek").getter(getter(PutMaintenanceStartTimeRequest::dayOfWeek)).setter(setter(Builder::dayOfWeek))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DayOfWeek").build()).build();

    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayArn").getter(getter(PutMaintenanceStartTimeRequest::gatewayArn))
            .setter(setter(Builder::gatewayArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayArn").build()).build();

    private static final SdkField<Integer> HOUR_OF_DAY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("HourOfDay").getter(getter(PutMaintenanceStartTimeRequest::hourOfDay)).setter(setter(Builder::hourOfDay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HourOfDay").build()).build();

    private static final SdkField<Integer> MINUTE_OF_HOUR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinuteOfHour").getter(getter(PutMaintenanceStartTimeRequest::minuteOfHour))
            .setter(setter(Builder::minuteOfHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinuteOfHour").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAY_OF_MONTH_FIELD,
            DAY_OF_WEEK_FIELD, GATEWAY_ARN_FIELD, HOUR_OF_DAY_FIELD, MINUTE_OF_HOUR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer dayOfMonth;

    private final Integer dayOfWeek;

    private final String gatewayArn;

    private final Integer hourOfDay;

    private final Integer minuteOfHour;

    private PutMaintenanceStartTimeRequest(BuilderImpl builder) {
        super(builder);
        this.dayOfMonth = builder.dayOfMonth;
        this.dayOfWeek = builder.dayOfWeek;
        this.gatewayArn = builder.gatewayArn;
        this.hourOfDay = builder.hourOfDay;
        this.minuteOfHour = builder.minuteOfHour;
    }

    /**
     * <p>
     * The day of the month start maintenance on a gateway.
     * </p>
     * <p>
     * Valid values range from <code>Sunday</code> to <code>Saturday</code>.
     * </p>
     * 
     * @return The day of the month start maintenance on a gateway.</p>
     *         <p>
     *         Valid values range from <code>Sunday</code> to <code>Saturday</code>.
     */
    public final Integer dayOfMonth() {
        return dayOfMonth;
    }

    /**
     * <p>
     * The day of the week to start maintenance on a gateway.
     * </p>
     * 
     * @return The day of the week to start maintenance on a gateway.
     */
    public final Integer dayOfWeek() {
        return dayOfWeek;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the gateway, used to specify its maintenance start time.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the gateway, used to specify its maintenance start time.
     */
    public final String gatewayArn() {
        return gatewayArn;
    }

    /**
     * <p>
     * The hour of the day to start maintenance on a gateway.
     * </p>
     * 
     * @return The hour of the day to start maintenance on a gateway.
     */
    public final Integer hourOfDay() {
        return hourOfDay;
    }

    /**
     * <p>
     * The minute of the hour to start maintenance on a gateway.
     * </p>
     * 
     * @return The minute of the hour to start maintenance on a gateway.
     */
    public final Integer minuteOfHour() {
        return minuteOfHour;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dayOfMonth());
        hashCode = 31 * hashCode + Objects.hashCode(dayOfWeek());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(hourOfDay());
        hashCode = 31 * hashCode + Objects.hashCode(minuteOfHour());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMaintenanceStartTimeRequest)) {
            return false;
        }
        PutMaintenanceStartTimeRequest other = (PutMaintenanceStartTimeRequest) obj;
        return Objects.equals(dayOfMonth(), other.dayOfMonth()) && Objects.equals(dayOfWeek(), other.dayOfWeek())
                && Objects.equals(gatewayArn(), other.gatewayArn()) && Objects.equals(hourOfDay(), other.hourOfDay())
                && Objects.equals(minuteOfHour(), other.minuteOfHour());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutMaintenanceStartTimeRequest").add("DayOfMonth", dayOfMonth()).add("DayOfWeek", dayOfWeek())
                .add("GatewayArn", gatewayArn()).add("HourOfDay", hourOfDay()).add("MinuteOfHour", minuteOfHour()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DayOfMonth":
            return Optional.ofNullable(clazz.cast(dayOfMonth()));
        case "DayOfWeek":
            return Optional.ofNullable(clazz.cast(dayOfWeek()));
        case "GatewayArn":
            return Optional.ofNullable(clazz.cast(gatewayArn()));
        case "HourOfDay":
            return Optional.ofNullable(clazz.cast(hourOfDay()));
        case "MinuteOfHour":
            return Optional.ofNullable(clazz.cast(minuteOfHour()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DayOfMonth", DAY_OF_MONTH_FIELD);
        map.put("DayOfWeek", DAY_OF_WEEK_FIELD);
        map.put("GatewayArn", GATEWAY_ARN_FIELD);
        map.put("HourOfDay", HOUR_OF_DAY_FIELD);
        map.put("MinuteOfHour", MINUTE_OF_HOUR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutMaintenanceStartTimeRequest, T> g) {
        return obj -> g.apply((PutMaintenanceStartTimeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BackupGatewayRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutMaintenanceStartTimeRequest> {
        /**
         * <p>
         * The day of the month start maintenance on a gateway.
         * </p>
         * <p>
         * Valid values range from <code>Sunday</code> to <code>Saturday</code>.
         * </p>
         * 
         * @param dayOfMonth
         *        The day of the month start maintenance on a gateway.</p>
         *        <p>
         *        Valid values range from <code>Sunday</code> to <code>Saturday</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dayOfMonth(Integer dayOfMonth);

        /**
         * <p>
         * The day of the week to start maintenance on a gateway.
         * </p>
         * 
         * @param dayOfWeek
         *        The day of the week to start maintenance on a gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dayOfWeek(Integer dayOfWeek);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the gateway, used to specify its maintenance start time.
         * </p>
         * 
         * @param gatewayArn
         *        The Amazon Resource Name (ARN) for the gateway, used to specify its maintenance start time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayArn(String gatewayArn);

        /**
         * <p>
         * The hour of the day to start maintenance on a gateway.
         * </p>
         * 
         * @param hourOfDay
         *        The hour of the day to start maintenance on a gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hourOfDay(Integer hourOfDay);

        /**
         * <p>
         * The minute of the hour to start maintenance on a gateway.
         * </p>
         * 
         * @param minuteOfHour
         *        The minute of the hour to start maintenance on a gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minuteOfHour(Integer minuteOfHour);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupGatewayRequest.BuilderImpl implements Builder {
        private Integer dayOfMonth;

        private Integer dayOfWeek;

        private String gatewayArn;

        private Integer hourOfDay;

        private Integer minuteOfHour;

        private BuilderImpl() {
        }

        private BuilderImpl(PutMaintenanceStartTimeRequest model) {
            super(model);
            dayOfMonth(model.dayOfMonth);
            dayOfWeek(model.dayOfWeek);
            gatewayArn(model.gatewayArn);
            hourOfDay(model.hourOfDay);
            minuteOfHour(model.minuteOfHour);
        }

        public final Integer getDayOfMonth() {
            return dayOfMonth;
        }

        public final void setDayOfMonth(Integer dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
        }

        @Override
        public final Builder dayOfMonth(Integer dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
            return this;
        }

        public final Integer getDayOfWeek() {
            return dayOfWeek;
        }

        public final void setDayOfWeek(Integer dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
        }

        @Override
        public final Builder dayOfWeek(Integer dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        public final String getGatewayArn() {
            return gatewayArn;
        }

        public final void setGatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
        }

        @Override
        public final Builder gatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
            return this;
        }

        public final Integer getHourOfDay() {
            return hourOfDay;
        }

        public final void setHourOfDay(Integer hourOfDay) {
            this.hourOfDay = hourOfDay;
        }

        @Override
        public final Builder hourOfDay(Integer hourOfDay) {
            this.hourOfDay = hourOfDay;
            return this;
        }

        public final Integer getMinuteOfHour() {
            return minuteOfHour;
        }

        public final void setMinuteOfHour(Integer minuteOfHour) {
            this.minuteOfHour = minuteOfHour;
        }

        @Override
        public final Builder minuteOfHour(Integer minuteOfHour) {
            this.minuteOfHour = minuteOfHour;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutMaintenanceStartTimeRequest build() {
            return new PutMaintenanceStartTimeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
