/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupsearch;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.backupsearch.model.GetSearchJobRequest;
import software.amazon.awssdk.services.backupsearch.model.GetSearchJobResponse;
import software.amazon.awssdk.services.backupsearch.model.GetSearchResultExportJobRequest;
import software.amazon.awssdk.services.backupsearch.model.GetSearchResultExportJobResponse;
import software.amazon.awssdk.services.backupsearch.model.ListSearchJobBackupsRequest;
import software.amazon.awssdk.services.backupsearch.model.ListSearchJobBackupsResponse;
import software.amazon.awssdk.services.backupsearch.model.ListSearchJobResultsRequest;
import software.amazon.awssdk.services.backupsearch.model.ListSearchJobResultsResponse;
import software.amazon.awssdk.services.backupsearch.model.ListSearchJobsRequest;
import software.amazon.awssdk.services.backupsearch.model.ListSearchJobsResponse;
import software.amazon.awssdk.services.backupsearch.model.ListSearchResultExportJobsRequest;
import software.amazon.awssdk.services.backupsearch.model.ListSearchResultExportJobsResponse;
import software.amazon.awssdk.services.backupsearch.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.backupsearch.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.backupsearch.model.StartSearchJobRequest;
import software.amazon.awssdk.services.backupsearch.model.StartSearchJobResponse;
import software.amazon.awssdk.services.backupsearch.model.StartSearchResultExportJobRequest;
import software.amazon.awssdk.services.backupsearch.model.StartSearchResultExportJobResponse;
import software.amazon.awssdk.services.backupsearch.model.StopSearchJobRequest;
import software.amazon.awssdk.services.backupsearch.model.StopSearchJobResponse;
import software.amazon.awssdk.services.backupsearch.model.TagResourceRequest;
import software.amazon.awssdk.services.backupsearch.model.TagResourceResponse;
import software.amazon.awssdk.services.backupsearch.model.UntagResourceRequest;
import software.amazon.awssdk.services.backupsearch.model.UntagResourceResponse;
import software.amazon.awssdk.services.backupsearch.paginators.ListSearchJobBackupsPublisher;
import software.amazon.awssdk.services.backupsearch.paginators.ListSearchJobResultsPublisher;
import software.amazon.awssdk.services.backupsearch.paginators.ListSearchJobsPublisher;
import software.amazon.awssdk.services.backupsearch.paginators.ListSearchResultExportJobsPublisher;

/**
 * Service client for accessing AWS Backup Search asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * <fullname>Backup Search</fullname>
 * <p>
 * Backup Search is the recovery point and item level search for Backup.
 * </p>
 * <p>
 * For additional information, see:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/api-reference.html">Backup API Reference</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html">Backup Developer Guide</a>
 * </p>
 * </li>
 * </ul>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface BackupSearchAsyncClient extends AwsClient {
    String SERVICE_NAME = "backup-search";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "backup-search";

    /**
     * <p>
     * This operation retrieves metadata of a search job, including its progress.
     * </p>
     *
     * @param getSearchJobRequest
     * @return A Java Future containing the result of the GetSearchJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found for this request.</p>
     *         <p>
     *         Confirm the resource information, such as the ARN or type is correct and exists, then retry the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupSearchAsyncClient.GetSearchJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/GetSearchJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSearchJobResponse> getSearchJob(GetSearchJobRequest getSearchJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation retrieves metadata of a search job, including its progress.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSearchJobRequest.Builder} avoiding the need to
     * create one manually via {@link GetSearchJobRequest#builder()}
     * </p>
     *
     * @param getSearchJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backupsearch.model.GetSearchJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSearchJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found for this request.</p>
     *         <p>
     *         Confirm the resource information, such as the ARN or type is correct and exists, then retry the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupSearchAsyncClient.GetSearchJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/GetSearchJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSearchJobResponse> getSearchJob(Consumer<GetSearchJobRequest.Builder> getSearchJobRequest) {
        return getSearchJob(GetSearchJobRequest.builder().applyMutation(getSearchJobRequest).build());
    }

    /**
     * <p>
     * This operation retrieves the metadata of an export job.
     * </p>
     * <p>
     * An export job is an operation that transmits the results of a search job to a specified S3 bucket in a .csv file.
     * </p>
     * <p>
     * An export job allows you to retain results of a search beyond the search job's scheduled retention of 7 days.
     * </p>
     *
     * @param getSearchResultExportJobRequest
     * @return A Java Future containing the result of the GetSearchResultExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found for this request.</p>
     *         <p>
     *         Confirm the resource information, such as the ARN or type is correct and exists, then retry the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupSearchAsyncClient.GetSearchResultExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/GetSearchResultExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSearchResultExportJobResponse> getSearchResultExportJob(
            GetSearchResultExportJobRequest getSearchResultExportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation retrieves the metadata of an export job.
     * </p>
     * <p>
     * An export job is an operation that transmits the results of a search job to a specified S3 bucket in a .csv file.
     * </p>
     * <p>
     * An export job allows you to retain results of a search beyond the search job's scheduled retention of 7 days.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSearchResultExportJobRequest.Builder} avoiding
     * the need to create one manually via {@link GetSearchResultExportJobRequest#builder()}
     * </p>
     *
     * @param getSearchResultExportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backupsearch.model.GetSearchResultExportJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetSearchResultExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found for this request.</p>
     *         <p>
     *         Confirm the resource information, such as the ARN or type is correct and exists, then retry the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupSearchAsyncClient.GetSearchResultExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/GetSearchResultExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSearchResultExportJobResponse> getSearchResultExportJob(
            Consumer<GetSearchResultExportJobRequest.Builder> getSearchResultExportJobRequest) {
        return getSearchResultExportJob(GetSearchResultExportJobRequest.builder().applyMutation(getSearchResultExportJobRequest)
                .build());
    }

    /**
     * <p>
     * This operation returns a list of all backups (recovery points) in a paginated format that were included in the
     * search job.
     * </p>
     * <p>
     * If a search does not display an expected backup in the results, you can call this operation to display each
     * backup included in the search. Any backups that were not included because they have a <code>FAILED</code> status
     * from a permissions issue will be displayed, along with a status message.
     * </p>
     * <p>
     * Only recovery points with a backup index that has a status of <code>ACTIVE</code> will be included in search
     * results. If the index has any other status, its status will be displayed along with a status message.
     * </p>
     *
     * @param listSearchJobBackupsRequest
     * @return A Java Future containing the result of the ListSearchJobBackups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found for this request.</p>
     *         <p>
     *         Confirm the resource information, such as the ARN or type is correct and exists, then retry the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupSearchAsyncClient.ListSearchJobBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/ListSearchJobBackups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSearchJobBackupsResponse> listSearchJobBackups(
            ListSearchJobBackupsRequest listSearchJobBackupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation returns a list of all backups (recovery points) in a paginated format that were included in the
     * search job.
     * </p>
     * <p>
     * If a search does not display an expected backup in the results, you can call this operation to display each
     * backup included in the search. Any backups that were not included because they have a <code>FAILED</code> status
     * from a permissions issue will be displayed, along with a status message.
     * </p>
     * <p>
     * Only recovery points with a backup index that has a status of <code>ACTIVE</code> will be included in search
     * results. If the index has any other status, its status will be displayed along with a status message.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSearchJobBackupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSearchJobBackupsRequest#builder()}
     * </p>
     *
     * @param listSearchJobBackupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backupsearch.model.ListSearchJobBackupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSearchJobBackups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found for this request.</p>
     *         <p>
     *         Confirm the resource information, such as the ARN or type is correct and exists, then retry the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupSearchAsyncClient.ListSearchJobBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/ListSearchJobBackups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSearchJobBackupsResponse> listSearchJobBackups(
            Consumer<ListSearchJobBackupsRequest.Builder> listSearchJobBackupsRequest) {
        return listSearchJobBackups(ListSearchJobBackupsRequest.builder().applyMutation(listSearchJobBackupsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSearchJobBackups(software.amazon.awssdk.services.backupsearch.model.ListSearchJobBackupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupsearch.paginators.ListSearchJobBackupsPublisher publisher = client.listSearchJobBackupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupsearch.paginators.ListSearchJobBackupsPublisher publisher = client.listSearchJobBackupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backupsearch.model.ListSearchJobBackupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backupsearch.model.ListSearchJobBackupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSearchJobBackups(software.amazon.awssdk.services.backupsearch.model.ListSearchJobBackupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSearchJobBackupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found for this request.</p>
     *         <p>
     *         Confirm the resource information, such as the ARN or type is correct and exists, then retry the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupSearchAsyncClient.ListSearchJobBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/ListSearchJobBackups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSearchJobBackupsPublisher listSearchJobBackupsPaginator(ListSearchJobBackupsRequest listSearchJobBackupsRequest) {
        return new ListSearchJobBackupsPublisher(this, listSearchJobBackupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSearchJobBackups(software.amazon.awssdk.services.backupsearch.model.ListSearchJobBackupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupsearch.paginators.ListSearchJobBackupsPublisher publisher = client.listSearchJobBackupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupsearch.paginators.ListSearchJobBackupsPublisher publisher = client.listSearchJobBackupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backupsearch.model.ListSearchJobBackupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backupsearch.model.ListSearchJobBackupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSearchJobBackups(software.amazon.awssdk.services.backupsearch.model.ListSearchJobBackupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSearchJobBackupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSearchJobBackupsRequest#builder()}
     * </p>
     *
     * @param listSearchJobBackupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backupsearch.model.ListSearchJobBackupsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found for this request.</p>
     *         <p>
     *         Confirm the resource information, such as the ARN or type is correct and exists, then retry the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupSearchAsyncClient.ListSearchJobBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/ListSearchJobBackups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSearchJobBackupsPublisher listSearchJobBackupsPaginator(
            Consumer<ListSearchJobBackupsRequest.Builder> listSearchJobBackupsRequest) {
        return listSearchJobBackupsPaginator(ListSearchJobBackupsRequest.builder().applyMutation(listSearchJobBackupsRequest)
                .build());
    }

    /**
     * <p>
     * This operation returns a list of a specified search job.
     * </p>
     *
     * @param listSearchJobResultsRequest
     * @return A Java Future containing the result of the ListSearchJobResults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found for this request.</p>
     *         <p>
     *         Confirm the resource information, such as the ARN or type is correct and exists, then retry the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupSearchAsyncClient.ListSearchJobResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/ListSearchJobResults"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSearchJobResultsResponse> listSearchJobResults(
            ListSearchJobResultsRequest listSearchJobResultsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation returns a list of a specified search job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSearchJobResultsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSearchJobResultsRequest#builder()}
     * </p>
     *
     * @param listSearchJobResultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backupsearch.model.ListSearchJobResultsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSearchJobResults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found for this request.</p>
     *         <p>
     *         Confirm the resource information, such as the ARN or type is correct and exists, then retry the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupSearchAsyncClient.ListSearchJobResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/ListSearchJobResults"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSearchJobResultsResponse> listSearchJobResults(
            Consumer<ListSearchJobResultsRequest.Builder> listSearchJobResultsRequest) {
        return listSearchJobResults(ListSearchJobResultsRequest.builder().applyMutation(listSearchJobResultsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSearchJobResults(software.amazon.awssdk.services.backupsearch.model.ListSearchJobResultsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupsearch.paginators.ListSearchJobResultsPublisher publisher = client.listSearchJobResultsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupsearch.paginators.ListSearchJobResultsPublisher publisher = client.listSearchJobResultsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backupsearch.model.ListSearchJobResultsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backupsearch.model.ListSearchJobResultsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSearchJobResults(software.amazon.awssdk.services.backupsearch.model.ListSearchJobResultsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSearchJobResultsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found for this request.</p>
     *         <p>
     *         Confirm the resource information, such as the ARN or type is correct and exists, then retry the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupSearchAsyncClient.ListSearchJobResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/ListSearchJobResults"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSearchJobResultsPublisher listSearchJobResultsPaginator(ListSearchJobResultsRequest listSearchJobResultsRequest) {
        return new ListSearchJobResultsPublisher(this, listSearchJobResultsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSearchJobResults(software.amazon.awssdk.services.backupsearch.model.ListSearchJobResultsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupsearch.paginators.ListSearchJobResultsPublisher publisher = client.listSearchJobResultsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupsearch.paginators.ListSearchJobResultsPublisher publisher = client.listSearchJobResultsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backupsearch.model.ListSearchJobResultsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backupsearch.model.ListSearchJobResultsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSearchJobResults(software.amazon.awssdk.services.backupsearch.model.ListSearchJobResultsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSearchJobResultsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSearchJobResultsRequest#builder()}
     * </p>
     *
     * @param listSearchJobResultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backupsearch.model.ListSearchJobResultsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found for this request.</p>
     *         <p>
     *         Confirm the resource information, such as the ARN or type is correct and exists, then retry the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupSearchAsyncClient.ListSearchJobResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/ListSearchJobResults"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSearchJobResultsPublisher listSearchJobResultsPaginator(
            Consumer<ListSearchJobResultsRequest.Builder> listSearchJobResultsRequest) {
        return listSearchJobResultsPaginator(ListSearchJobResultsRequest.builder().applyMutation(listSearchJobResultsRequest)
                .build());
    }

    /**
     * <p>
     * This operation returns a list of search jobs belonging to an account.
     * </p>
     *
     * @param listSearchJobsRequest
     * @return A Java Future containing the result of the ListSearchJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupSearchAsyncClient.ListSearchJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/ListSearchJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSearchJobsResponse> listSearchJobs(ListSearchJobsRequest listSearchJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation returns a list of search jobs belonging to an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSearchJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSearchJobsRequest#builder()}
     * </p>
     *
     * @param listSearchJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backupsearch.model.ListSearchJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSearchJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupSearchAsyncClient.ListSearchJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/ListSearchJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSearchJobsResponse> listSearchJobs(Consumer<ListSearchJobsRequest.Builder> listSearchJobsRequest) {
        return listSearchJobs(ListSearchJobsRequest.builder().applyMutation(listSearchJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSearchJobs(software.amazon.awssdk.services.backupsearch.model.ListSearchJobsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupsearch.paginators.ListSearchJobsPublisher publisher = client.listSearchJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupsearch.paginators.ListSearchJobsPublisher publisher = client.listSearchJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backupsearch.model.ListSearchJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backupsearch.model.ListSearchJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSearchJobs(software.amazon.awssdk.services.backupsearch.model.ListSearchJobsRequest)} operation.</b>
     * </p>
     *
     * @param listSearchJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupSearchAsyncClient.ListSearchJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/ListSearchJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSearchJobsPublisher listSearchJobsPaginator(ListSearchJobsRequest listSearchJobsRequest) {
        return new ListSearchJobsPublisher(this, listSearchJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSearchJobs(software.amazon.awssdk.services.backupsearch.model.ListSearchJobsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupsearch.paginators.ListSearchJobsPublisher publisher = client.listSearchJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupsearch.paginators.ListSearchJobsPublisher publisher = client.listSearchJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backupsearch.model.ListSearchJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backupsearch.model.ListSearchJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSearchJobs(software.amazon.awssdk.services.backupsearch.model.ListSearchJobsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSearchJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSearchJobsRequest#builder()}
     * </p>
     *
     * @param listSearchJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backupsearch.model.ListSearchJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupSearchAsyncClient.ListSearchJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/ListSearchJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSearchJobsPublisher listSearchJobsPaginator(Consumer<ListSearchJobsRequest.Builder> listSearchJobsRequest) {
        return listSearchJobsPaginator(ListSearchJobsRequest.builder().applyMutation(listSearchJobsRequest).build());
    }

    /**
     * <p>
     * This operation exports search results of a search job to a specified destination S3 bucket.
     * </p>
     *
     * @param listSearchResultExportJobsRequest
     * @return A Java Future containing the result of the ListSearchResultExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found for this request.</p>
     *         <p>
     *         Confirm the resource information, such as the ARN or type is correct and exists, then retry the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceQuotaExceededException The request denied due to exceeding the quota limits permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupSearchAsyncClient.ListSearchResultExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/ListSearchResultExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSearchResultExportJobsResponse> listSearchResultExportJobs(
            ListSearchResultExportJobsRequest listSearchResultExportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation exports search results of a search job to a specified destination S3 bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSearchResultExportJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSearchResultExportJobsRequest#builder()}
     * </p>
     *
     * @param listSearchResultExportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backupsearch.model.ListSearchResultExportJobsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListSearchResultExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found for this request.</p>
     *         <p>
     *         Confirm the resource information, such as the ARN or type is correct and exists, then retry the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceQuotaExceededException The request denied due to exceeding the quota limits permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupSearchAsyncClient.ListSearchResultExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/ListSearchResultExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSearchResultExportJobsResponse> listSearchResultExportJobs(
            Consumer<ListSearchResultExportJobsRequest.Builder> listSearchResultExportJobsRequest) {
        return listSearchResultExportJobs(ListSearchResultExportJobsRequest.builder()
                .applyMutation(listSearchResultExportJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSearchResultExportJobs(software.amazon.awssdk.services.backupsearch.model.ListSearchResultExportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupsearch.paginators.ListSearchResultExportJobsPublisher publisher = client.listSearchResultExportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupsearch.paginators.ListSearchResultExportJobsPublisher publisher = client.listSearchResultExportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backupsearch.model.ListSearchResultExportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backupsearch.model.ListSearchResultExportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSearchResultExportJobs(software.amazon.awssdk.services.backupsearch.model.ListSearchResultExportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSearchResultExportJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found for this request.</p>
     *         <p>
     *         Confirm the resource information, such as the ARN or type is correct and exists, then retry the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceQuotaExceededException The request denied due to exceeding the quota limits permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupSearchAsyncClient.ListSearchResultExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/ListSearchResultExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSearchResultExportJobsPublisher listSearchResultExportJobsPaginator(
            ListSearchResultExportJobsRequest listSearchResultExportJobsRequest) {
        return new ListSearchResultExportJobsPublisher(this, listSearchResultExportJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSearchResultExportJobs(software.amazon.awssdk.services.backupsearch.model.ListSearchResultExportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupsearch.paginators.ListSearchResultExportJobsPublisher publisher = client.listSearchResultExportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.backupsearch.paginators.ListSearchResultExportJobsPublisher publisher = client.listSearchResultExportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.backupsearch.model.ListSearchResultExportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.backupsearch.model.ListSearchResultExportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSearchResultExportJobs(software.amazon.awssdk.services.backupsearch.model.ListSearchResultExportJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSearchResultExportJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSearchResultExportJobsRequest#builder()}
     * </p>
     *
     * @param listSearchResultExportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backupsearch.model.ListSearchResultExportJobsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found for this request.</p>
     *         <p>
     *         Confirm the resource information, such as the ARN or type is correct and exists, then retry the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceQuotaExceededException The request denied due to exceeding the quota limits permitted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupSearchAsyncClient.ListSearchResultExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/ListSearchResultExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSearchResultExportJobsPublisher listSearchResultExportJobsPaginator(
            Consumer<ListSearchResultExportJobsRequest.Builder> listSearchResultExportJobsRequest) {
        return listSearchResultExportJobsPaginator(ListSearchResultExportJobsRequest.builder()
                .applyMutation(listSearchResultExportJobsRequest).build());
    }

    /**
     * <p>
     * This operation returns the tags for a resource type.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found for this request.</p>
     *         <p>
     *         Confirm the resource information, such as the ARN or type is correct and exists, then retry the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupSearchAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation returns the tags for a resource type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backupsearch.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found for this request.</p>
     *         <p>
     *         Confirm the resource information, such as the ARN or type is correct and exists, then retry the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupSearchAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * This operation creates a search job which returns recovery points filtered by SearchScope and items filtered by
     * ItemFilters.
     * </p>
     * <p>
     * You can optionally include ClientToken, EncryptionKeyArn, Name, and/or Tags.
     * </p>
     *
     * @param startSearchJobRequest
     * @return A Java Future containing the result of the StartSearchJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceQuotaExceededException The request denied due to exceeding the quota limits permitted.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful operation is
     *         detected. This generally occurs when the previous operation did not have time to propagate to the host
     *         serving the current request.</p>
     *         <p>
     *         A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupSearchAsyncClient.StartSearchJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/StartSearchJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartSearchJobResponse> startSearchJob(StartSearchJobRequest startSearchJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation creates a search job which returns recovery points filtered by SearchScope and items filtered by
     * ItemFilters.
     * </p>
     * <p>
     * You can optionally include ClientToken, EncryptionKeyArn, Name, and/or Tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartSearchJobRequest.Builder} avoiding the need to
     * create one manually via {@link StartSearchJobRequest#builder()}
     * </p>
     *
     * @param startSearchJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backupsearch.model.StartSearchJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartSearchJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceQuotaExceededException The request denied due to exceeding the quota limits permitted.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful operation is
     *         detected. This generally occurs when the previous operation did not have time to propagate to the host
     *         serving the current request.</p>
     *         <p>
     *         A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupSearchAsyncClient.StartSearchJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/StartSearchJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartSearchJobResponse> startSearchJob(Consumer<StartSearchJobRequest.Builder> startSearchJobRequest) {
        return startSearchJob(StartSearchJobRequest.builder().applyMutation(startSearchJobRequest).build());
    }

    /**
     * <p>
     * This operations starts a job to export the results of search job to a designated S3 bucket.
     * </p>
     *
     * @param startSearchResultExportJobRequest
     * @return A Java Future containing the result of the StartSearchResultExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found for this request.</p>
     *         <p>
     *         Confirm the resource information, such as the ARN or type is correct and exists, then retry the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceQuotaExceededException The request denied due to exceeding the quota limits permitted.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful operation is
     *         detected. This generally occurs when the previous operation did not have time to propagate to the host
     *         serving the current request.</p>
     *         <p>
     *         A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupSearchAsyncClient.StartSearchResultExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/StartSearchResultExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartSearchResultExportJobResponse> startSearchResultExportJob(
            StartSearchResultExportJobRequest startSearchResultExportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operations starts a job to export the results of search job to a designated S3 bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartSearchResultExportJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartSearchResultExportJobRequest#builder()}
     * </p>
     *
     * @param startSearchResultExportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backupsearch.model.StartSearchResultExportJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartSearchResultExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found for this request.</p>
     *         <p>
     *         Confirm the resource information, such as the ARN or type is correct and exists, then retry the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceQuotaExceededException The request denied due to exceeding the quota limits permitted.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful operation is
     *         detected. This generally occurs when the previous operation did not have time to propagate to the host
     *         serving the current request.</p>
     *         <p>
     *         A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupSearchAsyncClient.StartSearchResultExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/StartSearchResultExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartSearchResultExportJobResponse> startSearchResultExportJob(
            Consumer<StartSearchResultExportJobRequest.Builder> startSearchResultExportJobRequest) {
        return startSearchResultExportJob(StartSearchResultExportJobRequest.builder()
                .applyMutation(startSearchResultExportJobRequest).build());
    }

    /**
     * <p>
     * This operations ends a search job.
     * </p>
     * <p>
     * Only a search job with a status of <code>RUNNING</code> can be stopped.
     * </p>
     *
     * @param stopSearchJobRequest
     * @return A Java Future containing the result of the StopSearchJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found for this request.</p>
     *         <p>
     *         Confirm the resource information, such as the ARN or type is correct and exists, then retry the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful operation is
     *         detected. This generally occurs when the previous operation did not have time to propagate to the host
     *         serving the current request.</p>
     *         <p>
     *         A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupSearchAsyncClient.StopSearchJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/StopSearchJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StopSearchJobResponse> stopSearchJob(StopSearchJobRequest stopSearchJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operations ends a search job.
     * </p>
     * <p>
     * Only a search job with a status of <code>RUNNING</code> can be stopped.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopSearchJobRequest.Builder} avoiding the need to
     * create one manually via {@link StopSearchJobRequest#builder()}
     * </p>
     *
     * @param stopSearchJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backupsearch.model.StopSearchJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopSearchJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found for this request.</p>
     *         <p>
     *         Confirm the resource information, such as the ARN or type is correct and exists, then retry the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ConflictException This exception occurs when a conflict with a previous successful operation is
     *         detected. This generally occurs when the previous operation did not have time to propagate to the host
     *         serving the current request.</p>
     *         <p>
     *         A retry (with appropriate backoff logic) is the recommended response to this exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupSearchAsyncClient.StopSearchJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/StopSearchJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StopSearchJobResponse> stopSearchJob(Consumer<StopSearchJobRequest.Builder> stopSearchJobRequest) {
        return stopSearchJob(StopSearchJobRequest.builder().applyMutation(stopSearchJobRequest).build());
    }

    /**
     * <p>
     * This operation puts tags on the resource you indicate.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found for this request.</p>
     *         <p>
     *         Confirm the resource information, such as the ARN or type is correct and exists, then retry the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupSearchAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation puts tags on the resource you indicate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backupsearch.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found for this request.</p>
     *         <p>
     *         Confirm the resource information, such as the ARN or type is correct and exists, then retry the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupSearchAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * This operation removes tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found for this request.</p>
     *         <p>
     *         Confirm the resource information, such as the ARN or type is correct and exists, then retry the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupSearchAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation removes tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.backupsearch.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource was not found for this request.</p>
     *         <p>
     *         Confirm the resource information, such as the ARN or type is correct and exists, then retry the request.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by a service.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BackupSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BackupSearchAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/backupsearch-2018-05-10/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    @Override
    default BackupSearchServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link BackupSearchAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BackupSearchAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BackupSearchAsyncClient}.
     */
    static BackupSearchAsyncClientBuilder builder() {
        return new DefaultBackupSearchAsyncClientBuilder();
    }
}
