/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This contains information results retrieved from a search job that may not have completed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CurrentSearchProgress implements SdkPojo, Serializable,
        ToCopyableBuilder<CurrentSearchProgress.Builder, CurrentSearchProgress> {
    private static final SdkField<Integer> RECOVERY_POINTS_SCANNED_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("RecoveryPointsScannedCount")
            .getter(getter(CurrentSearchProgress::recoveryPointsScannedCount))
            .setter(setter(Builder::recoveryPointsScannedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointsScannedCount").build())
            .build();

    private static final SdkField<Long> ITEMS_SCANNED_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ItemsScannedCount").getter(getter(CurrentSearchProgress::itemsScannedCount))
            .setter(setter(Builder::itemsScannedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemsScannedCount").build()).build();

    private static final SdkField<Long> ITEMS_MATCHED_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ItemsMatchedCount").getter(getter(CurrentSearchProgress::itemsMatchedCount))
            .setter(setter(Builder::itemsMatchedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemsMatchedCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RECOVERY_POINTS_SCANNED_COUNT_FIELD, ITEMS_SCANNED_COUNT_FIELD, ITEMS_MATCHED_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer recoveryPointsScannedCount;

    private final Long itemsScannedCount;

    private final Long itemsMatchedCount;

    private CurrentSearchProgress(BuilderImpl builder) {
        this.recoveryPointsScannedCount = builder.recoveryPointsScannedCount;
        this.itemsScannedCount = builder.itemsScannedCount;
        this.itemsMatchedCount = builder.itemsMatchedCount;
    }

    /**
     * <p>
     * This number is the sum of all backups that have been scanned so far during a search job.
     * </p>
     * 
     * @return This number is the sum of all backups that have been scanned so far during a search job.
     */
    public final Integer recoveryPointsScannedCount() {
        return recoveryPointsScannedCount;
    }

    /**
     * <p>
     * This number is the sum of all items that have been scanned so far during a search job.
     * </p>
     * 
     * @return This number is the sum of all items that have been scanned so far during a search job.
     */
    public final Long itemsScannedCount() {
        return itemsScannedCount;
    }

    /**
     * <p>
     * This number is the sum of all items that match the item filters in a search job in progress.
     * </p>
     * 
     * @return This number is the sum of all items that match the item filters in a search job in progress.
     */
    public final Long itemsMatchedCount() {
        return itemsMatchedCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recoveryPointsScannedCount());
        hashCode = 31 * hashCode + Objects.hashCode(itemsScannedCount());
        hashCode = 31 * hashCode + Objects.hashCode(itemsMatchedCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CurrentSearchProgress)) {
            return false;
        }
        CurrentSearchProgress other = (CurrentSearchProgress) obj;
        return Objects.equals(recoveryPointsScannedCount(), other.recoveryPointsScannedCount())
                && Objects.equals(itemsScannedCount(), other.itemsScannedCount())
                && Objects.equals(itemsMatchedCount(), other.itemsMatchedCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CurrentSearchProgress").add("RecoveryPointsScannedCount", recoveryPointsScannedCount())
                .add("ItemsScannedCount", itemsScannedCount()).add("ItemsMatchedCount", itemsMatchedCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecoveryPointsScannedCount":
            return Optional.ofNullable(clazz.cast(recoveryPointsScannedCount()));
        case "ItemsScannedCount":
            return Optional.ofNullable(clazz.cast(itemsScannedCount()));
        case "ItemsMatchedCount":
            return Optional.ofNullable(clazz.cast(itemsMatchedCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RecoveryPointsScannedCount", RECOVERY_POINTS_SCANNED_COUNT_FIELD);
        map.put("ItemsScannedCount", ITEMS_SCANNED_COUNT_FIELD);
        map.put("ItemsMatchedCount", ITEMS_MATCHED_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CurrentSearchProgress, T> g) {
        return obj -> g.apply((CurrentSearchProgress) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CurrentSearchProgress> {
        /**
         * <p>
         * This number is the sum of all backups that have been scanned so far during a search job.
         * </p>
         * 
         * @param recoveryPointsScannedCount
         *        This number is the sum of all backups that have been scanned so far during a search job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPointsScannedCount(Integer recoveryPointsScannedCount);

        /**
         * <p>
         * This number is the sum of all items that have been scanned so far during a search job.
         * </p>
         * 
         * @param itemsScannedCount
         *        This number is the sum of all items that have been scanned so far during a search job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemsScannedCount(Long itemsScannedCount);

        /**
         * <p>
         * This number is the sum of all items that match the item filters in a search job in progress.
         * </p>
         * 
         * @param itemsMatchedCount
         *        This number is the sum of all items that match the item filters in a search job in progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemsMatchedCount(Long itemsMatchedCount);
    }

    static final class BuilderImpl implements Builder {
        private Integer recoveryPointsScannedCount;

        private Long itemsScannedCount;

        private Long itemsMatchedCount;

        private BuilderImpl() {
        }

        private BuilderImpl(CurrentSearchProgress model) {
            recoveryPointsScannedCount(model.recoveryPointsScannedCount);
            itemsScannedCount(model.itemsScannedCount);
            itemsMatchedCount(model.itemsMatchedCount);
        }

        public final Integer getRecoveryPointsScannedCount() {
            return recoveryPointsScannedCount;
        }

        public final void setRecoveryPointsScannedCount(Integer recoveryPointsScannedCount) {
            this.recoveryPointsScannedCount = recoveryPointsScannedCount;
        }

        @Override
        public final Builder recoveryPointsScannedCount(Integer recoveryPointsScannedCount) {
            this.recoveryPointsScannedCount = recoveryPointsScannedCount;
            return this;
        }

        public final Long getItemsScannedCount() {
            return itemsScannedCount;
        }

        public final void setItemsScannedCount(Long itemsScannedCount) {
            this.itemsScannedCount = itemsScannedCount;
        }

        @Override
        public final Builder itemsScannedCount(Long itemsScannedCount) {
            this.itemsScannedCount = itemsScannedCount;
            return this;
        }

        public final Long getItemsMatchedCount() {
            return itemsMatchedCount;
        }

        public final void setItemsMatchedCount(Long itemsMatchedCount) {
            this.itemsMatchedCount = itemsMatchedCount;
        }

        @Override
        public final Builder itemsMatchedCount(Long itemsMatchedCount) {
            this.itemsMatchedCount = itemsMatchedCount;
            return this;
        }

        @Override
        public CurrentSearchProgress build() {
            return new CurrentSearchProgress(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
