/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This contains arrays of objects, which may include CreationTimes time condition objects, FilePaths string objects,
 * LastModificationTimes time condition objects,
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EBSItemFilter implements SdkPojo, Serializable, ToCopyableBuilder<EBSItemFilter.Builder, EBSItemFilter> {
    private static final SdkField<List<StringCondition>> FILE_PATHS_FIELD = SdkField
            .<List<StringCondition>> builder(MarshallingType.LIST)
            .memberName("FilePaths")
            .getter(getter(EBSItemFilter::filePaths))
            .setter(setter(Builder::filePaths))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilePaths").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StringCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(StringCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LongCondition>> SIZES_FIELD = SdkField
            .<List<LongCondition>> builder(MarshallingType.LIST)
            .memberName("Sizes")
            .getter(getter(EBSItemFilter::sizes))
            .setter(setter(Builder::sizes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sizes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LongCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(LongCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TimeCondition>> CREATION_TIMES_FIELD = SdkField
            .<List<TimeCondition>> builder(MarshallingType.LIST)
            .memberName("CreationTimes")
            .getter(getter(EBSItemFilter::creationTimes))
            .setter(setter(Builder::creationTimes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TimeCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(TimeCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TimeCondition>> LAST_MODIFICATION_TIMES_FIELD = SdkField
            .<List<TimeCondition>> builder(MarshallingType.LIST)
            .memberName("LastModificationTimes")
            .getter(getter(EBSItemFilter::lastModificationTimes))
            .setter(setter(Builder::lastModificationTimes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTimes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TimeCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(TimeCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_PATHS_FIELD, SIZES_FIELD,
            CREATION_TIMES_FIELD, LAST_MODIFICATION_TIMES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<StringCondition> filePaths;

    private final List<LongCondition> sizes;

    private final List<TimeCondition> creationTimes;

    private final List<TimeCondition> lastModificationTimes;

    private EBSItemFilter(BuilderImpl builder) {
        this.filePaths = builder.filePaths;
        this.sizes = builder.sizes;
        this.creationTimes = builder.creationTimes;
        this.lastModificationTimes = builder.lastModificationTimes;
    }

    /**
     * For responses, this returns true if the service returned a value for the FilePaths property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilePaths() {
        return filePaths != null && !(filePaths instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * You can include 1 to 10 values.
     * </p>
     * <p>
     * If one file path is included, the results will return only items that match the file path.
     * </p>
     * <p>
     * If more than one file path is included, the results will return all items that match any of the file paths.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilePaths} method.
     * </p>
     * 
     * @return You can include 1 to 10 values.</p>
     *         <p>
     *         If one file path is included, the results will return only items that match the file path.
     *         </p>
     *         <p>
     *         If more than one file path is included, the results will return all items that match any of the file
     *         paths.
     */
    public final List<StringCondition> filePaths() {
        return filePaths;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sizes property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSizes() {
        return sizes != null && !(sizes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * You can include 1 to 10 values.
     * </p>
     * <p>
     * If one is included, the results will return only items that match.
     * </p>
     * <p>
     * If more than one is included, the results will return all items that match any of the included values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSizes} method.
     * </p>
     * 
     * @return You can include 1 to 10 values.</p>
     *         <p>
     *         If one is included, the results will return only items that match.
     *         </p>
     *         <p>
     *         If more than one is included, the results will return all items that match any of the included values.
     */
    public final List<LongCondition> sizes() {
        return sizes;
    }

    /**
     * For responses, this returns true if the service returned a value for the CreationTimes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCreationTimes() {
        return creationTimes != null && !(creationTimes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * You can include 1 to 10 values.
     * </p>
     * <p>
     * If one is included, the results will return only items that match.
     * </p>
     * <p>
     * If more than one is included, the results will return all items that match any of the included values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCreationTimes} method.
     * </p>
     * 
     * @return You can include 1 to 10 values.</p>
     *         <p>
     *         If one is included, the results will return only items that match.
     *         </p>
     *         <p>
     *         If more than one is included, the results will return all items that match any of the included values.
     */
    public final List<TimeCondition> creationTimes() {
        return creationTimes;
    }

    /**
     * For responses, this returns true if the service returned a value for the LastModificationTimes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLastModificationTimes() {
        return lastModificationTimes != null && !(lastModificationTimes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * You can include 1 to 10 values.
     * </p>
     * <p>
     * If one is included, the results will return only items that match.
     * </p>
     * <p>
     * If more than one is included, the results will return all items that match any of the included values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLastModificationTimes} method.
     * </p>
     * 
     * @return You can include 1 to 10 values.</p>
     *         <p>
     *         If one is included, the results will return only items that match.
     *         </p>
     *         <p>
     *         If more than one is included, the results will return all items that match any of the included values.
     */
    public final List<TimeCondition> lastModificationTimes() {
        return lastModificationTimes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFilePaths() ? filePaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSizes() ? sizes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCreationTimes() ? creationTimes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLastModificationTimes() ? lastModificationTimes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EBSItemFilter)) {
            return false;
        }
        EBSItemFilter other = (EBSItemFilter) obj;
        return hasFilePaths() == other.hasFilePaths() && Objects.equals(filePaths(), other.filePaths())
                && hasSizes() == other.hasSizes() && Objects.equals(sizes(), other.sizes())
                && hasCreationTimes() == other.hasCreationTimes() && Objects.equals(creationTimes(), other.creationTimes())
                && hasLastModificationTimes() == other.hasLastModificationTimes()
                && Objects.equals(lastModificationTimes(), other.lastModificationTimes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EBSItemFilter").add("FilePaths", hasFilePaths() ? filePaths() : null)
                .add("Sizes", hasSizes() ? sizes() : null).add("CreationTimes", hasCreationTimes() ? creationTimes() : null)
                .add("LastModificationTimes", hasLastModificationTimes() ? lastModificationTimes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilePaths":
            return Optional.ofNullable(clazz.cast(filePaths()));
        case "Sizes":
            return Optional.ofNullable(clazz.cast(sizes()));
        case "CreationTimes":
            return Optional.ofNullable(clazz.cast(creationTimes()));
        case "LastModificationTimes":
            return Optional.ofNullable(clazz.cast(lastModificationTimes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FilePaths", FILE_PATHS_FIELD);
        map.put("Sizes", SIZES_FIELD);
        map.put("CreationTimes", CREATION_TIMES_FIELD);
        map.put("LastModificationTimes", LAST_MODIFICATION_TIMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EBSItemFilter, T> g) {
        return obj -> g.apply((EBSItemFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EBSItemFilter> {
        /**
         * <p>
         * You can include 1 to 10 values.
         * </p>
         * <p>
         * If one file path is included, the results will return only items that match the file path.
         * </p>
         * <p>
         * If more than one file path is included, the results will return all items that match any of the file paths.
         * </p>
         * 
         * @param filePaths
         *        You can include 1 to 10 values.</p>
         *        <p>
         *        If one file path is included, the results will return only items that match the file path.
         *        </p>
         *        <p>
         *        If more than one file path is included, the results will return all items that match any of the file
         *        paths.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePaths(Collection<StringCondition> filePaths);

        /**
         * <p>
         * You can include 1 to 10 values.
         * </p>
         * <p>
         * If one file path is included, the results will return only items that match the file path.
         * </p>
         * <p>
         * If more than one file path is included, the results will return all items that match any of the file paths.
         * </p>
         * 
         * @param filePaths
         *        You can include 1 to 10 values.</p>
         *        <p>
         *        If one file path is included, the results will return only items that match the file path.
         *        </p>
         *        <p>
         *        If more than one file path is included, the results will return all items that match any of the file
         *        paths.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePaths(StringCondition... filePaths);

        /**
         * <p>
         * You can include 1 to 10 values.
         * </p>
         * <p>
         * If one file path is included, the results will return only items that match the file path.
         * </p>
         * <p>
         * If more than one file path is included, the results will return all items that match any of the file paths.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backupsearch.model.StringCondition.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.backupsearch.model.StringCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backupsearch.model.StringCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #filePaths(List<StringCondition>)}.
         * 
         * @param filePaths
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backupsearch.model.StringCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filePaths(java.util.Collection<StringCondition>)
         */
        Builder filePaths(Consumer<StringCondition.Builder>... filePaths);

        /**
         * <p>
         * You can include 1 to 10 values.
         * </p>
         * <p>
         * If one is included, the results will return only items that match.
         * </p>
         * <p>
         * If more than one is included, the results will return all items that match any of the included values.
         * </p>
         * 
         * @param sizes
         *        You can include 1 to 10 values.</p>
         *        <p>
         *        If one is included, the results will return only items that match.
         *        </p>
         *        <p>
         *        If more than one is included, the results will return all items that match any of the included values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizes(Collection<LongCondition> sizes);

        /**
         * <p>
         * You can include 1 to 10 values.
         * </p>
         * <p>
         * If one is included, the results will return only items that match.
         * </p>
         * <p>
         * If more than one is included, the results will return all items that match any of the included values.
         * </p>
         * 
         * @param sizes
         *        You can include 1 to 10 values.</p>
         *        <p>
         *        If one is included, the results will return only items that match.
         *        </p>
         *        <p>
         *        If more than one is included, the results will return all items that match any of the included values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizes(LongCondition... sizes);

        /**
         * <p>
         * You can include 1 to 10 values.
         * </p>
         * <p>
         * If one is included, the results will return only items that match.
         * </p>
         * <p>
         * If more than one is included, the results will return all items that match any of the included values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backupsearch.model.LongCondition.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.backupsearch.model.LongCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backupsearch.model.LongCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #sizes(List<LongCondition>)}.
         * 
         * @param sizes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backupsearch.model.LongCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sizes(java.util.Collection<LongCondition>)
         */
        Builder sizes(Consumer<LongCondition.Builder>... sizes);

        /**
         * <p>
         * You can include 1 to 10 values.
         * </p>
         * <p>
         * If one is included, the results will return only items that match.
         * </p>
         * <p>
         * If more than one is included, the results will return all items that match any of the included values.
         * </p>
         * 
         * @param creationTimes
         *        You can include 1 to 10 values.</p>
         *        <p>
         *        If one is included, the results will return only items that match.
         *        </p>
         *        <p>
         *        If more than one is included, the results will return all items that match any of the included values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimes(Collection<TimeCondition> creationTimes);

        /**
         * <p>
         * You can include 1 to 10 values.
         * </p>
         * <p>
         * If one is included, the results will return only items that match.
         * </p>
         * <p>
         * If more than one is included, the results will return all items that match any of the included values.
         * </p>
         * 
         * @param creationTimes
         *        You can include 1 to 10 values.</p>
         *        <p>
         *        If one is included, the results will return only items that match.
         *        </p>
         *        <p>
         *        If more than one is included, the results will return all items that match any of the included values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimes(TimeCondition... creationTimes);

        /**
         * <p>
         * You can include 1 to 10 values.
         * </p>
         * <p>
         * If one is included, the results will return only items that match.
         * </p>
         * <p>
         * If more than one is included, the results will return all items that match any of the included values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backupsearch.model.TimeCondition.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.backupsearch.model.TimeCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backupsearch.model.TimeCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #creationTimes(List<TimeCondition>)}.
         * 
         * @param creationTimes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backupsearch.model.TimeCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #creationTimes(java.util.Collection<TimeCondition>)
         */
        Builder creationTimes(Consumer<TimeCondition.Builder>... creationTimes);

        /**
         * <p>
         * You can include 1 to 10 values.
         * </p>
         * <p>
         * If one is included, the results will return only items that match.
         * </p>
         * <p>
         * If more than one is included, the results will return all items that match any of the included values.
         * </p>
         * 
         * @param lastModificationTimes
         *        You can include 1 to 10 values.</p>
         *        <p>
         *        If one is included, the results will return only items that match.
         *        </p>
         *        <p>
         *        If more than one is included, the results will return all items that match any of the included values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTimes(Collection<TimeCondition> lastModificationTimes);

        /**
         * <p>
         * You can include 1 to 10 values.
         * </p>
         * <p>
         * If one is included, the results will return only items that match.
         * </p>
         * <p>
         * If more than one is included, the results will return all items that match any of the included values.
         * </p>
         * 
         * @param lastModificationTimes
         *        You can include 1 to 10 values.</p>
         *        <p>
         *        If one is included, the results will return only items that match.
         *        </p>
         *        <p>
         *        If more than one is included, the results will return all items that match any of the included values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTimes(TimeCondition... lastModificationTimes);

        /**
         * <p>
         * You can include 1 to 10 values.
         * </p>
         * <p>
         * If one is included, the results will return only items that match.
         * </p>
         * <p>
         * If more than one is included, the results will return all items that match any of the included values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.backupsearch.model.TimeCondition.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.backupsearch.model.TimeCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.backupsearch.model.TimeCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #lastModificationTimes(List<TimeCondition>)}.
         * 
         * @param lastModificationTimes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.backupsearch.model.TimeCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastModificationTimes(java.util.Collection<TimeCondition>)
         */
        Builder lastModificationTimes(Consumer<TimeCondition.Builder>... lastModificationTimes);
    }

    static final class BuilderImpl implements Builder {
        private List<StringCondition> filePaths = DefaultSdkAutoConstructList.getInstance();

        private List<LongCondition> sizes = DefaultSdkAutoConstructList.getInstance();

        private List<TimeCondition> creationTimes = DefaultSdkAutoConstructList.getInstance();

        private List<TimeCondition> lastModificationTimes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EBSItemFilter model) {
            filePaths(model.filePaths);
            sizes(model.sizes);
            creationTimes(model.creationTimes);
            lastModificationTimes(model.lastModificationTimes);
        }

        public final List<StringCondition.Builder> getFilePaths() {
            List<StringCondition.Builder> result = StringConditionListCopier.copyToBuilder(this.filePaths);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilePaths(Collection<StringCondition.BuilderImpl> filePaths) {
            this.filePaths = StringConditionListCopier.copyFromBuilder(filePaths);
        }

        @Override
        public final Builder filePaths(Collection<StringCondition> filePaths) {
            this.filePaths = StringConditionListCopier.copy(filePaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filePaths(StringCondition... filePaths) {
            filePaths(Arrays.asList(filePaths));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filePaths(Consumer<StringCondition.Builder>... filePaths) {
            filePaths(Stream.of(filePaths).map(c -> StringCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<LongCondition.Builder> getSizes() {
            List<LongCondition.Builder> result = LongConditionListCopier.copyToBuilder(this.sizes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSizes(Collection<LongCondition.BuilderImpl> sizes) {
            this.sizes = LongConditionListCopier.copyFromBuilder(sizes);
        }

        @Override
        public final Builder sizes(Collection<LongCondition> sizes) {
            this.sizes = LongConditionListCopier.copy(sizes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sizes(LongCondition... sizes) {
            sizes(Arrays.asList(sizes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sizes(Consumer<LongCondition.Builder>... sizes) {
            sizes(Stream.of(sizes).map(c -> LongCondition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TimeCondition.Builder> getCreationTimes() {
            List<TimeCondition.Builder> result = TimeConditionListCopier.copyToBuilder(this.creationTimes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCreationTimes(Collection<TimeCondition.BuilderImpl> creationTimes) {
            this.creationTimes = TimeConditionListCopier.copyFromBuilder(creationTimes);
        }

        @Override
        public final Builder creationTimes(Collection<TimeCondition> creationTimes) {
            this.creationTimes = TimeConditionListCopier.copy(creationTimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder creationTimes(TimeCondition... creationTimes) {
            creationTimes(Arrays.asList(creationTimes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder creationTimes(Consumer<TimeCondition.Builder>... creationTimes) {
            creationTimes(Stream.of(creationTimes).map(c -> TimeCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<TimeCondition.Builder> getLastModificationTimes() {
            List<TimeCondition.Builder> result = TimeConditionListCopier.copyToBuilder(this.lastModificationTimes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLastModificationTimes(Collection<TimeCondition.BuilderImpl> lastModificationTimes) {
            this.lastModificationTimes = TimeConditionListCopier.copyFromBuilder(lastModificationTimes);
        }

        @Override
        public final Builder lastModificationTimes(Collection<TimeCondition> lastModificationTimes) {
            this.lastModificationTimes = TimeConditionListCopier.copy(lastModificationTimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastModificationTimes(TimeCondition... lastModificationTimes) {
            lastModificationTimes(Arrays.asList(lastModificationTimes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lastModificationTimes(Consumer<TimeCondition.Builder>... lastModificationTimes) {
            lastModificationTimes(Stream.of(lastModificationTimes).map(c -> TimeCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public EBSItemFilter build() {
            return new EBSItemFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
