/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupsearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * These are the items returned in the results of a search of Amazon EBS backup metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EBSResultItem implements SdkPojo, Serializable, ToCopyableBuilder<EBSResultItem.Builder, EBSResultItem> {
    private static final SdkField<String> BACKUP_RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupResourceArn").getter(getter(EBSResultItem::backupResourceArn))
            .setter(setter(Builder::backupResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupResourceArn").build()).build();

    private static final SdkField<String> SOURCE_RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceResourceArn").getter(getter(EBSResultItem::sourceResourceArn))
            .setter(setter(Builder::sourceResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceResourceArn").build()).build();

    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultName").getter(getter(EBSResultItem::backupVaultName))
            .setter(setter(Builder::backupVaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()).build();

    private static final SdkField<String> FILE_SYSTEM_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileSystemIdentifier").getter(getter(EBSResultItem::fileSystemIdentifier))
            .setter(setter(Builder::fileSystemIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemIdentifier").build())
            .build();

    private static final SdkField<String> FILE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilePath").getter(getter(EBSResultItem::filePath)).setter(setter(Builder::filePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilePath").build()).build();

    private static final SdkField<Long> FILE_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("FileSize")
            .getter(getter(EBSResultItem::fileSize)).setter(setter(Builder::fileSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSize").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(EBSResultItem::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(EBSResultItem::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_RESOURCE_ARN_FIELD,
            SOURCE_RESOURCE_ARN_FIELD, BACKUP_VAULT_NAME_FIELD, FILE_SYSTEM_IDENTIFIER_FIELD, FILE_PATH_FIELD, FILE_SIZE_FIELD,
            CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String backupResourceArn;

    private final String sourceResourceArn;

    private final String backupVaultName;

    private final String fileSystemIdentifier;

    private final String filePath;

    private final Long fileSize;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private EBSResultItem(BuilderImpl builder) {
        this.backupResourceArn = builder.backupResourceArn;
        this.sourceResourceArn = builder.sourceResourceArn;
        this.backupVaultName = builder.backupVaultName;
        this.fileSystemIdentifier = builder.fileSystemIdentifier;
        this.filePath = builder.filePath;
        this.fileSize = builder.fileSize;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * These are one or more items in the results that match values for the Amazon Resource Name (ARN) of recovery
     * points returned in a search of Amazon EBS backup metadata.
     * </p>
     * 
     * @return These are one or more items in the results that match values for the Amazon Resource Name (ARN) of
     *         recovery points returned in a search of Amazon EBS backup metadata.
     */
    public final String backupResourceArn() {
        return backupResourceArn;
    }

    /**
     * <p>
     * These are one or more items in the results that match values for the Amazon Resource Name (ARN) of source
     * resources returned in a search of Amazon EBS backup metadata.
     * </p>
     * 
     * @return These are one or more items in the results that match values for the Amazon Resource Name (ARN) of source
     *         resources returned in a search of Amazon EBS backup metadata.
     */
    public final String sourceResourceArn() {
        return sourceResourceArn;
    }

    /**
     * <p>
     * The name of the backup vault.
     * </p>
     * 
     * @return The name of the backup vault.
     */
    public final String backupVaultName() {
        return backupVaultName;
    }

    /**
     * <p>
     * These are one or more items in the results that match values for file systems returned in a search of Amazon EBS
     * backup metadata.
     * </p>
     * 
     * @return These are one or more items in the results that match values for file systems returned in a search of
     *         Amazon EBS backup metadata.
     */
    public final String fileSystemIdentifier() {
        return fileSystemIdentifier;
    }

    /**
     * <p>
     * These are one or more items in the results that match values for file paths returned in a search of Amazon EBS
     * backup metadata.
     * </p>
     * 
     * @return These are one or more items in the results that match values for file paths returned in a search of
     *         Amazon EBS backup metadata.
     */
    public final String filePath() {
        return filePath;
    }

    /**
     * <p>
     * These are one or more items in the results that match values for file sizes returned in a search of Amazon EBS
     * backup metadata.
     * </p>
     * 
     * @return These are one or more items in the results that match values for file sizes returned in a search of
     *         Amazon EBS backup metadata.
     */
    public final Long fileSize() {
        return fileSize;
    }

    /**
     * <p>
     * These are one or more items in the results that match values for creation times returned in a search of Amazon
     * EBS backup metadata.
     * </p>
     * 
     * @return These are one or more items in the results that match values for creation times returned in a search of
     *         Amazon EBS backup metadata.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * These are one or more items in the results that match values for Last Modified Time returned in a search of
     * Amazon EBS backup metadata.
     * </p>
     * 
     * @return These are one or more items in the results that match values for Last Modified Time returned in a search
     *         of Amazon EBS backup metadata.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backupResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(filePath());
        hashCode = 31 * hashCode + Objects.hashCode(fileSize());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EBSResultItem)) {
            return false;
        }
        EBSResultItem other = (EBSResultItem) obj;
        return Objects.equals(backupResourceArn(), other.backupResourceArn())
                && Objects.equals(sourceResourceArn(), other.sourceResourceArn())
                && Objects.equals(backupVaultName(), other.backupVaultName())
                && Objects.equals(fileSystemIdentifier(), other.fileSystemIdentifier())
                && Objects.equals(filePath(), other.filePath()) && Objects.equals(fileSize(), other.fileSize())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EBSResultItem").add("BackupResourceArn", backupResourceArn())
                .add("SourceResourceArn", sourceResourceArn()).add("BackupVaultName", backupVaultName())
                .add("FileSystemIdentifier", fileSystemIdentifier())
                .add("FilePath", filePath() == null ? null : "*** Sensitive Data Redacted ***").add("FileSize", fileSize())
                .add("CreationTime", creationTime()).add("LastModifiedTime", lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupResourceArn":
            return Optional.ofNullable(clazz.cast(backupResourceArn()));
        case "SourceResourceArn":
            return Optional.ofNullable(clazz.cast(sourceResourceArn()));
        case "BackupVaultName":
            return Optional.ofNullable(clazz.cast(backupVaultName()));
        case "FileSystemIdentifier":
            return Optional.ofNullable(clazz.cast(fileSystemIdentifier()));
        case "FilePath":
            return Optional.ofNullable(clazz.cast(filePath()));
        case "FileSize":
            return Optional.ofNullable(clazz.cast(fileSize()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BackupResourceArn", BACKUP_RESOURCE_ARN_FIELD);
        map.put("SourceResourceArn", SOURCE_RESOURCE_ARN_FIELD);
        map.put("BackupVaultName", BACKUP_VAULT_NAME_FIELD);
        map.put("FileSystemIdentifier", FILE_SYSTEM_IDENTIFIER_FIELD);
        map.put("FilePath", FILE_PATH_FIELD);
        map.put("FileSize", FILE_SIZE_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EBSResultItem, T> g) {
        return obj -> g.apply((EBSResultItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EBSResultItem> {
        /**
         * <p>
         * These are one or more items in the results that match values for the Amazon Resource Name (ARN) of recovery
         * points returned in a search of Amazon EBS backup metadata.
         * </p>
         * 
         * @param backupResourceArn
         *        These are one or more items in the results that match values for the Amazon Resource Name (ARN) of
         *        recovery points returned in a search of Amazon EBS backup metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupResourceArn(String backupResourceArn);

        /**
         * <p>
         * These are one or more items in the results that match values for the Amazon Resource Name (ARN) of source
         * resources returned in a search of Amazon EBS backup metadata.
         * </p>
         * 
         * @param sourceResourceArn
         *        These are one or more items in the results that match values for the Amazon Resource Name (ARN) of
         *        source resources returned in a search of Amazon EBS backup metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceResourceArn(String sourceResourceArn);

        /**
         * <p>
         * The name of the backup vault.
         * </p>
         * 
         * @param backupVaultName
         *        The name of the backup vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultName(String backupVaultName);

        /**
         * <p>
         * These are one or more items in the results that match values for file systems returned in a search of Amazon
         * EBS backup metadata.
         * </p>
         * 
         * @param fileSystemIdentifier
         *        These are one or more items in the results that match values for file systems returned in a search of
         *        Amazon EBS backup metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemIdentifier(String fileSystemIdentifier);

        /**
         * <p>
         * These are one or more items in the results that match values for file paths returned in a search of Amazon
         * EBS backup metadata.
         * </p>
         * 
         * @param filePath
         *        These are one or more items in the results that match values for file paths returned in a search of
         *        Amazon EBS backup metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePath(String filePath);

        /**
         * <p>
         * These are one or more items in the results that match values for file sizes returned in a search of Amazon
         * EBS backup metadata.
         * </p>
         * 
         * @param fileSize
         *        These are one or more items in the results that match values for file sizes returned in a search of
         *        Amazon EBS backup metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSize(Long fileSize);

        /**
         * <p>
         * These are one or more items in the results that match values for creation times returned in a search of
         * Amazon EBS backup metadata.
         * </p>
         * 
         * @param creationTime
         *        These are one or more items in the results that match values for creation times returned in a search
         *        of Amazon EBS backup metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * These are one or more items in the results that match values for Last Modified Time returned in a search of
         * Amazon EBS backup metadata.
         * </p>
         * 
         * @param lastModifiedTime
         *        These are one or more items in the results that match values for Last Modified Time returned in a
         *        search of Amazon EBS backup metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl implements Builder {
        private String backupResourceArn;

        private String sourceResourceArn;

        private String backupVaultName;

        private String fileSystemIdentifier;

        private String filePath;

        private Long fileSize;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(EBSResultItem model) {
            backupResourceArn(model.backupResourceArn);
            sourceResourceArn(model.sourceResourceArn);
            backupVaultName(model.backupVaultName);
            fileSystemIdentifier(model.fileSystemIdentifier);
            filePath(model.filePath);
            fileSize(model.fileSize);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getBackupResourceArn() {
            return backupResourceArn;
        }

        public final void setBackupResourceArn(String backupResourceArn) {
            this.backupResourceArn = backupResourceArn;
        }

        @Override
        public final Builder backupResourceArn(String backupResourceArn) {
            this.backupResourceArn = backupResourceArn;
            return this;
        }

        public final String getSourceResourceArn() {
            return sourceResourceArn;
        }

        public final void setSourceResourceArn(String sourceResourceArn) {
            this.sourceResourceArn = sourceResourceArn;
        }

        @Override
        public final Builder sourceResourceArn(String sourceResourceArn) {
            this.sourceResourceArn = sourceResourceArn;
            return this;
        }

        public final String getBackupVaultName() {
            return backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final String getFileSystemIdentifier() {
            return fileSystemIdentifier;
        }

        public final void setFileSystemIdentifier(String fileSystemIdentifier) {
            this.fileSystemIdentifier = fileSystemIdentifier;
        }

        @Override
        public final Builder fileSystemIdentifier(String fileSystemIdentifier) {
            this.fileSystemIdentifier = fileSystemIdentifier;
            return this;
        }

        public final String getFilePath() {
            return filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final Long getFileSize() {
            return fileSize;
        }

        public final void setFileSize(Long fileSize) {
            this.fileSize = fileSize;
        }

        @Override
        public final Builder fileSize(Long fileSize) {
            this.fileSize = fileSize;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public EBSResultItem build() {
            return new EBSResultItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
