/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupsearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This is the summary of an export job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportJobSummary.Builder, ExportJobSummary> {
    private static final SdkField<String> EXPORT_JOB_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportJobIdentifier").getter(getter(ExportJobSummary::exportJobIdentifier))
            .setter(setter(Builder::exportJobIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportJobIdentifier").build())
            .build();

    private static final SdkField<String> EXPORT_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportJobArn").getter(getter(ExportJobSummary::exportJobArn)).setter(setter(Builder::exportJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportJobArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ExportJobSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ExportJobSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletionTime").getter(getter(ExportJobSummary::completionTime))
            .setter(setter(Builder::completionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(ExportJobSummary::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> SEARCH_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SearchJobArn").getter(getter(ExportJobSummary::searchJobArn)).setter(setter(Builder::searchJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchJobArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_JOB_IDENTIFIER_FIELD,
            EXPORT_JOB_ARN_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, COMPLETION_TIME_FIELD, STATUS_MESSAGE_FIELD,
            SEARCH_JOB_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String exportJobIdentifier;

    private final String exportJobArn;

    private final String status;

    private final Instant creationTime;

    private final Instant completionTime;

    private final String statusMessage;

    private final String searchJobArn;

    private ExportJobSummary(BuilderImpl builder) {
        this.exportJobIdentifier = builder.exportJobIdentifier;
        this.exportJobArn = builder.exportJobArn;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.completionTime = builder.completionTime;
        this.statusMessage = builder.statusMessage;
        this.searchJobArn = builder.searchJobArn;
    }

    /**
     * <p>
     * This is the unique string that identifies a specific export job.
     * </p>
     * 
     * @return This is the unique string that identifies a specific export job.
     */
    public final String exportJobIdentifier() {
        return exportJobIdentifier;
    }

    /**
     * <p>
     * This is the unique ARN (Amazon Resource Name) that belongs to the new export job.
     * </p>
     * 
     * @return This is the unique ARN (Amazon Resource Name) that belongs to the new export job.
     */
    public final String exportJobArn() {
        return exportJobArn;
    }

    /**
     * <p>
     * The status of the export job is one of the following:
     * </p>
     * <p>
     * <code>CREATED</code>; <code>RUNNING</code>; <code>FAILED</code>; or <code>COMPLETED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the export job is one of the following:</p>
     *         <p>
     *         <code>CREATED</code>; <code>RUNNING</code>; <code>FAILED</code>; or <code>COMPLETED</code>.
     * @see ExportJobStatus
     */
    public final ExportJobStatus status() {
        return ExportJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the export job is one of the following:
     * </p>
     * <p>
     * <code>CREATED</code>; <code>RUNNING</code>; <code>FAILED</code>; or <code>COMPLETED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExportJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the export job is one of the following:</p>
     *         <p>
     *         <code>CREATED</code>; <code>RUNNING</code>; <code>FAILED</code>; or <code>COMPLETED</code>.
     * @see ExportJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * This is a timestamp of the time the export job was created.
     * </p>
     * 
     * @return This is a timestamp of the time the export job was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * This is a timestamp of the time the export job compeleted.
     * </p>
     * 
     * @return This is a timestamp of the time the export job compeleted.
     */
    public final Instant completionTime() {
        return completionTime;
    }

    /**
     * <p>
     * A status message is a string that is returned for an export job.
     * </p>
     * <p>
     * A status message is included for any status other than <code>COMPLETED</code> without issues.
     * </p>
     * 
     * @return A status message is a string that is returned for an export job.</p>
     *         <p>
     *         A status message is included for any status other than <code>COMPLETED</code> without issues.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The unique string that identifies the Amazon Resource Name (ARN) of the specified search job.
     * </p>
     * 
     * @return The unique string that identifies the Amazon Resource Name (ARN) of the specified search job.
     */
    public final String searchJobArn() {
        return searchJobArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exportJobIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(exportJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(searchJobArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportJobSummary)) {
            return false;
        }
        ExportJobSummary other = (ExportJobSummary) obj;
        return Objects.equals(exportJobIdentifier(), other.exportJobIdentifier())
                && Objects.equals(exportJobArn(), other.exportJobArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(completionTime(), other.completionTime())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(searchJobArn(), other.searchJobArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportJobSummary").add("ExportJobIdentifier", exportJobIdentifier())
                .add("ExportJobArn", exportJobArn()).add("Status", statusAsString()).add("CreationTime", creationTime())
                .add("CompletionTime", completionTime()).add("StatusMessage", statusMessage())
                .add("SearchJobArn", searchJobArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportJobIdentifier":
            return Optional.ofNullable(clazz.cast(exportJobIdentifier()));
        case "ExportJobArn":
            return Optional.ofNullable(clazz.cast(exportJobArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CompletionTime":
            return Optional.ofNullable(clazz.cast(completionTime()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "SearchJobArn":
            return Optional.ofNullable(clazz.cast(searchJobArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExportJobIdentifier", EXPORT_JOB_IDENTIFIER_FIELD);
        map.put("ExportJobArn", EXPORT_JOB_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("CompletionTime", COMPLETION_TIME_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("SearchJobArn", SEARCH_JOB_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportJobSummary, T> g) {
        return obj -> g.apply((ExportJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportJobSummary> {
        /**
         * <p>
         * This is the unique string that identifies a specific export job.
         * </p>
         * 
         * @param exportJobIdentifier
         *        This is the unique string that identifies a specific export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportJobIdentifier(String exportJobIdentifier);

        /**
         * <p>
         * This is the unique ARN (Amazon Resource Name) that belongs to the new export job.
         * </p>
         * 
         * @param exportJobArn
         *        This is the unique ARN (Amazon Resource Name) that belongs to the new export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportJobArn(String exportJobArn);

        /**
         * <p>
         * The status of the export job is one of the following:
         * </p>
         * <p>
         * <code>CREATED</code>; <code>RUNNING</code>; <code>FAILED</code>; or <code>COMPLETED</code>.
         * </p>
         * 
         * @param status
         *        The status of the export job is one of the following:</p>
         *        <p>
         *        <code>CREATED</code>; <code>RUNNING</code>; <code>FAILED</code>; or <code>COMPLETED</code>.
         * @see ExportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the export job is one of the following:
         * </p>
         * <p>
         * <code>CREATED</code>; <code>RUNNING</code>; <code>FAILED</code>; or <code>COMPLETED</code>.
         * </p>
         * 
         * @param status
         *        The status of the export job is one of the following:</p>
         *        <p>
         *        <code>CREATED</code>; <code>RUNNING</code>; <code>FAILED</code>; or <code>COMPLETED</code>.
         * @see ExportJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportJobStatus
         */
        Builder status(ExportJobStatus status);

        /**
         * <p>
         * This is a timestamp of the time the export job was created.
         * </p>
         * 
         * @param creationTime
         *        This is a timestamp of the time the export job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * This is a timestamp of the time the export job compeleted.
         * </p>
         * 
         * @param completionTime
         *        This is a timestamp of the time the export job compeleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionTime(Instant completionTime);

        /**
         * <p>
         * A status message is a string that is returned for an export job.
         * </p>
         * <p>
         * A status message is included for any status other than <code>COMPLETED</code> without issues.
         * </p>
         * 
         * @param statusMessage
         *        A status message is a string that is returned for an export job.</p>
         *        <p>
         *        A status message is included for any status other than <code>COMPLETED</code> without issues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The unique string that identifies the Amazon Resource Name (ARN) of the specified search job.
         * </p>
         * 
         * @param searchJobArn
         *        The unique string that identifies the Amazon Resource Name (ARN) of the specified search job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchJobArn(String searchJobArn);
    }

    static final class BuilderImpl implements Builder {
        private String exportJobIdentifier;

        private String exportJobArn;

        private String status;

        private Instant creationTime;

        private Instant completionTime;

        private String statusMessage;

        private String searchJobArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportJobSummary model) {
            exportJobIdentifier(model.exportJobIdentifier);
            exportJobArn(model.exportJobArn);
            status(model.status);
            creationTime(model.creationTime);
            completionTime(model.completionTime);
            statusMessage(model.statusMessage);
            searchJobArn(model.searchJobArn);
        }

        public final String getExportJobIdentifier() {
            return exportJobIdentifier;
        }

        public final void setExportJobIdentifier(String exportJobIdentifier) {
            this.exportJobIdentifier = exportJobIdentifier;
        }

        @Override
        public final Builder exportJobIdentifier(String exportJobIdentifier) {
            this.exportJobIdentifier = exportJobIdentifier;
            return this;
        }

        public final String getExportJobArn() {
            return exportJobArn;
        }

        public final void setExportJobArn(String exportJobArn) {
            this.exportJobArn = exportJobArn;
        }

        @Override
        public final Builder exportJobArn(String exportJobArn) {
            this.exportJobArn = exportJobArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExportJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getSearchJobArn() {
            return searchJobArn;
        }

        public final void setSearchJobArn(String searchJobArn) {
            this.searchJobArn = searchJobArn;
        }

        @Override
        public final Builder searchJobArn(String searchJobArn) {
            this.searchJobArn = searchJobArn;
            return this;
        }

        @Override
        public ExportJobSummary build() {
            return new ExportJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
