/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupsearch.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSearchJobResponse extends BackupSearchResponse implements
        ToCopyableBuilder<GetSearchJobResponse.Builder, GetSearchJobResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetSearchJobResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<SearchScopeSummary> SEARCH_SCOPE_SUMMARY_FIELD = SdkField
            .<SearchScopeSummary> builder(MarshallingType.SDK_POJO).memberName("SearchScopeSummary")
            .getter(getter(GetSearchJobResponse::searchScopeSummary)).setter(setter(Builder::searchScopeSummary))
            .constructor(SearchScopeSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchScopeSummary").build())
            .build();

    private static final SdkField<CurrentSearchProgress> CURRENT_SEARCH_PROGRESS_FIELD = SdkField
            .<CurrentSearchProgress> builder(MarshallingType.SDK_POJO).memberName("CurrentSearchProgress")
            .getter(getter(GetSearchJobResponse::currentSearchProgress)).setter(setter(Builder::currentSearchProgress))
            .constructor(CurrentSearchProgress::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentSearchProgress").build())
            .build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(GetSearchJobResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionKeyArn").getter(getter(GetSearchJobResponse::encryptionKeyArn))
            .setter(setter(Builder::encryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()).build();

    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletionTime").getter(getter(GetSearchJobResponse::completionTime))
            .setter(setter(Builder::completionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetSearchJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<SearchScope> SEARCH_SCOPE_FIELD = SdkField.<SearchScope> builder(MarshallingType.SDK_POJO)
            .memberName("SearchScope").getter(getter(GetSearchJobResponse::searchScope)).setter(setter(Builder::searchScope))
            .constructor(SearchScope::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchScope").build()).build();

    private static final SdkField<ItemFilters> ITEM_FILTERS_FIELD = SdkField.<ItemFilters> builder(MarshallingType.SDK_POJO)
            .memberName("ItemFilters").getter(getter(GetSearchJobResponse::itemFilters)).setter(setter(Builder::itemFilters))
            .constructor(ItemFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemFilters").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(GetSearchJobResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> SEARCH_JOB_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SearchJobIdentifier").getter(getter(GetSearchJobResponse::searchJobIdentifier))
            .setter(setter(Builder::searchJobIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchJobIdentifier").build())
            .build();

    private static final SdkField<String> SEARCH_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SearchJobArn").getter(getter(GetSearchJobResponse::searchJobArn)).setter(setter(Builder::searchJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchJobArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            SEARCH_SCOPE_SUMMARY_FIELD, CURRENT_SEARCH_PROGRESS_FIELD, STATUS_MESSAGE_FIELD, ENCRYPTION_KEY_ARN_FIELD,
            COMPLETION_TIME_FIELD, STATUS_FIELD, SEARCH_SCOPE_FIELD, ITEM_FILTERS_FIELD, CREATION_TIME_FIELD,
            SEARCH_JOB_IDENTIFIER_FIELD, SEARCH_JOB_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final SearchScopeSummary searchScopeSummary;

    private final CurrentSearchProgress currentSearchProgress;

    private final String statusMessage;

    private final String encryptionKeyArn;

    private final Instant completionTime;

    private final String status;

    private final SearchScope searchScope;

    private final ItemFilters itemFilters;

    private final Instant creationTime;

    private final String searchJobIdentifier;

    private final String searchJobArn;

    private GetSearchJobResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.searchScopeSummary = builder.searchScopeSummary;
        this.currentSearchProgress = builder.currentSearchProgress;
        this.statusMessage = builder.statusMessage;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.completionTime = builder.completionTime;
        this.status = builder.status;
        this.searchScope = builder.searchScope;
        this.itemFilters = builder.itemFilters;
        this.creationTime = builder.creationTime;
        this.searchJobIdentifier = builder.searchJobIdentifier;
        this.searchJobArn = builder.searchJobArn;
    }

    /**
     * <p>
     * Returned name of the specified search job.
     * </p>
     * 
     * @return Returned name of the specified search job.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Returned summary of the specified search job scope, including:
     * </p>
     * <ul>
     * <li>
     * <p>
     * TotalBackupsToScanCount, the number of recovery points returned by the search.
     * </p>
     * </li>
     * <li>
     * <p>
     * TotalItemsToScanCount, the number of items returned by the search.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Returned summary of the specified search job scope, including: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         TotalBackupsToScanCount, the number of recovery points returned by the search.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TotalItemsToScanCount, the number of items returned by the search.
     *         </p>
     *         </li>
     */
    public final SearchScopeSummary searchScopeSummary() {
        return searchScopeSummary;
    }

    /**
     * <p>
     * Returns numbers representing BackupsScannedCount, ItemsScanned, and ItemsMatched.
     * </p>
     * 
     * @return Returns numbers representing BackupsScannedCount, ItemsScanned, and ItemsMatched.
     */
    public final CurrentSearchProgress currentSearchProgress() {
        return currentSearchProgress;
    }

    /**
     * <p>
     * A status message will be returned for either a earch job with a status of <code>ERRORED</code> or a status of
     * <code>COMPLETED</code> jobs with issues.
     * </p>
     * <p>
     * For example, a message may say that a search contained recovery points unable to be scanned because of a
     * permissions issue.
     * </p>
     * 
     * @return A status message will be returned for either a earch job with a status of <code>ERRORED</code> or a
     *         status of <code>COMPLETED</code> jobs with issues.</p>
     *         <p>
     *         For example, a message may say that a search contained recovery points unable to be scanned because of a
     *         permissions issue.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The encryption key for the specified search job.
     * </p>
     * <p>
     * Example: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     * 
     * @return The encryption key for the specified search job.</p>
     *         <p>
     *         Example: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     */
    public final String encryptionKeyArn() {
        return encryptionKeyArn;
    }

    /**
     * <p>
     * The date and time that a search job completed, in Unix format and Coordinated Universal Time (UTC). The value of
     * <code>CompletionTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents Friday,
     * January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that a search job completed, in Unix format and Coordinated Universal Time (UTC). The
     *         value of <code>CompletionTime</code> is accurate to milliseconds. For example, the value 1516925490.087
     *         represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant completionTime() {
        return completionTime;
    }

    /**
     * <p>
     * The current status of the specified search job.
     * </p>
     * <p>
     * A search job may have one of the following statuses: <code>RUNNING</code>; <code>COMPLETED</code>;
     * <code>STOPPED</code>; <code>FAILED</code>; <code>TIMED_OUT</code>; or <code>EXPIRED</code> .
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SearchJobState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the specified search job.</p>
     *         <p>
     *         A search job may have one of the following statuses: <code>RUNNING</code>; <code>COMPLETED</code>;
     *         <code>STOPPED</code>; <code>FAILED</code>; <code>TIMED_OUT</code>; or <code>EXPIRED</code> .
     * @see SearchJobState
     */
    public final SearchJobState status() {
        return SearchJobState.fromValue(status);
    }

    /**
     * <p>
     * The current status of the specified search job.
     * </p>
     * <p>
     * A search job may have one of the following statuses: <code>RUNNING</code>; <code>COMPLETED</code>;
     * <code>STOPPED</code>; <code>FAILED</code>; <code>TIMED_OUT</code>; or <code>EXPIRED</code> .
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SearchJobState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the specified search job.</p>
     *         <p>
     *         A search job may have one of the following statuses: <code>RUNNING</code>; <code>COMPLETED</code>;
     *         <code>STOPPED</code>; <code>FAILED</code>; <code>TIMED_OUT</code>; or <code>EXPIRED</code> .
     * @see SearchJobState
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The search scope is all backup properties input into a search.
     * </p>
     * 
     * @return The search scope is all backup properties input into a search.
     */
    public final SearchScope searchScope() {
        return searchScope;
    }

    /**
     * <p>
     * Item Filters represent all input item properties specified when the search was created.
     * </p>
     * 
     * @return Item Filters represent all input item properties specified when the search was created.
     */
    public final ItemFilters itemFilters() {
        return itemFilters;
    }

    /**
     * <p>
     * The date and time that a search job was created, in Unix format and Coordinated Universal Time (UTC). The value
     * of <code>CompletionTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
     * Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that a search job was created, in Unix format and Coordinated Universal Time (UTC). The
     *         value of <code>CompletionTime</code> is accurate to milliseconds. For example, the value 1516925490.087
     *         represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The unique string that identifies the specified search job.
     * </p>
     * 
     * @return The unique string that identifies the specified search job.
     */
    public final String searchJobIdentifier() {
        return searchJobIdentifier;
    }

    /**
     * <p>
     * The unique string that identifies the Amazon Resource Name (ARN) of the specified search job.
     * </p>
     * 
     * @return The unique string that identifies the Amazon Resource Name (ARN) of the specified search job.
     */
    public final String searchJobArn() {
        return searchJobArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(searchScopeSummary());
        hashCode = 31 * hashCode + Objects.hashCode(currentSearchProgress());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(searchScope());
        hashCode = 31 * hashCode + Objects.hashCode(itemFilters());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(searchJobIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(searchJobArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSearchJobResponse)) {
            return false;
        }
        GetSearchJobResponse other = (GetSearchJobResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(searchScopeSummary(), other.searchScopeSummary())
                && Objects.equals(currentSearchProgress(), other.currentSearchProgress())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(encryptionKeyArn(), other.encryptionKeyArn())
                && Objects.equals(completionTime(), other.completionTime())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(searchScope(), other.searchScope())
                && Objects.equals(itemFilters(), other.itemFilters()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(searchJobIdentifier(), other.searchJobIdentifier())
                && Objects.equals(searchJobArn(), other.searchJobArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSearchJobResponse").add("Name", name()).add("SearchScopeSummary", searchScopeSummary())
                .add("CurrentSearchProgress", currentSearchProgress()).add("StatusMessage", statusMessage())
                .add("EncryptionKeyArn", encryptionKeyArn()).add("CompletionTime", completionTime())
                .add("Status", statusAsString()).add("SearchScope", searchScope()).add("ItemFilters", itemFilters())
                .add("CreationTime", creationTime()).add("SearchJobIdentifier", searchJobIdentifier())
                .add("SearchJobArn", searchJobArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SearchScopeSummary":
            return Optional.ofNullable(clazz.cast(searchScopeSummary()));
        case "CurrentSearchProgress":
            return Optional.ofNullable(clazz.cast(currentSearchProgress()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "EncryptionKeyArn":
            return Optional.ofNullable(clazz.cast(encryptionKeyArn()));
        case "CompletionTime":
            return Optional.ofNullable(clazz.cast(completionTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "SearchScope":
            return Optional.ofNullable(clazz.cast(searchScope()));
        case "ItemFilters":
            return Optional.ofNullable(clazz.cast(itemFilters()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "SearchJobIdentifier":
            return Optional.ofNullable(clazz.cast(searchJobIdentifier()));
        case "SearchJobArn":
            return Optional.ofNullable(clazz.cast(searchJobArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("SearchScopeSummary", SEARCH_SCOPE_SUMMARY_FIELD);
        map.put("CurrentSearchProgress", CURRENT_SEARCH_PROGRESS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("EncryptionKeyArn", ENCRYPTION_KEY_ARN_FIELD);
        map.put("CompletionTime", COMPLETION_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("SearchScope", SEARCH_SCOPE_FIELD);
        map.put("ItemFilters", ITEM_FILTERS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("SearchJobIdentifier", SEARCH_JOB_IDENTIFIER_FIELD);
        map.put("SearchJobArn", SEARCH_JOB_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSearchJobResponse, T> g) {
        return obj -> g.apply((GetSearchJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupSearchResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSearchJobResponse> {
        /**
         * <p>
         * Returned name of the specified search job.
         * </p>
         * 
         * @param name
         *        Returned name of the specified search job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Returned summary of the specified search job scope, including:
         * </p>
         * <ul>
         * <li>
         * <p>
         * TotalBackupsToScanCount, the number of recovery points returned by the search.
         * </p>
         * </li>
         * <li>
         * <p>
         * TotalItemsToScanCount, the number of items returned by the search.
         * </p>
         * </li>
         * </ul>
         * 
         * @param searchScopeSummary
         *        Returned summary of the specified search job scope, including: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        TotalBackupsToScanCount, the number of recovery points returned by the search.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TotalItemsToScanCount, the number of items returned by the search.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchScopeSummary(SearchScopeSummary searchScopeSummary);

        /**
         * <p>
         * Returned summary of the specified search job scope, including:
         * </p>
         * <ul>
         * <li>
         * <p>
         * TotalBackupsToScanCount, the number of recovery points returned by the search.
         * </p>
         * </li>
         * <li>
         * <p>
         * TotalItemsToScanCount, the number of items returned by the search.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link SearchScopeSummary.Builder} avoiding the
         * need to create one manually via {@link SearchScopeSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchScopeSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #searchScopeSummary(SearchScopeSummary)}.
         * 
         * @param searchScopeSummary
         *        a consumer that will call methods on {@link SearchScopeSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchScopeSummary(SearchScopeSummary)
         */
        default Builder searchScopeSummary(Consumer<SearchScopeSummary.Builder> searchScopeSummary) {
            return searchScopeSummary(SearchScopeSummary.builder().applyMutation(searchScopeSummary).build());
        }

        /**
         * <p>
         * Returns numbers representing BackupsScannedCount, ItemsScanned, and ItemsMatched.
         * </p>
         * 
         * @param currentSearchProgress
         *        Returns numbers representing BackupsScannedCount, ItemsScanned, and ItemsMatched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentSearchProgress(CurrentSearchProgress currentSearchProgress);

        /**
         * <p>
         * Returns numbers representing BackupsScannedCount, ItemsScanned, and ItemsMatched.
         * </p>
         * This is a convenience method that creates an instance of the {@link CurrentSearchProgress.Builder} avoiding
         * the need to create one manually via {@link CurrentSearchProgress#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CurrentSearchProgress.Builder#build()} is called immediately and
         * its result is passed to {@link #currentSearchProgress(CurrentSearchProgress)}.
         * 
         * @param currentSearchProgress
         *        a consumer that will call methods on {@link CurrentSearchProgress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #currentSearchProgress(CurrentSearchProgress)
         */
        default Builder currentSearchProgress(Consumer<CurrentSearchProgress.Builder> currentSearchProgress) {
            return currentSearchProgress(CurrentSearchProgress.builder().applyMutation(currentSearchProgress).build());
        }

        /**
         * <p>
         * A status message will be returned for either a earch job with a status of <code>ERRORED</code> or a status of
         * <code>COMPLETED</code> jobs with issues.
         * </p>
         * <p>
         * For example, a message may say that a search contained recovery points unable to be scanned because of a
         * permissions issue.
         * </p>
         * 
         * @param statusMessage
         *        A status message will be returned for either a earch job with a status of <code>ERRORED</code> or a
         *        status of <code>COMPLETED</code> jobs with issues.</p>
         *        <p>
         *        For example, a message may say that a search contained recovery points unable to be scanned because of
         *        a permissions issue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The encryption key for the specified search job.
         * </p>
         * <p>
         * Example: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * </p>
         * 
         * @param encryptionKeyArn
         *        The encryption key for the specified search job.</p>
         *        <p>
         *        Example: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKeyArn(String encryptionKeyArn);

        /**
         * <p>
         * The date and time that a search job completed, in Unix format and Coordinated Universal Time (UTC). The value
         * of <code>CompletionTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
         * Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param completionTime
         *        The date and time that a search job completed, in Unix format and Coordinated Universal Time (UTC).
         *        The value of <code>CompletionTime</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionTime(Instant completionTime);

        /**
         * <p>
         * The current status of the specified search job.
         * </p>
         * <p>
         * A search job may have one of the following statuses: <code>RUNNING</code>; <code>COMPLETED</code>;
         * <code>STOPPED</code>; <code>FAILED</code>; <code>TIMED_OUT</code>; or <code>EXPIRED</code> .
         * </p>
         * 
         * @param status
         *        The current status of the specified search job.</p>
         *        <p>
         *        A search job may have one of the following statuses: <code>RUNNING</code>; <code>COMPLETED</code>;
         *        <code>STOPPED</code>; <code>FAILED</code>; <code>TIMED_OUT</code>; or <code>EXPIRED</code> .
         * @see SearchJobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchJobState
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the specified search job.
         * </p>
         * <p>
         * A search job may have one of the following statuses: <code>RUNNING</code>; <code>COMPLETED</code>;
         * <code>STOPPED</code>; <code>FAILED</code>; <code>TIMED_OUT</code>; or <code>EXPIRED</code> .
         * </p>
         * 
         * @param status
         *        The current status of the specified search job.</p>
         *        <p>
         *        A search job may have one of the following statuses: <code>RUNNING</code>; <code>COMPLETED</code>;
         *        <code>STOPPED</code>; <code>FAILED</code>; <code>TIMED_OUT</code>; or <code>EXPIRED</code> .
         * @see SearchJobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchJobState
         */
        Builder status(SearchJobState status);

        /**
         * <p>
         * The search scope is all backup properties input into a search.
         * </p>
         * 
         * @param searchScope
         *        The search scope is all backup properties input into a search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchScope(SearchScope searchScope);

        /**
         * <p>
         * The search scope is all backup properties input into a search.
         * </p>
         * This is a convenience method that creates an instance of the {@link SearchScope.Builder} avoiding the need to
         * create one manually via {@link SearchScope#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchScope.Builder#build()} is called immediately and its result
         * is passed to {@link #searchScope(SearchScope)}.
         * 
         * @param searchScope
         *        a consumer that will call methods on {@link SearchScope.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchScope(SearchScope)
         */
        default Builder searchScope(Consumer<SearchScope.Builder> searchScope) {
            return searchScope(SearchScope.builder().applyMutation(searchScope).build());
        }

        /**
         * <p>
         * Item Filters represent all input item properties specified when the search was created.
         * </p>
         * 
         * @param itemFilters
         *        Item Filters represent all input item properties specified when the search was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemFilters(ItemFilters itemFilters);

        /**
         * <p>
         * Item Filters represent all input item properties specified when the search was created.
         * </p>
         * This is a convenience method that creates an instance of the {@link ItemFilters.Builder} avoiding the need to
         * create one manually via {@link ItemFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ItemFilters.Builder#build()} is called immediately and its result
         * is passed to {@link #itemFilters(ItemFilters)}.
         * 
         * @param itemFilters
         *        a consumer that will call methods on {@link ItemFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #itemFilters(ItemFilters)
         */
        default Builder itemFilters(Consumer<ItemFilters.Builder> itemFilters) {
            return itemFilters(ItemFilters.builder().applyMutation(itemFilters).build());
        }

        /**
         * <p>
         * The date and time that a search job was created, in Unix format and Coordinated Universal Time (UTC). The
         * value of <code>CompletionTime</code> is accurate to milliseconds. For example, the value 1516925490.087
         * represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param creationTime
         *        The date and time that a search job was created, in Unix format and Coordinated Universal Time (UTC).
         *        The value of <code>CompletionTime</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The unique string that identifies the specified search job.
         * </p>
         * 
         * @param searchJobIdentifier
         *        The unique string that identifies the specified search job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchJobIdentifier(String searchJobIdentifier);

        /**
         * <p>
         * The unique string that identifies the Amazon Resource Name (ARN) of the specified search job.
         * </p>
         * 
         * @param searchJobArn
         *        The unique string that identifies the Amazon Resource Name (ARN) of the specified search job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchJobArn(String searchJobArn);
    }

    static final class BuilderImpl extends BackupSearchResponse.BuilderImpl implements Builder {
        private String name;

        private SearchScopeSummary searchScopeSummary;

        private CurrentSearchProgress currentSearchProgress;

        private String statusMessage;

        private String encryptionKeyArn;

        private Instant completionTime;

        private String status;

        private SearchScope searchScope;

        private ItemFilters itemFilters;

        private Instant creationTime;

        private String searchJobIdentifier;

        private String searchJobArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSearchJobResponse model) {
            super(model);
            name(model.name);
            searchScopeSummary(model.searchScopeSummary);
            currentSearchProgress(model.currentSearchProgress);
            statusMessage(model.statusMessage);
            encryptionKeyArn(model.encryptionKeyArn);
            completionTime(model.completionTime);
            status(model.status);
            searchScope(model.searchScope);
            itemFilters(model.itemFilters);
            creationTime(model.creationTime);
            searchJobIdentifier(model.searchJobIdentifier);
            searchJobArn(model.searchJobArn);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final SearchScopeSummary.Builder getSearchScopeSummary() {
            return searchScopeSummary != null ? searchScopeSummary.toBuilder() : null;
        }

        public final void setSearchScopeSummary(SearchScopeSummary.BuilderImpl searchScopeSummary) {
            this.searchScopeSummary = searchScopeSummary != null ? searchScopeSummary.build() : null;
        }

        @Override
        public final Builder searchScopeSummary(SearchScopeSummary searchScopeSummary) {
            this.searchScopeSummary = searchScopeSummary;
            return this;
        }

        public final CurrentSearchProgress.Builder getCurrentSearchProgress() {
            return currentSearchProgress != null ? currentSearchProgress.toBuilder() : null;
        }

        public final void setCurrentSearchProgress(CurrentSearchProgress.BuilderImpl currentSearchProgress) {
            this.currentSearchProgress = currentSearchProgress != null ? currentSearchProgress.build() : null;
        }

        @Override
        public final Builder currentSearchProgress(CurrentSearchProgress currentSearchProgress) {
            this.currentSearchProgress = currentSearchProgress;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getEncryptionKeyArn() {
            return encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final Instant getCompletionTime() {
            return completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SearchJobState status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final SearchScope.Builder getSearchScope() {
            return searchScope != null ? searchScope.toBuilder() : null;
        }

        public final void setSearchScope(SearchScope.BuilderImpl searchScope) {
            this.searchScope = searchScope != null ? searchScope.build() : null;
        }

        @Override
        public final Builder searchScope(SearchScope searchScope) {
            this.searchScope = searchScope;
            return this;
        }

        public final ItemFilters.Builder getItemFilters() {
            return itemFilters != null ? itemFilters.toBuilder() : null;
        }

        public final void setItemFilters(ItemFilters.BuilderImpl itemFilters) {
            this.itemFilters = itemFilters != null ? itemFilters.build() : null;
        }

        @Override
        public final Builder itemFilters(ItemFilters itemFilters) {
            this.itemFilters = itemFilters;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getSearchJobIdentifier() {
            return searchJobIdentifier;
        }

        public final void setSearchJobIdentifier(String searchJobIdentifier) {
            this.searchJobIdentifier = searchJobIdentifier;
        }

        @Override
        public final Builder searchJobIdentifier(String searchJobIdentifier) {
            this.searchJobIdentifier = searchJobIdentifier;
            return this;
        }

        public final String getSearchJobArn() {
            return searchJobArn;
        }

        public final void setSearchJobArn(String searchJobArn) {
            this.searchJobArn = searchJobArn;
        }

        @Override
        public final Builder searchJobArn(String searchJobArn) {
            this.searchJobArn = searchJobArn;
            return this;
        }

        @Override
        public GetSearchJobResponse build() {
            return new GetSearchJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
