/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSearchResultExportJobRequest extends BackupSearchRequest implements
        ToCopyableBuilder<GetSearchResultExportJobRequest.Builder, GetSearchResultExportJobRequest> {
    private static final SdkField<String> EXPORT_JOB_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportJobIdentifier").getter(getter(GetSearchResultExportJobRequest::exportJobIdentifier))
            .setter(setter(Builder::exportJobIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ExportJobIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_JOB_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String exportJobIdentifier;

    private GetSearchResultExportJobRequest(BuilderImpl builder) {
        super(builder);
        this.exportJobIdentifier = builder.exportJobIdentifier;
    }

    /**
     * <p>
     * This is the unique string that identifies a specific export job.
     * </p>
     * <p>
     * Required for this operation.
     * </p>
     * 
     * @return This is the unique string that identifies a specific export job.</p>
     *         <p>
     *         Required for this operation.
     */
    public final String exportJobIdentifier() {
        return exportJobIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(exportJobIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSearchResultExportJobRequest)) {
            return false;
        }
        GetSearchResultExportJobRequest other = (GetSearchResultExportJobRequest) obj;
        return Objects.equals(exportJobIdentifier(), other.exportJobIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSearchResultExportJobRequest").add("ExportJobIdentifier", exportJobIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportJobIdentifier":
            return Optional.ofNullable(clazz.cast(exportJobIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExportJobIdentifier", EXPORT_JOB_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSearchResultExportJobRequest, T> g) {
        return obj -> g.apply((GetSearchResultExportJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupSearchRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSearchResultExportJobRequest> {
        /**
         * <p>
         * This is the unique string that identifies a specific export job.
         * </p>
         * <p>
         * Required for this operation.
         * </p>
         * 
         * @param exportJobIdentifier
         *        This is the unique string that identifies a specific export job.</p>
         *        <p>
         *        Required for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportJobIdentifier(String exportJobIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupSearchRequest.BuilderImpl implements Builder {
        private String exportJobIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSearchResultExportJobRequest model) {
            super(model);
            exportJobIdentifier(model.exportJobIdentifier);
        }

        public final String getExportJobIdentifier() {
            return exportJobIdentifier;
        }

        public final void setExportJobIdentifier(String exportJobIdentifier) {
            this.exportJobIdentifier = exportJobIdentifier;
        }

        @Override
        public final Builder exportJobIdentifier(String exportJobIdentifier) {
            this.exportJobIdentifier = exportJobIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSearchResultExportJobRequest build() {
            return new GetSearchResultExportJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
